<?php
include_once('../../conectorBDS14.php');
include_once("adminConceptos.php");

class FormaPago
{
  public $id;
  public $clave;
  public $forma_pago;
  public $accion;

  function __construct($id, $clave, $forma_pago)
  {
    $this->id = $id;
    $this->clave = $clave;
    $this->forma_pago = $forma_pago;
  }
}


class ConceptoFac
{
  //SELECT `id`, `id_factura`, `id_producto`, `cantidad`, `precio_unitario`, `precio_con_iva`, `precio_neto`, `precio_neto_iva`, `concepto` FROM `detalle_factura` WHERE 1
  public $id;
  public $id_factura;
  public $id_producto;
  public $cantidad;
  public $precio_unitario;
  public $precio_con_iva;
  public $precio_neto;
  public $precio_neto_iva;
  public $concepto;


  function __construct()
  {
    $this->id = 0;
  }
}

//`facturas` (`id`, `fecha`, `nombre`, `metodo_pago`, `moneda`, `forma_pago`, `status_pago`, `total_factura`, `empresa`, `estatus_cert`, `certificado`, `cadena`, `id_factura`, `razon`, `tipo_factura`, `total_sin_iva`, `total_iva`, `empresa_destino`, `token`, `tipo_comprobante`, `uso_cfdi`, `num_certificado`, `certificado_fact`, `uuid`, `fecha_timbrado`, `hora_timbrado`, `sello_cfd`, `num_certificado_sat`, `sello_sat`, `complemento`, `id_pago`, `requiere_complemento`, `factura_manual`, `id_clave_corta`, `xml_firmado`, `status`, `enviado`, `cuadrado`, `id_captura`, `status_error`, `folio`, `usuario_crea`, `serie`, `retencion_transporte`, `xml_total`, `xml_subtotal`)

class Factura
{
  public $id;
  public $fecha;
  public $nombre;
  public $metodo_pago;
  public $moneda;
  public $forma_pago;
  public $status_pago;
  public $total_factura;
  public $empresa;
  public $estatus_cert;
  public $certificado;
  public $cadena;
  public $id_factura;
  public $razon;
  public $tipo_factura;
  public $total_sin_iva;
  public $total_iva;
  public $empresa_destino;
  public $token;
  public $tipo_comprobante;
  public $uso_cfdi;
  public $num_certificado;
  public $certificado_fact;
  public $uuid;
  public $fecha_timbrado;
  public $hora_timbrado;
  public $sello_cfd;
  public $num_certificado_sat;
  public $sello_sat;
  public $complemento;
  public $id_pago;
  public $requiere_complemento;
  public $factura_manual;
  public $id_clave_corta;
  public $xml_firmado;
  public $status;
  public $enviado;
  public $cuadrado;
  public $id_captura;
  public $status_error;
  public $folio;
  public $usuario_crea;
  public $serie;
  public $retencion_transporte;
  public $xml_total;
  public $xml_subtotal;
  public $cliente;
  public $empresa_nombre;
  public $empresa_rfc;
  public $metodo_pago_nombre;
  public $forma_pago_nombre;
  public $conceptos;
  public $numeroPago;
  public $saldo;
  public $restante;
  public $folios_asociados;
  public $usuarioTimbra;
  public $usuarioTimbraNombre;

  function __construct()
  {
    $this->id = 0;
  }
}

class ReporteComplemento{
  public $total_iva;
  public $folio_f;
  public $monto;
  public $saldo;
  public $restante;
  public $uuid_rel;
  public $id_complemento;
  public $uuid;
  public $fecha_timbrado;
  public $status_pago;
  public $id;

}




class AdministradorFormasPago extends conectorS14
{




  public function agregaFactura($nombre, $metodo_pago, $moneda, $forma_pago, $estatus_pago, $razon, $total_iva, $token, $tipo_comprobante, $uso_cfdi, $id_clave_corta, $id_captura, $folio, $usuario_crea, $serie, $retencion_transporte, $xml_total, $xml_subtotal)
  {

    $sql = "INSERT INTO facturas (nombre, metodo_pago, moneda, forma_pago, status_pago, razon, total_iva, token, tipo_comprobante, uso_cfdi, id_clave_corta, id_captura, folio, usuario_crea, serie, retencion_transporte, xml_total, xml_subtotal, factura_manual) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$estatus_pago', '$razon', '$total_iva', '$token', '$tipo_comprobante', '$uso_cfdi', '$id_clave_corta', '$id_captura', '$folio', '$usuario_crea', '$serie', '$retencion_transporte', '$xml_total', '$xml_subtotal', '1')";
    $this->ejecutar($sql);
    //echo $sql;
    $id = $this->ultimoIdInsertado();
    return $id;
  }


  public function eliminarRelacionComplemento($id){
      $sql = 'delete from facturar_rel_complementos  where id = ' . $id;
      //echo $sql;
      $this->ejecutar($sql);
  }



  public function existeFactura($monto, $cliente, $empresa){
    $sql = "SELECT * FROM facturas WHERE total_iva = $monto and nombre = $cliente and razon = $empresa";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $id = $fila['id'];
    if($id > 0){
      return true;
    }else{
      return false;
    }
  }
   
  public function dameReporteFacturaPpd($factura){
    $sql = "SELECT fr.id as idRel, f.total_iva, f.uuid as folio_f, fr.monto, fr.saldo, fr.restante, fr.uuid_rel, fr.id_complemento, fc.uuid, fc.fecha_timbrado, fc.status_pago FROM `facturar_rel_complementos` fr
    left join facturas_complementos fc on fc.id = fr.id_complemento
    left join facturas f on f.id =  fr.id_factura
    where fr.id_factura = $factura;";
    $result = $this->ejecutar($sql);
    $reporte = array();
    while ($fila = mysqli_fetch_array($result)) {
      $reporteComplemento = new ReporteComplemento();
      $reporteComplemento->total_iva = $fila['total_iva'];
      $reporteComplemento->folio_f = $fila['folio_f'];
      $reporteComplemento->monto = $fila['monto'];
      $reporteComplemento->saldo = $fila['saldo'];
      $reporteComplemento->restante = $fila['restante'];
      $reporteComplemento->uuid_rel = $fila['uuid_rel'];
      $reporteComplemento->id_complemento = $fila['id_complemento'];
      $reporteComplemento->uuid = $fila['uuid'];
      $reporteComplemento->fecha_timbrado = $fila['fecha_timbrado'];
      $reporteComplemento->status_pago = $fila['status_pago'];
      $reporteComplemento->id = $fila['idRel'];
      array_push($reporte, $reporteComplemento);
    }
    return $reporte;
  }


  public function agregaFacturaCargada($nombre, $metodo_pago, $moneda, $forma_pago, $estatus_pago, $razon, $total_iva, $token, $tipo_comprobante, $uso_cfdi, $id_clave_corta, $id_captura, $folio, $usuario_crea, $serie, $retencion_transporte, $xml_total, $xml_subtotal, $uuid)
  {

    $sql = "INSERT INTO facturas (nombre, metodo_pago, moneda, forma_pago, status_pago, razon, total_iva, token, tipo_comprobante, uso_cfdi, id_clave_corta, id_captura, folio, usuario_crea, serie, retencion_transporte, xml_total, xml_subtotal, factura_manual, uuid) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$estatus_pago', '$razon', '$total_iva', '$token', '$tipo_comprobante', '$uso_cfdi', '$id_clave_corta', '$id_captura', '$folio', '$usuario_crea', '$serie', '$retencion_transporte', '$xml_total', '$xml_subtotal', '1', '$uuid')";
    $this->ejecutar($sql);
    //echo $sql;
    $id = $this->ultimoIdInsertado();
    return $id;
  }

  function actualizarFolioComplementos($id, $folio){
    $sql = "UPDATE `facturar_rel_complementos` SET `uuid_rel` = '$folio' WHERE `facturar_rel_complementos`.`id_factura` = $id;";
    $this->ejecutar($sql);
  }

  function excluirFactura($id){
    $sql = "UPDATE `facturas` SET `ex` = '1' WHERE `facturas`.`id` = $id;";
    $this->ejecutar($sql);
  }
  public function agregaFacturaComplemento($nombre, $metodo_pago, $moneda, $forma_pago, $estatus_pago, $razon, $total_iva, $token, $tipo_comprobante, $uso_cfdi, $id_clave_corta, $id_captura, $folio, $usuario_crea, $serie, $retencion_transporte, $xml_total, $xml_subtotal)
  {

    $sql = "INSERT INTO facturas (nombre, metodo_pago, moneda, forma_pago, status_pago, razon, total_iva, token, tipo_comprobante, uso_cfdi, id_clave_corta, id_captura, folio, usuario_crea, serie, retencion_transporte, xml_total, xml_subtotal, factura_manual) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$estatus_pago', '$razon', '$total_iva', '$token', '$tipo_comprobante', '$uso_cfdi', '$id_clave_corta', '$id_captura', '$folio', '$usuario_crea', '$serie', '$retencion_transporte', '$xml_total', '$xml_subtotal', '1')";
    $this->ejecutar($sql);
    $id = $this->ultimoIdInsertado();
    return $id;
  }

  public function cuentaComplementos($factura)
  {
    $sql = "SELECT id_factura, COUNT(id_factura) as numero FROM `facturar_rel_complementos`  where id_factura = $factura group by id_factura;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $numero = $fila['numero'];
    //cuenta el numero de pagos que se han hecho y le suma uno para sacar el proximo indice recomendado
    return intval($numero) + 1;
  }

  public function eliminarFactura($id)
  {
    $usuario = $_SESSION["usuario_id"];
    $sql = "DELETE FROM facturas WHERE id = '$id'";
    $this->ejecutar($sql);
    $sql = "DELETE FROM detalle_factura WHERE id_factura = '$id'";
    $this->ejecutar($sql);
    $sql = "UPDATE facturas_eliminadas set usuario_timbra = '$usuario'  WHERE id = '$id'";
    $this->ejecutar($sql);
  }

  public function sumaSaldos($factura)
  {
    $sql = "SELECT id_factura, SUM(monto) as suma FROM `facturar_rel_complementos` where id_factura = $factura group by id_factura;";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $numero = $fila['suma'];
    return floatval($numero);
  }

  function existeMonto($monto){
    $sql = "SELECT * FROM facturas WHERE total_iva = $monto and nombre = 13 and uuid is not null";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $id = $fila['id'];
    if($id > 0){
      return true;
    }else{
      return false;
    }
  }


  function dameMonto($id)
  {
    $sql = "SELECT total_iva FROM facturas WHERE id = $id";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $monto = $fila['total_iva'];
    return $monto;
  }

  function agregarConcepto($id_factura, $id_producto, $cantidad, $precio_unitario, $precio_con_iva, $precio_neto, $precio_neto_iva, $concepto, $iva)
  {
    $sql = "INSERT INTO detalle_factura (id_factura, id_producto, cantidad, precio_unitario, precio_con_iva, precio_neto, precio_neto_iva, concepto, iva) VALUES ('$id_factura', '$id_producto', '$cantidad', '$precio_unitario', '$precio_con_iva', '$precio_neto', '$precio_neto_iva', '$concepto','$iva')";
    //echo $sql;
    $this->ejecutar($sql);
  }

  public function ultimoIdInsertado()
  {
    $sql = "SELECT MAX(id) as id FROM facturas";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $id = $fila['id'];
    return $id;
  }

  public function compuebaFolioFiscal($id)
  {
    $sql = "SELECT uuid FROM facturas WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $folio = $fila['uuid'];
    //echo $folio;
    if (strlen($folio) > 1) {
      return true;
    } else {
      return false;
    }
  }

  public function dameFolioFiscal($id)
  {
    $sql = "SELECT uuid FROM facturas WHERE id = '$id'";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $folio = $fila['uuid'];
    return $folio;
  }

  public function relacionaFactura($id_factura, $id_pago)
  {
    $sql = "UPDATE `pagos` SET `id_factura` = '$id_factura' WHERE `pagos`.`id` = $id_pago;";
    $sql2 = "UPDATE `facturas` SET `id_pago` = '$id_pago' WHERE `facturas`.`id` = $id_factura;";
    $this->ejecutar($sql);
    $this->ejecutar($sql2);
  }

  public function agregarFavorito($usuario, $factura, $nota)
  {
    $sql = "INSERT INTO `facturas_fav` (`id_usuario`, `id_factura`, `nota`) VALUES ('$usuario', '$factura', '$nota');";
    $this->ejecutar($sql);
  }

  public function dameConceptosPorFactura($factura)
  {
    $sql = "SELECT * FROM detalle_factura WHERE id_factura = '$factura'";
    $result = $this->ejecutar($sql);
    $conceptos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $concepto = new ConceptoFac();
      $concepto->id = $fila['id'];
      $concepto->id_factura = $fila['id_factura'];
      $concepto->id_producto = $fila['id_producto'];
      $concepto->cantidad = $fila['cantidad'];
      $concepto->precio_unitario = $fila['precio_unitario'];
      $concepto->precio_con_iva = $fila['precio_con_iva'];
      $concepto->precio_neto = $fila['precio_neto'];
      $concepto->precio_neto_iva = $fila['precio_neto_iva'];
      $concepto->concepto = $fila['concepto'];
      array_push($conceptos, $concepto);
    }
    return $conceptos;
  }


  public function dameFacturaPorUUID($uuid)
  {
    $sql = "SELECT * FROM facturas WHERE uuid = '$uuid'";
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte
        = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $factura;
  }





  public function dameFacturasPPDSinConcluir()
  {


    $sql = 'SELECT 
    f.*, 
    c.nombre AS cliente_nombre, 
    e.razon AS empresa_nombre, 
    cc.rfc AS empresa_rfc, 
    fp.forma_pago AS forma_pago_nombre, 
    mp.metodo_pago AS metodo_pago_nombre, 
    COUNT(fc.id) AS complementos_conteo, 
    (f.total_iva - SUM(fc.monto)) AS suma_complementos
FROM 
    facturas f 
    INNER JOIN clientes c ON c.id = f.nombre 
    INNER JOIN empresas e ON e.id = f.razon 
    INNER JOIN formas_pago fp ON fp.id = f.forma_pago 
    INNER JOIN metodos_pago mp ON mp.id = f.metodo_pago  
    INNER JOIN claves_cortas cc ON cc.id = f.id_clave_corta
    INNER JOIN facturar_rel_complementos fc ON fc.id_factura = f.id
WHERE 
    f.forma_pago = 23  
GROUP BY 
    f.id
HAVING 
    suma_complementos > 1
ORDER BY 
    f.id DESC 
LIMIT 1000;';


    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->empresa_nombre = $fila['razon'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];

      $factura->restante = $fila['suma_complementos'];
      $factura->folios_asociados = $fila['complementos_conteo'];

      array_push($facturas, $factura);
    }
    return $facturas;
  }




  public function dameFacturasPPDConcluidas()
  {


    $sql = 'SELECT 
    f.*, 
    c.nombre AS cliente_nombre, 
    e.razon AS empresa_nombre, 
    cc.rfc AS empresa_rfc, 
    fp.forma_pago AS forma_pago_nombre, 
    mp.metodo_pago AS metodo_pago_nombre, 
    COUNT(fc.id) AS complementos_conteo, 
    (f.total_iva - SUM(fc.monto)) AS suma_complementos
FROM 
    facturas f 
    INNER JOIN clientes c ON c.id = f.nombre 
    INNER JOIN empresas e ON e.id = f.razon 
    INNER JOIN formas_pago fp ON fp.id = f.forma_pago 
    INNER JOIN metodos_pago mp ON mp.id = f.metodo_pago  
    INNER JOIN claves_cortas cc ON cc.id = f.id_clave_corta
    INNER JOIN facturar_rel_complementos fc ON fc.id_factura = f.id
WHERE 
    f.forma_pago = 23  
GROUP BY 
    f.id
HAVING 
    suma_complementos < 1
ORDER BY 
    f.id DESC 
LIMIT 1000;';


    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->empresa_nombre = $fila['razon'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];

      $factura->restante = $fila['suma_complementos'];
      $factura->folios_asociados = $fila['complementos_conteo'];

      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasPPD()
  {


    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, count(fc.id) as complementos_conteo, (f.total_iva - sum(fc.monto)) as suma_complementos
    from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    inner join claves_cortas cc
    on cc.id = f.id_clave_corta
    inner join facturar_rel_complementos fc
    on fc.id_factura = f.id
    WHERE f.forma_pago = 23
    group by f.id
    order by f.id desc limit 1000;';


    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->empresa_nombre = $fila['razon'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];

      $factura->restante = $fila['suma_complementos'];
      $factura->folios_asociados = $fila['complementos_conteo'];

      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasFavoritas($usuario, $empresa)
  {
    $adminConceptos = new AdministradorConceptos();
    $sql = '
      select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
         inner join clientes c 
         on c.id = f.nombre 
         inner join empresas e 
         on e.id  = f.razon 
         inner join formas_pago fp 
         on fp.id = f.forma_pago 
         inner join metodos_pago mp 
         on mp.id = f.metodo_pago 
         inner join facturas_fav fv
       on f.id = fv.id_factura
         where fv.id_usuario = ' . $usuario . ' and e.id = ' . $empresa . '
         order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->conceptos = $adminConceptos->dameConceptosPorFactura($factura->id);
      array_push($facturas, $factura);
    }
    return $facturas;
  }


  public function dameComplementos()
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas_complementos f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasEmpresaRazon($empresa, $razon)
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    where f.razon = ' . $empresa . ' and f.id_clave_corta = ' . $razon . '  and f.metodo_pago = 2 order by f.id desc limit 1000';
    //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->numeroPago = $this->cuentaComplementos($factura->id);
      $factura->saldo = $factura->total_factura -  $this->sumaSaldos($factura->id);
      array_push($facturas, $factura);
    }
    return $facturas;
  }



  public function dameFacturas()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra

    from facturas f 
        inner join clientes c 
        on c.id = f.nombre 
        inner join empresas e 
        on e.id  = f.razon 
        inner join formas_pago fp 
        on fp.id = f.forma_pago 
        inner join metodos_pago mp 
        on mp.id = f.metodo_pago  
        inner join claves_cortas cc
        on cc.id = f.id_clave_corta
        left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra
        where f.razon != 132
         group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }


  public function dameFacturasEliminadasRep()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra

    from facturas_eliminadas f 
        inner join clientes c 
        on c.id = f.nombre 
        inner join empresas e 
        on e.id  = f.razon 
        inner join formas_pago fp 
        on fp.id = f.forma_pago 
        inner join metodos_pago mp 
        on mp.id = f.metodo_pago  
        inner join claves_cortas cc
        on cc.id = f.id_clave_corta
        left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra
        where f.razon != 132
         group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  function dameFacturasInternas(){
    $primeroMesActual = date('Y-m-01');

    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra

    from facturas f 
        inner join clientes c 
        on c.id = f.nombre 
        inner join empresas e 
        on e.id  = f.razon 
        inner join formas_pago fp 
        on fp.id = f.forma_pago 
        inner join metodos_pago mp 
        on mp.id = f.metodo_pago  
        inner join claves_cortas cc
        on cc.id = f.id_clave_corta
        left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra
        where f.nombre = 13 and f.fecha >= "'.$primeroMesActual.'"
         group by f.id order by f.total_iva desc;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasEliminadas()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra

    from facturas_eliminadas f 
        inner join clientes c 
        on c.id = f.nombre 
        inner join empresas e 
        on e.id  = f.razon 
        inner join formas_pago fp 
        on fp.id = f.forma_pago 
        inner join metodos_pago mp 
        on mp.id = f.metodo_pago  
        inner join claves_cortas cc
        on cc.id = f.id_clave_corta
        left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra
         group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasCanceladas()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra

    from facturas_eliminadas f 
        inner join clientes c 
        on c.id = f.nombre 
        inner join empresas e 
        on e.id  = f.razon 
        inner join formas_pago fp 
        on fp.id = f.forma_pago 
        inner join metodos_pago mp 
        on mp.id = f.metodo_pago  
        inner join claves_cortas cc
        on cc.id = f.id_clave_corta
        left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra 
        where uuid IS NOT NULL 
        group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }


  public function dameFacturasNoRelacionadasBuscadas($buscar)
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    inner join claves_cortas cc
    on cc.id = f.id_clave_corta
    left join usuarios u 
    on u.id = f.usuario_crea
    where (f.uuid = "'.$buscar.'" or f.id = '.intval( $buscar).')
     group by f.id order by f.id desc limit 1000;';
     //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }




  public function dameFacturasNoRelacionadas()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre 
    from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    inner join claves_cortas cc
    on cc.id = f.id_clave_corta
    left join usuarios u 
    on u.id = f.usuario_crea
    left join pagos p on p.id = f.id_pago
    where f.id_pago IS NULL and f.fecha_timbrado >= "2024-05-08"  AND p.id IS NULL
     group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasRelacionadas()
  {
    $sql = 'select u.nombre as usuario_creo, f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cc.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago  
    inner join claves_cortas cc
    on cc.id = f.id_clave_corta
    left join usuarios u 
    on u.id = f.usuario_crea
    where f.id_pago IS NOT NULL
     group by f.id order by f.id desc limit 1000;';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }






  public function dameFacturaSimple($id)
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago where f.id = ' . $id . ';';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $factura = new Factura();
    $factura->id = $fila['id'];
    $factura->fecha = $fila['fecha'];
    $factura->nombre = $fila['nombre'];
    $factura->metodo_pago = $fila['metodo_pago'];
    $factura->moneda = $fila['moneda'];
    $factura->forma_pago = $fila['forma_pago'];
    $factura->status_pago = $fila['status_pago'];
    $factura->total_factura = $fila['total_factura'];
    $factura->empresa = $fila['empresa'];
    $factura->estatus_cert = $fila['estatus_cert'];
    $factura->certificado = $fila['certificado'];
    $factura->cadena = $fila['cadena'];
    $factura->id_factura = $fila['id_factura'];
    $factura->razon = $fila['razon'];
    $factura->tipo_factura = $fila['tipo_factura'];
    $factura->total_sin_iva = $fila['total_sin_iva'];
    $factura->total_iva = $fila['total_iva'];
    $factura->empresa_destino = $fila['empresa_destino'];
    $factura->token = $fila['token'];
    $factura->tipo_comprobante = $fila['tipo_comprobante'];
    $factura->uso_cfdi = $fila['uso_cfdi'];
    $factura->num_certificado = $fila['num_certificado'];
    $factura->certificado_fact = $fila['certificado_fact'];
    $factura->uuid = $fila['uuid'];
    $factura->fecha_timbrado = $fila['fecha_timbrado'];
    $factura->hora_timbrado = $fila['hora_timbrado'];
    $factura->sello_cfd = $fila['sello_cfd'];
    $factura->num_certificado_sat = $fila['num_certificado_sat'];
    $factura->sello_sat = $fila['sello_sat'];
    $factura->complemento = $fila['complemento'];
    $factura->id_pago = $fila['id_pago'];
    $factura->requiere_complemento = $fila['requiere_complemento'];
    $factura->factura_manual = $fila['factura_manual'];
    $factura->id_clave_corta = $fila['id_clave_corta'];
    $factura->xml_firmado = $fila['xml_firmado'];
    $factura->status = $fila['status'];
    $factura->enviado = $fila['enviado'];
    $factura->cuadrado = $fila['cuadrado'];
    $factura->id_captura = $fila['id_captura'];
    $factura->status_error = $fila['status_error'];
    $factura->folio = $fila['folio'];
    $factura->usuario_crea = $fila['usuario_crea'];
    $factura->serie = $fila['serie'];
    $factura->retencion_transporte = $fila['retencion_transporte'];
    $factura->xml_total = $fila['xml_total'];
    $factura->xml_subtotal = $fila['xml_subtotal'];
    $factura->cliente = $fila['cliente_nombre'];
    $factura->empresa_nombre = $fila['empresa_nombre'];
    $factura->empresa_rfc = $fila['empresa_rfc'];
    return $factura;
  }



  public function dameFactura($id)
  {
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago where f.id = ' . $id . ';';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $factura = new Factura();
    $factura->id = $fila['id'];
    $factura->fecha = $fila['fecha'];
    $factura->nombre = $fila['nombre'];
    $factura->metodo_pago = $fila['metodo_pago'];
    $factura->moneda = $fila['moneda'];
    $factura->forma_pago = $fila['forma_pago'];
    $factura->status_pago = $fila['status_pago'];
    $factura->total_factura = $fila['total_factura'];
    $factura->empresa = $fila['empresa'];
    $factura->estatus_cert = $fila['estatus_cert'];
    $factura->certificado = $fila['certificado'];
    $factura->cadena = $fila['cadena'];
    $factura->id_factura = $fila['id_factura'];
    $factura->razon = $fila['razon'];
    $factura->tipo_factura = $fila['tipo_factura'];
    $factura->total_sin_iva = $fila['total_sin_iva'];
    $factura->total_iva = $fila['total_iva'];
    $factura->empresa_destino = $fila['empresa_destino'];
    $factura->token = $fila['token'];
    $factura->tipo_comprobante = $fila['tipo_comprobante'];
    $factura->uso_cfdi = $fila['uso_cfdi'];
    $factura->num_certificado = $fila['num_certificado'];
    $factura->certificado_fact = $fila['certificado_fact'];
    $factura->uuid = $fila['uuid'];
    $factura->fecha_timbrado = $fila['fecha_timbrado'];
    $factura->hora_timbrado = $fila['hora_timbrado'];
    $factura->sello_cfd = $fila['sello_cfd'];
    $factura->num_certificado_sat = $fila['num_certificado_sat'];
    $factura->sello_sat = $fila['sello_sat'];
    $factura->complemento = $fila['complemento'];
    $factura->id_pago = $fila['id_pago'];
    $factura->requiere_complemento = $fila['requiere_complemento'];
    $factura->factura_manual = $fila['factura_manual'];
    $factura->id_clave_corta = $fila['id_clave_corta'];
    $factura->xml_firmado = $fila['xml_firmado'];
    $factura->status = $fila['status'];
    $factura->enviado = $fila['enviado'];
    $factura->cuadrado = $fila['cuadrado'];
    $factura->id_captura = $fila['id_captura'];
    $factura->status_error = $fila['status_error'];
    $factura->folio = $fila['folio'];
    $factura->usuario_crea = $fila['usuario_crea'];
    $factura->serie = $fila['serie'];
    $factura->retencion_transporte = $fila['retencion_transporte'];
    $factura->xml_total = $fila['xml_total'];
    $factura->xml_subtotal = $fila['xml_subtotal'];
    $factura->cliente = $fila['cliente_nombre'];
    $factura->empresa_nombre = $fila['empresa_nombre'];
    $factura->empresa_rfc = $fila['empresa_rfc'];
    $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
    $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
    $factura->conceptos = $this->dameConceptosPorFactura($factura->id);
    return $factura;
  }

  public function dameFacturasPorMonto($monto, $fecha, $cliente)
  {
    $montoSup = $monto + 0.3;
    $montoInf = $monto - 0.3;
    $fechaMin = date('Y-m-d', strtotime('-6 month', strtotime($fecha)));
    $fechaMax = date('Y-m-d', strtotime('+6 month', strtotime($fecha)));
    $sql = ' select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where f.total_factura > ' . $montoInf . ' and  f.total_factura < ' . $montoSup . ' and f.fecha_timbrado > "' . $fechaMin . '" and f.fecha_timbrado < "' . $fechaMax . '"  and f.nombre = ' . $cliente . ' order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasEliminadasPorCaptura()
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre 
    from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where status = "CAPDEL" 
    order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasSinTimbrar()
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where uuid is null
    order by f.id desc limit 1000';
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }


  public function dameFacturasSinTimbrarTemporal()
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where uuid is null
    and f.razon not in (107,102)
    and f.id_clave_corta not in (270, 543)
      and f.status is null
    limit 1';
    // and f.razon not in (107,102)
    // and f.id_clave_corta not in (270, 543)
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

    public function dameFacturasPeriodo($inicio, $fin)
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, e.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where f.fecha_timbrado >= "' . $inicio . '" and f.fecha_timbrado <= "' . $fin . '"';

    // and f.razon not in (107,102)
    // and f.id_clave_corta not in (270, 543)
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasBusquedaEliminadas($busqueda)
  {
    $sql = 'select f.*, u2.nombre as usuario_timbra_nombre, u2.id as id_usuario_timbra,  c.nombre  as cliente_nombre, e.razon as empresa_nombre, cla.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas_eliminadas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    inner join claves_cortas cla
    on f.id_clave_corta = cla.id
     left join usuarios u 
        on u.id = f.usuario_crea
        left join usuarios u2
        on u2.id = f.usuario_timbra
    where f.id like "%' . $busqueda . '%" or  f.fecha like "%' . $busqueda . '%" or f.nombre like "%' . $busqueda . '%" or mp.metodo_pago like "%' . $busqueda . '%" or fp.forma_pago like "%' . $busqueda . '%" or e.razon like "%' . $busqueda . '%" or total_factura = "' . $busqueda . '" or status_pago like "%' . $busqueda . '%" or c.nombre like "%' . $busqueda . '%" or fecha_timbrado like "%' . $busqueda . '%" or uuid like "%' . $busqueda . '%" or e.rfc like "%' . $busqueda . '%" or cla.rfc like "%' . $busqueda . '%"  or f.folio like "%' . $busqueda . '%" or f.total_iva like "%' . $busqueda . '%" or f.xml_subtotal like "%' . $busqueda . '%" or f.xml_total like "%' . $busqueda . '%"
    order by f.id desc limit 1000;';
    //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuario_crea = $fila['usuario_creo'];

      if ($factura->usuario_crea == '') {
        $factura->usuario_crea = 'AUTO';
      }

      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      $factura->usuarioTimbra = $fila['id_usuario_timbra'];
      $factura->usuarioTimbraNombre = $fila['usuario_timbra_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function dameFacturasBusqueda($busqueda)
  {
    $sql = 'select f.*, c.nombre  as cliente_nombre, e.razon as empresa_nombre, cla.rfc as empresa_rfc, fp.forma_pago as forma_pago_nombre, mp.metodo_pago  as metodo_pago_nombre from facturas f 
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    inner join claves_cortas cla
    on f.id_clave_corta = cla.id
    where f.id like "%' . $busqueda . '%" or  f.fecha like "%' . $busqueda . '%" or f.nombre like "%' . $busqueda . '%" or mp.metodo_pago like "%' . $busqueda . '%" or fp.forma_pago like "%' . $busqueda . '%" or e.razon like "%' . $busqueda . '%" or total_factura = "' . $busqueda . '" or status_pago like "%' . $busqueda . '%" or c.nombre like "%' . $busqueda . '%" or fecha_timbrado like "%' . $busqueda . '%" or uuid like "%' . $busqueda . '%" or e.rfc like "%' . $busqueda . '%" or cla.rfc like "%' . $busqueda . '%"  or f.folio like "%' . $busqueda . '%" or f.total_iva like "%' . $busqueda . '%" or f.xml_subtotal like "%' . $busqueda . '%" or f.xml_total like "%' . $busqueda . '%"
    order by f.id desc limit 20000;';
    //echo $sql;
    $result = $this->ejecutar($sql);
    $facturas = array();
    while ($fila = mysqli_fetch_array($result)) {
      $factura = new Factura();
      $factura->id = $fila['id'];
      $factura->fecha = $fila['fecha'];
      $factura->nombre = $fila['nombre'];
      $factura->metodo_pago = $fila['metodo_pago'];
      $factura->moneda = $fila['moneda'];
      $factura->forma_pago = $fila['forma_pago'];
      $factura->status_pago = $fila['status_pago'];
      $factura->total_factura = $fila['total_factura'];
      $factura->empresa = $fila['empresa'];
      $factura->estatus_cert = $fila['estatus_cert'];
      $factura->certificado = $fila['certificado'];
      $factura->cadena = $fila['cadena'];
      $factura->id_factura = $fila['id_factura'];
      $factura->razon = $fila['razon'];
      $factura->tipo_factura = $fila['tipo_factura'];
      $factura->total_sin_iva = $fila['total_sin_iva'];
      $factura->total_iva = $fila['total_iva'];
      $factura->empresa_destino = $fila['empresa_destino'];
      $factura->token = $fila['token'];
      $factura->tipo_comprobante = $fila['tipo_comprobante'];
      $factura->uso_cfdi = $fila['uso_cfdi'];
      $factura->num_certificado = $fila['num_certificado'];
      $factura->certificado_fact = $fila['certificado_fact'];
      $factura->uuid = $fila['uuid'];
      $factura->fecha_timbrado = $fila['fecha_timbrado'];
      $factura->hora_timbrado = $fila['hora_timbrado'];
      $factura->sello_cfd = $fila['sello_cfd'];
      $factura->num_certificado_sat = $fila['num_certificado_sat'];
      $factura->sello_sat = $fila['sello_sat'];
      $factura->complemento = $fila['complemento'];
      $factura->id_pago = $fila['id_pago'];
      $factura->requiere_complemento = $fila['requiere_complemento'];
      $factura->factura_manual = $fila['factura_manual'];
      $factura->id_clave_corta = $fila['id_clave_corta'];
      $factura->xml_firmado = $fila['xml_firmado'];
      $factura->status = $fila['status'];
      $factura->enviado = $fila['enviado'];
      $factura->cuadrado = $fila['cuadrado'];
      $factura->id_captura = $fila['id_captura'];
      $factura->status_error = $fila['status_error'];
      $factura->folio = $fila['folio'];
      $factura->usuario_crea = $fila['usuario_crea'];
      $factura->serie = $fila['serie'];
      $factura->retencion_transporte = $fila['retencion_transporte'];
      $factura->xml_total = $fila['xml_total'];
      $factura->xml_subtotal = $fila['xml_subtotal'];
      $factura->cliente = $fila['cliente_nombre'];
      $factura->empresa_nombre = $fila['empresa_nombre'];
      $factura->empresa_rfc = $fila['empresa_rfc'];
      $factura->metodo_pago_nombre = $fila['metodo_pago_nombre'];
      $factura->forma_pago_nombre = $fila['forma_pago_nombre'];
      array_push($facturas, $factura);
    }
    return $facturas;
  }

  public function cuentaFacturas()
  {
    $sql = 'select count(*) as cuenta from facturas';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }

  public function cuentaFacturasSinTimbrar()
  {
    $sql = 'select count(*) as cuenta from facturas f
    inner join clientes c 
    on c.id = f.nombre 
    inner join empresas e 
    on e.id  = f.razon 
    inner join formas_pago fp 
    on fp.id = f.forma_pago 
    inner join metodos_pago mp 
    on mp.id = f.metodo_pago 
    where uuid is null
    ';
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }

  public function nuevaFormaPago($forma_pago)
  {
    $sql = "INSERT INTO formas_pago (forma_pago) VALUES ('$forma_pago')";
    $this->ejecutar($sql);
  }
  public function dameFormasPago()
  {
    $sql = "SELECT * FROM formas_pago";
    $result = $this->ejecutar($sql);
    $formasPago = array();
    while ($fila = mysqli_fetch_array($result)) {
      $formaPago = new FormaPago($fila['id'], $fila['clave'], $fila['forma_pago']);
      $formaPago->accion = '<a href="cat-formas-pago-mod?id=' . $fila['id'] . '"> <div class="circle long">
      <p>Ver</p>
    </div> </a>';
      array_push($formasPago, $formaPago);
    }
    return $formasPago;
  }

  public function dameFormaPago($id)
  {
    $sql = "SELECT * FROM formas_pago WHERE id = $id";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    $formaPago = new FormaPago($fila['id'], $fila['clave'], $fila['forma_pago']);
    return $formaPago;
  }

  public function cuentaFormasPago()
  {
    $sql = "SELECT COUNT(*) AS cuenta FROM formas_pago";
    $result = $this->ejecutar($sql);
    $fila = mysqli_fetch_array($result);
    return $fila['cuenta'];
  }
}
