<?php 
include_once 'adminFacturasSEC.php';
include_once 'adminConceptos.php';


$accion = $_POST['action'];

$casoRecrear = 'recrearFactura';
$casoGuardarRecreada = 'guardarFacturaRecreada';



function recrearFactura() {
    $id = $_POST['id'];
    $adminConceptos = new AdministradorConceptos();
    $adminFacturas = new AdministradorFacturas();
    $conceptosRecreados = $adminFacturas->dameFacturasPre($id);
    $factura = $adminFacturas->dameFactura($id);
    $conceptosSistema = array();
    $conceptosDetalles = array();
    foreach ($conceptosRecreados as $concepto) {
        $conceptoEnSistema = $adminConceptos->dameConceptosClaveSatRazon($concepto->clave_sat, $factura->razon)[0];
        $conceptosDetalles[] = [
            //SELECT id, id_factura, id_producto, cantidad, precio_unitario, precio_con_iva, precio_neto, precio_neto_iva, concepto, iva FROM iohanes_14.detalle_factura;
            'id_factura' => $factura->id,
            'id_producto' => $conceptoEnSistema->id,
            'cantidad' => $concepto->cantidad,
            'precio_unitario' => $concepto->precio_unitario,
            'precio_con_iva' => $concepto->precio_unitario_iva,
            'precio_neto' => $concepto->total,
            'precio_neto_iva' => $concepto->total_iva,
            'concepto' => $concepto->concepto,
            'iva' => $conceptoEnSistema->iva,
            'clave_sat' => $conceptoEnSistema->clave_sat,
        ];
    }   

    echo json_encode([
        'conceptos' => $conceptosDetalles,
        'razon' => $factura->razon,
        'total_iva' => $factura->total_iva,
        'id' => $id
    ]);

}


function guardarFacturaRecreada(){
    $adminFacturas = new AdministradorFacturas();
    $id = $_POST['id'];
    $conceptos = json_decode($_POST['conceptos'], true);
    $idFacturaClonada = $adminFacturas->clonarFactura($id);
    foreach ($conceptos as $concepto) {
        //agregarConcepto($id_factura, $id_producto, $cantidad, $precio_unitario, $precio_con_iva, $precio_neto, $precio_neto_iva, $concepto)
        //echo 'Se inserto el concepto: ' . $concepto['concepto'] . ' para id: ' . $idFacturaClonada . '<br>';
        $adminFacturas->agregarConcepto(
            $idFacturaClonada,
            $concepto['id_producto'],
            $concepto['cantidad'],
            $concepto['precio_unitario'],
            $concepto['precio_con_iva'],
            $concepto['precio_neto'],
            $concepto['precio_neto_iva'],
            $concepto['concepto']
        );
    }
    echo json_encode([
        'status' => 'success',
        'message' => 'Factura recreada y conceptos guardados correctamente.',
        'id_factura' => $idFacturaClonada
    ]);

}



switch ($accion) {
    case $casoRecrear:
     recrearFactura();
        break;
    case $casoGuardarRecreada:
        guardarFacturaRecreada();
        break;
    default:
        echo json_encode(['error' => 'Acción no reconocida']);
        break;
}

?> 