<?php

function crearDocumentoXML($ruta)
{
    // Crear un nuevo documento XML
    $xmlDoc = new DOMDocument('1.0', 'UTF-8');
    
    // Crear el elemento raíz 'cfdi:Comprobante'
    $comprobante = $xmlDoc->createElement('cfdi:Comprobante');
    
    // Agregar los atributos al elemento 'cfdi:Comprobante'
    $comprobante->setAttribute('xmlns:cfdi', 'http://www.sat.gob.mx/cfd/4');
    $comprobante->setAttribute('xmlns:pago20', 'http://www.sat.gob.mx/Pagos20');
    $comprobante->setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
    $comprobante->setAttribute('Certificado', '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"');
    $comprobante->setAttribute('Exportacion' , '01');
    $comprobante->setAttribute('Fecha', '2024-02-13T15:03:22');
    $comprobante->setAttribute('Folio', '544');
    $comprobante->setAttribute('LugarExpedicion', '44670');
    $comprobante->setAttribute('Moneda', 'XXX');
    $comprobante->setAttribute('NoCertificado', '00001000000511805964');
    $comprobante->setAttribute('Sello', 'c7bZuy4Y2VUmvu9S9ozhmyyi3MV2WiYC6SnmymkUW9AxWmIN/IvqCMlhGb8CWCBV51ODf44GBXCUn+VIktVL16UfMOvf+P+lZ56sq3YS2Wsntem1rsj/+co9aig+pDhOOatyHoWB0TDgSZC5RXHEF3Ng6vzQ1MuwImSPkqXfDMi4mOYJ5xs1854/QNt63dhY0KPhhVff3NGLgdJdjBNkamK1JCnHlVLCTo8wY1HdQCcf7De9I3V8fSztDYcuKFCKVrE5V3p1PBq0HI6navOotY8Mr/I1mRblj/iMZGMlBvb0d457K+HOgc06/M6a8kxRtBqIcWa/Msdy9hK/Q1O0hA==');
    $comprobante->setAttribute('Serie', 'P');
    $comprobante->setAttribute('SubTotal', '0');
    $comprobante->setAttribute('TipoDeComprobante', 'P');
    $comprobante->setAttribute('Total', '0');
    $comprobante->setAttribute('Version', '4.0');
    $comprobante->setAttribute('xsi:schemaLocation', 'http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd http://www.sat.gob.mx/Pagos20 http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos20.xsd');

    
    // Agregar elementos hijo al elemento 'cfdi:Comprobante'
    $emisor = $xmlDoc->createElement('cfdi:Emisor');
    $emisor->setAttribute('Nombre', 'NALDUR COMMERCE MEXICO');
    $emisor->setAttribute('RegimenFiscal', '601');
    $emisor->setAttribute('Rfc', 'NCM180130I75');
    $comprobante->appendChild($emisor);
    
    $receptor = $xmlDoc->createElement('cfdi:Receptor');
    $receptor->setAttribute('DomicilioFiscalReceptor', '45239');
    $receptor->setAttribute('Nombre', 'DELMENT TRADING');
    $receptor->setAttribute('RegimenFiscalReceptor', '601');
    $receptor->setAttribute('Rfc', 'DTR211025CU0');
    $receptor->setAttribute('UsoCFDI', 'CP01');
    $comprobante->appendChild($receptor);
    
    $conceptos = $xmlDoc->createElement('cfdi:Conceptos');
    $concepto = $xmlDoc->createElement('cfdi:Concepto');
    $concepto->setAttribute('Cantidad', '1');
    $concepto->setAttribute('ClaveProdServ', '84111506');
    $concepto->setAttribute('ClaveUnidad', 'ACT');
    $concepto->setAttribute('Descripcion', 'Pago');
    $concepto->setAttribute('Importe', '0');
    $concepto->setAttribute('ObjetoImp', '01');
    $concepto->setAttribute('ValorUnitario', '0');
    $conceptos->appendChild($concepto);
    $comprobante->appendChild($conceptos);


    //complemento

    $complemento = $xmlDoc->createElement('cfdi:Complemento');
    $pago = $xmlDoc->createElement('pago20:Pagos');
    $pago->setAttribute('Version', '2.0');
    //<pago20:Totales MontoTotalPagos="7471.29" TotalTrasladosBaseIVA16="78051.31" TotalTrasladosImpuestoIVA16="12488.21"/>

    $pagoTotales = $xmlDoc->createElement('pago20:Totales');
    $pagoTotales->setAttribute('MontoTotalPagos', '7471.29');
    $pagoTotales->setAttribute('TotalTrasladosBaseIVA16', '78051.31');
    $pagoTotales->setAttribute('TotalTrasladosImpuestoIVA16', '12488.21');
    //<pago20:Pago FechaPago="2024-01-12T15:02:00" FormaDePagoP="03" MonedaP="MXN" Monto="7471.29" TipoCambioP="1">
    $pagoPago = $xmlDoc->createElement('pago20:Pago');
    $pagoPago->setAttribute('FechaPago', '2024-01-12T15:02:00');
    $pagoPago->setAttribute('FormaDePagoP', '03');
    $pagoPago->setAttribute('MonedaP', 'MXN');
    $pagoPago->setAttribute('Monto', '7471.29');
    $pagoPago->setAttribute('TipoCambioP', '1');

  //<pago20:DoctoRelacionado EquivalenciaDR="1" Folio="567104" IdDocumento="7ED89BF2-41D3-47DE-AF34-5596466424FC" ImpPagado="7471.29" ImpSaldoAnt="25942.53" ImpSaldoInsoluto="18471.24" MonedaDR="MXN" NumParcialidad="3" ObjetoImpDR="02" Serie="CW">

    $pagoPagoRel = $xmlDoc->createElement('pago20:DoctoRelacionado');
    $pagoPagoRel->setAttribute('EquivalenciaDR', '1');
    $pagoPagoRel->setAttribute('Folio', '567104');
    $pagoPagoRel->setAttribute('IdDocumento', '7ED89BF2-41D3-47DE-AF34-5596466424FC');
    $pagoPagoRel->setAttribute('ImpPagado', '7471.29');
    $pagoPagoRel->setAttribute('ImpSaldoAnt', '25942.53');
    $pagoPagoRel->setAttribute('ImpSaldoInsoluto', '18471.24');
    $pagoPagoRel->setAttribute('MonedaDR', 'MXN');
    $pagoPagoRel->setAttribute('NumParcialidad', '3');
    $pagoPagoRel->setAttribute('ObjetoImpDR', '02');
    $pagoPagoRel->setAttribute('Serie', 'CW');
    $impuestosDr = $xmlDoc->createElement('pago20:ImpuestosDR');
    $trasladosDr = $xmlDoc->createElement('pago20:TrasladosDR');
    $trasladoDr = $xmlDoc->createElement('pago20:TrasladoDR');
    //<pago20:TrasladoDR BaseDR="78051.31" ImporteDR="12488.209600" ImpuestoDR="002" TasaOCuotaDR="0.160000" TipoFactorDR="Tasa"/>

    $trasladoDr->setAttribute('BaseDR', '78051.31');
    $trasladoDr->setAttribute('ImporteDR', '12488.209600');
    $trasladoDr->setAttribute('ImpuestoDR', '002');
    $trasladoDr->setAttribute('TasaOCuotaDR', '0.160000');
    $trasladoDr->setAttribute('TipoFactorDR', 'Tasa');



    $impuestosP = $xmlDoc->createElement('pago20:ImpuestosP');
    $trasladosP = $xmlDoc->createElement('pago20:TrasladosP');
    $trasladoP = $xmlDoc->createElement('pago20:TrasladoP');
//<pago20:TrasladoP BaseP="78051.310000" ImporteP="12488.209600" ImpuestoP="002" TasaOCuotaP="0.160000" TipoFactorP="Tasa"/>

    $trasladoP->setAttribute('BaseP', '78051.310000');
    $trasladoP->setAttribute('ImporteP', '12488.209600');
    $trasladoP->setAttribute('ImpuestoP', '002');
    $trasladoP->setAttribute('TasaOCuotaP', '0.160000');
    $trasladoP->setAttribute('TipoFactorP', 'Tasa');

    $trasladosP->appendChild($trasladoP);
    $impuestosP->appendChild($trasladosP);

    $trasladosDr->appendChild($trasladoDr);
    $impuestosDr->appendChild($trasladosDr);
    $pagoPagoRel->appendChild($impuestosDr);
    $pago->appendChild($pagoTotales);
    $pago->appendChild($pagoPago);
    $pagoPago->appendChild($pagoPagoRel);
    $pagoPago->appendChild($impuestosP);
    $complemento->appendChild($pago);
    $comprobante->appendChild($complemento);





    
    // Continúa agregando el resto de los elementos y atributos según sea necesario
    
    // Agregar el elemento 'cfdi:Comprobante' al documento
    $xmlDoc->appendChild($comprobante);
    
    // Formatear el XML para mejor legibilidad
    $xmlDoc->formatOutput = true;
    
    // Guardar el XML en la ruta especificada
    $xmlDoc->save($ruta);
}

// Ruta donde se guardará el archivo XML
$rutaArchivoXML = 'xml/documento'.rand(1,100).'.xml';

// Crear el documento XML
crearDocumentoXML($rutaArchivoXML);

// Ver xml
echo file_get_contents($rutaArchivoXML);
?>