<?php
header('Content-Type: application/json');
include_once 'adminFacturasSEC.php';
include_once 'adminClavesCortas.php';
include_once 'adminConceptos.php';
include_once 'adminEmpresas.php';
$adminFacturas = new AdministradorFacturas();
$adminEmpresas = new AdminEmpresas();
$adminClavesCortas = new AdministradorClavesCortas();
$adminConceptos = new AdministradorConceptos();
$factura  = $adminFacturas->dameFacturaSinCuadrar();
$empresa = $adminEmpresas->dameEmpresa($factura[0]->razon);
$claveCorta = $adminClavesCortas->dameClaveCorta($factura[0]->id_clave_corta);
$empresaR = $adminEmpresas->dameEmpresaRfcLite($claveCorta->rfc);
$conceptosCruzados = $adminConceptos->dameConceptosCruzados($empresa->id, $empresaR->id);


function numeroConProbabilidad() {
    $probabilidades = [
        1 => 73, // 73%
        2 => 24, // 24%
        3 => 41, // 41%
        4 => 17, // 17%
        5 => 8   // 8%
    ];

    $total = array_sum($probabilidades);
    $rand = mt_rand(1, $total);
    $acumulado = 0;
    foreach ($probabilidades as $numero => $prob) {
        $acumulado += $prob;
        if ($rand <= $acumulado) {
            return $numero;
        }
    }
}


$llave = 'asg31323ogldf1235sdfg45gdfg';

if (isset($_GET['llave']) && $_GET['llave'] == $llave) {


    $json = array(
        'id' => $factura[0]->id,
        'folio' => $factura[0]->folio,
        'razon' => $factura[0]->razon,
        'rfc' => $factura[0]->rfc,
        'fecha' => $factura[0]->fecha,
        'total' => $factura[0]->total_factura,
        'total_iva' => $factura[0]->total_iva,
        'conceptos' => $conceptosCruzados,
        'descripcion' => $empresa->descripcion,
        'descripcion_rfc' => $empresaR->descripcion,
        'nombre' => $empresa->razon,
        'nombre_rfc' => $empresaR->razon,
        'uso_conceptos' => numeroConProbabilidad()

    );
    echo json_encode($json);
    //marcar factura como enviada a n8n
    $adminFacturas->marcarFacturasCuadrado($factura[0]->id, 99);
} else {
    $json = array(
        'error' => 'Acceso no autorizado'
    );
    echo json_encode($json);
}
