<?php
// Configuración de conexión
$host = 'localhost';
$db = 'iohanes_14';
$user = 'iohanes_14';
$pass = 'bSh4_(+L*)sY';
$llave = 'asd3123gldfglasd1234';
$llaveGet = $_GET['llave'];


try {
    if ($llaveGet !== $llave) {
        echo json_encode(['error' => 'Llave de acceso inválida']);
        exit;
    }
    //SELECT id, concepto, clave_sat, cantidad, precio_unitario, precio_unitario_iva, id_factura, total, total_iva FROM iohanes_14.facturas_pre;
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    $explicacion = $data['explicacion'];
    $data = $data['data'][0];

    //echo json_encode($data);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['error' => 'Error al decodificar JSON: ' . json_last_error_msg()]);
        exit;
    }

    $mensajes = [];

    $id_factura = $data['id_factura'];
    $conceptos = $data['conceptos'];
    $escenario = $data['escenario'] . ' ' . $explicacion;

    $mensajes[] = "Escenario: $escenario";

    foreach ($conceptos as $concepto) {
        $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare("INSERT INTO facturas_pre (concepto, clave_sat, cantidad, precio_unitario, precio_unitario_iva, id_factura, total, total_iva) VALUES (:concepto, :clave_sat, :cantidad, :precio_unitario, :precio_unitario_iva, :id_factura, :total, :total_iva)");
        //insertar el concepto en la base de datos
        $stmt->execute([
            ':concepto' => $concepto['nombre'],
            ':clave_sat' => $concepto['clave_sat'],
            ':cantidad' => $concepto['cantidad'],
            ':precio_unitario' => $concepto['precio_unitario'],
            ':precio_unitario_iva' => $concepto['precio_unitario_iva'],
            ':id_factura' => $id_factura,
            ':total' => $concepto['total'],
            ':total_iva' => $concepto['total_iva']
        ]);
        $mensajes[] = "Concepto '{$concepto['nombre']}' procesado correctamente en el escenario '$escenario'.";
    }

    //marcar factura como procesada
    $stmt = $pdo->prepare("UPDATE facturas SET cuadrado = 1, ecenario = :escenario WHERE id = :id_factura");
    $stmt->execute([
        ':escenario' => $escenario,
        ':id_factura' => $id_factura
    ]);
    header('Content-Type: application/json');
    //echo json_encode($data);
    echo json_encode(['success' => true, 'message' => 'Factura creada correctamente.', 'details' => $mensajes], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} catch (PDOException $e) {
    // Manejo de error
    echo json_encode(['error' => 'Error en la conexión: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['error' => 'Error general: ' . $e->getMessage()]);
}
