<?php
/* ===========================================================
 *  Envío por Mandrill + APPEND IMAP a "Enviados" (PHP 5.4)
 * ===========================================================
 */
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once('adminUtil.php');
$adminUtil = new AdministradorUtil();
$conector  = new conectorS14();

/* ====== CONFIG IMAP ====== */
define('IMAP_HOST', '{mail.fapa.mx:993/imap/ssl}'); // AJUSTA TU HOST

// Mapa simple remitente -> password IMAP (puedes sustituirlo por consulta a BD)
$IMAP_PASSWORDS = array(
    'cuentas.premium@zacbanquetes.com'       => 'hrvR2NwEq&-E@@uD',
    'postventa@tcs-mexico.com'               => 'hrvR2NwEq&-E@@uD',
    'atencionalcliente@promotoracpe.com'     => 'hrvR2NwEq&-E@@uD',
    'clientes@parispublicidad.com'           => 'hrvR2NwEq&-E@@uD',
    'seguimiento@maniobrasnaldur.com'        => 'hrvR2NwEq&-E@@uD',
    'atencionpostventa@maguire.mx'           => 'hrvR2NwEq&-E@@uD',
    'asistencia@picamue.com'                 => 'hrvR2NwEq&-E@@uD',
    'atencionalcliente@edworld.mx'           => 'hrvR2NwEq&-E@@uD',
    'seguimiento@delment-trading.com'        => 'hrvR2NwEq&-E@@uD',
    'clientes.seguimiento@banquetesvistalomas.com' => 'hrvR2NwEq&-E@@uD',
    'clientes.seguimiento@afepsa.mx'         => 'hrvR2NwEq&-E@@uD',
);
/* ====== ASUNTOS ====== */
$asuntos = array(
    'Seguimiento de servicio prestado',
    'Seguimiento realizado',
    'Seguimiento de servicio concluido',
    'Seguimiento de servicio programado',
    'Seguimiento de servicio completado',
    'Seguimiento de servicio en curso',
    'Seguimiento de servicio finalizado',
    'Seguimiento de servicio ejecutado',
    'Seguimiento de servicio atendido',
    'Seguimiento de servicio solicitado',
    'Seguimiento de servicio agendado',
    'Seguimiento de servicio contratado',
    'Seguimiento de servicio brindado',
    'Seguimiento de servicio confirmado',
    'Seguimiento de servicio registrado',
    'Seguimiento de servicio asignado',
    'Seguimiento de servicio entregado',
    'Seguimiento de servicio cumplido',
    'Seguimiento de servicio reportado',
    'Seguimiento de servicio realizado al cliente'
);

$asuntosRespuesta = array(
    'Re: Seguimiento',
    'Re: Opiniones',
    'Re: Servicio al cliente',
    'Re: Consulta sobre su pedido'
);

$hoy = date('Y-m-d H:i:s');

$facturasSinEnviar    = $adminUtil->dameContextoCorreoSinEnviar();
$facturasSinResponder = $adminUtil->dameContextoSinReenvio();

foreach ($facturasSinEnviar as $fila) {
    $separado = separarCorreoRespuesta($fila->mensaje);
    if ($fila->fecha_entrega < $hoy) {
        $asunto = $asuntos[array_rand($asuntos)];
        echo "Enviado mensaje a {$fila->correo_destino} con asunto: $asunto <br>";
        echo "Mensaje: <br> {$separado['correo']} <br>";

        $correo_origen = $fila->correo_origen;
        $nombre        = $fila->nombreEmpresa;
        $mensaje       = $separado['correo'];

        enviarMailChimp(
            $fila->correo_destino,
            $nombre,
            $asunto,
            $mensaje,
            array(),  // adjuntos paths
            array(),  // adjuntos nombres
            array(),  // BCC extra
            $correo_origen
        );

        $adminUtil->marcarContextoEnviado($fila->id, 1);
    }
}

foreach ($facturasSinResponder as $fila) {
    $separado = separarCorreoRespuesta($fila->mensaje);
    if ($fila->fecha_respuesta < $hoy) {
        $asunto        = $asuntosRespuesta[array_rand($asuntosRespuesta)];
        $correo_origen = $fila->correo_destino; // responde desde la casilla que recibió
        $nombre        = $fila->nombreEmpresa;
        $mensaje       = $separado['respuesta'];

        $adminUtil->marcarContextoEnviado($fila->id, 2);

        enviarMailChimp(
            $fila->correo_origen, // destinatario original
            $nombre,
            $asunto,
            $mensaje,
            array(),
            array(),
            array(),
            $correo_origen
        );
    }
}

/* ===========================================================
 *  ENVÍO por Mandrill/Mailchimp + APPEND a Enviados por IMAP
 * ===========================================================
 */
function enviarMailChimp($email, $nombre, $asunto, $mensajeHtml, $attachment, $attachment_name, $mail_oculto, $correo_origen)
{
    $apiKey = 'md-N-ItQ7kjJI47Vv3jmGH5-A'; // AJUSTA TU API KEY

    // Destinatarios API Mandrill
    $to = array(
        array('email' => $email, 'name' => $nombre, 'type' => 'to')
    );

    if (is_array($mail_oculto)) {
        foreach ($mail_oculto as $bcc) {
            if (!empty($bcc)) {
                $to[] = array('email' => $bcc, 'type' => 'bcc');
            }
        }
    }

    if (stripos($asunto . ' ' . $mensajeHtml, 'fapa') !== false) {
        $to[] = array('email' => 'log@fapa.mx', 'type' => 'bcc');
    }

    // Adjuntos Mandrill
    $adjuntosApi = array();
    if (is_array($attachment)) {
        foreach ($attachment as $key => $value) {
            if (!isset($attachment_name[$key])) continue;
            $fileContent = @file_get_contents($value);
            if ($fileContent === false) continue;
            $adjuntosApi[] = array(
                'type'    => 'application/pdf',
                'name'    => $attachment_name[$key],
                'content' => base64_encode($fileContent)
            );
        }
    }

    // Llamada HTTP a Mandrill
    $postData = array(
        'key'     => $apiKey,
        'message' => array(
            'from_email'  => $correo_origen,
            'to'          => $to,
            'subject'     => $asunto,
            'html'        => $mensajeHtml,
            'attachments' => $adjuntosApi
        )
    );

    $ch = curl_init('https://mandrillapp.com/api/1.0/messages/send.json');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $curlErr  = ($response === false) ? curl_error($ch) : null;
    curl_close($ch);

    if ($response === false) {
        echo json_encode(array('status' => 'error', 'message' => $curlErr));
        return;
    }

    echo $response;

    /* ====== APPEND en IMAP "Enviados" ====== */
    // Preparar arrays To/Bcc para la copia en Sent
    $listaTo  = array($email);
    $listaBcc = array();
    foreach ($to as $rcp) {
        $tp = isset($rcp['type']) ? $rcp['type'] : '';
        if ($tp === 'bcc') $listaBcc[] = $rcp['email'];
    }

    $mensajeText = htmlToTextFallback($mensajeHtml);

    // Construye RFC822 con HTML + texto + adjuntos (PDF)
    $rawRfc822 = buildRawEmailWithAttachments(
        $correo_origen,
        $listaTo,
        array(),         // CC
        $listaBcc,       // BCC (si no quieres guardarlo, pasa array())
        $asunto,
        $mensajeText,
        $mensajeHtml,
        is_array($attachment) ? $attachment : array(),
        is_array($attachment_name) ? $attachment_name : array()
    );

    // Obtener credenciales IMAP del remitente
    $cred = obtenerCredencialesImap($correo_origen);
    if (!$cred || empty($cred['user']) || empty($cred['pass'])) {
        error_log("No hay credenciales IMAP para ".$correo_origen."; no se hará APPEND.");
        return;
    }

    // Guardar en “Enviados”
    $okAppend = imapAppendToSentAll(IMAP_HOST, $cred['user'], $cred['pass'], $rawRfc822);
    if (!$okAppend) {
        error_log("Fallo APPEND IMAP para ".$correo_origen);
    }
}

/* ===========================================================
 *  UTILIDADES (PHP 5.4-friendly)
 * ===========================================================
 */

// Fallback rápido HTML -> texto
function htmlToTextFallback($html) {
    $text = strip_tags($html);
    $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
    $text = preg_replace("/[ \t]+/", ' ', $text);
    $text = preg_replace("/\r\n|\r|\n/", "\r\n", $text);
    return trim($text);
}

// Codifica headers (Subject, etc) a MIME UTF-8
function mimeHeaderEncode($str) {
    return mb_encode_mimeheader($str, 'UTF-8', 'B', "\r\n");
}

// ID de mensaje sencillo (compatible 5.4)
function simpleMessageId() {
    $host = isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : 'localdomain';
    return '<'.uniqid('', true).'@'.$host.'>';
}

/**
 * Construye un RFC822 con:
 * - multipart/mixed (si hay adjuntos)
 *   - multipart/alternative (text/plain + text/html)
 * - adjuntos PDF
 */
function buildRawEmailWithAttachments(
    $fromEmail,
    $toEmails,
    $ccEmails,
    $bccEmails,
    $subject,
    $textBody,
    $htmlBody,
    $attachPaths,
    $attachNames
) {
    $dateRfc   = date('r');
    $messageId = simpleMessageId();
    $subjectM  = mimeHeaderEncode($subject);

    // Encabezados
    $headers = array();
    $headers[] = "Date: ".$dateRfc;
    $headers[] = "Message-ID: ".$messageId;
    $headers[] = "From: <".$fromEmail.">";

    if (is_array($toEmails) && count($toEmails)) {
        $toLineParts = array();
        foreach ($toEmails as $e) { $toLineParts[] = "<".$e.">"; }
        $headers[] = "To: ".implode(', ', $toLineParts);
    }

    if (is_array($ccEmails) && count($ccEmails)) {
        $ccLineParts = array();
        foreach ($ccEmails as $e) { $ccLineParts[] = "<".$e.">"; }
        $headers[] = "Cc: ".implode(', ', $ccLineParts);
    }

    if (is_array($bccEmails) && count($bccEmails)) {
        $bccLineParts = array();
        foreach ($bccEmails as $e) { $bccLineParts[] = "<".$e.">"; }
        $headers[] = "Bcc: ".implode(', ', $bccLineParts);
    }

    $headers[] = "Subject: ".$subjectM;
    $headers[] = "MIME-Version: 1.0";

    $hasAttachments = (is_array($attachPaths) && count($attachPaths) > 0);

    if ($hasAttachments) {
        $boundaryMixed = '=_mix_'.md5(uniqid('', true));
        $boundaryAlt   = '=_alt_'.md5(uniqid('', true));
        $headers[] = "Content-Type: multipart/mixed; boundary=\"".$boundaryMixed."\"";

        $body  = "This is a multi-part message in MIME format.\r\n";
        $body .= "--".$boundaryMixed."\r\n";
        $body .= "Content-Type: multipart/alternative; boundary=\"".$boundaryAlt."\"\r\n\r\n";

        // Texto
        $body .= "--".$boundaryAlt."\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
        $body .= quoted_printable_encode($textBody)."\r\n";

        // HTML
        $body .= "--".$boundaryAlt."\r\n";
        $body .= "Content-Type: text/html; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
        $body .= quoted_printable_encode($htmlBody)."\r\n";
        $body .= "--".$boundaryAlt."--\r\n";

        // Adjuntos
        foreach ($attachPaths as $idx => $path) {
            $name = isset($attachNames[$idx]) ? $attachNames[$idx] : basename($path);
            $file = @file_get_contents($path);
            if ($file === false) continue;

            $body .= "--".$boundaryMixed."\r\n";
            $body .= "Content-Type: application/pdf; name=\"".mimeHeaderEncode($name)."\"\r\n";
            $body .= "Content-Transfer-Encoding: base64\r\n";
            $body .= "Content-Disposition: attachment; filename=\"".mimeHeaderEncode($name)."\"\r\n\r\n";
            $body .= chunk_split(base64_encode($file))."\r\n";
        }

        $body .= "--".$boundaryMixed."--\r\n";
    } else {
        // Sin adjuntos: multipart/alternative
        $boundaryAlt = '=_alt_'.md5(uniqid('', true));
        $headers[] = "Content-Type: multipart/alternative; boundary=\"".$boundaryAlt."\"";

        $body  = "This is a multi-part message in MIME format.\r\n";
        $body .= "--".$boundaryAlt."\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
        $body .= quoted_printable_encode($textBody)."\r\n";

        $body .= "--".$boundaryAlt."\r\n";
        $body .= "Content-Type: text/html; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: quoted-printable\r\n\r\n";
        $body .= quoted_printable_encode($htmlBody)."\r\n";
        $body .= "--".$boundaryAlt."--\r\n";
    }

    return implode("\r\n", $headers)."\r\n\r\n".$body;
}

/**
 * APPEND del RFC822 a “Enviados” (detectando variantes).
 * Devuelve true si logra al menos un append.
 */
function imapAppendToSentAll($imapHost, $userEmail, $userPass, $rawRfc822, $internalDate = null) {
    if (!function_exists('imap_open')) {
        error_log('La extensión PHP IMAP no está habilitada.');
        return false;
    }

    $inbox = @imap_open($imapHost.'INBOX', $userEmail, $userPass, 0, 1);
    if (!$inbox) {
        error_log('IMAP open failed: '.imap_last_error());
        return false;
    }

    $mailboxes = imap_getmailboxes($inbox, $imapHost, '*');
    if ($mailboxes === false) $mailboxes = array();

    $candidatos = array('Sent', 'Enviados', 'Enviadas', 'Sent Items', 'Correo enviado', 'INBOX.Sent', 'INBOX.Enviados', 'INBOX.Sent Items');

    $destinos = array();
    foreach ($mailboxes as $mb) {
        $folder = preg_replace('#^\{[^}]+\}#', '', $mb->name);
        $plain  = mb_strtolower($folder, 'UTF-8');

        // Coincidencia exacta con candidatos comunes
        for ($i=0; $i<count($candidatos); $i++) {
            if ($plain === mb_strtolower($candidatos[$i], 'UTF-8')) {
                if (!in_array($folder, $destinos)) $destinos[] = $folder;
            }
        }

        // Heurística: contiene "sent" o "enviad"
        if (strpos($plain, 'sent') !== false || strpos($plain, 'enviad') !== false) {
            if (!in_array($folder, $destinos)) $destinos[] = $folder;
        }
    }

    if (!count($destinos)) $destinos = array('Sent'); // fallback

    $date = $internalDate ? $internalDate : date('d-M-Y H:i:s O');
    $ok   = false;

    for ($j=0; $j<count($destinos); $j++) {
        $folder = $destinos[$j];
        $mailboxFull = $imapHost.$folder;
        $res = @imap_append($inbox, $mailboxFull, $rawRfc822, "\\Seen", $date);
        if (!$res) {
            error_log("IMAP APPEND falló en '".$folder."': ".imap_last_error());
        } else {
            $ok = true;
        }
    }

    imap_close($inbox);
    return $ok;
}

/**
 * Credenciales IMAP para el remitente (sustituye por tu lógica/BD si aplica).
 */
function obtenerCredencialesImap($correo_origen) {
    global $IMAP_PASSWORDS;

    // Opción simple: el usuario IMAP es el correo y la pass del mapa
    $user = $correo_origen;
    $pass = isset($IMAP_PASSWORDS[$correo_origen]) ? $IMAP_PASSWORDS[$correo_origen] : null;

    // Ejemplo master-user (descomentar si lo usas)
    // $user = $correo_origen.'*masteruser';
    // $pass = 'PASS_MASTER';

    if (!$pass) return null;
    return array('user' => $user, 'pass' => $pass);
}

/* ===========================================================
 *  Tu función original de separación
 * ===========================================================
 */
function separarCorreoRespuesta($mensaje)
{
    $partes    = explode('RESPUESTA', $mensaje, 2);
    $correo    = trim($partes[0]);
    $respuesta = isset($partes[1]) ? trim($partes[1]) : '';

    $correo    = nl2br($correo);
    $respuesta = nl2br($respuesta);

    $correo    = str_replace('*', '', $correo);
    $respuesta = str_replace('*', '', $respuesta);

    $respuesta = str_replace(':', '', $respuesta);
    $correo    = str_replace(':', '', $correo);

    return array(
        'correo'    => $correo,
        'respuesta' => $respuesta
    );
}
