<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabla de Peticiones</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
    <script>
        async function sendPostRequest(data) {
            try {
                const response = await fetch('temporal_facturas.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams(data)
                });
                return await response.text();
            } catch (error) {
                return 'Error al realizar la petición';
            }
        }

        async function generateTable() {
            const tableBody = document.getElementById('tableBody');

            for (let i = 1; i <= 250; i++) {
                const postData = { numero: i };
                const response = await sendPostRequest(postData);

                const row = document.createElement('tr');
                const cellExecution = document.createElement('td');
                const cellResponse = document.createElement('td');

                cellExecution.textContent = i;
                cellResponse.textContent = response;

                row.appendChild(cellExecution);
                row.appendChild(cellResponse);
                tableBody.appendChild(row);
            }
        }

        document.addEventListener('DOMContentLoaded', generateTable);
    </script>
</head>
<body>
    <h1>Tabla de Respuestas</h1>
    <table>
        <thead>
            <tr>
                <th># Ejecución</th>
                <th>Respuesta</th>
            </tr>
        </thead>
        <tbody id="tableBody">
            <!-- Filas generadas dinámicamente -->
        </tbody>
    </table>
</body>
</html>
