<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>S14 U</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <img src="favicon.png" alt="">

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->
            <?php
            include_once "api/adminAsistencias.php";
            include_once "api/notificador.php";

            $adminAsistencias = new AdministradorChecador();
            $asistencias = $adminAsistencias->dameAsistencias();
            function llegoTarde($horaEntrada, $horaLimite)
            {
                $horaLimite = date('H:i:s', strtotime('+10 minutes', strtotime($horaLimite)));

                // Convertir las horas en formato "00:00:00" a segundos
                $segundosHoraEntrada = strtotime($horaEntrada);
                $segundosHoraLimite = strtotime($horaLimite);

                // Verificar si la hora de entrada es posterior a la hora límite
                if ($segundosHoraEntrada > $segundosHoraLimite) {
                    return true; // Llegó tarde
                } else {
                    return false; // No llegó tarde
                }
            }

            function seFueTemprano($horaSalida, $horaLimite)
            {
                // Convertir las horas en formato "00:00:00" a segundos
                $segundosHoraSalida = strtotime($horaSalida);
                $segundosHoraLimite = strtotime($horaLimite);

                // Verificar si la hora de salida es anterior a la hora límite
                if ($segundosHoraSalida < $segundosHoraLimite) {
                    return true; // Se fue temprano
                } else {
                    return false; // No se fue temprano
                }
            }


            function diferenciaHorasEnMinutos($hora1, $hora2)
            {
                // Convertir las horas a timestamps
                $timestampHora1 = strtotime($hora1);
                $timestampHora2 = strtotime($hora2);

                // Calcular la diferencia en segundos
                $diferenciaSegundos = abs($timestampHora2 - $timestampHora1);

                // Convertir la diferencia de segundos a minutos
                $diferenciaMinutos = $diferenciaSegundos / 60;

                return $diferenciaMinutos;
            }


            function obtenerDiaSemana($fecha)
            {
                // Convertir la fecha a timestamp
                $timestamp = strtotime($fecha);

                // Obtener el día de la semana como número (0 para domingo, 1 para lunes, etc.)
                $numero_dia = date("w", $timestamp);

                // Definir un arreglo con los nombres de los días de la semana
                $dias_semana = array("Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado");

                // Obtener el nombre del día de la semana usando el número obtenido
                $nombre_dia = $dias_semana[$numero_dia];

                return $nombre_dia;
            }

            function formatearFecha($fecha)
            {
                $fecha = explode(" ", $fecha);


                $fecha = $fecha[0];

                $fecha = explode("-", $fecha);
                $mes = $fecha[1];
                switch ($mes) {
                    case 1:
                        $mes = "Enero";
                        break;
                    case 2:
                        $mes = "Febrero";
                        break;
                    case 3:
                        $mes = "Marzo";
                        break;
                    case 4:
                        $mes = "Abril";
                        break;
                    case 5:
                        $mes = "Mayo";
                        break;
                    case 6:
                        $mes = "Junio";
                        break;

                    case 7:
                        $mes = "Julio";
                        break;
                    case 8:
                        $mes = "Agosto";
                        break;
                    case 9:
                        $mes = "Septiembre";
                        break;
                    case 10:
                        $mes = "Octubre";
                        break;
                    case 11:
                        $mes = "Noviembre";
                        break;
                    case 12:
                        $mes = "Diciembre";
                        break;
                }
                $fecha = $fecha[2] . "/" . $mes . "/" . $fecha[0];
                return $fecha;
            }



            function obtenerFechasLaboralesDesdeLunesHaceTresSemanas($fecha)
            {
                // Crear un objeto DateTime a partir de la fecha proporcionada
                $date = new DateTime($fecha);

                // Clonar el objeto para no modificar el original
                $lunes = clone $date;

                // Restar 3 semanas (21 días) a la fecha
                $lunes->modify('-21 days');

                // Obtener el día de la semana (1 = lunes, ..., 7 = domingo)
                $diaDeLaSemana = $lunes->format('N');

                // Ajustar la fecha al lunes de esa semana
                if ($diaDeLaSemana != 1) {
                    $lunes->modify('-' . ($diaDeLaSemana - 1) . ' days');
                }

                // Crear un arreglo para almacenar las fechas laborales
                $fechasLaborales = [];

                // Agregar las fechas omitiendo los fines de semana
                for ($i = 0; $i < 15; $i++) { // 3 semanas son 15 días laborales
                    $diaActual = clone $lunes;
                    $diaActual->modify('+' . $i . ' weekdays');

                    // Agregar la fecha al arreglo en formato Y-m-d
                    $fechasLaborales[] = $diaActual->format('Y-m-d');
                }

                return $fechasLaborales;
            }

            $adminEmpleados = new AdministradorChecador();


            $usuarios = $adminEmpleados->dameEmpleados();

            $fechas = obtenerFechasLaboralesDesdeLunesHaceTresSemanas(date('Y-m-d'));


            ?>
            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->

                <div x-data="striped">


                    <div class="panel mt-6">
                        <h5 class="mb-5 text-lg font-semibold dark:text-white-light md:absolute md:top-[25px] md:mb-0">Asistencias</h5>
                        <table id="tableStripe" class="table-striped">

                            <thead>
                                <th>Empleado</th>
                                <th>Periodo</th>
                                <th>Faltas</th>
                                <th>Retardos</th>
                                <th>Acumulación</th>
                                <th>Faltas por retardo</th>
                                <th>Dias descuento</th>
                                <th>Tiempo extra</th>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($usuarios as $usuario) {
                                    $faltas = 0;
                                    $retardos = 0;
                                    $acumulacion = 0;

                                    foreach ($fechas as $fecha) {
                                        $asistencia = $adminEmpleados->dameAsistenciasDia($usuario->id, $fecha);

                                        if ($asistencia != null) {
                                            $nota = '';
                                            $minutosTarde = 0;
                                            $minutosAntes = 0;
                                            $minutosExtras = 0;
                                            if ($asistencia->salida == 'Sin Salida') {
                                                $nota .= 'No marco salida';
                                            } else {
                                                if (seFueTemprano($asistencia->salida, $asistencia->salidaO)) {
                                                    $minutosAntes = diferenciaHorasEnMinutos($asistencia->salida, $asistencia->salidaO);
                                                    $nota .= ' Se fue temprano ' . number_format($minutosAntes, 0)  . ' minutos antes ';
                                                } else {
                                                    $minutosExtras += diferenciaHorasEnMinutos($asistencia->salida, $asistencia->salidaO);
                                                    $asistencia->salida = '';
                                                    $asistencia->salidaO = '';
                                                }
                                            }
                                            if (llegoTarde($asistencia->entrada, $asistencia->entradaO)) {
                                                $minutosTarde  = diferenciaHorasEnMinutos($asistencia->entrada, $asistencia->entradaO);
                                                $nota .= ' Llego tarde ' . number_format($minutosTarde, 0)  . " minutos ";
                                                $retardos++;
                                                $acumulacion += $minutosTarde;
                                            } else {
                                                $minutosExtras += diferenciaHorasEnMinutos($asistencia->entrada, $asistencia->entradaO);
                                                $asistencia->entrada = '';
                                                $asistencia->entradaO = '';
                                            }


                                            if ($asistencia->fecha == date('Y-m-d')) {
                                                //$adminAsistencias->agregaIncidencias($asistencia->empleado, $asistencia->entrada, date('Y-m-d'), $nota, 'NA');
                                            }
                                        } else {
                                            $faltas++;
                                        }
                                    }
                                    $hoy = date('Y-m-d');
                                    $hoy21Dias = date('Y-m-d', strtotime('-21 days', strtotime($hoy)));


                                    $faltasPorRetardo = $acumulacion / 30;

                                    $diasDescuento = $faltasPorRetardo / 3;
                                    $diasDescuento = $diasDescuento = $faltas;
                                    echo '<tr>';
                                    echo '<td>' . $usuario->nombre . '</td>';

                                    echo '<td>' . $hoy21Dias . ' - ' . $hoy . '</td>';
                                    echo '<td>' .  $faltas . '</td>';
                                    echo '<td>' . $retardos . '</td>';
                                    echo '<td>' . number_format($acumulacion, 2) . ' Minutos</td>';
                                    echo '<td>' . number_format($faltasPorRetardo, 2) . ' Faltas</td>';
                                    echo '<td>' . number_format($diasDescuento, 2) . ' Dias</td>';
                                    echo '<td>' . number_format($minutosExtras, 2) . ' Minutos</td>';
                                    echo '</tr>';
                                }
                                ?>


                        </table>
                    </div>

                </div>
                <!-- end main content section -->

            </div>

            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2022</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/highlight.min.js"></script>
    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script src="assets/js/simple-datatables.js"></script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));
            var tabla = null;
            Alpine.data('striped', () => ({
                init() {
                    const tableOptions = {
                        data: {

                        },
                        sortable: false,
                        searchable: true,
                        perPage: 10,
                        perPageSelect: [10, 20, 30, 50, 100],
                        firstLast: true,
                        firstText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        lastText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        prevText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        nextText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        labels: {
                            perPage: '{select}',
                        },
                        layout: {
                            top: '<div class="grid grid-cols-3"><div class="font-bold text-2xl">Facturas del usuario</div><div class="text-7xl">$</div><div class="grid grid-cols-2 gap-2"><div>{search}</div> <div class="ml-auto"><button onclick="buscar()" type="button" class="btn btn-danger"> Búsqueda avanzada  </button></div> </div></div>',
                            bottom: '{info}{select}{pager}',
                        },


                    };
                    tabla = tableOptions;
                    const datatable1 = new simpleDatatables.DataTable('#tableStripe', tableOptions);
                    datatable1.on('datatable.init', function() {
                        //asignar id al buscador 
                        document.querySelector('.dataTable-input').id = 'buscador';
                    });

                },
            }));

            Alpine.data('striped', () => ({
                init() {
                    const tableOptions = {
                        data: {

                        },
                        sortable: false,
                        searchable: true,
                        perPage: 10,
                        perPageSelect: [10, 20, 30, 50, 100],
                        firstLast: true,
                        firstText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        lastText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        prevText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        nextText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        labels: {
                            perPage: '{select}',
                        },
                        layout: {
                            top: '{search}',
                            bottom: '{info}{select}{pager}',
                        },
                    };

                    const datatable1 = new simpleDatatables.DataTable('#tableStripe', tableOptions);

                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));


        });
    </script>
</body>

</html>