<?php

include_once('../../conectorBDS14.php');

class ItemBusqueda{
  public $id;
  public $tipo;
  public $fecha;
  public $descripcion;
  public $monto;
  public $detalle;
  public $fecha_captura;
  public $cliente;
  public $claveCorta;
  public $captura;
  public $pago;
  public $token;
  public $movimiento;
  public $banco;
  public $fecha_cadena;
  public $fecha_captura_cadena;
  public $saldo_acreditable;

  function __construct($id, $tipo, $fecha, $descripcion, $monto, $detalle, $fecha_captura, $cliente, $claveCorta, $captura, $pago, $token, $movimiento, $banco){
    $this->id = $id;
    $this->tipo = $tipo;
    $this->fecha = $fecha;
    $this->descripcion = $descripcion;
    $this->monto = $monto;
    $this->detalle = $detalle;
    $this->fecha_captura = $fecha_captura;
    $this->cliente = $cliente;
    $this->claveCorta = $claveCorta;
    $this->captura = $captura;
    $this->pago = $pago;
    $this->token = $token;
    $this->movimiento = $movimiento;
    $this->banco = $banco;
  }
}


class AdminBuscador extends conectorS14 {

  public function fechaComoCadena($fecha)
  {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);
  
    switch ($mes) {
      case "01":
        $mes = 'Enero';
        break;
      case "02":
        $mes = 'Febrero';
        break;
      case "03":
        $mes = 'Marzo';
        break;
      case  "04":
        $mes = 'Abril';
        break;
      case "05":
        $mes = 'Mayo';
        break;
      case "06":
        $mes = 'Junio';
        break;
      case "07":
        $mes = 'Julio';
        break;
      case "08":
        $mes = 'Agosto';
        break;
      case "09":
        $mes = 'Septiembre';
        break;
      case "10":
        $mes = 'Octubre';
        break;
      case "11":
        $mes = 'Noviembre';
        break;
      case "12":
        $mes = 'Diciembre';
        break;
      default:
        $mes = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
  }


  public function dameBusqueda($parametro){

    $numero = str_replace(",", "", $parametro);
    $numero = str_replace("$", "", $numero);
    $numero = str_replace(" ", "", $numero);
    $numero = floatval($numero);
    if($numero == 0){
      $numero = "null";
      $numeroTolera1 = 'null';
      $numeroTolera2 = 'null';
    }
    else{
      if($numero<0){
        $numero = $numero * -1;
      }
      $numeroTolera1 = $numero + 0.01;
      $numeroTolera2 = $numero - 0.01;
    }
  

    

  
    $hoyMenosTresMeses = date("Y-m-d",strtotime(date("Y-m-d")."- 3 month"));

    $sql = "
    SELECT facturas.id, 'Factura' AS tipo, fecha_timbrado as fecha, 'FACTURA' as descripcion, total_factura as monto, 'FACTURA S14' as detalle, fecha_timbrado as fecha_captura, clientes.nombre as cliente, 'NA' as clave_corta, 'NA' as captura, id_pago as pago, 'FACTURA EMITIDA' as movimiento, token, 'NA' as banco, 'NA' as saldo_acreditable, 'NA' as fecha_asignacion
    FROM facturas
    INNER JOIN detalle_factura ON detalle_factura.id_factura = facturas.id
    INNER JOIN claves_cortas ON claves_cortas.id = facturas.id_clave_corta
    INNER JOIN clientes ON clientes.id = claves_cortas.id_cliente
    INNER JOIN empresas ON empresas.id = facturas.razon
    WHERE
    ";
    
    if ($numero != 0) {
        $sql .= "facturas.total_iva = '$numero' OR facturas.id = $numero OR ";
    }
    
    $sql .= "
    detalle_factura.concepto LIKE '%$parametro%' 
    OR clientes.nombre LIKE '%$parametro%' 
    OR claves_cortas.clave_corta LIKE '%$parametro%' 
    OR claves_cortas.razon_social LIKE '%$parametro%' 
    OR claves_cortas.rfc LIKE '%$parametro%'
    UNION
    SELECT pagos.id, 'Pago' AS tipo, fecha_banco as fecha, pagos.descripcion, pagos.monto, pagos.detalle, pagos.fecha_captura, clientes.nombre as cliente, bancos.nombre_corto as banco, pagos.id_captura, 'NA' as pago, pagos.tipo_movimiento as movimiento, 'NA' as token, pagos.banco as b, pagos.saldo_acreditable, pagos.fecha_asignacion
    FROM pagos
    LEFT JOIN clientes ON clientes.id = pagos.nombre
    LEFT JOIN captura ON captura.id = pagos.id_captura
    LEFT JOIN bancos ON bancos.id = captura.nombre_corto
    LEFT JOIN empresas ON empresas.id = captura.razon
    WHERE
    ";
    
    if ($numero != 0) {
        $sql .= "ABS(pagos.monto) = '$numero' OR  
        (ABS(pagos.saldo_acreditable) < '$numeroTolera1' AND ABS(pagos.saldo_acreditable) > '$numeroTolera2') 
        OR pagos.id = $numero OR ";
    }
    
    $sql .= "
    clientes.nombre LIKE '%$parametro%' 
    OR pagos.detalle LIKE '%$parametro%' 
    OR pagos.descripcion LIKE '%$parametro%' 
    OR pagos.tipo_movimiento LIKE '%$parametro%' 
    OR pagos.fecha_captura LIKE '%$parametro%' 
    OR pagos.fecha_banco LIKE '%$parametro%' 
    OR pagos.fecha_asignacion LIKE '%$parametro%'
    UNION
    SELECT c.id, 'Captura' AS tipo, c.fecha, 'CAPTURA S14', 'NA', 'CAPTURA S14', c.fecha as fecha_captura, '0', 'NA' as cliente, 'NA' as id_captura, 'NA' as pago, 'Captura de saldos' as movimiento, 'NA' as token, b.nombre_corto as banco, 'NA' as saldo_acreditable, c.fecha as fecha_asignacion
    FROM captura c
    INNER JOIN pagos p ON c.id = p.id_captura 
    INNER JOIN bancos b ON b.id = c.nombre_corto
    WHERE
    ";
    
    if ($numero != 0) {
        $sql .= "p.monto = '$numero' OR c.id = $numero OR ";
    }
    
    $sql .= "c.id = '$parametro'";

    $sql .= "UNION
SELECT 
    pre.id, 
    'Comprobante STP' AS tipo, 
    DATE(pre.fecha_creacion) AS fecha_creacion,
    'Comprobante STP', 
    pre.monto, 
    pre.nombre, 
    DATE(pre.fecha_creacion) AS fecha_captura,  
    cli.nombre AS cliente, 
    'NA', 
    'NA' AS id_captura, 
    'NA' AS pago, 
    'Comprobante' AS movimiento, 
    'NA' AS token, 
    'STP' AS banco, 
    pre.monto * -1 AS saldo_acreditable, 
    DATE(pre.fecha_creacion) AS fecha_asignacion    FROM pre_ejecuta_plantilla pre
    inner join clientes cli on cli.id = pre.cliente 
    WHERE cli.nombre LIKE '%$parametro%' or pre.id = '$numero' or pre.monto = '$numero' or pre.nombre LIKE '%$parametro%';";
    
    //echo "consulta" .  $sql;

    $result = $this->ejecutar($sql);

    $array = array();

    while ($row = $result->fetch_assoc()) {
      $item = new ItemBusqueda($row['id'], $row['tipo'], ($row['fecha']), $row['descripcion'], $row['monto'], $row['detalle'], ($row['fecha_asignacion']), $row['cliente'], $row['clave_corta'], $row['captura'], $row['pago'], $row['token'], $row['movimiento'], $row['banco']);
      $item->fecha_cadena = $this->fechaComoCadena($item->fecha);
      $item->fecha_captura_cadena = $this->fechaComoCadena($item->fecha_captura);
      if($item->descripcion == 'Traspaso'){
        $item->movimiento = 'Traspaso entre cuentas';
      }
      $item->saldo_acreditable = $row['saldo_acreditable'];
      array_push($array, $item);
    }

    return $array;

  }


}



