<?php
include_once("conectorBD.php");

class MovimientoStp
{
  //INSERT INTO `pre_ejecuta_plantilla`(`id`, `plantilla`, `cliente`, `nombre`, `tarjeta`, `clabe`, `institucion`, `monto`, `fecha_creacion`, `fecha_ejecucion`, `status`, `status_banxico`, `id_stp`, `folio`, `estado`, `causa_devolucion`, `time_liquidacion`, `status_pre`, `consulta_cep`, `cep`, `espera_liquidacion`)

  public $nombre;
  public $clabe;
  public $tarjeta;
  public $montos;
  public $clabes;
}

class ItemEstadistica
{
  public $nombre;
  public $cantidad;
  public $cantidadNegativa;
  public $cantidadTotal;

  public function __construct()
  {
    $this->nombre = "0";
    $this->cantidad = 0;
    $this->cantidadNegativa = 0;
    $this->cantidadTotal = 0;
  }
}

class AdministradorEstadisticas extends conectorO
{
  public function dameMovimientosStp()
  {
    $hoy = date('Y-m-d');
    $sql = "SELECT nombre, clabe, tarjeta, SUM(monto) AS montos, COUNT(clabe) AS clabes
FROM pre_ejecuta_plantilla
WHERE fecha_creacion >= '2024-06-01' AND fecha_creacion <= '2024-06-30'
GROUP BY clabe, nombre, tarjeta HAVING COUNT(clabe) >= 5 ORDER BY montos DESC;";
    $result = $this->ejecutar($sql);
    $movimientos = array();
    while ($fila = mysqli_fetch_array($result)) {
      $movimiento = new MovimientoStp();
      $movimiento->nombre = $fila['nombre'];
      $movimiento->clabe = $fila['clabe'];
      $movimiento->tarjeta = $fila['tarjeta'];
      $movimiento->montos = $fila['montos'];
      $movimiento->clabes = $fila['clabes'];
      array_push($movimientos, $movimiento);
    }
    return $movimientos;
  }

  public function aumentaUnMes($fecha)
  {
    $arreglo = explode("-", $fecha);
    $mes = intval($arreglo[1]);
    $anio = intval($arreglo[0]);
    if ($mes >= 12) {
      $anio++;
      $mes = 1;
    } else {
      $mes++;
    }
    //echo "El mes es: " . ($mes);
    return $anio . "-" . $mes . "-" . $arreglo[2];
  }

  public function dameEstadisticasTotales($id, $inicio, $fin)
  {


    $estadisticasTotales = array();
    $estadisticasTotales = $this->dameEstatisticasGenerales($id, $inicio, $fin);
    $aux1 = $this->dameEstadisticasNegativas($id, $inicio, $fin);
    $aux2 = $this->dameEstadisticasPositivas($id, $inicio, $fin);
    for ($i = 0; $i < count($estadisticasTotales); $i++) {
      for ($j = 0; $j < count($aux1); $j++) {
        if ($estadisticasTotales[$i]->nombre == $aux1[$j]->nombre) {
          $estadisticasTotales[$i]->cantidadNegativa = floatval($aux1[$j]->cantidad);
          //echo $aux1[$j]->nombre . " " . $aux1[$j]->cantidad . "<br>";
          //echo $estadisticasTotales[$i]->nombre . "------------ " . $estadisticasTotales[$i]->cantidadNegativa . "<br>";
        }
      }
    }
    for ($i = 0; $i < count($estadisticasTotales); $i++) {
      for ($j = 0; $j < count($aux2); $j++) {
        if ($estadisticasTotales[$i]->nombre == $aux2[$j]->nombre) {
          $estadisticasTotales[$i]->cantidad = floatval($aux2[$j]->cantidad);
        }
      }
    }
    for ($i = 0; $i < count($estadisticasTotales); $i++) {
      $estadisticasTotales[$i]->cantidadTotal = $estadisticasTotales[$i]->cantidad + $estadisticasTotales[$i]->cantidadNegativa;
    }
    return $estadisticasTotales;
  }

  public function dameEstatisticasGenerales($cliente, $inicio, $fin)
  {





    $sql = '
        select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,  SUM(pagos.saldo_acreditable) as saldo_acreditable from pagos left join clientes on (clientes.id=pagos.cliente_origen_comision) left join captura on (captura.id=pagos.id_captura) left join bancos on (bancos.id=captura.nombre_corto) LEFT JOIN empresas ON (empresas.id=captura.razon) 
        where pagos.nombre= ' . $cliente . ' and fecha_asignacion>= "' . $inicio . '" and fecha_asignacion<= "' . $fin . '" GROUP by cliente_origen order by cliente_origen ASC
        ';
    $result = $this->ejecutar($sql);

    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ItemEstadistica();
      $item->nombre = $row['cliente_origen'];
      $item->cantidad = 0;
      //echo  var_dump($row);
      $items[] = $item;
    }
    //echo $sql;
    //echo json_encode($items);
    return $items;
  }

  public function dameEstadisticasNegativas($cliente, $inicio, $fin)
  {

    $sql = 'select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,  SUM(pagos.saldo_acreditable) as saldo_acreditable from pagos left join clientes on (clientes.id=pagos.cliente_origen_comision) left join captura on (captura.id=pagos.id_captura) left join bancos on (bancos.id=captura.nombre_corto) LEFT JOIN empresas ON (empresas.id=captura.razon) 
        where pagos.nombre= ' . $cliente . ' and saldo_acreditable<=0 and fecha_asignacion>= "' . $inicio . '" and fecha_asignacion<= "' . $fin . '" GROUP by cliente_origen order by empresas.razon ASC';
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ItemEstadistica();
      $item->nombre = $row['cliente_origen'];
      $item->cantidad = $row['saldo_acreditable'];
      //echo  var_dump($row);
      $items[] = $item;
    }
    return $items;
  }

  public function dameEstadisticasPositivas($cliente, $inicio, $fin)
  {


    $sql = 'select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,  SUM(pagos.saldo_acreditable) as saldo_acreditable from pagos left join clientes on (clientes.id=pagos.cliente_origen_comision) left join captura on (captura.id=pagos.id_captura) left join bancos on (bancos.id=captura.nombre_corto) LEFT JOIN empresas ON (empresas.id=captura.razon) 
        where pagos.nombre= ' . $cliente . ' and saldo_acreditable>=0 and fecha_asignacion>= "' . $inicio . '" and fecha_asignacion<= "' . $fin . '" GROUP by cliente_origen order by empresas.razon ASC';
    $result = $this->ejecutar($sql);
    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ItemEstadistica();
      $item->nombre = $row['cliente_origen'];
      $item->cantidad = $row['saldo_acreditable'];
      //echo  var_dump($row);
      $items[] = $item;
    }
    return $items;
  }








  public function dameEstadisticasTotalesConAbono($id, $inicio, $fin)
  {


    $estadisticasTotales = array();
    $estadisticasTotales = $this->dameEstatisticasGeneralesConAbono($id, $inicio, $fin);

    return $estadisticasTotales;
  }

  public function dameEstatisticasGeneralesConAbono($cliente, $inicio, $fin)
  {





    $sql = '
        select empresas.razon,bancos.nombre_corto as nombre_corto_b,clientes.nombre as cliente_origen,  SUM(pagos.saldo_acreditable) as saldo_acreditable from pagos left join clientes on (clientes.id=pagos.cliente_origen_comision) left join captura on (captura.id=pagos.id_captura) left join bancos on (bancos.id=captura.nombre_corto) LEFT JOIN empresas ON (empresas.id=captura.razon) 
        where pagos.nombre= ' . $cliente . ' and fecha_asignacion>= "' . $inicio . '" and fecha_asignacion<= "' . $fin . '"  and detalle = "Abono de porcentaje por comision" or detalle like "%utilidades%" and saldo_acreditable > 0  GROUP by cliente_origen order by cliente_origen ASC
        ';
    $result = $this->ejecutar($sql);

    $items = array();
    while ($row = mysqli_fetch_array($result)) {
      $item = new ItemEstadistica();
      $item->nombre = $row['cliente_origen'];
      $item->cantidadTotal = $row['saldo_acreditable'];
      $item->cantidad = $row['saldo_acreditable'];

      //echo  var_dump($row);
      $items[] = $item;
    }
    //echo $sql;
    //echo json_encode($items);
    return $items;
  }
}
