<?php


function generarFactura($monto, $conceptos)
{
    $factura = [];
    $total = 0;

    // Mezclar los conceptos de forma aleatoria para evitar que siempre se facturen los mismos
    shuffle($conceptos);

    foreach ($conceptos as $concepto) {
        if ($total >= $monto) {
            break;
        }
        // Calcular la cantidad máxima que se puede facturar para este concepto sin exceder el monto ni limite precio maximo

        $cantidadMaxima = floor(($monto - $total) / $concepto->precio_min);
        $cantidad = min($cantidadMaxima, $concepto->unidades_max);

        $precioMaximo = $concepto->precio_max;


        if ($precioMaximo > ($monto - $total)) {
            $precioUnitario = ($monto - $total);
            $subtotal = ($monto - $total);
            $nuevoConcepto = clone $concepto;
            $nuevoConcepto->cantidad = 1;
            $nuevoConcepto->precioUnitario = ($monto - $total);
            $factura[] = $nuevoConcepto;
            $total += $subtotal;
            return $factura;
        } else if ($cantidad > 0) {

            $precioUnitario = $concepto->precio_min;
            $subtotal = $cantidad * $precioUnitario;

            $nuevoConcepto = clone $concepto;
            $nuevoConcepto->cantidad = $cantidad;
            $nuevoConcepto->precioUnitario = $precioUnitario;

            $factura[] = $nuevoConcepto;
            $total += $subtotal;
        }
    }

    // Ajustar el último concepto para igualar exactamente el monto que le mandamos a la funcion 
    if ($total < $monto) {
        $diferencia = $monto - $total;
        $ultimoConcepto = end($factura);

        // Ajustar el precio unitario del último concepto para cubrir la diferencia de monto
        $ultimoConcepto->precioUnitario += $diferencia / $ultimoConcepto->cantidad;

        // Recalcular el subtotal del último concepto y el total de la factura
        $ultimoSubtotal = $ultimoConcepto->cantidad * $ultimoConcepto->precioUnitario;
        $total += $ultimoSubtotal - ($ultimoConcepto->cantidad * $ultimoConcepto->precio_min);
    }

    return $factura;
}

// Función para imprimir la factura
function imprimirFactura($factura, $id_max)
{
    if (is_string($factura)) {
        echo $factura;
    } else {
        $total = 0;
        echo "<h2>Factura Generada</h2>";
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Concepto</th><th>Clave SAT</th><th>Clave Producto</th><th>Clave Unidad Medida</th><th>Cantidad</th><th>Precio Unitario Sin iva</th><th>Precio Unitario</th><th>Aplica IVA</th><th>Aplicalbe</th><th>iva</th><th>subtotal</th><th>total</th><th>Query</th></tr>";
        foreach ($factura as $item) {
            $subtotal = $item->cantidad * $item->precioUnitario;
            $total += $subtotal;
            if ($item->aplica_iva == 'si') {
                $iva = doubleval( $subtotal  / 1.16);
                //acorta a 6 decimales
                $iva = $subtotal - $iva;
                $iva = round($iva, 6);

              
                
                $ivaUnitario = $iva / $item->cantidad;
            } else {
                $iva = 0;
            }
            $sinIva = $subtotal - $iva;
            $sinIvaUnitario = $item->precioUnitario - $ivaUnitario;
            $query = "insert into detalle_factura (id_factura,id_producto,cantidad,precio_unitario,precio_con_iva,precio_neto,precio_neto_iva,concepto) VALUES ($id_max, $item->id, $item->cantidad, $sinIvaUnitario, $item->precioUnitario, $sinIva, $subtotal, '$item->concepto')";
            echo "<tr>";
            echo "<td>{$item->id}</td>";
            echo "<td>{$item->concepto}</td>";
            echo "<td>{$item->clave_sat}</td>";
            echo "<td>{$item->clave_producto}</td>";
            echo "<td>{$item->clave_unidad_medida}</td>";
            echo "<td>{$item->cantidad}</td>";
            echo "<td>{$sinIvaUnitario}</td>";
            echo "<td>{$item->precioUnitario}</td>";
            echo "<td>{$item->aplica_iva}</td>";
            echo "<td>{$item->impuesto}</td>";
            echo "<td>{$iva}</td>";
            echo "<td>{$sinIva}</td>";
            echo "<td>{$subtotal}</td>";
            echo "<td>{$query}</td>";
            echo "</tr>";
        }
        echo '<tr><td colspan="11">Total</td><td>' . $total . '</td></tr>';

        echo "</table>";
    }
}








function fact_ok($empresa_factura, $total_fact, $max_id_fact)
{
    include_once('adminConceptos.php');
    $adminConceptos = new AdministradorConceptos();
    $conceptos = $adminConceptos->dameConceptosPorRazonAlgoritmo($empresa_factura);
    $factura = generarFactura($total_fact, $conceptos);
    imprimirFactura($factura, $max_id_fact);
}


fact_ok(5, 100000, 1);
