<?php
function extraerDatosINE($urlImagen) {
    // 1. Descargar la imagen
    $nombreTemporal = 'ine_tmp.jpg';
    file_put_contents($nombreTemporal, file_get_contents($urlImagen));

    // 2. Usar Tesseract para OCR
    $archivoTexto = 'resultado_ocr';
    $comando = "tesseract $nombreTemporal $archivoTexto -l spa 2>&1";
    shell_exec($comando);

    // 3. Leer el texto extraído
    $texto = file_get_contents($archivoTexto . ".txt");

    // 4. Eliminar archivo temporal
    unlink($nombreTemporal);
    unlink($archivoTexto . ".txt");

    // 5. Extraer datos con expresiones regulares
    $datos = [];

    // Nombre completo
    if (preg_match('/(?:(?:NOMBRE|Nombre)\s*:\s*)([A-ZÑ ]+)/', $texto, $match)) {
        $datos['nombre'] = trim($match[1]);
    } else {
        // Otra estrategia si no aparece "NOMBRE:"
        if (preg_match('/^[A-ZÑ ]{3,}\n[A-ZÑ ]+\n[A-ZÑ ]+/m', $texto, $match)) {
            $lineas = explode("\n", $match[0]);
            $datos['nombre'] = implode(" ", array_map('trim', $lineas));
        }
    }

    // CURP
    if (preg_match('/([A-Z]{4}\d{6}[HM][A-Z]{5}[A-Z\d]{2})/', $texto, $match)) {
        $datos['curp'] = $match[1];
    }

    // Clave de elector
    if (preg_match('/CLAVE DE ELECTOR\s*:?[\s\n]*([A-Z0-9]+)/i', $texto, $match)) {
        $datos['clave_elector'] = $match[1];
    }

    // Emisión
    if (preg_match('/EMISION\s*:?[\s\n]*([0-9]{4})/i', $texto, $match)) {
        $datos['emision'] = $match[1];
    }

    // Año de registro
    if (preg_match('/AÑO DE REGISTRO\s*:?[\s\n]*([0-9]{4})/i', $texto, $match)) {
        $datos['anio_registro'] = $match[1];
    }

    // Sección
    if (preg_match('/SECCION\s*:?[\s\n]*([0-9]{4})/i', $texto, $match)) {
        $datos['seccion'] = $match[1];
    }

    // Domicilio (heurística: buscar justo antes de "C.P.")
    if (preg_match('/DOMICILIO\s*:?([\s\S]{10,100}?)C\.P\./i', $texto, $match)) {
        $datos['domicilio'] = trim(preg_replace('/\s+/', ' ', $match[1]));
    }

    return $datos;
}

// 📌 Ejemplo de uso
$url = "https://example.com/ine.jpg"; // Reemplaza con tu URL
$datos = extraerDatosINE($url);

echo "<pre>";
print_r($datos);
echo "</pre>";
?>
