<?php
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="REPORTE-CONCEPTOS-EMPRESA-'.$_GET['id'].'.xls"');
include_once("adminConceptos.php");
$adminConceptos = new AdministradorConceptos();
$conceptos = $adminConceptos->dameConceptosPorRazon($_GET['id']);
?>

<div class="padding">
  <div class="box">
    <div class="box-header">

    </div>
    <div class="table-responsive">
      <table id="tableStripe" class="table-striped">
        <thead>
          <tr>
            <th>Concepto </th>
            <th>Empresa</th>
            <th>Clave sat </th>
            <th>Unidad medida </th>
            <th>Precio mínimo </th>
            <th>Precio máximo </th>
            <th>Facturable automático </th>
            <th>Aplica iva </th>
            <th>Impuesto </th>

          </tr>
        </thead>
        <tbody>
          <?php

          foreach ($conceptos as $concepto) {
            echo "<tr id='row" . $concepto->id . "'>";
            echo "<td>" . $concepto->concepto . "</td>";
            echo "<td>" . $concepto->nombreEmpresa . "</td>";
            echo "<td>" . $concepto->clave_sat . "</td>";
            echo "<td>" . $concepto->clave_unidad_medida . "</td>";
            echo "<td>$ " . number_format($concepto->precio_min, 2)  . "</td>";
            echo "<td>$ " . number_format($concepto->precio_max, 2) . "</td>";
            echo "<td>" . $concepto->facturable_auto . "</td>";
            echo "<td>" . $concepto->aplica_iva . "</td>";
            echo "<td>" . $concepto->impuesto . "</td>";

            echo "</tr>";
          }

          ?>
        </tbody>
      </table>
    </div>
  </div>
</div>