<?php
header('Content-Type: application/json');
include_once "adminProveedores.php";
include_once "adminEmpresas.php";
include_once "adminFacturasSEC.php";

$adminProveedores = new AdministradorProveedores();
$adminEmpresas = new AdminEmpresas();
$adminFacturasSEC = new AdministradorFacturas();
$empresas = $adminEmpresas->dameEmpresaLiteContext($_GET['id']);
$empresasJson = [];
$fecha_inicio = '2025-08-04';
$fecha_fin = '2025-08-08';
foreach ($empresas as $empresa) {
    $proveedores = $adminProveedores->dameProveedoresEmpresa($empresa->id);
    $empresa->proveedores = $proveedores;
    $proveedores->analisis = $fecha_inicio . ' - ' . $fecha_fin;
    foreach ($empresa->proveedores as $proveedor) {
        $correoConta = $adminEmpresas->dameCorreoContaRfc($proveedor->rfc);
        $conceptos = [];
        $proveedor->correo_conta_prov = procesarCorreoContacto($correoConta);
        $usuarioRFC = $adminEmpresas->dameUsuarioRfc($empresa->rfc);
        $proveedor->correo_conta = procesarCorreoUno($proveedor->correo_conta,$usuarioRFC);
        $facturas = $adminFacturasSEC->dameFactturasEmpresaClaveInicioFin($proveedor->id_proveedor, $proveedor->id_empresa, $fecha_inicio, $fecha_fin);
        foreach ($facturas as $fac) {
            foreach ($fac->conceptos as $concepto) {
                if ($concepto->clave_unidad_medida == 'E48') {
                    $conceptos[] = [
                        'id' => $concepto->id,
                        'clave' => $concepto->clave_unidad_medida,
                        'nombre' => $concepto->concepto,
                        'cantidad' => $concepto->cantidad,
                        'unidad' => $concepto->unidad,
                        'valor_unitario' => $concepto->valor_unitario,
                        'importe' => $concepto->importe
                    ];
                }
            }
        }
        $proveedor->conceptos = $conceptos;
        $proveedor->analisis = $fecha_inicio . ' - ' . $fecha_fin;
    }
    $empresa->analisis = $fecha_inicio . ' - ' . $fecha_fin; 
    $empresasJson[] = $empresa;
    echo json_encode($proveedores, JSON_PRETTY_PRINT);
    break; // Remove this line if you want to process all companies
}

function procesarCorreoUno($correo, $usuario)
{
 

    // Elegir una opción de forma aleatoria
    $aleatorio = $usuario;

    // Separar la parte antes y después del arroba
    $partes = explode("@", $correo, 2);

    // Reemplazar lo que está a la izquierda del arroba
    $nuevoCorreo = $aleatorio . "@" . $partes[1];

    return $nuevoCorreo;
}

function procesarCorreo($correo)
{
    // Arreglo con las opciones
    $opciones = [
        "atencion.cliente",
        "atencionalcliente",
        "asistencia",
        "postventa",
        "clientes",
        "experiencia.clientes",
        "seguimiento",
        "cuentas",
        "cuentas.premium",
        "atencionpostventa",
        "clientes.seguimiento"
    ];

    // Elegir una opción de forma aleatoria
    $aleatorio = $opciones[array_rand($opciones)];

    // Separar la parte antes y después del arroba
    $partes = explode("@", $correo, 2);

    // Reemplazar lo que está a la izquierda del arroba
    $nuevoCorreo = $aleatorio . "@" . $partes[1];

    return $nuevoCorreo;
}
function procesarCorreoContacto($correo)
{
    // Buscar posición de @
    $pos = strpos($correo, '@');
    if ($pos === false) {
        return $correo; // Si no hay @, devolver sin cambios
    }

    // Tomar la parte del dominio (a la derecha del @)
    $dominio = substr($correo, $pos + 1);

    // Reemplazar la parte izquierda con "contacto"
    return "contacto@" . $dominio;
}
