<?php
include_once 'adminEmpresas.php';
include_once 'adminClavesCortas.php';
function procesarArchivoXML()
{
  $adminEmpresas = new AdminEmpresas();
  $adminClaves = new AdministradorClavesCortas();

  // Verificar si se ha enviado un archivo XML
  if ($_FILES["archivo"]["error"] == UPLOAD_ERR_OK && $_FILES["archivo"]["type"] == "text/xml") {
    // Obtener el nombre temporal del archivo
    $archivo_tmp = $_FILES["archivo"]["tmp_name"];

    // Leer el contenido del archivo XML
    $contenido_xml = file_get_contents($archivo_tmp);

    // Descomponer el XML en un objeto SimpleXMLElement
    $xml = simplexml_load_string($contenido_xml);

    $TipoDeComprobante = $xml->attributes()->TipoDeComprobante . "";
    $version =  $xml->attributes()->Version . "";
    $formaPago =  $xml->attributes()->FormaPago . "";
    $rfcEmisor = $xml->children('cfdi', true)->Emisor->attributes()->Rfc . "";
    $rfcReceptor = $xml->children('cfdi', true)->Receptor->attributes()->Rfc . "";
    $nombreEmisor = $xml->children('cfdi', true)->Emisor->attributes()->Nombre . "";
    $nombreReceptor = $xml->children('cfdi', true)->Receptor->attributes()->Nombre . "";
    $folioFactura = $xml->attributes()->Folio . "";
    $serieFactura = $xml->attributes()->Series . "";
    $metodoPago = $xml->attributes()->MetodoPago . "";
    $usoCfdi =  $xml->children('cfdi', true)->Receptor->attributes()->UsoCFDI . "";
    $folioFiscal =  $xml->children('cfdi', true)->Complemento->children('tfd', true)->attributes()->UUID . "";
    $fechaTimbrado =  $xml->attributes()->Fecha . "";
    $subTotal =  $xml->attributes()->SubTotal . "";
    $total =  $xml->attributes()->Total . "";

    $fechaT = array();

    $fechaT = explode('T', $fechaTimbrado);

    $fechaTimbrado = $fechaT[0];
    $hora = $fechaT[1];


    if ($metodoPago == 'PPD') {
      $metodoPago = 2;
    } else {
      $metodoPago = 1;
    }


    switch ($formaPago) {
      case '99':
        $formaPago = 23;
        break;
      case '03':
        $formaPago = 3;
        break;
    }
    switch($usoCfdi){
      case 'G03':
        $usoCfdi = 3;
        break;
    }

    $empresa = $adminEmpresas->dameEmpresaRfc($rfcEmisor);
    $claveCorta = $adminClaves->dameClaveCortaRfc($rfcReceptor);

    $facturaArray = array(

      'rfc_emisor' => $rfcEmisor,
      'rfc_receptor' => $rfcReceptor,
      'nombre_emisor' => $nombreEmisor,
      'nombre_receptor' => $nombreReceptor,
      'folio_factura' => $folioFactura,
      'serie_factura' => $serieFactura,
      'metodo_pago' => $metodoPago,
      'usoCfdi' => $usoCfdi,
      'folio_fiscal' => $folioFiscal,
      'fecha_timbrado' => $fechaTimbrado,
      'hora_timbrado' => $hora,
      'sub_total' => $subTotal,
      'total' => $total,
      'version' => $version,
      'forma_pago' => $formaPago,
      'tipo_comprobante' => $TipoDeComprobante,
      'empresa_id' => $empresa->id,
      'clave_corta' => $claveCorta->id,
      'cliente_id' => $claveCorta->id_cliente,
      'nombre_clave' => $claveCorta->razon_social

    );





    // Aquí puedes realizar cualquier manipulación que necesites con el XML
    // Por ejemplo, acceder a elementos específicos del XML:
    // $elemento = $xml->nombre_del_elemento;

    // O recorrer elementos del XML
    // foreach ($xml->nombre_del_elemento as $elemento) {
    //    // hacer algo con cada elemento
    // }

    // Devolver el objeto SimpleXMLElement resultante
    return $facturaArray;
  } else {
    // Si no se envió un archivo XML válido, puedes manejar el error de acuerdo a tus necesidades
    return null;
  }
}
?>




<?php
// Llamar a la función para procesar el archivo XML
$xml = procesarArchivoXML();

// Verificar si se pudo leer y descomponer el archivo XML correctamente
if ($xml !== null) {
  // Hacer algo con el XML, como mostrarlo en pantalla
  //echo "Archivo XML procesado correctamente:";
  //echo "<pre>";
  echo json_encode($xml);
  //echo "</pre>";
} else {
  // Manejar el caso en que no se pudo procesar el archivo XML
  echo "Error al procesar el archivo XML. Asegúrate de que sea un archivo XML válido.";
}
?>
