<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Conceptos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once('api/adminEmpresas.php');
    $adminEMpresas = new AdminEmpresas();
    $empresas = $adminEMpresas->dameEmpresasLite();
    ?>
    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Empresas</h6>
          <a class="btn btn-primary btn-sm" href="catalogos-empresas-formulario.php">Agregar</a>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de empresas capturadas.</p>
        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>
                <th>Razón social </th>
                <th>RCF</th>
                <th>Usuario </th>
                <th>Regimen </th>
                <th>Dirección </th>
                <th>Logotipo </th>
                <th>Acciones </th>

              </tr>
            </thead>
            <tbody>
              <?php foreach ($empresas as $empresa) { ?>
                <tr>
                  <!-- Logo siempre al inicio -->
                  <td style="width: 60px; text-align: center;">
                    <img src="https://sistema14.com/<?php echo $empresa->logo ?>"
                      alt="Logo"
                      class="img-thumbnail imagen-tabla"
                      style="height: 40px; width: 40px; object-fit: contain;">
                  </td>

                  <td><?php echo $empresa->razon ?></td>
                  <td><?php echo $empresa->rfc ?></td>
                  <td><?php echo $empresa->usuario ?></td>
                  <td><?php echo $empresa->regimen ?></td>
                  <td><?php echo $empresa->direccion ?></td>

                  <td>
                    <div class="btn-group" role="group">
                      <a href="catalogos-empresas-formulario.php?id=<?php echo $empresa->id ?>"
                        class="btn btn-warning btn-sm w-100">
                        Editar
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none"
                          xmlns="http://www.w3.org/2000/svg" class="inline-block ms-1">
                          <path d="M15.2869 3.15178L14.3601 4.07866L5.83882 12.5999..." stroke="currentColor" stroke-width="1.5"></path>
                        </svg>
                      </a>

                      <a href="api/generaReporteConceptos.php?id=<?php echo $empresa->id ?>"
                        class="btn btn-success btn-sm w-100">
                        Ver conceptos (T)
                      </a>

                      <a href="catalogos-empresas-eco-formulario.php?id=<?php echo $empresa->id ?>"
                        class="btn btn-primary btn-sm w-100">
                        Actividades económicas
                      </a>
                    </div>
                  </td>
                </tr>
              <?php } ?>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>