<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Grupos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once('api/adminGrupos.php');
    $adminGrupos = new AdministradorGrupos();
    $grupos = $adminGrupos->dameGrupos();
    ?>
    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Grupos de clientes</h6>
          <a class="btn btn-primary btn-sm" href="catalogos-grupos-formulario.php">Agregar</a>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de grupos de clientes.</p>
        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Nombre</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Cliente maestro</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Color</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($grupos as $grupo) {
                echo '
                  <tr id="row' . $grupo->id . '">
                    <td>' . $grupo->id . '</td>
                    <td>' . $grupo->nombre . '</td>
                    <td>' . $grupo->cliente_padre . '</td>
                    <td>' . $grupo->color . '</td>
                    <td>
                      <a href="catalogos-grupos-formulario.php?id=' . $grupo->id . '" class="btn btn-sm btn-block info text-u-c">Editar</a>
                      <a onclick="eliminarGrupo(' . $grupo->id . ')" class="btn btn-sm btn-block danger text-u-c">Eliminar</a>
                    </td>
                  </tr>
                  ';
              }


              ?>
            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>