<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 empresas</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <?php include_once 'api/adminEmpresas.php';
  $adminEmpresas = new AdminEmpresas();
  $empresa = $adminEmpresas->dameEmpresa($_GET['empresa']);
  ?>

  <?php

  include_once "api/adminProveedores.php";
  $adminProveedores = new AdministradorProveedores();
  //$empresa = $adminEmpresas->dameEmpresaLite($_GET['id']);
  $totalEmpresa = $adminProveedores->dameSumaReporte($empresa->rfc);
  $unoPorciento = 100 / $totalEmpresa;
  $unoPorCientoToal = $totalEmpresa * 0.01;
  $reporte = $adminProveedores->dameReporte($empresa->rfc);


  ?>
  <script>
    var proveedores = [];
    var porcentajes = [];
    var porcentajesIdeal = [];
    var idealInferior = [];
    var idealSuperior = [];
  </script>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>



    <div class="am-pagebody">
      <div class="row row-sm mg-t-15 mg-sm-t-20">
        <div class="col-md-12 mg-t-15 mg-sm-t-20 mg-md-t-0">
          <h2><?= $empresa->razon ?></h2>
        </div><!-- col-6 -->
      </div><!-- row -->
    </div><!-- row -->




    <div class="am-pagebody">


      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Datos de banking</h6>
        <p class="mg-b-20 mg-sm-b-30">Consulta el banking de la empresa.</p>

        <div id="accordion" class="accordion" role="tablist" aria-multiselectable="true">
          <div class="card">
            <div class="card-header" role="tab" id="headingOne">
              <h6 class="mg-b-0">
                <a data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="false" aria-controls="collapseOne" class="tx-gray-800 transition collapsed">
                  Lista de proveedores </a>
              </h6>
            </div><!-- card-header -->

            <div id="collapseOne" class="collapse" role="tabpanel" aria-labelledby="headingOne" style="">
              <div class="card-body">
                <table class="table mg-b-0">
                  <thead>
                    <tr>
                      <th class="text-center">Proveedor </th>
                      <th class="text-center">Total ideal</th>
                      <th class="text-center">Total enviado</th>
                      <!-- <th class="text-center">Porcentaje enviado </th> -->
                      <th class="text-center">Porcentaje Capturado</th>

                    </tr>
                  </thead>
                  <tbody>


                    <?php

                    foreach ($reporte as $r) {
                      $proveedor = $adminProveedores->dameProveedorE($r->id_empresa, $r->id_clave);
                      $treintaPorciento = $proveedor->porcentaje_sugerido / 100;
                      $treintaPorciento = $treintaPorciento * 30;
                      $rangoMenor = $proveedor->porcentaje_sugerido - $treintaPorciento;
                      $rangoMayor = $proveedor->porcentaje_sugerido + $treintaPorciento;
                      if (($r->total * $unoPorciento) < $rangoMenor || ($r->total * $unoPorciento) > $rangoMayor) {
                        $color = "color: red;";
                      } else {
                        $color = "";
                      }
                      if ($r->total > 0) {
                        echo "<tr>";
                        echo "<td>" . $r->razon_social . "</td>";
                        echo "<td>$ " . number_format(($proveedor->porcentaje_sugerido * $unoPorCientoToal), 2) . "</td>";

                        echo "<td>$ " . number_format($r->total, 2) . "</td>";
                        // echo "<td style='".$color."'> ". number_format(($r->total * $unoPorciento) , 2) ."%</td>";
                        echo "<td> " . number_format(($rangoMenor), 2) . "% - <span style='font-weight: bold;'> " . number_format(($proveedor->porcentaje_sugerido), 2) . "% </span> - " . number_format(($rangoMayor), 2) . "%</td>";
                        echo "</tr>";
                      }

                      echo "<script>proveedores.push('" . $r->razon_social . "');</script>";
                      echo "<script>porcentajes.push('" . ($r->total * $unoPorciento) . "');</script>";
                      echo "<script>porcentajesIdeal.push('" . ($proveedor->porcentaje_sugerido) . "');</script>";
                      echo "<script>idealInferior.push('" . ($rangoMenor) . "');</script>";
                      echo "<script>idealSuperior.push('" . ($rangoMayor) . "');</script>";
                    }


                    ?>



                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-header" role="tab" id="headingTwo">
              <h6 class="mg-b-0">
                <a class="transition collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                  Gráfica de uso de Banking </a>
              </h6>
            </div>
            <div id="collapseTwo" class="collapse" role="tabpanel" aria-labelledby="headingTwo" style="">
              <div class="card-body">


                <h6 class="card-body-title">Banking</h6>
                <p class="mg-b-20 mg-sm-b-30">Consulta los datos de banking en la grafica.</p>
                <div id="chart" class="ht-200 ht-sm-300"></div>

              </div>
            </div>
          </div>

        </div><!-- accordion -->
      </div>

      <div class="row row-sm mg-t-15 mg-sm-t-20">
        <div class="col-md-4 mg-t-15 mg-sm-t-20 mg-md-t-0">

          <div class="card position-relative overflow-hidden mt-3">
            <div class="card-body">
              <h6 class="card-title">Banking</h6>
              <p class="card-subtitle mb-3 text-muted">Ingresa el monto.</p>

              <!-- Formulario -->
              <form class="form-inline">
                <div class="input-group mr-12 mb-12">
                  <div class="input-group-prepend">
                  </div>
                  <input type="text" class="form-control" id="montoAnking"
                    placeholder="0.00"
                    oninput="sanearMonto(this)"
                    onblur="formatearMontoFinal(this)"
                    onkeypress="detonarModal(event)"
                    inputmode="decimal" autocomplete="off">
                </div>
                <button type="button" class="btn btn-primary mb-2 ml-auto" onclick="calcularEmpresas()"
                  data-toggle="modal" data-target="#ankingModal" id="dinero_empresa">
                  Banking
                </button>
              </form>
            </div>
          </div>
        </div>
      </div>



      <!-- Modal -->
      <div class="modal fade" id="ankingModal" tabindex="-1" role="dialog" aria-labelledby="ankingModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header bg-primary text-white">
              <h5 class="modal-title" id="ankingModalLabel">Confirmar Banking</h5>
              <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>

            <div class="modal-body">

              <!-- Tabla -->
              <div class="table-responsive">
                <table class="table table-sm table-striped table-hover mb-0" id="tablaAnking">
                  <thead class="thead-light">
                    <tr>
                      <th>Empresa</th>
                      <th class="text-right">Monto</th>
                      <th class="text-right">Calculado</th>
                      <th class="text-right">Capturado</th>
                    </tr>
                  </thead>
                  <tbody id="tablaCalculadora">
                    <!-- Ejemplos (puedes llenarlos dinámicamente) -->

                  </tbody>
                </table>
              </div>
            </div>

            <div class="modal-footer d-flex justify-content-between">
              <button type="button" class="btn btn-outline-secondary" id="btnCopiarTabla" onclick="copiarTabla()">
                Copiar
              </button>


            </div>
          </div>
        </div>
      </div>

      <!-- Script: muestra el monto en el modal (opcional) -->
      <script>
        $('#ankingModal').on('show.bs.modal', function() {
          var monto = document.getElementById('montoAnking') ? (document.getElementById('montoAnking').value || '0.00') : '0.00';
          document.getElementById('montoPreview').textContent = monto;
        });
      </script>







      <div class="row row-sm mg-t-15 mg-sm-t-20">


        <?php
        $cuentaSalto = 0;
        foreach ($empresa->cuentas as $cuenta) {
          $cuentaSaldo =  $adminEmpresas->dameRetirosYDepositos($cuenta->id);
          switch ($cuenta->banco) {
            case 'Bancomer':
              $imagen = 'img/bbva.png';
              break;
            case 'BBVA-NEW':
              $imagen = 'img/bbva.png';
              break;
            case 'Base':
              $imagen = 'img/base.png';
              break;
            case 'Mifel':
              $imagen = 'img/mifel.png';
              break;
            case 'Fondeadora':
              $imagen = 'img/fondea.jpg';
              break;
            case 'BanBajio':
              $imagen = 'img/bancajio.png';
              break;
            case 'Banorte':
              $imagen = 'img/banorte.png';
              break;
            case 'Santander':
              $imagen = 'img/santander.png';
              break;
            case 'HSBC':
              $imagen = 'img/hsbc.png';
              break;
            case 'CitiBanamex':
              $imagen = 'img/citibanamex.png';
              break;
            case 'Scotiabank':
              $imagen = 'img/scotiabank.png';
              break;
            case 'Banregio':
              $imagen = 'img/banregio.png';
              break;
            case 'STP':
              $imagen = 'img/stp.png';
              break;
            case 'Manual':
              $imagen = 'favicon.png';
              break;
            case 'Banamex':
              $imagen = 'img/banamex.jpg';
              break;
            case 'ASP':
              $imagen = 'img/asp.jpg';
              break;
            default:
              $imagen = '';
              break;
          }
        ?>


          <div class="col-lg-4" style="padding-top: 1rem;">
            <div class="card position-relative overflow-hidden">
              <div id="" class="wd-100p ht-200 "></div>
              <div class="overlay-body pd-x-20 pd-t-20">
                <div class="d-flex justify-content-between">
                  <div>
                    <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-15"><?= $cuenta->banco ?></h6>
                    <p class="tx-12"><?= $cuenta->moneda ?></p>
                  </div>
                </div><!-- d-flex -->
                <a href="empresa-captura.php?cuenta=<?= $cuenta->id ?>&empresa=<?= $empresa->id ?>">
                  <h2 class="mg-b-5 tx-inverse tx-lato">$ <?= number_format($cuentaSaldo, 2) ?></h2>
                  <p class="tx-12 mg-b-0">saldo de la cuenta.</p>
                </a>
              </div>

              <!-- Imagen más grande y saliendo de la esquina -->
              <img src="../../<?= $imagen ?>"
                alt="icono"
                style="position:absolute; bottom:-20px; right:-20px; width:80px; height:80px; border-radius:50%; background:rgba(0,0,0,0.3); padding:10px; object-fit:cover;">
            </div><!-- card -->
          </div>



        <?php } ?>

      </div><!-- row -->

    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script>
    var options = {
      series: [{
          name: "Total distribuido",
          data: porcentajes
        },

        {
          name: "Ideal Inferior",
          data: idealInferior
        },
        {
          name: "Ideal Superior",
          data: idealSuperior
        }
      ],
      colors: ['#FF5733', '#007bff', '#007bff'],
      chart: {
        height: 350,
        type: 'line',
        dropShadow: {
          enabled: true,
          color: '#000',
          top: 18,
          left: 7,
          blur: 10,
          opacity: 0.2
        },
        toolbar: {
          show: false
        }
      },

      dataLabels: {
        enabled: true,
      },
      stroke: {
        curve: 'smooth'
      },
      title: {
        text: 'Porcentaje de distribución de proveedores',
        align: 'left'
      },
      grid: {
        borderColor: '#e7e7e7',
        row: {
          colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
          opacity: 0.5
        },
      },
      markers: {
        size: 1
      },
      xaxis: {
        categories: proveedores,
        title: {
          text: 'Proveedores'
        }
      },
      yaxis: {
        title: {
          text: 'Porcentaje'
        },

      },
      legend: {
        position: 'top',
        horizontalAlign: 'right',
        floating: true,
        offsetY: -25,
        offsetX: -5
      }
    };

    var chart = new ApexCharts(document.querySelector("#chart"), options);
    chart.render();
  </script>



  <script>
    var reporteCal = null;
    var textoCopiar = ""; // variable global para almacenar la info lista para copiar

    function calcularEmpresas() {
      var enviarDatos = new FormData();
      enviarDatos.append("dinero", document.getElementById("montoAnking").value);
      enviarDatos.append("id", <?= $empresa->id ?>);
      enviarDatos.append("accion", "reporte");

      fetch("api/apiProveedores.php", {
          method: "POST",
          body: enviarDatos,
        })
        .then((respuesta) => respuesta.json())
        .then((data) => {
          var espacioResultado = document.getElementById("tablaCalculadora");
          espacioResultado.innerHTML = "";
          var total = 0;
          var totalProcentaje = 0;
          var dataJson = JSON.stringify(data);
          reporteCal = dataJson;

          // reinicia textoCopiar
          textoCopiar = "";

          for (var i = 0; i < data.length; i++) {
            var numeroFormateado = new Intl.NumberFormat('es-MX', {
              style: 'currency',
              currency: 'MXN'
            }).format(data[i].total);

            total = total + data[i].total;
            totalProcentaje = totalProcentaje + data[i].porcentaje_calculado;

            // pinta la tabla
            espacioResultado.innerHTML +=
              "<tr><td>" + data[i].proveedor + "</td><td>" + numeroFormateado + "</td><td>" +
              data[i].porcentaje_calculado + "%</td><td>" + data[i].porcentaje + "%</td></tr>";

            // agrega a la cadena de copiado (proveedor \t monto sin formato de moneda)
            textoCopiar += data[i].proveedor + "\t$" + parseFloat(data[i].total).toFixed(2) + "\n";
          }

          var numeroFormateado = new Intl.NumberFormat('es-MX', {
            style: 'currency',
            currency: 'MXN'
          }).format(total);

          espacioResultado.innerHTML += "<tr><td>Total</td><td>" + numeroFormateado + "</td><td>" +
            totalProcentaje + "%</td><td></td></tr>";
        });
    }

    // función copiar que usa textoCopiar generado arriba
    function copiarTabla() {
      if (!textoCopiar) return;
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(textoCopiar.trim()).then(function() {
          alert("Datos copiados al portapapeles ✅");
        });
      } else {
        // fallback
        var ta = document.createElement("textarea");
        ta.value = textoCopiar.trim();
        document.body.appendChild(ta);
        ta.select();
        document.execCommand("copy");
        document.body.removeChild(ta);
        alert("Datos copiados al portapapeles ✅");
      }
    }
  </script>
  <script>
    function sanearMonto(el) {
      let v = el.value;
      v = v.replace(/[^0-9.]/g, '');
      const firstDot = v.indexOf('.');
      if (firstDot !== -1) {
        v = v.slice(0, firstDot + 1) + v.slice(firstDot + 1).replace(/\./g, '');
      }
      if (firstDot !== -1) {
        const [ent, dec] = v.split('.');
        v = ent + '.' + dec.slice(0, 2);
      }
      el.value = v;
    }

    function formatearMontoFinal(el) {
      const limpio = el.value.replace(/,/g, '');
      if (limpio === '' || isNaN(limpio)) {
        el.value = '';
        return;
      }
      const num = parseFloat(limpio);
      el.value = num.toLocaleString('en-US', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      });
    }

    function detonarModal(e) {
      if (e.key === "Enter") {
        e.preventDefault(); // evita enviar formulario

        // Ejecuta la función de cálculo
        calcularEmpresas();

        // Abre el modal (requiere Bootstrap JS cargado)
        $('#ankingModal').modal('show');
      }
    }
  </script>


</body>

</html>