<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <script>
      var semana = [];
      var conteoEn = [];
      var conteoWk = [];
      var conteoZac = [];

      var conteoEnEntrada = [];
      var conteoWkEntrada = [];
      var conteoZacEntrada = [];

      var sumaEn = [];
      var sumaWk = [];
      var sumaZac = [];

      var salidasMontoEn = [];
      var salidasMontosWk = [];
      var salidasMontosZac = [];


      //conteoEn.push();
    </script>
    <?php

    include_once "api/adminUtil.php";
    $adminUtil = new AdministradorUtil();
    $estadisticasUsoConteo = $adminUtil->dameEstadisticasFacturas();



    foreach ($estadisticasUsoConteo as $est) {
      echo '<script>semana.push(' . $est->semana . ');</script>';
      echo '<script>conteoEn.push(' . $est->facturasManuales . ');</script>';
      echo '<script>conteoWk.push(' . $est->facturasAutomaticas . ');</script>';
    }



    ?>

    <div class="am-pagebody">
     



      <div class="row row-sm mg-t-15 mg-sm-t-20">

        <div class="col-md-12 mg-t-15 mg-sm-t-20 mg-md-t-0">
          <div class="card pd-20 pd-sm-40">
            <h6 class="card-body-title">Estadísticas generales</h6>
            <p class="mg-b-20 mg-sm-b-30">Estadísticas generales por cliente, aportaciones por cartera.</p>
            <canvas id="chartLine1"></canvas>
          </div><!-- card -->
        </div><!-- col-6 -->
      </div><!-- row -->



    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/chart.js/Chart.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>

  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const hoy = new Date();
      const haceUnMes = new Date();
      haceUnMes.setMonth(hoy.getMonth() - 1);

      // Función para formatear a YYYY-MM-DD
      const toFechaInput = (fecha) => {
        const y = fecha.getFullYear();
        const m = String(fecha.getMonth() + 1).padStart(2, "0");
        const d = String(fecha.getDate()).padStart(2, "0");
        return `${y}-${m}-${d}`;
      };

      // Asignar valores por defecto
      document.getElementById("fechaInicio").value = toFechaInput(haceUnMes);
      document.getElementById("fechaFin").value = toFechaInput(hoy);

      // Ejemplo: mostrar en consola cuando se hace click
      document.getElementById("btnPeriodo").addEventListener("click", () => {
        var inicio = document.getElementById("fechaInicio").value;
        var fin = document.getElementById("fechaFin").value;
        //verificar que fecha fin no este antes que inicio 
        if (inicio && fin) {
          var fechaInicio = new Date(inicio);
          var fechaFin = new Date(fin);

          if (fechaFin < fechaInicio) {

            document.getElementById("fin").value = "";

            Swal.fire({
              title: 'Error',
              text: 'La fecha fin no puede ser menor a la fecha inicio',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            });
            return;
          }
        }




        window.location.href = "estadisticas-general-dia.php?fecha=" + inicio + " to " + fin;
      });
    });
  </script>
  
<script>
  $(document).ready(function () {
    var ctx3 = document.getElementById('chartLine1').getContext('2d');

    var myChart3 = new Chart(ctx3, {
      type: 'bar', // cambia a 'line' si la quieres como líneas
      data: {
        labels: semana,            // <- de la 1a gráfica (Apex)
        datasets: [
          {
            label: 'Facturas manuales',
            data: conteoEn,        // <- de la 1a gráfica
            backgroundColor: 'rgba(251, 147, 55, 0.45)',
            borderColor: '#FB9337',
            borderWidth: 1
          },
          {
            label: 'Facturas automáticas',
            data: conteoWk,        // <- de la 1a gráfica
            backgroundColor: 'rgba(75, 192, 192, 0.45)',
            borderColor: 'rgba(75, 192, 192, 1)',
            borderWidth: 1
          }
        ]
      },
      options: {
        legend: {
          display: true
        },
        tooltips: {
          callbacks: {
            label: function (tooltipItem, data) {
              var ds = data.datasets[tooltipItem.datasetIndex].label || '';
              var val = tooltipItem.yLabel;
              return ds + ': ' + Number(val).toLocaleString('en-US') + ' facturas';
            }
          }
        },
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true,
              callback: function (value) {
                return Number(value).toLocaleString('en-US');
              }
            },
            scaleLabel: {
              display: true,
              labelString: 'Facturas'
            }
          }],
          xAxes: [{
            ticks: {
              autoSkip: false, // mostrar todas las categorías
              maxRotation: 90, // vertical
              minRotation: 90,
              fontSize: 11
            }
          }]
        }
      }
    });
  });
</script>



</body>

</html>