<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <script>
      var nombres = [];
      var aportaciones = [];
    </script>
    <?php

    include_once("api/adminUtil.php");
    $adminUtil = new AdministradorUtil();
    $totalAcumulado = 0;

    if (isset($_GET['fecha'])) {
      $fecha = $_GET['fecha'];
      $fecha = explode(" to ", $fecha);
      $fecha_inicio = $fecha[0];
      $fecha_fin = $fecha[1];
      $clientes = $adminUtil->dameEstadisticasClienteFecha($fecha_inicio, $fecha_fin);
    } else {

      $clientes = $adminUtil->dameEstadisticasCliente();
      $fecha_fin = date('Y-m-d');
    }
    echo "<script>";
    foreach ($clientes as $cliente) {
      echo "nombres.push('$cliente->nombre');";
      echo "aportaciones.push($cliente->aportacion);";
      $totalAcumulado += $cliente->aportacion;
    }
    echo "</script>";

    function fechaComoCadena($fecha)
    {

      if($fecha == null){
        return "El inicio del tiempo";
      }

      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);

      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case  "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }



    ?>

    <div class="am-pagebody">

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Seleccionar fechas de análisis</h6>

        <div class="row">
          <div class="col-lg">
            <label class="form-control-label">Fecha inicio: <span class="tx-danger">*</span></label>
            <input class="form-control" type="date" id="fechaInicio">
          </div><!-- col -->
          <div class="col-lg mg-t-10 mg-lg-t-0">
            <label class="form-control-label">Fecha fin: <span class="tx-danger">*</span></label>
            <input class="form-control" type="date" id="fechaFin">
          </div><!-- col -->
        </div><!-- row -->

        <!-- Botón -->
        <div class="mt-3">
          <button type="button" class="btn btn-primary" id="btnPeriodo">Ver periodo</button>
        </div>
      </div>

      <br>
      <div class="row row-sm">
        <div class="col-lg-4">
          <div class="card">
            <div class="wd-100p ht-200 rickshaw_graph"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-15">Monto acumulado:</h6>
                  <p class="tx-12"><?= fechaComoCadena($fecha_inicio) ?> a <?= fechaComoCadena($fecha_fin) ?></p>
                </div>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$<?=number_format($totalAcumulado,2)?></h2>
              <p class="tx-12 mg-b-0">Pesos mexicanos.</p>
            </div>
          </div><!-- card -->
        </div>
        <div class="col-lg-8">
          <div class="card pd-20 wd-100p ht-200">
            <h6 class="tx-12 tx-uppercase  tx-inverse tx-bold mg-b-15">Mayor aportador</h6>
            <div class="d-flex mg-b-10">
              <div class="bd-r pd-r-10">
                <label class="tx-12">Cartera</label>
                <p class="tx-lato tx-inverse tx-bold"><?= $clientes[0]->nombre ?></p>
              </div>
              <div class="bd-r pd-x-10">
                <label class="tx-12">Monto aportado</label>
                <p class="tx-lato tx-inverse tx-bold">$<?= number_format($clientes[0]->aportacion, 2) ?> </p>
              </div>
              <div class="pd-l-10">
                <label class="tx-12">Porcentaje</label>
                <p class="tx-lato tx-inverse tx-bold"><?= number_format($porcentaje = (100 / $totalAcumulado) * $clientes[0]->aportacion, 2) ?> %</p>
              </div>
            </div><!-- d-flex -->
            <div class="progress">
              <div
                class="progress-bar bg-success"
                role="progressbar"
                style="width: <?= $porcentaje ?>%;"
                aria-valuenow="<?= $porcentaje ?>"
                aria-valuemin="0"
                aria-valuemax="100">
                <?= number_format($porcentaje, 2) ?>%
              </div>
            </div>
            <p class="tx-12 mg-b-0">Los datos corresponden al periodo de análisis seleccionado</p>
          </div><!-- card -->
        </div><!-- col-4 -->


      </div>



      <div class="row row-sm mg-t-15 mg-sm-t-20">

        <div class="col-md-12 mg-t-15 mg-sm-t-20 mg-md-t-0">
          <div class="card pd-20 pd-sm-40">
            <h6 class="card-body-title">Estadísticas generales</h6>
            <p class="mg-b-20 mg-sm-b-30">Estadísticas generales por cliente, aportaciones por cartera.</p>
            <canvas id="chartLine1"></canvas>
          </div><!-- card -->
        </div><!-- col-6 -->
      </div><!-- row -->



    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/chart.js/Chart.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>

  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const hoy = new Date();
      const haceUnMes = new Date();
      haceUnMes.setMonth(hoy.getMonth() - 1);

      // Función para formatear a YYYY-MM-DD
      const toFechaInput = (fecha) => {
        const y = fecha.getFullYear();
        const m = String(fecha.getMonth() + 1).padStart(2, "0");
        const d = String(fecha.getDate()).padStart(2, "0");
        return `${y}-${m}-${d}`;
      };

      // Asignar valores por defecto
      document.getElementById("fechaInicio").value = toFechaInput(haceUnMes);
      document.getElementById("fechaFin").value = toFechaInput(hoy);

      // Ejemplo: mostrar en consola cuando se hace click
      document.getElementById("btnPeriodo").addEventListener("click", () => {
        var inicio = document.getElementById("fechaInicio").value;
        var fin = document.getElementById("fechaFin").value;
        //verificar que fecha fin no este antes que inicio 
        if (inicio && fin) {
          var fechaInicio = new Date(inicio);
          var fechaFin = new Date(fin);

          if (fechaFin < fechaInicio) {

            document.getElementById("fin").value = "";

            Swal.fire({
              title: 'Error',
              text: 'La fecha fin no puede ser menor a la fecha inicio',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            });
            return;
          }
        }




        window.location.href = "estadisticas-general.php?fecha=" + inicio + " to " + fin;
      });
    });
  </script>
<script>
  $(document).ready(function() {
    var ctx3 = document.getElementById('chartLine1');
    var myChart3 = new Chart(ctx3, {
      type: 'line',
      data: {
        labels: nombres,
        datasets: [{
          label: 'Pesos',
          data: aportaciones,
          borderColor: '#FB9337',
          borderWidth: 1,
          fill: false
        }]
      },
      options: {
        legend: {
          display: false,
          labels: { display: false }
        },
        tooltips: {
          callbacks: {
            label: function(tooltipItem) {
              let value = tooltipItem.yLabel;
              return '$' + value.toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
              });
            }
          }
        },
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true,
              fontSize: 10,
              callback: function(value) {
                return '$' + value.toLocaleString('en-US', {
                  minimumFractionDigits: 2,
                  maximumFractionDigits: 2
                });
              }
            }
          }],
          xAxes: [{
            ticks: {
              beginAtZero: true,
              fontSize: 11,
              autoSkip: false, // mostrar todas
              maxRotation: 90, // vertical
              minRotation: 90
            }
          }]
        }
      }
    });
  });
</script>




</body>

</html>