<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Bancos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script
    src="https://code.jquery.com/jquery-3.7.1.min.js"
    integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="
    crossorigin="anonymous"></script>
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <?php
    session_start();
    ?>
    <?php
    include_once "api/adminEmpresas.php";
    include_once "api/adminConceptos.php";
    include_once "api/adminClientes.php";
    include_once "api/adminFormasPago.php";
    include_once "api/adminPagos.php";

    $adminEmpresas = new AdminEmpresas();
    $adminConceptos = new AdministradorConceptos();
    $adminClientes = new AdministradorClientes();
    $adminFormasPago = new AdministradorFormasPago();
    $adminPagos = new AdministradorPagos();
    ?>

    <?php




    ?>
    <div class="am-pagebody">

      <?php if (!isset($_GET['empresa'])) { ?>

        <div class="card pd-20 pd-sm-40">
          <h6 class="card-body-title">Empresa</h6>
          <p class="mg-b-20 mg-sm-b-30">Seleccione la empresa que emitirá la factura.</p>

          <form action="">
            <div class="form-layout">
              <div class="row mg-b-25">
                <div class="col-lg-12">
                  <div class="form-group">
                    <label class="form-control-label">Empresa: <span class="tx-danger">*</span></label>
                    <select name="empresa" class="form-control select2" id="empresaSelect">
                      <?php
                      foreach ($empresas as $empresa) {
                        echo "<option value='$empresa->id'>$empresa->razon</option>";
                      }
                      ?>
                    </select>
                  </div>
                </div><!-- col-4 -->



              </div><!-- row -->

              <div class="form-layout-footer">
                <button class="btn btn-info mg-r-5">Seleccionar</button>
              </div><!-- form-layout-footer -->
            </div><!-- form-layout -->
          </form>
        </div>

      <?php } else {


        $empresa = $adminEmpresas->dameEmpresa($_GET['empresa']);
        $clientes = $adminClientes->dameClientes();
        $formasPago = $adminFormasPago->dameFormasPago();
        $metodosPago = $adminFormasPago->dameMetodosPago();
        $usosCfdi = $adminFormasPago->dameUsosCfdi();
        if (isset($_GET['movimiento'])) {
          $seCargo = 'readonly';
          $movimiento = $adminPagos->damePago($_GET['movimiento']);
          $detectado = 1;
          //echo var_dump($movimiento);
          // $modalRef = '<a data-toggle="modal" data-target="#barraMovimiento" > DETALLES MOVIMIENTO</a>';
        } else {
          $movimiento = null;
          $detectado = 0;
        }

      ?>





        <br>
        <div class="card pd-20 pd-sm-40">

          <p class="mg-b-20 mg-sm-b-30">Genera la factura.</p>
          <div class="table-wrapper">


            <!-- CARD FACTURACIÓN -->
            <div class="card">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-between mb-4">
                  <h5 class="mb-0">Facturación <?php echo $empresa->razon ?></h5>
                </div>

                <form onsubmit="submitForm5(); return false;">
                  <!-- FILA 1 -->
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <label for="seachable-select">Selecciona cliente</label>
                      <select onchange="cargarClaves(this.value)" id="seachable-select" name="cliente" class="form-control">
                        <?php
                        foreach ($clientes as $cliente) {
                          if ($cliente->id == $movimiento->idCliente) {
                            echo "<option value='$cliente->id' selected>$cliente->nombre</option>";
                          } else {
                            echo "<option value='$cliente->id'>$cliente->nombre</option>";
                          }
                        }
                        ?>
                      </select>
                    </div>
                    <div class="form-group col-md-6">
                      <label for="clave_c">Razón social</label>
                      <select name="clave_c" id="clave_c" class="form-control"></select>
                    </div>
                  </div>

                  <!-- FILA 2 -->
                  <div class="form-row">
                    <div class="form-group col-md-3">
                      <label for="metodo_pago">Método de pago</label>
                      <select name="metodo_pago" id="metodo_pago" class="form-control" onchange="filtrarOpciones(this.value)">
                        <?php
                        foreach ($metodosPago as $metodoPago) {
                          if (isset($_GET['movimiento'])) {
                            if ($metodoPago->id == 1) {
                              echo "<option value='$metodoPago->id' selected>$metodoPago->metodo_pago</option>";
                            }
                          } else {
                            echo "<option value='$metodoPago->id'>$metodoPago->metodo_pago</option>";
                          }
                        }
                        ?>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="forma_pago">Forma de pago</label>
                      <select name="forma_pago" id="forma_pago" class="form-control">
                        <option value="0">Seleccione</option>
                        <?php
                        foreach ($formasPago as $formaPago) {
                          if (isset($_GET['movimiento'])) {
                            if ($formaPago->id == 3) {
                              echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                            } else {
                              echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                            }
                          } else {
                            if ($formaPago->id == 23) {
                              echo "<option value='$formaPago->id' style='display: none;'>$formaPago->forma_pago</option>";
                            } else {
                              echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                            }
                          }
                        }
                        ?>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="tipo_comprobante">Tipo de comprobante</label>
                      <select name="tipo_comprobante" id="tipo_comprobante" required class="form-control">
                        <option value=""></option>
                        <option value="I" selected>Ingreso</option>
                        <option value="E">Egreso</option>
                        <option value="T">Traslado</option>
                        <option value="N">Nomina</option>
                        <option value="P">Pago</option>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="uso_cfdi">Uso De CFDI</label>
                      <select name="uso_cfdi" id="uso_cfdi" class="form-control">
                        <option value="0">Seleccione</option>
                        <?php
                        foreach ($usosCfdi as $usoCfdi) {
                          if (isset($_GET['movimiento'])) {
                            if ($usoCfdi->id == 3) {
                              echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                            } else {
                              echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                            }
                          } else {
                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                          }
                        }
                        ?>
                      </select>
                    </div>
                  </div>

                  <!-- FILA 3 -->
                  <div class="form-row">
                    <div class="form-group col-md-3">
                      <label for="status_pago">Estatus de pago</label>
                      <select name="status_pago" id="status_pago" required class="form-control" <?php echo $seCargo ?>>
                        <?php
                        if (isset($_GET['movimiento'])) {
                          echo '<option value="Pagado" selected>Pagado</option>';
                        } else {
                          echo '<option value="No Pagado">No Pagado</option>
                      <option value="Pagado" selected>Pagado</option>';
                        }
                        ?>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="retencion_transporte">Retención 4%</label>
                      <select name="retencion_transporte" id="retencion_transporte" required class="form-control">
                        <option value="No">No</option>
                        <option value="Si">Si</option>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="moneda">Moneda</label>
                      <select name="moneda" id="moneda" required class="form-control">
                        <option value="1" selected>MXN</option>
                        <option value="2">USD</option>
                        <option value="3">EUR</option>
                      </select>
                    </div>
                    <div class="form-group col-md-3">
                      <label for="pago_asociado">Pago asociado</label>
                      <input type="number" class="form-control" id="pago_asociado" name="pago_asociado" readonly>
                    </div>

                    <?php if (isset($_GET['movimiento'])) { ?>
                      <div class="form-group col-md-3">
                        <label for="monto-cargado">Monto cargado</label>
                        <input type="text" value="$ <?php echo number_format($movimiento->monto, 2) ?>" name="monto-cargado" id="monto-cargado" class="form-control" disabled>
                      </div>
                    <?php } ?>
                  </div>

                  <!-- BOTONES -->
                  <div class="row">
                    <div class="col-12 col-md-2 mb-2">
                      <button type="submit" onclick="enviarFactura()" id="boton-terminar" class="btn btn-primary btn-block">Terminar Factura</button>
                    </div>

                    <div class="col-12 col-md-2 mb-2">
                      <button type="button" class="btn btn-warning btn-block" data-toggle="modal" data-target="#modalConceptos">Agregar Concepto</button>
                    </div>

                    <div class="col-12 col-md-2 mb-2">
                      <button type="button" class="btn btn-info btn-block" data-toggle="modal" data-target="#modalImportar">Importar captura</button>
                    </div>

                    <div class="col-12 col-md-2 mb-2">
                      <button type="button" class="btn btn-primary btn-block" onclick="crearFactura(<?php echo $movimiento->monto ?>);">Randomize</button>
                    </div>

                    <div class="col-12 col-md-2 mb-2">
                      <button type="button" class="btn btn-warning btn-block" onclick="relacionarPagos()" data-toggle="modal" data-target="#modalRelacionar">Relacionar pago</button>
                    </div>
                  </div>
                </form>
              </div>
            </div>

            <!-- RESULTADOS -->
            <div class="pt-4">
              <div class="card">
                <div class="card-body">
                  <div id="resultados" class="table-responsive">
                    <table class="table">
                      <thead>
                        <tr>
                          <th>CODIGO SAT</th>
                          <th>CANT.</th>
                          <th>PRODUCTO</th>
                          <th>PRECIO UNIT.</th>
                          <th>APLICA IVA.</th>
                          <th>PRECIO TOTAL</th>
                          <th>PRECIO TOTAL C/IVA</th>
                          <th>ACCION</th>
                        </tr>
                      </thead>
                      <tbody id="resultadosTabla"></tbody>
                      <tr>
                        <td class="text-right" colspan="4">SUBTOTAL $</td>
                        <td></td>
                        <td></td>
                        <td class="text-right">
                          <p id="subTotal_f" class="mb-0"></p>
                        </td>
                        <td></td>
                      </tr>
                      <tr>
                        <td class="text-right" colspan="4">RETENCIÓN 4%</td>
                        <td></td>
                        <td></td>
                        <td class="text-right">
                          <p id="retencion_f" class="mb-0">- $ 0.00</p>
                        </td>
                        <td></td>
                      </tr>
                      <tr>
                        <td class="text-right" colspan="4">IVA (16)% $</td>
                        <td></td>
                        <td></td>
                        <td class="text-right">
                          <p id="iva_f" class="mb-0"></p>
                        </td>
                        <td></td>
                      </tr>
                      <tr>
                        <td class="text-right" colspan="4">TOTAL $</td>
                        <td></td>
                        <td></td>
                        <td class="text-right" id="total_factura">
                          <p id="total_f" class="mb-0"></p>
                        </td>
                        <td></td>
                      </tr>
                    </table>
                  </div>
                </div>
              </div>
            </div>

            <!-- MODAL: CONCEPTOS -->
            <div class="modal fade" id="modalConceptos" tabindex="-1" role="dialog" aria-labelledby="modalConceptosLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 id="modalConceptosLabel" class="modal-title">Conceptos</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                  </div>
                  <div class="modal-body">
                    <div class="table-responsive">
                      <table id="miTabla" class="table">
                        <thead>
                          <tr>
                            <th>Código</th>
                            <th>Cve Unidad.</th>
                            <th style="min-width:220px;">Producto</th>
                            <th style="min-width:100px;" class="text-right">Cant.</th>
                            <th style="min-width:100px;" class="text-right">P/U con IVA</th>
                            <th style="min-width:100px;" class="text-right">Precio total con IVA</th>
                            <th class="text-center" style="width:36px;">Agregar</th>
                          </tr>
                        </thead>
                        <tbody></tbody>
                      </table>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-outline-danger" data-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Guardar</button>
                  </div>
                </div>
              </div>
            </div>

            <!-- MODAL: IMPORTAR -->
            <div class="modal fade" id="modalImportar" tabindex="-1" role="dialog" aria-labelledby="modalImportarLabel" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 id="modalImportarLabel" class="modal-title">Importar factura</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                  </div>
                  <div class="modal-body">
                    <textarea name="captura" id="summernote"></textarea>
                    <script>
                      $('#summernote').summernote({
                        placeholder: 'Pega la factura aquí...',
                        tabsize: 2,
                        height: 120,
                        toolbar: false
                      });
                    </script>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-outline-danger" onclick="enviarImportado()">Importar</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Save</button>
                  </div>
                </div>
              </div>
            </div>

            <!-- MODAL: RELACIONAR PAGO -->
            <div class="modal fade" id="modalRelacionar" tabindex="-1" role="dialog" aria-labelledby="modalRelacionarLabel" aria-hidden="true">
              <div class="modal-dialog modal-xl pos-static" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 id="modalRelacionarLabel" class="modal-title">Relacionar pagos</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                  </div>
                  <div class="modal-body">
                    <div class="table-responsive">
                      <table id="tableRelacionar" class="table">
                        <thead>
                          <tr>
                            <th>ID</th>
                            <th>Tipo Movimiento</th>
                            <th style="min-width:120px;">Fecha Banco</th>
                            <th style="min-width:120px;">Fecha Captura</th>
                            <th style="min-width:220px;">Nombre Cliente</th>
                            <th>Monto</th>
                            <th>ID Factura</th>
                            <th>Acciones</th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-outline-danger" data-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Guardar</button>
                  </div>
                </div>
              </div>
            </div>



          </div><!-- table-wrapper -->
        </div><!-- card -->
      <?php } ?>
    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>

  <script>
    $(document).ready(function() {
      $('#empresaSelect').select2({
        placeholder: "Selecciona una empresa",
        allowClear: true,
        width: '100%' // hace que se adapte al ancho del form-control
      });
    });
  </script>


  <script>
    var conceptosFactura = [];

    obtenerConceptos();

    function obtenerConceptos() {
      console.log("Obteniendo conceptos");

      fetch("api/apiReporteConceptos.php?accion=empresa&empresa=<?php echo $empresa->id ?>", {
          method: "GET",
        })
        .then((respuesta) => respuesta.json())
        .then((data) => {
          let conceptos = data.aaData;
          let tbody = document.querySelector("#miTabla tbody");
          tbody.innerHTML = ""; // limpiar por si acaso

          for (let i = 0; i < conceptos.length; i++) {
            let fila = `
                      <tr>
                        <td>${conceptos[i].clave_sat}</td>
                        <td>${conceptos[i].clave_unidad_medida}</td>
                        <td>
                          <textarea class="form-control" id="${conceptos[i].id}concepto">${conceptos[i].concepto}</textarea>
                          <p hidden>${conceptos[i].concepto}</p>
                        </td>
                        <td><input class="form-control" type="number" id="${conceptos[i].id}cantidad" value="1"></td>
                        <td></td>
                        <td><input class="form-control" type="number" id="${conceptos[i].id}precio" value="${conceptos[i].precio_min}"></td>
                        <td>
                          <button
                            type="button"
                            class="btn btn-primary btn-sm"
                            data-clave_sat="${conceptos[i].clave_sat}"
                            onclick="anadirAFactura(this, '${conceptos[i].id}', 16)">
                            Agregar
                          </button>
                          <button
                            type="button"
                            class="btn btn-secondary btn-sm"
                            data-clave_sat="${conceptos[i].clave_sat}"
                            onclick="anadirAFactura(this, '${conceptos[i].id}', 0)">
                            Tasa 0
                          </button>
                        </td>
                      </tr>`;

            tbody.insertAdjacentHTML("beforeend", fila);
          }
        });
    }
  </script>


  <script>
    // ====== Estado global ======
    window.conceptosFactura = window.conceptosFactura || []; // [{id, concepto, cantidad, precio(linea con IVA), aplicaIva, claveSat}]

    // ====== Utilidades ======
    const money = v => Number(v ?? 0).toLocaleString('es-MX', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    });
    const toNum = v => {
      if (typeof v === 'number') return v;
      if (!v) return 0;
      // Limpia símbolos $, comas, espacios
      return Number(String(v).replace(/[^0-9.\-]/g, '')) || 0;
    };

    // ====== Render de la tabla inferior y totales ======
    function renderTablaFactura() {
      const tbody = document.getElementById('resultadosTabla');
      if (!tbody) {
        console.warn('#resultadosTabla no encontrado');
        return;
      }
      tbody.innerHTML = '';

      let subtotal = 0; // suma de bases SIN IVA
      let ivaTotal = 0; // suma de IVA

      window.conceptosFactura.forEach((it, idx) => {
        const cantidad = Math.max(1, toNum(it.cantidad || 1));
        const totalConIva = Math.max(0, toNum(it.precio || 0)); // TOTAL de la LÍNEA con IVA (capturado en modal)
        const unitWithIva = totalConIva / cantidad;

        let unitBase = unitWithIva;
        let lineBase = totalConIva;
        let lineIva = 0;

        if (it.aplicaIva) {
          unitBase = unitWithIva / 1.16;
          lineBase = totalConIva / 1.16; // = unitBase * cantidad
          lineIva = totalConIva - lineBase; // IVA de la línea
        }

        subtotal += lineBase;
        ivaTotal += lineIva;

        const tr = document.createElement('tr');
        tr.innerHTML = `
      <td>${it.claveSat || '—'}</td>
      <td class="text-right">${cantidad}</td>
      <td>${it.concepto}</td>
      <td class="text-right">$ ${money(unitBase)}</td>          <!-- PRECIO UNIT. (sin IVA) -->
      <td class="text-center">${it.aplicaIva ? 'Sí (16%)' : 'No'}</td>
      <td class="text-right">$ ${money(lineBase)}</td>          <!-- PRECIO TOTAL (sin IVA) -->
      <td class="text-right">$ ${money(totalConIva)}</td>       <!-- PRECIO TOTAL C/IVA -->
      <td class="text-center">
        <button type="button" class="btn btn-sm btn-outline-danger" onclick="eliminarConcepto(${idx})">Quitar</button>
      </td>
    `;
        tbody.appendChild(tr);
      });

      // Retención 4% sobre subtotal (sin IVA)
      const retSel = document.getElementById('retencion_transporte');
      const hayRetencion = retSel && retSel.value === 'Si';
      const retencion = hayRetencion ? subtotal * 0.04 : 0;

      // Pinta totales
      const subEl = document.getElementById('subTotal_f');
      const ivaEl = document.getElementById('iva_f');
      const retEl = document.getElementById('retencion_f'); // opcional
      const totEl = document.getElementById('total_f');

      if (subEl) subEl.textContent = `$ ${money(subtotal)}`;
      if (ivaEl) ivaEl.textContent = `$ ${money(ivaTotal)}`;
      if (retEl) retEl.textContent = `- $ ${money(retencion)}`;
      if (totEl) totEl.textContent = `$ ${money(subtotal + ivaTotal - retencion)}`;
    }

    // ====== Agregar concepto desde el modal ======
    // Firma soportada:
    //   anadirAFactura(this, 'ID', 16)   -> recomendado (lleva data-clave_sat)
    //   anadirAFactura('ID', 16)         -> compatible
    function anadirAFactura(btnOrId, maybeIdOrIva, maybeIva) {
      let btn = null,
        id = null,
        ivaPct = 0;
      if (typeof btnOrId === 'object') { // viene 'this'
        btn = btnOrId;
        id = String(maybeIdOrIva);
        ivaPct = Number(maybeIva || 0);
      } else { // firma antigua
        id = String(btnOrId);
        ivaPct = Number(maybeIdOrIva || 0);
      }

      // Lee campos del modal por ID
      const conceptoEl = document.getElementById(id + 'concepto');
      const cantidadEl = document.getElementById(id + 'cantidad');
      const precioEl = document.getElementById(id + 'precio');

      const concepto = (conceptoEl?.value ?? '').trim();
      const cantidad = Math.max(1, toNum(cantidadEl?.value ?? 1));
      const precioCapturado = Math.max(0, toNum(precioEl?.value ?? 0)); // **TOTAL de la línea con IVA**

      // Si pasas clave SAT como data-*
      const claveSat = (btn && btn.dataset && btn.dataset.clave_sat) ? btn.dataset.clave_sat : null;

      // Guarda la línea
      window.conceptosFactura.push({
        id,
        concepto,
        cantidad,
        precio: precioCapturado, // total con IVA
        aplicaIva: ivaPct === 16, // true si botón "Agregar", false si "Tasa 0"
        claveSat
      });

      renderTablaFactura();
    }

    // ====== Quitar concepto ======
    function eliminarConcepto(idx) {
      idx = Number(idx);
      if (Number.isNaN(idx)) return;
      if (idx < 0 || idx >= window.conceptosFactura.length) return;

      window.conceptosFactura.splice(idx, 1);
      renderTablaFactura();
    }
    window.eliminarConcepto = eliminarConcepto; // expone al onclick inline

    // ====== Recalcular al cambiar retención ======
    document.addEventListener('DOMContentLoaded', function() {
      const sel = document.getElementById('retencion_transporte');
      if (sel) sel.addEventListener('change', renderTablaFactura);
    });
  </script>

  <script>
    // Asegura el arreglo global (no lo pisa si ya existe)
    window.conceptosFactura = window.conceptosFactura || [];

    /**
     * Elimina el concepto por índice y recalcula totales.
     * Usada por: onclick="eliminarConcepto(IDX)"
     */
    function eliminarConcepto(idx) {
      idx = Number(idx);
      if (Number.isNaN(idx)) return;
      if (idx < 0 || idx >= window.conceptosFactura.length) return;

      window.conceptosFactura.splice(idx, 1);

      // Redibuja tabla y totales
      if (typeof renderTablaFactura === 'function') {
        renderTablaFactura();
      }
    }

    // Exponer explícitamente en el scope global para el onclick inline
    window.eliminarConcepto = eliminarConcepto;
  </script>


</body>

</html>