<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Bancos</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <?php
    session_start();
    include_once('api/adminFacturas.php');
    $adminFacturas = new AdministradorFormasPago();
    if (isset($_GET['busqueda'])) {
      $facturas = $adminFacturas->dameFacturasBusqueda($_GET['busqueda']);
    } else if (isset($_GET['not'])) {
      $facturas = $adminFacturas->dameFacturasSinTimbrar();
    } else if (isset($_GET['inicio'])) {
      $facturas = $adminFacturas->dameFacturasPeriodo($_GET['inicio'], $_GET['fin']);
    } else {
      $facturas = $adminFacturas->dameFacturas();
    }

    function fechaComoCadenaFacturas($fecha)
    {
      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);

      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case  "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }

    ?>
    <div class="am-pagebody">
      <div class="card pd-20 pd-sm-40">
        <div class="d-flex justify-content-between align-items-center">
          <h6 class="card-body-title">Bancos de empresas</h6>
          <div class="btn-group" role="group" aria-label="Basic example">
            <button type="button" class="btn btn-secondary pd-x-25 active">General Settings</button>
            <button type="button" class="btn btn-secondary pd-x-25">Privacy Settings</button>
            <button type="button" class="btn btn-secondary pd-x-25">Account Settings</button>
          </div>
        </div>
        <p class="mg-b-20 mg-sm-b-30">Lista de bancos de las empresas.</p>
        <div class="table-wrapper">
          <table id="datatable" class="table display responsive nowrap">
            <thead>
              <tr>
                <th scope="col">
                  <input type="checkbox" id="chkAll" onchange="toggleAll(this)">
                </th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID Factura</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Folio Interno</th>


                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Método de Pago</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Forma de Pago</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>



                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Cliente</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC</th>
                <?php

                if (($sessionTipoUser == 'administrador' || $sessionTipoUser == 'administrador_b')) {

                ?>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Usuario Crea</th>
                <?php

                }

                ?>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Descarga</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" hidden>FFF</th>

              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($facturas as $factura) {
                $classEliminadas = '';
                if ($factura->status == 'CAPDEL') {
                  $classEliminadas = ' background-color: red;';
                }

                echo '<tr style="height: 100px;' . $classEliminadas . '">';
                /* NUEVA CELDA checkbox */
                echo '<td><input type="checkbox" class="factura-select" value="' . $factura->id . '" onchange="toggleFactura(this)"></td>';

                echo '<td  onclick="detonarModal(' . $factura->id . ', ' . "'" . $factura->token . "'" .  ',' . "'" . $factura->uuid . "'" . ')">' . $factura->id . '</td>';
                if ($factura->cuadrado == 1) {
              ?>
                  <td style="position: relative;">
                    <?php echo $factura->folio . "-" . $factura->serie; ?>

                    <a href="fac-factura-ia.php?id=<?php echo $factura->id ?>" target="_blank"> <i class="fas fa-robot" style="position: absolute; top: -5px; right: -5px; color: #17a2b8;"></i></a>
                  </td>

              <?php


                } else if ($factura->cuadrado == 99) {
                  //significa que esta en proceso
                  echo '<td style="position: relative;">' . $factura->folio . "-" . $factura->serie . ' <i class="fas fa-spinner" style="position: absolute; top: -5px; right: -5px; color: orange;"></i></td>';
                } else if ($factura->cuadrado == 2) {
                  //significa que fallo
                  echo '<td style="position: relative;">' . $factura->folio . "-" . $factura->serie . ' <i class="fas fa-times-circle" style="position: absolute; top: -5px; right: -5px; color: red;"></i></td>';
                } else {
                  echo '<td>' . $factura->folio . "-" . $factura->serie . '</td>';
                }


                echo '<td>' . $factura->metodo_pago_nombre . '</td>';
                echo '<td>' . $factura->forma_pago_nombre . '</td>';
                echo '<td>' . $factura->empresa_nombre . '</td>';
                echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                echo '<td>' . $factura->cliente . '</td>';
                echo '<td>' . $factura->fecha_timbrado . '</td>';
                echo '<td>' . $factura->uuid . '</td>';
                echo '<td>' . $factura->empresa_rfc . '</td>';
                if (($sessionTipoUser == 'administrador' || $sessionTipoUser == 'administrador_b')) {



                  echo '<td> <p style="font-weight: bold;">CREO:</p> ' . $factura->usuario_crea . ' <br><p style="font-weight: bold;">TIMBRO:</p> ' . $factura->usuarioTimbraNombre . '</td>';
                }
                echo '<td>
                                    <a href="https://sistema14.com/api/genera_factura.php?token=' . $factura->token . '&per=' . $factura->id . '" download class="inline-flex items-center px-4 py-2 bg-blue-600 text-black text-sm font-medium rounded-lg hover:bg-blue-700 transition-colors">
                                        Descargar PDF
                                    </a>
                                                                            </td>';
                echo '<td hidden>' . fechaComoCadenaFacturas($factura->fecha_timbrado)  . '</td>';
                echo '</tr>';
                $classEliminadas = '';
              }

              ?>
            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>

  <script>
    $(document).ready(function() {
      $('#datatable').DataTable({
        responsive: true, // tabla adaptable
        pageLength: 10, // número de registros por página
        lengthMenu: [5, 10, 25, 50, 100],
        language: {
          url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-MX.json" // Español México
        }
      });
    });
  </script>
</body>

</html>