<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php include_once 'api/adminClientes.php';

    $adminClinetes = new AdministradorClientes();

    $clientes = $adminClinetes->dameClientes();


    include_once('api/adminGrupos.php');
    include_once('api/adminUtil.php');
    include_once('api/encriptador.php');
    include_once 'api/adminEmpresas.php';
    include_once 'api/doxeador.php';

    $adminUtil = new AdministradorUtil();
    $adminClientes = new AdministradorClientes();
    $adminEmpresas = new AdminEmpresas();
    $empresas = $adminEmpresas->dameEmpresasLite();
    $tipo_cambio =  $adminUtil->dameUltimoTipoCambio()->tipo_cambio;
    $ultimos_tipos_cambio = $adminUtil->dameUltimos5TiposCambio();
    $clientes = $adminClientes->dameClientesAdministrador();
    $token = $_SESSION['token_autoriza'];
    $doxeo = dameDoxeo();

    //acortar a 20 caracteres 
    $token = substr($token, 0, 20);
    $token = $token . "...";
    $tokenInfo = desencriptar($_SESSION['token_autoriza']);
    $tokenInfo = explode(",", $tokenInfo);
    $idUsuario = $tokenInfo[0];
    $nombreUsuario = $tokenInfo[1];
    $fecha = $tokenInfo[2];
    $hora = $tokenInfo[3];
    $fechaToken = $fecha . " " . $hora;

    //aumentar una hora y media 

    $fechaToken = strtotime('+30 minutes', strtotime($fechaToken));

    $fechaActual = date("Y-m-d H:i:s");
    $fechaTokenFormato = date("d-m-Y H:i:s", $fechaToken);
    //comparar 
    $diferencia = strtotime($fechaActual) - strtotime($fechaTokenFormato);
    if ($diferencia > 0) {
      $_SESSION['token_autoriza'] = null;
      $_SESSION['id_banca_autoriza'] = null;
      $_SESSION['nombre_banca_autoriza'] = null;
      $token = null;
    }

    ?>
    <?php
    $internos = $adminUtil->dameSaldoInternos();
    if ($internos == 0) {
      $mensajeInternos = "Sin operaciones pendientes";
    } else {
      $mensajeInternos = "Operaciones pendientes";
    }

    ?>

    <?php
    $diferencias = $adminUtil->dameDiferenciasDeSaldo();
    $diferenciaDelment = $adminUtil->dameDiferenciasDeSaldoZac();







    $diferenciaEnclenci = $adminUtil->dameDiferenciasDeSaldoEnclenci();
    $diferenciaWk  = $adminUtil->dameDiferenciasDeSaldoWk();
    $diferenciaToki = $adminUtil->dameDiferenciasDeSaldoTokidoki();
    $diferenciaRedondeada = round($diferencias, 2);
    $ultimaDiferencia = $adminUtil->dameUltimaDiferencia();
    $fechaUltima = $ultimaDiferencia->fecha;
    // Crear un objeto DateTime
    $fecha_obj = new DateTime($fechaUltima);

    // Aumentar la hora en 1
    $fecha_obj->modify('+1 hour');

    // Obtener la nueva fecha
    $fechaUltima = $fecha_obj->format('Y-m-d H:i:s');

    $fechaUltima = explode(" ", $fechaUltima);
    $fechaU = $fechaUltima[0];
    $horaU = $fechaUltima[1];

    if ($fechaU == date("Y-m-d")) {
      $diaU = "HOY";
    } else {
      $diaU = $fechaU;
    }

    //aumentar una hora 

    if ($diferenciaRedondeada != 0) {
      $claseDif = "animate-flicker";
    } else {
      $claseDif = "";
    }

    ?>
    <div class="am-pagebody">
      <div class="row row-sm">
        <div class="col-lg-4">
          <div class="card">
            <div class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">Saldos internos</h6>
                  <p class="tx-12"><?= $mensajeInternos ?></p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$<?= number_format($internos, 2) ?></h2>
              <p class="tx-12 mg-b-0">Ir a saldos internos.</p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
        <div class="col-lg-4 mg-t-15 mg-sm-t-20 mg-lg-t-0">
          <div class="card">
            <div class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">Movimientos pendientes</h6>
                  <p class="tx-12">Cantidad: <?= $adminUtil->cuentaMovimientosPendientes() ?></p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$<?= number_format(($adminUtil->dameMovimientosPedientes() - 1394712), 2) ?></h2>
              <p class="tx-12 mg-b-0">Ir a asignaciones.</p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
        <div class="col-lg-4 mg-t-15 mg-sm-t-20 mg-lg-t-0">
          <div class="card">
            <div class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">Diferencia de saldos</h6>
                  <p class="tx-12">Ultima diferencia conocida: <?=$diaU . " " . $horaU?></p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$ <?=number_format($diferencias, 2)?></h2>
              <p class="tx-12 mg-b-0">Ir a reporte de diferencias.</p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
      </div><!-- row -->
      <br>



      <div class="row row-sm">
        <div class="col-lg-4">
          <div class="card">
            <div id="rs1" class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">STP Kulindra</h6>
                  <p class="tx-12">Movimientos pendientes: 0</p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$<?=number_format($adminUtil->dameSaldosStpKulindra(), 2)?></h2>
              <p class="tx-12 mg-b-0">Diferencia $<?=number_format($adminUtil->dameDiferenciasDeSaldoKul(), 2)?></p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
        <div class="col-lg-4 mg-t-15 mg-sm-t-20 mg-lg-t-0">
          <div class="card">
            <div id="rs2" class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">STP Tokidoki</h6>
                  <p class="tx-12">Movimientos pendientes: 0</p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$<?=number_format($adminUtil->dameSaldosStpTo(), 2)?></h2>
              <p class="tx-12 mg-b-0">$<?= number_format($diferenciaToki-411, 2)?></p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
        <div class="col-lg-4 mg-t-15 mg-sm-t-20 mg-lg-t-0">
          <div class="card">
            <div id="rs3" class="wd-100p ht-200"></div>
            <div class="overlay-body pd-x-20 pd-t-20">
              <div class="d-flex justify-content-between">
                <div>
                  <h6 class="tx-12 tx-uppercase tx-inverse tx-bold mg-b-5">Proximo STP</h6>
                  <p class="tx-12">Movimientos pendientes: NA</p>
                </div>
                <a href="" class="tx-gray-600 hover-info"><i class="icon ion-more tx-16 lh-0"></i></a>
              </div><!-- d-flex -->
              <h2 class="mg-b-5 tx-inverse tx-lato">$0.00</h2>
              <p class="tx-12 mg-b-0">Diferencia NA.</p>
            </div>
          </div><!-- card -->
        </div><!-- col-4 -->
      </div><!-- row -->



      <div class="row row-sm mg-t-15 mg-sm-t-20">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-header bg-transparent pd-20">
              <h6 class="card-title tx-uppercase tx-12 mg-b-0">Carteras de clientes</h6>
            </div><!-- card-header -->
            <div class="table-responsive">
              <table class="table table-white mg-b-0 tx-12">
                <tbody>

                  <?php
                  foreach ($clientes as $cliente) {
                    $saldos = $adminClinetes->dameSaldosPorCliente($cliente->id);
                  ?>

                    <tr>
                      <td class="pd-l-20 tx-center">
                        <img src="<?= $cliente->imagen ?>"
                          alt="Image"
                          style="width:36px; height:36px; border-radius:50%; object-fit:cover;">
                      </td>
                      <td>
                        <a href="" class="tx-inverse tx-14 tx-medium d-block"><?= $cliente->nombre ?></a>
                        <span class="tx-11 d-block">$ <?= number_format($saldos[0]->saldoss, 2)  ?></span>
                      </td>
                      <td class="tx-12">
                        <span class="square-8 bg-success mg-r-5 rounded-circle"></span> Mov Pendientes : <?= number_format($saldos[0]->movimientos_pend) ?>
                      </td>
                      <td class="tx-center">
                        <div class="btn-group" role="group">
                          <!-- Botón actualizar -->
                          <button type="button" class="btn btn-sm btn-outline-primary" title="Actualizar saldo">
                            <i class="fas fa-sync-alt"></i>
                          </button>
                          <!-- Botón configuraciones -->
                          <button type="button" class="btn btn-sm btn-outline-secondary" title="Configurar cartera">
                            <i class="fas fa-cog"></i>
                          </button>
                          <!-- Botón modificar -->
                          <button type="button" class="btn btn-sm btn-outline-info" title="Ir a cartera">
                            <i class="fas fa-edit"></i>
                          </button>
                        </div>
                      </td>
                    </tr>

                  <?php } ?>

                </tbody>
              </table>
            </div><!-- table-responsive -->

          </div><!-- card -->
        </div><!-- col-8 -->

      </div><!-- row -->

    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>
</body>

</html>