<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>
  <style>
    .float {
      position: fixed;
      width: 60px;
      height: 60px;
      bottom: 40px;
      right: 40px;
      background-color: orange;
      color: #FFF;
      border-radius: 50px;
      text-align: center;
      box-shadow: 2px 2px 3px #999;
      cursor: pointer;
      z-index: 999;
    }

    .my-float {
      margin-top: 15px;
      margin-left: 16px;
    }

    input,
    textarea,
    select {
      -webkit-appearance: none;
      appearance: none;
    }
  </style>
  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
    <?php
    include_once('api/adminPagos.php');
    include_once('api/adminClientes.php');

    $adminPagos = new AdministradorPagos();
    $adminClientes  = new AdministradorClientes();
    $pagosSinAsingar = $adminPagos->damePagosSinAsignar();
    $clientes = $adminClientes->dameClientes();

    function fechaComoCadenaNoAsig($fecha)
    {
      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);
      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }
    ?>
    <div class="am-pagebody">
      <div class="row row-sm">
        <div class="col-12">
          <div class="card mg-t-20">
            <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
              <div class="d-flex align-items-center">
                <button onclick="tomarModificados()" class="btn btn-primary btn-sm d-flex align-items-center mr-2">
                  <!-- icon disquete -->
                  <svg style="width:15px;height:15px;margin-right:6px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1250 1280">
                    <g fill="#ffffff">
                      <path d="M0 0h6250 6250v5368L11453 6768 10406 7801H5204 1V0z m9390 9955V8020H6250 3110v1935 1935h3140 3140V9955z m1370-6450V2450H3750  -760v2455 2455h4510 4510V3505z" />
                      <path d="M7210 8750V7545h695 695V8750 9955H7905 7210V8750z" />
                    </g>
                  </svg>
                  Guardar
                </button>
                <h6 class="mg-b-0">Asignación de movimientos</h6>
              </div>

              <!-- Buscador opcional -->
              <div class="input-group input-group-sm" style="max-width:320px;">
                <input type="text" id="mySearch" class="form-control" placeholder="Buscar...">
                <div class="input-group-append">
                  <button class="btn btn-outline-primary" type="button" onclick="busquedaGeneral()">Buscar</button>
                </div>
              </div>
            </div>

            <div class="card-body">
              <div class="table-responsive">
                <table id="tableStripe" class="table table-striped table-hover table-bordered">
                  <thead class="thead-dark">
                    <tr>
                      <th>ID</th>
                      <th>Empresa</th>
                      <th>Nombre Corto</th>
                      <th>Banco</th>
                      <th hidden>montoS</th>
                      <th>Monto</th>
                      <th>Tipo de Movimiento</th>
                      <th>Descripción</th>
                      <th>Descripción Detallada</th>
                      <th>Fecha de banco</th>
                      <th hidden>Fecha de banco (raw)</th>
                      <th style="width: 240px;">Acciones</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($pagosSinAsingar as $pago): ?>
                      <?php
                      if ($pago->id == 212733) {
                        continue;
                      }
                      if (in_array($pago->monto, [7.5, 2.88, 8, 1.28, 1.2, 0.8, 5])) {
                        continue;
                      }
                      $fecha_banco = ($pago->fecha_banco == "" || $pago->fecha_banco == null) ? $pago->fecha_operacion : $pago->fecha_banco;
                      ?>
                      <tr id="fila_<?php echo $pago->id; ?>">
                        <td><?php echo $pago->id; ?></td>
                        <td><?php echo $pago->empresa; ?></td>
                        <td><?php echo $pago->nombre_corto; ?></td>
                        <td><?php echo $pago->banco; ?></td>
                        <td hidden><?php echo $pago->monto; ?></td>
                        <td>$<?php echo number_format($pago->monto, 2); ?></td>
                        <td><?php echo $pago->tipo_movimiento; ?></td>
                        <td><?php echo $pago->descripcion; ?></td>
                        <td><?php echo $pago->descripcion_detallada; ?></td>
                        <td><?php echo fechaComoCadenaNoAsig($fecha_banco); ?></td>
                        <td hidden><?php echo $pago->fecha_banco; ?></td>
                        <td class="text-center">
                          <div class="mb-1 font-weight-bold">Clientes</div>
                          <select class="form-control form-control-sm nice-select2"
                            id="pago_<?php echo $pago->id; ?>"
                            onchange="asignarModificados(<?php echo $pago->id; ?>)">
                            <option value="0">Sin asignar</option>
                            <?php foreach ($clientes as $cliente): ?>
                              <option value="<?php echo $cliente->id; ?>"><?php echo $cliente->nombre; ?></option>
                            <?php endforeach; ?>
                          </select>
                        </td>
                      </tr>
                      <script>
                        window.camposSinMod = (window.camposSinMod || []);
                        window.camposSinMod.push(<?php echo $pago->id; ?>);
                      </script>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            </div>

          </div>
        </div>
      </div>







    </div><!-- am-pagebody -->

    <a onclick="tomarModificados()" class="float" title="Guardar asignaciones">
      <svg class="my-float" xmlns="http://www.w3.org/2000/svg" fill="#000000" viewBox="0 0 407.096 407.096" width="30" height="30">
        <g>
          <g>
            <path d="M402.115,84.008L323.088,4.981C319.899,1.792,315.574,0,311.063,0H17.005C7.613,0,0,7.614,0,17.005v373.086
      c0,9.392,7.613,17.005,17.005,17.005h373.086c9.392,0,17.005-7.613,17.005-17.005V96.032
      C407.096,91.523,405.305,87.197,402.115,84.008z M300.664,163.567H67.129V38.862h233.535V163.567z" />
            <path d="M214.051,148.16h43.08c3.131,0,5.668-2.538,5.668-5.669V59.584c0-3.13-2.537-5.668-5.668-5.668h-43.08
      c-3.131,0-5.668,2.538-5.668,5.668v82.907C208.383,145.622,210.92,148.16,214.051,148.16z" />
          </g>
        </g>
      </svg>
    </a>


    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Nice Select 2 (vanilla) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/nice-select2@2.1.0/dist/css/nice-select2.css">
  <script src="https://cdn.jsdelivr.net/npm/nice-select2@2.1.0/dist/js/nice-select2.js"></script>

  <script>
    // Estado en memoria
    var modificados = [];
    var modificadosEnvio = [];
    var camposSinMod = window.camposSinMod || [];

    class Modificados {
      constructor(id, idCliente) {
        this.id = id;
        this.idCliente = idCliente;
      }
    }

    // Inicializar selects bonitos
    document.addEventListener('DOMContentLoaded', function() {
      document.querySelectorAll('.nice-select2').forEach(function(sel) {
        try {
          NiceSelect.bind(sel, {
            searchable: true
          });
        } catch (e) {}
      });
    });

    // Marcar como modificado
    function asignarModificados(id) {
      if (!modificados.includes(id)) modificados.push(id);
      // Opcional: feedback visual
      const row = document.getElementById('fila_' + id);
      if (row) row.classList.add('table-warning');
    }

    // Reset masivo
    function reiniciarTodosLosCampos() {
      for (var i = 0; i < camposSinMod.length; i++) {
        var id = camposSinMod[i];
        var el = document.getElementById("pago_" + id);
        if (el) {
          el.value = 0;
          // si usas nice-select2:
          el.dispatchEvent(new Event('change'));
        }
      }
      modificados = [];
      modificadosEnvio = [];
      document.querySelectorAll('tr.table-warning').forEach(tr => tr.classList.remove('table-warning'));
    }

    // Guardar asignaciones
    function tomarModificados() {
      if (modificados.length === 0) {
        Swal.fire('Sin cambios', 'No hay movimientos seleccionados para asignar.', 'info');
        return;
      }

      const datosPagos = new FormData();
      for (var i = 0; i < modificados.length; i++) {
        var id = modificados[i];
        var el = document.getElementById("pago_" + id);
        var idCliente = el ? el.value : 0;
        datosPagos.append('cliente[]', idCliente);
        datosPagos.append('id_registro[]', id);
      }
      datosPagos.append("accion", "asignarPagos");

      fetch("api/apiPagosT.php", {
          method: "POST",
          body: datosPagos,
        })
        .then((respuesta) => respuesta.json())
        .then((data) => {
          Swal.fire(
            (data?.[0]?.estatus) || 'Éxito',
            (data?.[0]?.mensaje) || 'Asignaciones guardadas.',
            (data?.[0]?.subMensaje) || ''
          );

          // Remover filas asignadas
          for (var i = 0; i < modificados.length; i++) {
            var id = modificados[i];
            var fila = document.getElementById("fila_" + id);
            if (fila) fila.remove();
          }
          modificados = [];
        })
        .catch((err) => {
          console.error(err);
          Swal.fire('Error', 'No se pudo guardar la asignación.', 'error');
        });
    }

    // Búsqueda
    function busquedaGeneral() {
      var valor = document.getElementById("mySearch")?.value || '';
      window.location.href = "mov-movimientos-asignados-c.php?busqueda=" + encodeURIComponent(valor);
    }
  </script>




</body>

</html>