<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/rickshaw/rickshaw.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>
   
    <div class="am-pagebody">
<?php
include_once('api/adminPagos.php');
include_once('api/encriptador.php');

$adminPagos = new AdministradorPagos();
$pagosStp = $adminPagos->dameMovimientosStp();

function fechaComoCadenaStp($fecha) {
    $dia = substr($fecha, 8, 2);
    $mes = substr($fecha, 5, 2);
    $anio = substr($fecha, 0, 4);
    switch ($mes) {
        case "01": $mes = 'Enero'; break;
        case "02": $mes = 'Febrero'; break;
        case "03": $mes = 'Marzo'; break;
        case "04": $mes = 'Abril'; break;
        case "05": $mes = 'Mayo'; break;
        case "06": $mes = 'Junio'; break;
        case "07": $mes = 'Julio'; break;
        case "08": $mes = 'Agosto'; break;
        case "09": $mes = 'Septiembre'; break;
        case "10": $mes = 'Octubre'; break;
        case "11": $mes = 'Noviembre'; break;
        case "12": $mes = 'Diciembre'; break;
        default: $mes = "NA"; $dia = "NA"; $anio = "NA";
    }
    return $dia . '/' . $mes . '/' . $anio;
}

function addHora($hora) {
    return date('H:i:s', strtotime($hora) + 3600);
}
?>
<div class="col-12">
  <div class="card mg-t-20">
    <div class="card-header d-flex align-items-center justify-content-between flex-wrap">
      <h6 class="mg-b-0">Movimientos STP</h6>
    </div>

    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-striped table-hover table-bordered">
          <thead class="thead-dark">
            <tr>
              <th>ID</th>
              <th>Cliente</th>
              <th>Nombre</th>
              <th>Número</th>
              <th>Folio</th>
              <th class="text-right">Monto</th>
              <th>Fecha creación</th>
              <th>Hora creación</th>
              <th>Status</th>
              <th>Estado</th>
              <th>Error Interno</th>
              <th>Comprobante enviado</th>
              <th>Comprobante</th>
              <th hidden>monto_raw</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($pagosStp as $pago) { 
              $fechaPartes = explode(' ', $pago->fecha_creacion);
              $fechaStr = isset($fechaPartes[0]) ? $fechaPartes[0] : '';
              $horaStr  = isset($fechaPartes[1]) ? $fechaPartes[1] : '00:00:00';
              $numero   = trim((isset($pago->tarjeta)?$pago->tarjeta:'') . (isset($pago->clabe)?$pago->clabe:''));
              $notificado = (intval($pago->status_notificado) === 1) ? 'SI' : 'NO';
              $errorInterno = trim((isset($pago->status_pre)?$pago->status_pre:'') . ' ' . (isset($pago->causa_devolucion)?$pago->causa_devolucion:''));
              ?>
              <tr>
                <td><?php echo $pago->id; ?></td>
                <td><?php echo $pago->cliente; ?></td>
                <td><?php echo $pago->nombre; ?></td>
                <td><?php echo $numero; ?></td>
                <td><?php echo $pago->folio; ?></td>
                <td class="text-right">$ <?php echo number_format($pago->monto, 2); ?></td>
                <td><?php echo $fechaStr; ?></td>
                <td><?php echo addHora($horaStr); ?></td>

                <td>
                  <?php if (strtoupper($pago->status) === 'EXITOSO') { ?>
                    <span class="badge badge-success">EXITOSO</span>
                  <?php } elseif (strtoupper($pago->status) === 'PENDIENTE') { ?>
                    <span class="badge badge-warning">PENDIENTE</span>
                  <?php } else { ?>
                    <span class="badge badge-secondary"><?php echo $pago->status; ?></span>
                  <?php } ?>
                </td>

                <td>
                  <?php if (strtoupper($pago->estado) === 'LIQUIDADO') { ?>
                    <span class="badge badge-primary">LIQUIDADO</span>
                  <?php } elseif (strtoupper($pago->estado) === 'DEVUELTO') { ?>
                    <span class="badge badge-danger">DEVUELTO</span>
                  <?php } else { ?>
                    <span class="badge badge-info"><?php echo $pago->estado; ?></span>
                  <?php } ?>
                </td>

                <td><?php echo $errorInterno; ?></td>
                <td>
                  <?php if ($notificado === 'SI') { ?>
                    <span class="badge badge-success">SI</span>
                  <?php } else { ?>
                    <span class="badge badge-danger">NO</span>
                  <?php } ?>
                </td>

                <td>
                  <?php if (!empty($pago->cep) && $pago->cep !== 'null') { ?>
                    <div class="btn-group btn-group-sm" role="group">
                      <a href="<?php echo $pago->cep; ?>" target="_blank" class="btn btn-dark" title="Ver CEP">
                        CEP
                      </a>
                      <a href="https://old.sistema14.com/gen_cep_pdf-directo.php?pago=<?php echo encriptar($pago->id); ?>"
                         target="_blank" class="btn btn-secondary" title="Generar PDF S14">
                        S14
                      </a>
                    </div>
                  <?php } else { 
                    if (strtoupper($pago->estado) === 'LIQUIDADO') { ?>
                      <span class="text-warning">EN ESPERA</span>
                    <?php } else { ?>
                      <span class="text-muted">NO DISPONIBLE</span>
                    <?php } 
                  } ?>
                </td>

                <td hidden><?php echo $pago->monto; ?></td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
</div>








    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->

  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/d3/d3.js"></script>
  <script src="../lib/rickshaw/rickshaw.min.js"></script>
  <script src="http://maps.google.com/maps/api/js?key=AIzaSyAEt_DBLTknLexNbTVwbXyq2HSf2UbRBU8"></script>
  <script src="../lib/gmaps/gmaps.js"></script>
  <script src="../lib/Flot/jquery.flot.js"></script>
  <script src="../lib/Flot/jquery.flot.pie.js"></script>
  <script src="../lib/Flot/jquery.flot.resize.js"></script>
  <script src="../lib/flot-spline/jquery.flot.spline.js"></script>

  <script src="../js/amanda.js"></script>
  <script src="../js/ResizeSensor.js"></script>
  <script src="../js/dashboard.js"></script>

  <!-- SweetAlert2 (añádelo debajo de tus otros <script> ya existentes) -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script>
    function desasignar(id) {
      Swal.fire({
        title: '¿Desea des-asignar el movimiento?',
        text: 'Se desasignará y quedará como no asignado.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Des-asignar',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
          const datos = new FormData();
          datos.append('accion', 'desasignarMovimiento');
          datos.append('id', id);

          fetch('api/apiPagosT.php', {
              method: 'POST',
              body: datos
            })
            .then(resp => resp.json())
            .then(data => {
              // Esperando estructura: [{ estatus, mensaje, subMensaje }]
              Swal.fire(
                data?.[0]?.estatus || 'Hecho',
                data?.[0]?.mensaje || 'Movimiento des-asignado',
                data?.[0]?.subMensaje || ''
              );

              // Remueve la fila en la tabla
              const fila = document.getElementById('row' + id);
              if (fila) fila.remove();
            })
            .catch(err => {
              console.error(err);
              Swal.fire('Error', 'No se pudo des-asignar el movimiento.', 'error');
            });
        }
      });
    }

    function busquedaGeneral() {
      const valor = document.getElementById('mySearch')?.value || '';
      window.location.href = 'mov-movimientos-asignados-c.php?busqueda=' + encodeURIComponent(valor);
    }
  </script>




</body>

</html>