<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Reporte Conta14 Interno</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    include_once "api/adminProveedores.php";
    include_once "api/adminEmpresas.php";

    $adminProveedores = new AdministradorProveedores();
    $adminEmpresas = new AdminEmpresas();
    $empresas = $adminEmpresas->dameEmpresasLite();

    ?>

    <div class="am-pagebody">

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Reporte conta 14</h6>
        <p class="mg-b-20 mg-sm-b-30">Reporte de relaciones entre facturas y pagos de sistema 14.</p>



        <?php
        foreach ($empresas as $empresa) {

          $totalEmpresa = $adminProveedores->dameSumaReporte($empresa->rfc);
          $unoPorciento = 100 / $totalEmpresa;
          $unoPorCientoToal = $totalEmpresa * 0.01;
          $reporteArray = $adminProveedores->dameReporte($empresa->rfc);
          $cantidadProveedoresErroresAux = 0;
          $totalFallo = 0;
          foreach ($reporteArray as $r) {
            $proveedor = $adminProveedores->dameProveedorE($r->id_empresa, $r->id_clave);
            $treintaPorciento = $proveedor->porcentaje_sugerido / 100;
            $treintaPorciento = $treintaPorciento * 30;
            $rangoMenor = $proveedor->porcentaje_sugerido - $treintaPorciento;
            $rangoMayor = $proveedor->porcentaje_sugerido + $treintaPorciento;
            $porcentajeTotal = $r->total * $unoPorciento;



            if (($porcentajeTotal) < $rangoMenor || ($porcentajeTotal) > $rangoMayor) {
              $cantidadProveedoresErroresAux++;
              if ($porcentajeTotal < $rangoMenor) {
                $totalDesvio = $porcentajeTotal;
              } else {
                $totalDesvio = $porcentajeTotal;
              }
              $totalFallo +=  abs($totalDesvio);

              $color = "color: red;";
            }
          }
          if (count($reporteArray) > 0 && $cantidadProveedoresErroresAux > 0) {
            $cantidadProveedores = count($reporteArray);
            $totalFallo = 0;
            $cantidadProveedoresErrores = 0;
            $sumaFallo = 0;
        ?>


            <div class="panel mt-6">
              <h5 class="mb-5 text-lg font-semibold dark:text-white-light md:absolute md:top-[25px] md:mb-0"><?php echo $empresa->razon ?></h5>
              <br><br><br>
              <table id="tableStripe" class="table-striped">
                <thead>
                  <td>Proveedor</td>
                  <td>Porcentaje de desvío</td>
                  <td>Rangos aceptables</td>
                </thead>

                <script>
                  var proveedores = [];
                  var porcentajes = [];
                  var porcentajesIdeal = [];
                  var idealInferior = [];
                  var idealSuperior = [];
                </script>
                <?php


                foreach ($reporteArray as $r) {

                  $proveedor = $adminProveedores->dameProveedorE($r->id_empresa, $r->id_clave);
                  $treintaPorciento = $proveedor->porcentaje_sugerido / 100;
                  $treintaPorciento = $treintaPorciento * 30;
                  $rangoMenor = $proveedor->porcentaje_sugerido - $treintaPorciento;
                  $rangoMayor = $proveedor->porcentaje_sugerido + $treintaPorciento;
                  $porcentajeTotal = $r->total * $unoPorciento;



                  $cantidadProveedoresErrores++;
                  if ($porcentajeTotal < $rangoMenor) {

                    $totalDesvio = $porcentajeTotal;
                    $color = "color: red;";
                    $sumaFallo += abs($totalDesvio);
                  } else {
                    $totalDesvio = $porcentajeTotal;
                    $color = "color: black;";
                    $sumaFallo += abs($totalDesvio);
                  }
                  $totalFallo +=  abs($totalDesvio);

                  // $color = "color: red;";
                  if ($r->total > 0 && abs(number_format($totalDesvio, 2)) > 0) {
                    echo  "<tr>";
                    echo  "<td>" . $r->razon_social . "</td>";
                    echo  "<td style='" . $color . "'> " . number_format(abs($totalDesvio), 2) . "%</td>";
                    echo  "<td>" . number_format($rangoMenor, 2) . "% - " . number_format($rangoMayor, 2) . "%</td>";

                    echo  "</tr>";
                  }

                  echo "<script>proveedores.push('" . $r->razon_social . "');</script>";
                  echo "<script>porcentajes.push('" . ($r->total * $unoPorciento) . "');</script>";
                  echo "<script>porcentajesIdeal.push('" . ($proveedor->porcentaje_sugerido) . "');</script>";
                  echo "<script>idealInferior.push('" . ($rangoMenor) . "');</script>";
                  echo "<script>idealSuperior.push('" . ($rangoMayor) . "');</script>";
                }


                $color = "color: red;";
                $promedioFallo = $totalFallo / $cantidadProveedores;

                echo "<tr>";
                echo "<td style='font-weight: bold;'>TOTAL (" . $cantidadProveedores . " proveedores promediados " . $cantidadProveedoresErrores . " con errores)  </td>";
                echo "<td style='" . $color . " font-weight: bold;'> " . number_format($sumaFallo, 2) . "%</td>";

                echo "</tr>";

                ?>

              </table>



              <div id="chart<?php echo $empresa->id ?>">

              </div>







            </div>


        <?php }
        } ?>




      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>