<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta property="og:image" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:secure_url" content="http://themepixels.me/amanda/img/amanda-social.png">
  <meta property="og:image:type" content="image/png">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="600">
  <!-- Meta -->
  <meta name="description" content="Sistema 14.">
  <meta name="author" content="Edworld & Skll">
  <title>Sistema 14 Facturas eliminadas</title>
  <!-- vendor css -->
  <link href="../lib/font-awesome/css/font-awesome.css" rel="stylesheet">
  <link href="../lib/Ionicons/css/ionicons.css" rel="stylesheet">
  <link href="../lib/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet">
  <link href="../lib/jquery-toggles/toggles-full.css" rel="stylesheet">
  <link href="../lib/highlightjs/github.css" rel="stylesheet">
  <link href="../lib/datatables/jquery.dataTables.css" rel="stylesheet">
  <link href="../lib/select2/css/select2.min.css" rel="stylesheet">
  <!-- Amanda CSS -->
  <link rel="stylesheet" href="../css/amanda.css">
</head>

<body>

  <?php include_once 'template/header.php' ?>

  <?php include_once 'template/barra.php' ?>

  <div class="am-mainpanel">

    <?php include_once 'template/buscador.php' ?>

    <?php
    session_start();
    include_once('api/adminFacturas.php');
    $adminFacturas = new AdministradorFormasPago();
    if (isset($_GET['busqueda'])) {
      $facturas = $adminFacturas->dameFacturasBusquedaEliminadas($_GET['busqueda']);
    } else {
      $facturas = $adminFacturas->dameFacturasEliminadasRep();
    }

    function fechaComoCadenaFacturas($fecha)
    {
      $dia = substr($fecha, 8, 2);
      $mes = substr($fecha, 5, 2);
      $anio = substr($fecha, 0, 4);

      switch ($mes) {
        case "01":
          $mes = 'Enero';
          break;
        case "02":
          $mes = 'Febrero';
          break;
        case "03":
          $mes = 'Marzo';
          break;
        case  "04":
          $mes = 'Abril';
          break;
        case "05":
          $mes = 'Mayo';
          break;
        case "06":
          $mes = 'Junio';
          break;
        case "07":
          $mes = 'Julio';
          break;
        case "08":
          $mes = 'Agosto';
          break;
        case "09":
          $mes = 'Septiembre';
          break;
        case "10":
          $mes = 'Octubre';
          break;
        case "11":
          $mes = 'Noviembre';
          break;
        case "12":
          $mes = 'Diciembre';
          break;
        default:
          $mes = "NA";
          $dia = "NA";
          $anio = "NA";
      }
      return $dia . '/' . $mes . '/' . $anio;
    }

    ?>

    <div class="am-pagebody">

      <div class="card pd-20 pd-sm-40">
        <h6 class="card-body-title">Bitácora de sistema</h6>
        <p class="mg-b-20 mg-sm-b-30">Reporte de las ultimas acciones de sistema 14.</p>

        <div class="table-wrapper">
          <table id="datatable1" class="table display responsive nowrap">
            <thead>
              <tr>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID Factura</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Folio Interno</th>


                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Metodo de Pago</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Forma de Pago</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>



                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Cliente</th>

                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC</th>
                <?php

                if (($sessionTipoUser == 'administrador' || $sessionTipoUser == 'administrador_b')) {

                ?>
                  <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Usuario Crea</th>
                <?php

                }

                ?>
                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" hidden>FFF</th>

              </tr>
            </thead>
            <tbody>
              <?php

              foreach ($facturas as $factura) {
                $classEliminadas = '';
                if ($factura->status == 'CAPDEL') {
                  $classEliminadas = ' background-color: red;';
                }

                echo '<tr style="height: 100px;' . $classEliminadas . '">';
                echo '<td>' . $factura->id . '</td>';
                echo '<td>' . $factura->folio . "-" . $factura->serie . '</td>';

                echo '<td>' . $factura->metodo_pago_nombre . '</td>';
                echo '<td>' . $factura->forma_pago_nombre . '</td>';
                echo '<td>' . $factura->empresa_nombre . '</td>';
                echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                echo '<td>' . $factura->cliente . '</td>';
                echo '<td>' . $factura->fecha_timbrado . '</td>';
                echo '<td>' . $factura->uuid . '</td>';
                echo '<td>' . $factura->empresa_rfc . '</td>';
                if (($sessionTipoUser == 'administrador' || $sessionTipoUser == 'administrador_b')) {



                  echo '<td> <p style="font-weight: bold;">CREO:</p> ' . $factura->usuario_crea . ' <br><p style="font-weight: bold;">Elimino:</p> ' . $factura->usuarioTimbraNombre . '</td>';
                }
                echo '<td hidden>' . fechaComoCadenaFacturas($factura->fecha_timbrado)  . '</td>';
                echo '</tr>';
                $classEliminadas = '';
              }

              ?>
            </tbody>
          </table>
        </div><!-- table-wrapper -->
      </div><!-- card -->







    </div><!-- am-pagebody -->
    <?php include_once 'template/footer.php' ?>
  </div><!-- am-mainpanel -->


  <script src="../lib/jquery/jquery.js"></script>
  <script src="../lib/popper.js/popper.js"></script>
  <script src="../lib/bootstrap/bootstrap.js"></script>
  <script src="../lib/perfect-scrollbar/js/perfect-scrollbar.jquery.js"></script>
  <script src="../lib/jquery-toggles/toggles.min.js"></script>
  <script src="../lib/highlightjs/highlight.pack.js"></script>
  <script src="../lib/datatables/jquery.dataTables.js"></script>
  <script src="../lib/datatables-responsive/dataTables.responsive.js"></script>
  <script src="../lib/select2/js/select2.min.js"></script>

  <script src="../js/amanda.js"></script>
  <script>
    $(function() {
      'use strict';

      $('#datatable1').DataTable({
        responsive: true,
        language: {
          searchPlaceholder: 'Search...',
          sSearch: '',
          lengthMenu: '_MENU_ items/page',
        }
      });

      $('#datatable2').DataTable({
        bLengthChange: false,
        searching: false,
        responsive: true
      });

      // Select2
      $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity
      });

    });
  </script>
</body>

</html>