<?php
include_once 'conector.php';

class Documentos
{
    //SELECT id, ruta, fecha_subida, procesado FROM advs_14.documentos;
    public $id;
    public $ruta;
    public $fecha_subida;
    public $procesado;
    public $nombreOriginal;
    public $nombres;
    public $fechas;
    public $numeros;
    public $paginas;
    public $interesados;
}

class DocumentoBuscado
{
    //SELECT id, ruta, fecha_subida, procesado FROM advs_14.documentos;
    public $id;
    public $ruta;
    public $fecha_subida;
    public $ruta_imagen;
    public $nombreOriginal;
    public $nombres;
    public $fechas;
    public $numeros;
}


class InfoConKey
{
    public $fecha_solicita;
    public $ip;
    public $key;
    public $emite;
    public $paginas;
}


class Fecha
{
    //SELECT id, fecha, id_pagina, id_documento FROM advs_14.fechas;
    public $id;
    public $fecha;
    public $id_pagina;
    public $id_documento;
}

class Nombre
{
    //SELECT id, nombre, id_pagina, id_documento FROM advs_14.nombres;
    public $id;
    public $nombre;
    public $id_pagina;
    public $id_documento;
}

class Numero
{
    //SELECT id, numero, id_pagina, id_documento FROM advs_14.numeros;
    public $id;
    public $numero;
    public $id_pagina;
    public $id_documento;
}


class RutaTermporal
{
    //SELECT id, `key`, id_documento, usuario_solicita, fecha_solicita FROM advs_14.rutas_temporales;
    public $id;
    public $key;
    public $id_documento;
    public $usuario_solicita;
    public $fecha_solicita;
}

class Data
{
    //SELECT id, raw_data, ruta_doc, id_documento, procesado, proc_data FROM advs_14.`data`;
    public $id;
    public $raw_data;
    public $ruta_doc;
    public $id_documento;
    public $procesado;
    public $proc_data;
}



class AdministradorDocumentos extends Conector
{
    public function agregarDocumento($ruta, $nombreOriginal)
    {
        $sql = "INSERT INTO documentos (ruta, fecha_subida, procesado, nombre_original) VALUES ('$ruta', NOW(), 0, '$nombreOriginal')";
        // echo $sql;
        $this->ejecutar($sql);
        return $this->dameUltimoId();
    }

    public function agregarData($raw_data, $ruta_doc, $id_documento, $procesado, $proc_data)
    {
        $sql = "INSERT INTO `data` (raw_data, ruta_doc, id_documento, procesado, proc_data) VALUES ('$raw_data', '$ruta_doc', $id_documento, $procesado, '$proc_data')";
        // echo $sql;
        $this->ejecutar($sql);
    }

    public function agregarRutaTemporal($key, $id_documento, $usuario_solicita, $ip)
    {
        $sql = "INSERT INTO rutas_temporales (`key`, id_documento, usuario_solicita, fecha_solicita, ip_em) VALUES ('$key', $id_documento, '$usuario_solicita', NOW(), '$ip')";
        //echo $sql;
        $this->ejecutar($sql);
    }

    public function dameUltimoId()
    {
        $sql = "SELECT MAX(id) as id FROM documentos";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['id'];
    }


    public function marcarProcesado($id)
    {
        $sql = "UPDATE documentos SET procesado = 1 WHERE id = $id";
        $this->ejecutar($sql);
    }

    public function dameNumeros($documento)
    {
        $sql = "SELECT id, numero, id_pagina, id_documento FROM advs_14.numeros WHERE id_documento = $documento";
        $stmt = $this->ejecutar($sql);
        $numeros = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $numero = new Numero();
            $numero->id = $row['id'];
            $numero->numero = $row['numero'];
            $numero->id_pagina = $row['id_pagina'];
            $numero->id_documento = $row['id_documento'];
            $numeros[] = $numero;
        }
        return $numeros;
    }

    public function insertaNumero($numero, $documento, $data)
    {
        $sql = "INSERT INTO numeros (numero, id_pagina, id_documento) VALUES ('$numero', $data, $documento)";
        $this->ejecutar($sql);
    }

    public function dameNombres($documento)
    {
        $sql = "SELECT id, nombre, id_pagina, id_documento FROM advs_14.interesados WHERE id_documento = $documento group by nombre order by id desc";
        $stmt = $this->ejecutar($sql);
        $nombres = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $nombre = new Nombre();
            $nombre->id = $row['id'];
            $nombre->nombre = $row['nombre'];
            $nombre->id_pagina = $row['id_pagina'];
            $nombre->id_documento = $row['id_documento'];
            $nombres[] = $nombre;
        }
        return $nombres;
    }

    public function insertaNombre($nombre, $documento, $data)
    {
        $sql = "INSERT INTO interesados (nombre, id_pagina, id_documento) VALUES ('$nombre', $data, $documento)";
        $this->ejecutar($sql);
    }

    public function limpiaNombres($documento)
    {
        $sql = "DELETE FROM interesados WHERE id_documento = $documento";
        $this->ejecutar($sql);
    }

    public function dameFechas($documento)
    {
        $sql = "SELECT id, fecha, id_pagina, id_documento FROM advs_14.fechas WHERE id_documento = $documento";
        $stmt = $this->ejecutar($sql);
        $fechas = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $fecha = new Fecha();
            $fecha->id = $row['id'];
            $fecha->fecha = $row['fecha'];
            $fecha->id_pagina = $row['id_pagina'];
            $fecha->id_documento = $row['id_documento'];
            $fechas[] = $fecha;
        }
        return $fechas;
    }

    public function insertaFecha($fecha, $documento, $data)
    {
        $sql = "INSERT INTO fechas (fecha, id_pagina, id_documento) VALUES ('$fecha', $data, $documento)";
        $this->ejecutar($sql);
    }

    public function aprovarDocumento($id)
    {
        $sql = "UPDATE documentos SET aprovado = 1 WHERE id = $id";
        $this->ejecutar($sql);
    }

    public function obtenerDocumentos()
    {
        $sql = "SELECT advs_14.documentos.*, 
       COUNT(DISTINCT advs_14.data.id) AS paginas, 
       COUNT(DISTINCT advs_14.interesados.id) AS interesados 
        FROM advs_14.documentos
        LEFT JOIN advs_14.data ON advs_14.documentos.id = advs_14.data.id_documento
        LEFT JOIN advs_14.interesados ON advs_14.documentos.id = advs_14.interesados.id_documento
        GROUP BY advs_14.documentos.id
        ORDER BY advs_14.documentos.id DESC ;";
        $stmt = $this->ejecutar($sql);
        $documentos = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $documento = new Documentos();
            $documento->id = $row['id'];
            $documento->ruta = $row['ruta'];
            $documento->fecha_subida = $row['fecha_subida'];
            $documento->procesado = $row['procesado'];
            $documento->nombreOriginal = $row['nombre_original'];
            $documento->paginas = $row['paginas'];
            $documento->interesados = $row['interesados'];
            $fechas = $this->dameFechas($documento->id);
            $nombres = $this->dameNombres($documento->id);
            $numeros = $this->dameNumeros($documento->id);
            $documento->nombres = $nombres;
            $documento->fechas = $fechas;
            $documento->numeros = $numeros;
            $documentos[] = $documento;
        }
        return $documentos;
    }

    function obtenUltimos5Documentos()
    {
        $sql = "SELECT advs_14.documentos.*, 
       COUNT(DISTINCT advs_14.data.id) AS paginas, 
       COUNT(DISTINCT advs_14.interesados.id) AS interesados 
        FROM advs_14.documentos
        LEFT JOIN advs_14.data ON advs_14.documentos.id = advs_14.data.id_documento
        LEFT JOIN advs_14.interesados ON advs_14.documentos.id = advs_14.interesados.id_documento
        GROUP BY advs_14.documentos.id
        ORDER BY advs_14.documentos.id DESC 
        LIMIT 5;";
        $stmt = $this->ejecutar($sql);
        $documentos = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $documento = new Documentos();
            $documento->id = $row['id'];
            $documento->ruta = $row['ruta'];
            $documento->fecha_subida = $row['fecha_subida'];
            $documento->procesado = $row['procesado'];
            $documento->nombreOriginal = $row['nombre_original'];
            $documento->paginas = $row['paginas'];
            $documento->interesados = $row['interesados'];
            $fechas = $this->dameFechas($documento->id);
            $nombres = $this->dameNombres($documento->id);
            $numeros = $this->dameNumeros($documento->id);
            $documento->nombres = $nombres;
            $documento->fechas = $fechas;
            $documento->numeros = $numeros;
            $documentos[] = $documento;
        }
        return $documentos;
    }

    public function cuentaDocumentosProcesados()
    {
        $sql = "SELECT COUNT(*) as total FROM documentos where procesado = 1";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }


    public function cuentaDocumentos()
    {
        $sql = "SELECT COUNT(*) as total FROM documentos";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosSinProcesar()
    {
        $sql = "SELECT COUNT(*) as total FROM documentos where procesado = 0";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function dameDocumentoBuscado($busqueda)
    {

        //divir por espacios 
        $busqueda = explode(" ", $busqueda);
        $sql = "select d2.id, d2.ruta, d2.nombre_original, d2.fecha_subida, d2.procesado ,ruta_doc from advs_14.`data` d 
        inner join advs_14.documentos d2 
        on d2.id = d.id_documento where ";

        foreach ($busqueda as $key => $value) {
             $busqueda[$key] = sha1($value);
            $sql .= "proc_data like '%$busqueda[$key]%' ";
            if ($key < count($busqueda) - 1) {
                $sql .= "or ";
            }
        }
        $sql .= "group by d.id";

        echo $sql;
        $stmt = $this->ejecutar($sql);
        $documentos = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $documento = new DocumentoBuscado();
            $documento->id = $row['id'];
            $documento->ruta = $row['ruta'];
            $documento->fecha_subida = $row['fecha_subida'];
            $documento->ruta_imagen = str_replace('/var/www/html/scaner/', 'https://efficientdata.mx/', $row['ruta_doc']);
            $documento->nombres = $this->dameNombres($documento->id);
            $documento->fechas = $this->dameFechas($documento->id);
            $documento->numeros = $this->dameNumeros($documento->id);
            $documento->nombreOriginal = $row['nombre_original'];
            $documentos[] = $documento;
        }
        return $documentos;
    }



    public function dameDocumentoNoAprovado()
    {
        $sql = "SELECT advs_14.documentos.*, 
       COUNT(DISTINCT advs_14.data.id) AS paginas, 
       COUNT(DISTINCT advs_14.interesados.id) AS interesados 
        FROM advs_14.documentos
        LEFT JOIN advs_14.data ON advs_14.documentos.id = advs_14.data.id_documento
        LEFT JOIN advs_14.interesados ON advs_14.documentos.id = advs_14.interesados.id_documento
        WHERE advs_14.documentos.aprovado = 0 and advs_14.documentos.procesado = 1
        GROUP BY advs_14.documentos.id
        ORDER BY advs_14.documentos.id ASC limit 1;";
        $stmt = $this->ejecutar($sql);
        $documentos = array();
        // solo un documento 
        $row = $stmt->fetch_assoc();
        $documento = new Documentos();
        $documento->id = $row['id'];
        $documento->ruta = $row['ruta'];
        $documento->fecha_subida = $row['fecha_subida'];
        $documento->procesado = $row['procesado'];
        $documento->nombreOriginal = $row['nombre_original'];
        $documento->paginas = $row['paginas'];
        $documento->interesados = $row['interesados'];

        if ($documento->id != null) {
            $fechas = $this->dameFechas($documento->id);
            $nombres = $this->dameNombres($documento->id);
            $numeros = $this->dameNumeros($documento->id);
            $documento->nombres = $nombres;
            $documento->fechas = $fechas;
            $documento->numeros = $numeros;
        }


        return $documento;
    }

    public function dameDocumentoBuscadoNombres($busqueda)
    {

        //divir por espacios
        //$busqueda = str_replace(" ",'', $busqueda);
        $busqueda = explode(",", $busqueda);

        $sql = "SELECT 
    d2.id, 
    d2.ruta, 
    d2.nombre_original, 
    d2.fecha_subida, 
    d2.procesado, 
    d2.ruta 
FROM 
    advs_14.documentos d2
LEFT JOIN 
    advs_14.interesados i ON i.id_documento = d2.id 
LEFT JOIN 
    advs_14.fechas f ON f.id_documento = d2.id 
LEFT JOIN 
    advs_14.numeros n ON n.id_documento = d2.id 
WHERE ";



        foreach ($busqueda as $key => $value) {
            $subBusqueda = explode(" ", $busqueda[$key]);
            foreach ($subBusqueda as $keySub => $subVal) {
                //$busqueda[$key] = sha1($value);
                $sql .= "
                 d2.id IN (
        SELECT i.id_documento
        FROM advs_14.interesados i 
        WHERE LOWER(i.nombre) LIKE '%$subBusqueda[$keySub]%'
    )
                
                ";
                if ($keySub < count($subBusqueda) - 1) {
                    $sql .= " or ";
                }
            }
            if ($key < count($busqueda) - 1) {
                $sql .= " and ";
            }
        }
        $sql .= "group by d2.id";
        //echo $sql;


        $stmt = $this->ejecutar($sql);
        $documentos = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $documento = new DocumentoBuscado();
            $documento->id = $row['id'];
            $documento->ruta = $row['ruta'];
            $documento->fecha_subida = $row['fecha_subida'];
            $documento->ruta_imagen = str_replace('/var/www/html/scaner/', 'https://efficientdata.mx/', $row['ruta_doc']);
            $documento->nombreOriginal = $row['nombre_original'];
            $documento->nombres = $this->dameNombres($documento->id);
            $documento->fechas = $this->dameFechas($documento->id);
            $documento->numeros = $this->dameNumeros($documento->id);
            $documentos[] = $documento;
        }
        return $documentos;
    }

    
    public function dameDocumentoBuscadoNumeros($busqueda)
    {

        //divir por espacios
        //$busqueda = str_replace(" ",'', $busqueda);
        $busqueda = explode(",", $busqueda);

        $sql = "SELECT 
    d2.id, 
    d2.ruta, 
    d2.nombre_original, 
    d2.fecha_subida, 
    d2.procesado, 
    d2.ruta 
FROM 
    advs_14.documentos d2
LEFT JOIN 
    advs_14.interesados i ON i.id_documento = d2.id 
LEFT JOIN 
    advs_14.fechas f ON f.id_documento = d2.id 
LEFT JOIN 
    advs_14.numeros n ON n.id_documento = d2.id 
WHERE ";



        foreach ($busqueda as $key => $value) {
            $subBusqueda = explode(" ", $busqueda[$key]);
            foreach ($subBusqueda as $keySub => $subVal) {
                //$busqueda[$key] = sha1($value);
                $sql .= "
                 d2.id IN (
        SELECT i.id_documento
        FROM advs_14.numeros i 
        WHERE (i.numero) LIKE '%$subBusqueda[$keySub]%'
    )
                
                ";
                if ($keySub < count($subBusqueda) - 1) {
                    $sql .= " or ";
                }
            }
            if ($key < count($busqueda) - 1) {
                $sql .= " and ";
            }
        }
        $sql .= "group by d2.id";
        //echo $sql;


        $stmt = $this->ejecutar($sql);
        $documentos = array();
        //mysqli_fetch_array
        while ($row = $stmt->fetch_assoc()) {
            $documento = new DocumentoBuscado();
            $documento->id = $row['id'];
            $documento->ruta = $row['ruta'];
            $documento->fecha_subida = $row['fecha_subida'];
            $documento->ruta_imagen = str_replace('/var/www/html/scaner/', 'https://efficientdata.mx/', $row['ruta_doc']);
            $documento->nombreOriginal = $row['nombre_original'];
            $documento->nombres = $this->dameNombres($documento->id);
            $documento->fechas = $this->dameFechas($documento->id);
            $documento->numeros = $this->dameNumeros($documento->id);
            $documentos[] = $documento;
        }
        return $documentos;
    }

    public function cuentaNombres()
    {
        $sql = "SELECT COUNT(*) as total FROM interesados";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function obtenerDocumento($id)
    {
        $sql = "SELECT id, ruta, fecha_subida, procesado FROM advs_14.documentos WHERE id = $id";
        $stmt = $this->ejecutar($sql);

        $row = $stmt->fetch_assoc();
        $documento = new Documentos();
        $documento->id = $row['id'];
        $documento->ruta = $row['ruta'];
        $documento->fecha_subida = $row['fecha_subida'];
        $documento->procesado = $row['procesado'];
        return $documento;
    }

    public function dameDocPorKey($key)
    {
        $sql = "select * from advs_14.documentos d 
        inner join advs_14.rutas_temporales r on r.id_documento = d.id 
        where r.`key` = '$key' limit 1";

        $stmt = $this->ejecutar($sql);
        //un solo documento 
        $row = $stmt->fetch_assoc();
        $documento = new Documentos();
        $documento->id = $row['id'];
        $documento->ruta = $row['ruta'];
        $documento->fecha_subida = $row['fecha_subida'];
        $documento->procesado = $row['procesado'];
        return $documento;
    }

    public function dameDocPorKeyInfo($key)
    {
        $sql = "select r.ip_em, r.fecha_solicita, r.usuario_solicita, count(da.id) as paginas from advs_14.documentos d 
        inner join advs_14.rutas_temporales r on r.id_documento = d.id 
        left join advs_14.data da on da.id_documento = d.id
        where r.`key` = '$key'  limit 1";

        $stmt = $this->ejecutar($sql);
        //un solo documento 
        $row = $stmt->fetch_assoc();
        $documento = new InfoConKey();
        $documento->fecha_solicita = $row['fecha_solicita'];
        $documento->ip = $row['ip_em'];
        $documento->emite = $row['usuario_solicita'];
        $documento->paginas = $row['paginas'];
        $documento->key = $key;
        return $documento;
    }

    public function dameUsuarioTrac($id)
    {
        $sql = "SELECT nombre FROM advs_14.usuarios WHERE id = $id";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['nombre'];
    }


    public function marcarVisto($key)
    {
        $sql = "update advs_14.rutas_temporales set `visto` = 1 where `key` = '$key'";
        $this->ejecutar($sql);
    }




    public function eliminarDocumento($id)
    {
        $sql = "DELETE FROM documentos WHERE id = $id";
        $this->ejecutar($sql);
    }



    public function cuentaNombresRepetidos()
    {
        $sql = "SELECT COUNT(*) as total FROM (SELECT nombre FROM interesados GROUP BY nombre HAVING COUNT(*) > 1) as subquery";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosRevisados()
    {
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 1";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosAprovadosHoy(){
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 1 and DATE(fecha_subida) = CURDATE()";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosAprovadosSemana(){
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 1 and DATE(fecha_subida) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosAprovadosMes(){
        $mesActual = date('m');
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 1 and MONTH(fecha_subida) = $mesActual";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosAprovadosAnio(){
        $anioActual = date('Y');
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 1 and YEAR(fecha_subida) = $anioActual";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }

    public function cuentaDocumentosSinAprovarHoy(){
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 0 and DATE(fecha_subida) = CURDATE()";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }
    public function cuentaDocumentosSinAprovarSemana(){
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 0 and DATE(fecha_subida) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }
    public function cuentaDocumentosSinAprovarMes(){
        $mesActual = date('m');
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 0 and MONTH(fecha_subida) = $mesActual";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }
    public function cuentaDocumentosSinAprovarAnio(){
        $anioActual = date('Y');
        $sql = "SELECT COUNT(*) as total FROM documentos WHERE aprovado = 0 and YEAR(fecha_subida) = $anioActual";
        $stmt = $this->ejecutar($sql);
        $row = $stmt->fetch_assoc();
        return $row['total'];
    }
}
