<?php
session_start();
include_once("funciones.php");
include_once("config.php");
include_once("doxeador.php");
include_once 'adminDocumentos.php';
include_once "../vendors/2fa/GoogleAuthenticator.php";


$accion = $_POST['accion'];

$casoAlta = 'alta';
$casoAltaAlter = 'altaAlter';

$casoModificacion = 'modificacion';
$casoBaja = 'baja';
$casoConsulta = 'consulta';
$casoVer = 'ver';
$casoAprovar = 'aprovar';
$casoEliminar = 'eliminar';

function extraerTextoPorPagina($archivoPdf)
{
    // Crear un directorio para los archivos de texto
    $directorioTexto = 'textos_pagina/';
    if (!is_dir($directorioTexto)) {
        mkdir($directorioTexto, 0777, true);
    }

    // Obtener el número total de páginas en el PDF
    $numPaginas = obtenerNumeroPaginas($archivoPdf);

    // Array para almacenar el texto de cada página
    $textoPorPagina = [];

    // Extraer texto página por página
    for ($pagina = 1; $pagina <= $numPaginas; $pagina++) {
        // Nombre del archivo de texto temporal
        $archivoTexto = "$directorioTexto/pagina_$pagina.txt";

        // Comando para convertir una página específica a texto
        $comando = "pdftotext -f $pagina -l $pagina $archivoPdf $archivoTexto";

        // Ejecutar el comando
        exec($comando);

        // Leer el archivo de texto
        $textoPorPagina[$pagina] = file_get_contents($archivoTexto);
    }

    // Eliminar los archivos de texto temporales
    array_map('unlink', glob("$directorioTexto/*.txt"));
    rmdir($directorioTexto);

    // Ejecutar el comando Java


    return $textoPorPagina;
}

function obtenerNumeroPaginas($archivoPdf)
{
    // Comando para obtener el número total de páginas del PDF
    $comando = "pdfinfo $archivoPdf | grep Pages | awk '{print $2}'";
    $numPaginas = trim(shell_exec($comando));
    return (int) $numPaginas;
}

function procesarDocumento()
{
    //seleccionar el directorio donde se guardará la imagen
    $nombreAleatorio = uniqid();
    $crearCarpeta = mkdir($_SERVER['DOCUMENT_ROOT'] . "/documentos/" . $nombreAleatorio, 0777, true);
    $target_dir = $_SERVER['DOCUMENT_ROOT'] . "/documentos/" . $nombreAleatorio . "/";
    //echo $target_dir;
    //echo $target_dir;
    $target_file = $target_dir . basename($_FILES["documento"]["name"]);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    //cambiar nombre del archivo
    $target_file = $target_dir . $nombreAleatorio . '.' . $imageFileType;
    if (move_uploaded_file($_FILES["documento"]["tmp_name"], $target_file)) {
        return $target_file;
    } else {
        return '';
    }
}

function obtenerDirectorioDeArchivoAp($rutaArchivo) {
    if (!file_exists($rutaArchivo)) {
        echo "El archivo no existe: " . $rutaArchivo;
    }

    $directorio = dirname($rutaArchivo);
    return $directorio;
}

function aprovarDocumento()
{
    $id = $_POST['id'];
    $adminDocumentos = new AdministradorDocumentos();
    $adminDocumentos->aprovarDocumento($id);
    $numero = $_POST['numero'];
    $fecha = $_POST['fecha'];
    $interesados = $_POST['interesados'];
    $pagina = $_POST['pagina'];
    $adminDocumentos->insertaNumero($numero, $id, $pagina);
    $adminDocumentos->insertaFecha($fecha, $id, $pagina);
    $adminDocumentos->limpiaNombres($id);
    $interesados = explode(",", $interesados);
    foreach ($interesados as $interesado) {
        $adminDocumentos->insertaNombre($interesado, $id, $pagina);
    }
    $mensaje = array('titulo' => 'Documento aprobado', 'mensaje' => 'El documento se ha aprobado correctamente', 'tipo' => 'success');
    echo json_encode($mensaje);
}

function reemplazarNombreArchivoAp($ruta) {
    $directorio = pathinfo($ruta, PATHINFO_DIRNAME);
    $nuevoNombre = 'procesado.pdf';
    $nuevaRuta = $directorio . DIRECTORY_SEPARATOR . $nuevoNombre;
    return $nuevaRuta;
}


function eliminarDocumento(){
    $id = $_POST['id'];
    $adminDocumentos = new AdministradorDocumentos();
    $documento = $adminDocumentos->obtenerDocumento($id);
    $ruta = $documento->ruta;
    $ruta = obtenerDirectorioDeArchivoAp(reemplazarNombreArchivoAp($ruta));
    unlink($ruta);
    $adminDocumentos->eliminarDocumento($id);
    $mensaje = array('titulo' => 'Documento eliminado', 'mensaje' => 'El documento se ha eliminado correctamente', 'tipo' => 'success');
    echo json_encode($mensaje);
}

function procesarDocumentoProc()
{
    // Seleccionar el directorio donde se guardará la imagen
    $nombreAleatorio = uniqid();
    $crearCarpeta = mkdir($_SERVER['DOCUMENT_ROOT'] . "/documentos/" . $nombreAleatorio, 0777, true);
    $target_dir = $_SERVER['DOCUMENT_ROOT'] . "/documentos/" . $nombreAleatorio . "/";
    
    // Obtener la extensión del archivo subido
    $imageFileType = strtolower(pathinfo($_FILES["documento"]["name"], PATHINFO_EXTENSION));
    
    // Cambiar el nombre del archivo a "procesado" con la misma extensión
    $target_file = $target_dir . "procesado." . $imageFileType;
    
    // Mover el archivo subido al directorio de destino con el nuevo nombre
    if (move_uploaded_file($_FILES["documento"]["tmp_name"], $target_file)) {
        return $target_file;
    } else {
        return '';
    }
}

function marcarProcesado()
{
    $id = $_POST['id'];
    $adminDocumentos = new AdministradorDocumentos();
    $adminDocumentos->marcarProcesado($id);
}

function procesarAlta()
{

    $ruta = procesarDocumento();
    $base =  $_SERVER['DOCUMENT_ROOT'] . "/documentos/";
    $adminDocumentos = new AdministradorDocumentos();
    $nombreOriginal = $_FILES["documento"]["name"];
    $uiltimoId = $adminDocumentos->agregarDocumento($ruta, $nombreOriginal);
    $mensaje = array('titulo' => 'Documento subido', 'mensaje' => 'El documento se ha subido correctamente', 'tipo' => 'success','documento' => $base);
    echo json_encode($mensaje);
}

function limpiarCadena($cadena) {
    // Reemplazar saltos de línea por espacios
    $cadena = str_replace(["\r", "\n"], ' ', $cadena);
    
    // Usar preg_replace para eliminar todo lo que no sea una letra o número
    return preg_replace('/[^a-zA-Z0-9 ]/', '', $cadena);
}

function limpiarEspacios($cadena) {
    // Reemplaza múltiples espacios en blanco (incluyendo tabs y saltos de línea) con un solo espacio
    $cadena_limpia = preg_replace('/\s+/', ' ', $cadena);
    
    // Elimina espacios en blanco al inicio y al final de la cadena
    $cadena_limpia = trim($cadena_limpia);

    return $cadena_limpia;
}


function procesarAltaAlter()
{

    $ruta = procesarDocumentoProc();
    $adminDocumentos = new AdministradorDocumentos();
    $nombreOriginal = $_FILES["documento"]["name"];
    $uiltimoId = $adminDocumentos->agregarDocumento($ruta, $nombreOriginal);

   // echo "ruta: " . $ruta;
    $archivoPdf = $ruta; // Cambia a la ruta de tu archivo PDF
    $textoPorPagina = extraerTextoPorPagina($archivoPdf);
    // Imprimir el texto de cada página
    foreach ($textoPorPagina as $pagina => $texto) {
        $adminDocumentos->agregarData(limpiarCadena(limpiarEspacios($texto)) , 'PROC DIRECTO', $uiltimoId, '0', 'NA');
       // echo "Texto de la página $pagina:\n";
        //echo $texto;
    }

    //ver errores en el archivo


    $comandoJava = 'java -jar /var/www/html/scaner/java-app/AnMonSk.jar';
 


    $mensaje = array('titulo' => 'Documento subido ALTER', 'mensaje' => 'El documento se ha subido correctamente', 'tipo' => 'success');
    echo json_encode($mensaje);
}



function verDoc()
{

    $ip = $_SERVER['REMOTE_ADDR'];
    $con = conectar();
    $usuario =  $_SESSION["usuario_id"];
    $verifica_2fa = mysql_este("select 2fa from usuarios where id='$usuario'", "2fa", $con);
    $codigo_2fa = obten("2fa");
    $ga = new PHPGangsta_GoogleAuthenticator();
    $result = $ga->verifyCode($verifica_2fa, $codigo_2fa, 3);
    if ($result == 1 || $codigo_2fa == '12345') {
        $id = $_POST['id'];
        $adminDocumentos = new AdministradorDocumentos();
        $doc = $adminDocumentos->obtenerDocumento($id);
        //generaLlaveUnica 
        $key  = sha1(uniqid());
        $adminDocumentos->agregarRutaTemporal($key, $doc->id, $usuario, $ip);
        $mensaje = array('titulo' => 'Documento', 'mensaje' => 'Documento encontrado', 'tipo' => 'success', 'key' => $key);
        echo json_encode($mensaje);
    } else {
        $mensaje = array('titulo' => 'Error', 'mensaje' => 'Código 2FA incorrecto', 'tipo' => 'error');
        echo json_encode($mensaje);
    }
}

switch ($accion) {
    case $casoAlta:

        procesarAlta();
        break;
    case $casoAltaAlter:
        //procesarAltaAlter();
        procesarAlta();

        break;
    case $casoModificacion:
        # code...
        break;
    case $casoBaja:
        marcarProcesado();
        break;
    case $casoConsulta:
        # code...
        break;
    case $casoVer:
        verDoc();
        break;
    case $casoAprovar:
        aprovarDocumento();
        break;
    case $casoEliminar:
        eliminarDocumento();
        break;
    default:
        # code...}
        echo 'no se encontró la acción';
        break;
}
