<?php
require('FPDF/fpdf.php');

// Función para procesar las imágenes y generar el PDF
function generarPDFConImagenes($archivoTxt, $imagenOverlay, $outputPdf) {
    // Leer el archivo txt
    $imagenes = file($archivoTxt, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
    // Crear un nuevo documento PDF
    $pdf = new FPDF();
    
    foreach ($imagenes as $imagen) {
        // Verificar si la imagen existe
        echo "verificando imagen: " . $imagen . "<br>";
        if (!file_exists($imagen)) {
            echo "Imagen no encontrada: " . $imagen . "<br>";
            continue;
        }

        // Crear una nueva imagen con GD
        $baseImg = imagecreatefrompng($imagen);
        $overlayImg = imagecreatefrompng($imagenOverlay);

        // Obtener dimensiones de la imagen base y de la imagen overlay
        $baseWidth = imagesx($baseImg);
        $baseHeight = imagesy($baseImg);
        $overlayWidth = imagesx($overlayImg);
        $overlayHeight = imagesy($overlayImg);

        // Calcular la posición para colocar la overlay en la esquina inferior izquierda
        $xPos = 0; // Posición en X
        $yPos = $baseHeight - $overlayHeight; // Posición en Y

        // Sobreponer la imagen overlay en la imagen base en la esquina inferior izquierda
        imagecopy($baseImg, $overlayImg, $xPos, $yPos, 0, 0, $overlayWidth, $overlayHeight);

        // Guardar la imagen temporalmente
        $tempImg = tempnam("/var/www/html/scaner/temporales/", 'img_') . '.png';
        imagepng($baseImg, $tempImg);

        // Convertir píxeles a milímetros (asumiendo 96 DPI)
        $widthInMM = $baseWidth * 25.4 / 96;
        $heightInMM = $baseHeight * 25.4 / 96;

        // Añadir una nueva página al PDF con el tamaño de la imagen
        $pdf->AddPage('P', array($widthInMM, $heightInMM));
        
        // Colocar la imagen en el PDF manteniendo el tamaño original
        $pdf->Image($tempImg, 0, 0, $widthInMM, $heightInMM);

        // Liberar memoria
        imagedestroy($baseImg);
        imagedestroy($overlayImg);
        //unlink($tempImg);
        echo "imagen agregada: " . $tempImg . "<br>";
    }

    // Generar el PDF
    $pdf->Output('F', $outputPdf);
}

// Llamar a la función
$archivoTxt = '../documentos/66b39edc67131/imgs.txt';
$imagenOverlay = '../qr.png';
$outputPdf = 'documento_con_imagenes.pdf';

generarPDFConImagenes($archivoTxt, $imagenOverlay, $outputPdf);
?>