<?php
// Función recursiva para contar archivos .png en directorios y subdirectorios
function contar_png_en_directorio($directorio) {
    $archivos_png = [];

    // Abrir el directorio
    $iterador = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directorio));

    // Iterar sobre todos los archivos y carpetas
    foreach ($iterador as $archivo) {
        // Verificar si el archivo es .png
        if (pathinfo($archivo, PATHINFO_EXTENSION) === 'png') {
            $archivos_png[] = $archivo;
        }
    }

    return count($archivos_png);
}

// Definir la ruta de la carpeta 'documentos'
$directorio = 'documentos';

// Verificar si la carpeta existe
if (is_dir($directorio)) {
    // Contar los archivos .png en el directorio y subdirectorios
    $cantidad_png = contar_png_en_directorio($directorio);

    // Imprimir la cantidad de archivos .png
    echo "Hay " . $cantidad_png . " archivos .png en la carpeta '$directorio' y sus subcarpetas.";
} else {
    echo "La carpeta '$directorio' no existe.";
}
?>
