import mysql.connector
import fitz  # PyMuPDF
from PIL import Image, ImageEnhance
import cv2
import pytesseract
import io
import os
import re
import random
import subprocess
import tempfile
import fcntl
import sys  # Asegúrate de importar sys para poder usar sys.exit()
from reportlab.pdfgen import canvas
from reportlab.lib.pagesizes import letter

# Ruta del archivo de bloqueo
LOCKFILE = '/tmp/mi_script.lock'

# Conectar a la base de datos
db_config = {
    'user': 'advs_14',
    'password': 'advperro2',
    'host': 'localhost',
    'database': 'advs_14'
}

def process_image_for_ocr(args):
    image_path, output_dir, contador = args

    # Verificar si el archivo de imagen existe
    if not os.path.exists(image_path):
        raise FileNotFoundError(f"El archivo de imagen no existe: {image_path}")

    # Leer la imagen sin realizar ningún procesamiento
    img = Image.open(image_path)

    # Guardar la imagen con un nuevo nombre en el directorio de salida
    processed_image_path = os.path.join(output_dir, f"processed_image{contador}.png")
    img.save(processed_image_path)

    return processed_image_path

def obtener_info_pdf():
    try:
        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        cursor.execute("SELECT id, ruta FROM documentos WHERE procesado = 0 LIMIT 1")
        result = cursor.fetchone()
        return result  # Retorna una tupla (id, ruta) o None si no hay resultados
    except mysql.connector.Error as err:
        print(f"Error: {err}")
        return None
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

def insertar_en_db(texto, ruta, id_pdf):
    try:
        # Limpiar el texto: conservar solo espacios, números, letras, comas, guiones y la letra Ñ/ñ
        texto_limpio = re.sub(r'[^a-zA-Z0-9\s,ñÑáéíóúÁÉÍÓÚüÜ]', '', texto)

        # Eliminar saltos de línea y reemplazarlos con un espacio
        texto_limpio = texto_limpio.replace('\n', ' ').replace('\r', '')

        # Reemplazar múltiples espacios por un solo espacio
        texto_limpio = re.sub(r'\s+', ' ', texto_limpio).strip()

        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        query = "INSERT INTO advs_14.`data` (raw_data, ruta_doc, id_documento) VALUES (%s, %s, %s)"
        valores = (texto_limpio, ruta, id_pdf)
        cursor.execute(query, valores)
        connection.commit()
        print(f"Datos insertados en la base de datos para {ruta}")
    except mysql.connector.Error as err:
        print(f"Error: {err}")
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

def marcar_procesado(id_pdf):
    try:
        connection = mysql.connector.connect(**db_config)
        cursor = connection.cursor()
        query = "UPDATE advs_14.documentos SET procesado = 1 WHERE id = %s"
        valores = (int(id_pdf),)
        cursor.execute(query, valores)
        connection.commit()
        print(f"Actualizado en la base de datos para {id_pdf}")
    except mysql.connector.Error as err:
        print(f"Error: {err}")
    finally:
        if connection.is_connected():
            cursor.close()
            connection.close()

def eliminar_archivos(archivos):
    for file_path in archivos:
        try:
            os.remove(file_path)
            print(f"Archivo eliminado: {file_path}")
        except OSError as e:
            print(f"Error al eliminar {file_path}: {e}")

def acquire_lock(lockfile):
    """Intenta adquirir un bloqueo en el archivo."""
    try:
        fd = open(lockfile, 'w')
        fcntl.flock(fd, fcntl.LOCK_EX | fcntl.LOCK_NB)
        return fd
    except IOError:
        print("El script ya está en ejecución.")
        sys.exit(1)

def release_lock(lockfile_descriptor):
    """Libera el bloqueo y elimina el archivo."""
    fcntl.flock(lockfile_descriptor, fcntl.LOCK_UN)
    lockfile_descriptor.close()
    os.remove(lockfile_descriptor.name)

def execute_command(command):
    """Ejecuta un comando y maneja errores."""
    try:
        subprocess.run(command, check=True, shell=True)
    except subprocess.CalledProcessError as e:
        print(f"Error al ejecutar '{command}': {e}")
        sys.exit(1)

def main():
    # Adquirir el bloqueo
    lockfile_descriptor = acquire_lock(LOCKFILE)
    try:
        # Obtener la información del PDF
        pdf_info = obtener_info_pdf()
        if not pdf_info:
            print("No se encontró un archivo PDF sin procesar.")
            exit()

        id_pdf, pdf_path = pdf_info

        # Directorio donde se encuentra el PDF
        output_dir = os.path.dirname(pdf_path)

        # Generar un número aleatorio
        random_number = random.randint(1000, 9999)

        # Nombre del archivo de salida para las rutas de las imágenes
        output_file = os.path.join(output_dir, f'imgs.txt')

        # Abrir el archivo PDF
        pdf_document = fitz.open(pdf_path)
        contador = 0

        # Lista para almacenar los argumentos de las imágenes
        args_list = []
        processed_image_paths = []  # Lista para almacenar las rutas de las imágenes procesadas
        text_file_paths = []  # Lista para almacenar las rutas de los archivos de texto generados
        imagenes_originales = [] # Lista para almacenar las rutas de las imágenes originales

        # Abrir el archivo de salida para escribir las rutas de las imágenes
        with open(output_file, 'w') as file:
            # Recorrer todas las páginas del PDF
            for page_num in range(len(pdf_document)):
                page = pdf_document.load_page(page_num)
                images = page.get_images(full=True)

                for img_index, img in enumerate(images):
                    xref = img[0]
                    base_image = pdf_document.extract_image(xref)
                    image_bytes = base_image["image"]
                    image_ext = base_image["ext"]
                    image = Image.open(io.BytesIO(image_bytes))

                    # Crear el nombre del archivo para la imagen extraída
                    image_filename = f"pagina_{page_num+1}_imagen_{img_index+1}.{image_ext}"
                    image_filepath = os.path.join(output_dir, image_filename)
                    imagenes_originales.append(image_filepath)

                    # Guardar la imagen
                    contador += 1
                    image.save(image_filepath)
                    
                    # Agregar los argumentos a la lista para el procesamiento de imágenes
                    args_list.append((image_filepath, output_dir, contador))

        # Procesar las imágenes secuencialmente
        for args in args_list:
            processed_image_path = process_image_for_ocr(args)
            processed_image_paths.append(processed_image_path)
        
        # Escribir las rutas de las imágenes procesadas en el archivo de salida
        with open(output_file, 'a') as file:
            for processed_image_path in processed_image_paths:
                file.write(processed_image_path + '\n')
                print(f"Imagen procesada guardada: {processed_image_path}")

        # Generar el PDF con las imágenes procesadas
        procesado_pdf_path = os.path.join(output_dir, "procesado.pdf")
        c = canvas.Canvas(procesado_pdf_path, pagesize=letter)
        for image_path in processed_image_paths:
            c.drawImage(image_path, 0, 0, width=letter[0], height=letter[1])
            c.showPage()
        c.save()

        print(f"PDF generado con las imágenes procesadas: {procesado_pdf_path}")

       

        # Procesar cada imagen para extraer texto secuencialmente
        for image_path in processed_image_paths:
            image_path = image_path.strip()  # Eliminar espacios en blanco y saltos de línea

            # Abrir la imagen con PIL
            image = Image.open(image_path)

            # Configurar Tesseract para usar el idioma español
            custom_config = r'--oem 3 --psm 6 -l spa'

            # Extraer texto de la imagen con configuración personalizada para el idioma español
            text = pytesseract.image_to_string(image, config=custom_config)

            # Generar un número aleatorio
            random_number = random.randint(1000, 9999)

            # Crear el nombre del archivo
            file_name = os.path.join(output_dir, f'analisis_{random_number}.txt')

            # Guardar el texto extraído en un archivo
            with open(file_name, 'w') as file:
                file.write(text)

            print(f'Texto extraído de {image_path} guardado en {file_name}')
            text_file_paths.append(file_name)

            # Insertar en la base de datos
            insertar_en_db(text, image_path, id_pdf)
            break

        # Eliminar las imágenes procesadas y los archivos de texto generados
        text_file_paths.append(pdf_path)
        eliminar_archivos(text_file_paths)
         # Marcar el documento como procesado
        marcar_procesado(id_pdf)

        # Ejecutar pac.py con el ID del documento como argumento
        try:
            subprocess.run(["python3", "/var/www/html/16/ultra/sistema/documentos/pac.py", str(id_pdf)], check=True)
            print(f"Script pac.py ejecutado exitosamente con id_documento: {id_pdf}")
        except subprocess.CalledProcessError as e:
            print(f"Error al ejecutar pac.py: {e}")
    finally:
        # Liberar el bloqueo
        release_lock(lockfile_descriptor)

if __name__ == "__main__":
    main()