import sys
import subprocess

def main():
    # Verifica si se pasó un argumento
    if len(sys.argv) < 2:
        print("Por favor, proporciona el parámetro id_doc.")
        sys.exit(1)

    # Asigna el parámetro id_doc a una variable
    id_doc = sys.argv[1]

    # Ejecuta cada script con el parámetro id_doc
    scripts = [
        "/var/www/html/16/ultra/sistema/documentos/tensor.py",
        "/var/www/html/16/ultra/sistema/documentos/tensor2.py",
        "/var/www/html/16/ultra/sistema/documentos/tensor3.py"
    ]

    for script in scripts:
        result = subprocess.run(["python3", script, id_doc], capture_output=True, text=True)
        if result.returncode != 0:
            print(f"Error al ejecutar {script}:")
            print(result.stderr)
        else:
            print(f"Salida de {script}:")
            print(result.stdout)

if __name__ == "__main__":
    main()