import mysql.connector
import re
from word2number import w2n
import sys

# Configuración de la conexión a la base de datos
db_config = {
    'user': 'advs_14',
    'password': 'advperro2',
    'host': 'localhost',
    'database': 'advs_14'
}
def convertir_palabra_a_numero(palabra):
    """Convierte números escritos en palabras a números usando word2number."""
    try:
        return w2n.word_to_num(palabra)
    except ValueError:
        return None

def extraer_numero_documento(texto):
    """Extrae el número de un documento de un texto dado."""
    # Definir expresiones regulares para encontrar palabras clave relacionadas con números de documentos
    patrones = [
        # Variantes con acentos y sin acentos
        r'\b(?:número|n°|num|póliza|contrato|folio|documento|documento\s+no|no|numero|poliza|nmero|nmr|nº)\b'
    ]

    texto = texto.lower()  # Convertir el texto a minúsculas para uniformidad
    coincidencias = []

    for patron in patrones:
        # Buscar todas las posiciones donde se encuentra la palabra clave
        for match in re.finditer(patron, texto):
            inicio = match.end()  # Posición después de la palabra clave

            # Buscar el primer número después de la palabra clave
            siguiente_numero = re.search(r'\d{1,5}(?:[\.,\s]*\d{1,5})*|\d+(?:[\.,]\d+)?', texto[inicio:])
            if siguiente_numero:
                coincidencia = siguiente_numero.group()
                coincidencias.append(coincidencia)
                break  # Salir del bucle después de encontrar el primer número después de la palabra clave
    
    if coincidencias:
        # Convertir la primera coincidencia encontrada a número
        coincidencia = coincidencias[0]
        numero = convertir_palabra_a_numero(coincidencia)
        if numero is None:
            try:
                numero = float(coincidencia.replace(',', '').replace('.', ''))
            except ValueError:
                numero = None
        return numero if numero is not None else None
    
    return None


def main(id_doc):
    # Conectar a la base de datos
    connection = mysql.connector.connect(**db_config)
    cursor = connection.cursor()

    # Seleccionar datos de la tabla 'data'
    cursor.execute("""
        SELECT id, raw_data, ruta_doc, id_documento, procesado, proc_data
        FROM advs_14.data
        WHERE procesado = 0 AND id_documento = %s;
    """, (id_doc,))
    rows = cursor.fetchall()

    for row in rows:
        id_data = row[0]
        raw_data = row[1]
        id_documento = row[3]

        print(f"Procesando documento {id_documento}...")

        # Extraer número de documento del campo 'raw_data'
        numero_documento = extraer_numero_documento(raw_data)

        if numero_documento is not None:
            try:
                print(f"Documento {id_documento}: Número encontrado: {numero_documento}")
                # Insertar número en la tabla 'numeros'
                cursor.execute("""
                    INSERT INTO advs_14.numeros (numero, id_documento, id_pagina)
                    VALUES (%s, %s, %s)
                """, (numero_documento, id_documento, id_data))
                connection.commit()
            except mysql.connector.Error as err:
                print(f"Error al insertar número {numero_documento}: {err}")

        # Marcar el registro como procesado
        try:
            cursor.execute("UPDATE advs_14.data SET procesado = 1 WHERE id = %s;", (id_data,))
            connection.commit()
        except mysql.connector.Error as err:
            print(f"Error al actualizar el estado del registro {id_data}: {err}")

    # Cerrar la conexión a la base de datos
    cursor.close()
    connection.close()

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Uso: python3 /var/www/html/scaner/tensor2.py <id_doc>")
        sys.exit(1)

    id_doc = sys.argv[1]
    main(id_doc)