<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>S14 U</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <img src="favicon.png" alt="">

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <?php
    include "api/adminFacturasSEC.php";
    include "api/adminPagos.php";
    ?>


    <?php
    function separar_fecha_hora($fecha_hora)
    {
        $partes = explode(' ', $fecha_hora);
        $fecha_partes = explode('-', $partes[0]);
        $fecha = $fecha_partes[2] . '/' . $fecha_partes[1] . '/' . $fecha_partes[0];

        $hora = $partes[1];
        return array(
            'fecha' => $fecha,
            'hora' => $hora
        );
    }
    ?>

    <?php
    $adminFacturas = new AdministradorFacturas();
    $adminPagos = new AdministradorPagos();
    $relFacturas = $adminFacturas->dameRelacionFacturasPago();
    $factura = $adminFacturas->dameFactura($_GET['id']);
    $pagos = $adminPagos->damePagosPorMonto($factura->total_iva);
    function fechaComoCadenaFacturas($fecha)
    {
        $dia = substr($fecha, 8, 2);
        $mes = substr($fecha, 5, 2);
        $anio = substr($fecha, 0, 4);

        switch ($mes) {
            case "01":
                $mes = 'Enero';
                break;
            case "02":
                $mes = 'Febrero';
                break;
            case "03":
                $mes = 'Marzo';
                break;
            case  "04":
                $mes = 'Abril';
                break;
            case "05":
                $mes = 'Mayo';
                break;
            case "06":
                $mes = 'Junio';
                break;
            case "07":
                $mes = 'Julio';
                break;
            case "08":
                $mes = 'Agosto';
                break;
            case "09":
                $mes = 'Septiembre';
                break;
            case "10":
                $mes = 'Octubre';
                break;
            case "11":
                $mes = 'Noviembre';
                break;
            case "12":
                $mes = 'Diciembre';
                break;
            default:
                $mes = "NA";
                $dia = "NA";
                $anio = "NA";
        }
        return $dia . '/' . $mes . '/' . $anio;
    }

    ?>

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->

                <div x-data="striped">

                    <div class="grid gap-6 xl:grid-flow-row">
                        <!-- Previous Statement -->
                        <div class="panel overflow-hidden">
                            <div class="flex items-center justify-between">
                                <div>
                                    <div class="text-lg font-bold">Factura <?php echo $factura->id ?> </div>
                                    <div class="text-success">Facturada <?php echo separar_fecha_hora($factura->fecha_timbrado)['fecha'] ?> </div>
                                </div>
                                <div>
                                    <div class="text-lg font-bold">Salida: <?php echo $factura->empresa_nombre ?> </div>
                                    <div class="text-lg font-bold">Destino: <?php echo $factura->empresa_destino ?> </div>
                                </div>
                            </div>
                            <div class="relative mt-10">
                                <div class="absolute -bottom-12 h-24 w-24 ltr:-right-12 rtl:-left-12">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full w-full text-success opacity-20">
                                        <circle opacity="0.5" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="1.5"></circle>
                                        <path d="M8.5 12.5L10.5 14.5L15.5 9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </div>
                                <div class="grid grid-cols-2 gap-6 md:grid-cols-3">

                                    <div>
                                        <div class="text-primary">Total con IVA </div>
                                        <div class="mt-2 text-2xl font-semibold">$<?php echo number_format($factura->total_iva, 2) ?></div>
                                    </div>
                                    <!-- <div>
                                        <div class="text-primary">Total sin IVA</div>
                                        <div class="mt-2 text-2xl font-semibold" >$<?php echo number_format($factura->xml_subtotal, 2) ?></div>
                                    </div> -->
                                </div>
                            </div>
                        </div>


                    </div>

                    <br>
                    <h5 class="">Pagos relacionados a la factura </h5>

                    <div class="panel mt-6">

                        <div class="md:absolute md:top-5 ltr:md:left-5 rtl:md:right-5">
                            <div class="mb-5 flex items-center gap-2">


                            </div>
                        </div>
                        <table id="tableStripe" class="table-striped">

                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Empresa</th>
                                    <th>Nombre Corto</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Banco</th>


                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1" hidden>montoS</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">monto</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Tipo de Movimiento</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Descripción</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="4">Descripción Detallada</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Fecha de banco</th>
                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5" hidden>Fecha de banco</th>

                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" style="width: 200px;">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php

                                foreach ($pagos as $pago) {
                                    echo "<tr id='fila_" . $pago->id . "'>";
                                    echo "<td>" . $pago->id . "</td>";
                                    echo "<td>" . $pago->empresa . "</td>";
                                    echo "<td>" . $pago->nombre_corto . "</td>";
                                    echo "<td>" . $pago->banco . "</td>";
                                    echo "<td hidden>" . $pago->monto . "</td>";

                                    echo "<td>$" . number_format($pago->monto, 2) . "</td>";
                                    echo "<td>" . $pago->tipo_movimiento . "</td>";
                                    echo "<td>" . $pago->descripcion . "</td>";
                                    echo "<td>" . $pago->descripcion_detallada . "</td>";
                                    echo "<td>" . fechaComoCadenaFacturas($pago->fecha_banco)  . " o " . fechaComoCadenaFacturas($pago->fechaAsignacionRaw) . "</td>";
                                    echo "<td hidden>" . ($pago->fecha_banco)  . "</td>";

                                    echo '<td style="text-align: center;" ><button onclick="relacionar(' . $pago->id . ')" type="button" class="btn btn-info">Relacionar</button></td>';
                                    echo "</tr>";

                                    echo "<script>camposSinMod.push(" . $pago->id . ");</script>";
                                }


                                ?>


                            </tbody>

                        </table>
                    </div>


                </div>
                <!-- end main content section -->

            </div>

            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2022</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/highlight.min.js"></script>
    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script src="assets/js/simple-datatables.js"></script>


    <script>
        function relacionar(pago) {
            var datosForm = new FormData();
            datosForm.append('accion', 'asignar');
            datosForm.append('factura', '<?php echo $factura->id ?>');
            datosForm.append('movimiento', pago);
            Swal.fire({
                title: '¿Estas seguro de relacionar esta factura?',
                text: "Se relacionara la factura con el pago",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Si, relacionar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch("api/apiFactura.php", {
                            method: "POST",
                            body: datosForm,
                        })
                        .then((respuesta) => respuesta.json())
                        .then((data) => {
                            console.log(data);
                            Swal.fire(
                                data.estatus,
                                data.mensaje,
                                data.subMensaje
                            ).then((result) => {
                                if (result.isConfirmed) {
                                    window.close();

                                }
                            });


                        });
                }
            })

        }
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));

            Alpine.data('striped', () => ({
                init() {
                    const tableOptions = {

                        sortable: true,
                        searchable: true,
                        perPage: 10,
                        perPageSelect: [10, 20, 30, 50, 100],
                        firstLast: true,
                        firstText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        lastText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M11 19L17 12L11 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.5" d="M6.99976 19L12.9998 12L6.99976 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        prevText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M15 5L9 12L15 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        nextText: '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="w-4.5 h-4.5 rtl:rotate-180"> <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                        labels: {
                            perPage: '{select}',
                        },
                        layout: {
                            top: '{search}',
                            bottom: '{info}{select}{pager}',
                        },
                    };

                    const datatable1 = new simpleDatatables.DataTable('#tableStripe', tableOptions);

                    const datatable2 = new simpleDatatables.DataTable('#tableHover', tableOptions);

                    const datatable3 = new simpleDatatables.DataTable('#tableBorder', tableOptions);

                    const datatable4 = new simpleDatatables.DataTable('#tableCompact', tableOptions);

                    const datatable5 = new simpleDatatables.DataTable('#tableAll', tableOptions);
                },
            }));
        });
    </script>
</body>

</html>