<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Nuevo complemento de pago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
    <link rel="stylesheet" type="text/css" href="assets/css/nice-select2.css" />
    <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>
    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex min-h-screen flex-col">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>
            <!-- end header section -->

            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->
                <div x-data="sales">
                    <ul class="flex space-x-2 rtl:space-x-reverse">
                        <li>
                            <a href="index.php" class="text-primary hover:underline">Inicio</a>
                        </li>
                        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                            <span>Facturación</span>
                        </li>
                    </ul>

                    <div class="pt-5">




                        <?php
                        include "api/adminEmpresas.php";
                        include "api/adminConceptos.php";
                        include "api/adminClientes.php";
                        include "api/adminFormasPago.php";
                        include "api/adminPagos.php";
                        include "api/adminFacturasSEC.php";

                        $adminEmpresas = new AdminEmpresas();
                        $adminConceptos = new AdministradorConceptos();
                        $adminClientes = new AdministradorClientes();
                        $adminFormasPago = new AdministradorFormasPago();
                        $adminPagos = new AdministradorPagos();
                        $adminFacturas = new AdministradorFacturas();
                        $facturasPpd = $adminFacturas->dameFacturasPPD();
                        function fechaComoCadenaFacturas($fecha)
                        {
                            $dia = substr($fecha, 8, 2);
                            $mes = substr($fecha, 5, 2);
                            $anio = substr($fecha, 0, 4);

                            switch ($mes) {
                                case "01":
                                    $mes = 'Enero';
                                    break;
                                case "02":
                                    $mes = 'Febrero';
                                    break;
                                case "03":
                                    $mes = 'Marzo';
                                    break;
                                case  "04":
                                    $mes = 'Abril';
                                    break;
                                case "05":
                                    $mes = 'Mayo';
                                    break;
                                case "06":
                                    $mes = 'Junio';
                                    break;
                                case "07":
                                    $mes = 'Julio';
                                    break;
                                case "08":
                                    $mes = 'Agosto';
                                    break;
                                case "09":
                                    $mes = 'Septiembre';
                                    break;
                                case "10":
                                    $mes = 'Octubre';
                                    break;
                                case "11":
                                    $mes = 'Noviembre';
                                    break;
                                case "12":
                                    $mes = 'Diciembre';
                                    break;
                                default:
                                    $mes = "NA";
                                    $dia = "NA";
                                    $anio = "NA";
                            }
                            return $dia . '/' . $mes . '/' . $anio;
                        }


                        ?>

                        <!-- ############ PAGE START-->

                        <?php

                        if (isset($_GET['empresa'])) {
                            $empresa = $adminEmpresas->dameEmpresa($_GET['empresa']);
                            $clientes = $adminClientes->dameClientes();
                            $formasPago = $adminFormasPago->dameFormasPago();
                            $metodosPago = $adminFormasPago->dameMetodosPago();
                            $usosCfdi = $adminFormasPago->dameUsosCfdi();
                            if (isset($_GET['movimiento'])) {
                                $movimiento = $adminPagos->damePago($_GET['movimiento']);
                                $detectado = 1;
                                //echo var_dump($movimiento);
                            } else {
                                $movimiento = null;
                                $detectado = 0;
                            }

                        ?>








                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Facturación de complementos </h5>

                                </div>
                                <form id="agregar-complemento">
                                    <div class="mb-5">
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserFname">Selecciona cliente</label>
                                                <select onchange="cargarClaves(this.value)" name="cliente" class="form-input">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($clientes as $cliente) {
                                                        if ($cliente->id == $movimiento->idCliente) {
                                                            echo "<option value='$cliente->id' selected>$cliente->nombre</option>";
                                                        } else {
                                                            echo "<option value='$cliente->id'>$cliente->nombre</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserLname">Razón social</label>
                                                <select name="clave_c" id="clave_c" class="form-select">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                </select>
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserFname">Método de pago</label>
                                                <select id="metodo_pago" name="metodo_pago" class="form-select">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($metodosPago as $metodoPago) {
                                                        if ($metodoPago->id == 1) {
                                                            echo "<option value='$metodoPago->id' selected>$metodoPago->metodo_pago</option>";
                                                        } else {
                                                            echo "<option value='$metodoPago->id'>$metodoPago->metodo_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserLname">Forma de pago</label>
                                                <select name="forma_pago" id="forma_pago" class="form-input">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($formasPago as $formaPago) {

                                                        if ($formaPago->id == 3) {
                                                            echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                                                        } else {
                                                            echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>


                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">

                                            <div>
                                                <label for="browserFname">Tipo de comprobante</label>
                                                <select id="tipo_comprobante" name="tipo_comprobante" class="form-input">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <option selected="" value=""></option>
                                                    <option value="I">Ingreso</option>
                                                    <option value="E">Egreso</option>
                                                    <option value="T">Traslado</option>
                                                    <option value="N">Nomina</option>
                                                    <option value="P" selected>Pago</option>
                                                </select>
                                            </div>

                                            <div>
                                                <label for="browserLname">Uso de CFDI</label>
                                                <select name="uso_cfdi" id="uso_cfdi" class="form-select">
                                                    <option value="" disabled selected>Selecciona una opción</option>
                                                    <?php
                                                    foreach ($usosCfdi as $usoCfdi) {


                                                        if ($usoCfdi->id == 3) {
                                                            echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                                                        } else {
                                                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                        }

                                                        //echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>


                                            <div>
                                                <label for="browserFname">Tipo de complemento (En desarrollo)</label>
                                                <select id="tipo_com" name="tipo_com" class="form-input">
                                                    <option value="T" selected>Típico</option>
                                                    <option value="4">4 %</option>
                                                    <option value="T0">Taza 0</option>
                                                    <option value="SV">Sin IVA</option>
                                                    
                                                </select>
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserCity">Fecha</label>
                                                <input type="date" class="form-input" value="<?php echo $movimiento->fecha_banco ?>" name="fecha" id="fecha">
                                            </div>

                                            <div>
                                                <label for="browserCity">Monto</label>
                                                <input type="text" class="form-input" value="<?php echo $movimiento->monto ?>" name="monto" id="monto" placeholder="$">
                                            </div>

                                        </div>

                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-4">
                                            <div>
                                                <label for="browserState">Folio fiscal</label>
                                                <input type="text" name="folio" id="folio" class="form-input" style="width: 1510px;">
                                            </div>

                                        </div>
                                        <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                            <div>
                                                <label for="browserCity">Monto a pagar</label>
                                                <input type="text" class="form-input" name="monto-pagar" id="monto-pagar" placeholder="$">
                                            </div>

                                            <div>
                                                <label for="browserCity">Número complemento</label>
                                                <input type="text" class="form-input" name="complemento" id="complemento">
                                            </div>

                                        </div>
                                    </div>




                                    <button type="submit" class="btn btn-primary !mt-6">Terminar</button>

                                </form>

                                <br>
                                <!-- extra large -->
                                <div x-data="modal">
                                    <!-- button -->
                                    <button type="button" class="btn btn-warning" @click="toggle">Ver facturas PPD</button>

                                    <!-- modal -->
                                    <div class="fixed inset-0 bg-[black]/60 z-[999]  hidden" :class="open && '!block'">
                                        <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                            <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-5xl my-8">
                                                <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                    <h5 class="font-bold text-lg">Facturas PPD</h5>
                                                </div>
                                                <div class="p-5">
                                                    <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">

                                                        <table id="miTabla" class="table-striped">

                                                            <thead>
                                                                <tr>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">ID Factura</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Acción</th>
                                                                    <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist" hidden>FFF</th>

                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php

                                                                foreach ($facturasPpd as $factura) {
                                                                    echo '<tr style="height: 100px;">';
                                                                    echo '<td  onclick="detonarModal(' . $factura->id . ', ' . "'" . $factura->token . "'" .  ')">' . $factura->id . '</td>';
                                                                    echo '<td>' . $factura->empresa_nombre . '</td>';
                                                                    echo '<td>$' . number_format($factura->total_iva, 2)  . '</td>';
                                                                    echo '<td>' . $factura->fecha_timbrado . '</td>';
                                                                    echo "<td><a href='https://sistema14.com/api/genera_factura.php?token=" . $factura->token . "&per=" . $factura->id . "' target='_blank'>" . $factura->uuid . "</a></td>";
                                                                    echo '<td><button onclick="agregarFactura(' . "'" . $factura->uuid . "'" . ')" type="button" class="btn btn-outline-primary" @click="toggle">Agregar factura</button></td>';
                                                                    echo '<td hidden>' . fechaComoCadenaFacturas($factura->fecha_timbrado)  . '</td>';
                                                                    echo '</tr>';
                                                                }

                                                                ?>

                                                            </tbody>

                                                        </table>

                                                    </div>
                                                    <div class="flex justify-end items-center mt-8">
                                                        <button type="button" class="btn btn-outline-danger" @click="toggle">Agregar Factura</button>
                                                        <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Salir</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div>
                                    <button onclick="enviarFactura()" id="boton-terminar" class="btn btn-primary !mt-6">Agregar Complemento</button>
                                </div>
                                <!-- vertically centered -->
                                <div class="mb-5" x-data="modal">
                                    <!-- button -->
                                    <div class="flex items-center">
                                        <button type="button" class="btn btn-info" @click="toggle">Exportar captura</button>
                                    </div>

                                    <!-- modal -->
                                    <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                        <div class="flex items-center justify-center min-h-screen px-4" @click.self="open = false">
                                            <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-lg my-8">
                                                <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                                    <h5 class="font-bold text-lg">Exportar folios</h5>
                                                </div>
                                                <div class="p-5">
                                                    <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">

                                                        <textarea name="captura" id="summernote"></textarea>
                                                        <script>
                                                            $('#summernote').summernote({
                                                                placeholder: 'Pega los folios aqui...',
                                                                tabsize: 2,
                                                                height: 120,
                                                                toolbar: false
                                                            });
                                                        </script>

                                                    </div>
                                                    <div class="flex justify-end items-center mt-8">
                                                        <button type="button" class="btn btn-outline-danger" onclick="enviarImportado()">Exportar</button>
                                                        <button type="button" class="btn btn-primary ltr:ml-4 rtl:mr-4" @click="toggle">Salir</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- script -->
                                <script>
                                    document.addEventListener("alpine:init", () => {
                                        Alpine.data("modal", (initialOpenState = false) => ({
                                            open: initialOpenState,
                                            toggle() {
                                                this.open = !this.open;
                                            },
                                        }));
                                    });
                                </script>




                            </div>
                    </div>
                    <br>
                    <div class="panel">
                        <div class="mb-5 flex items-center justify-between">
                            <table>
                                <thead>
                                    <td>Fólio fiscal</td>
                                    <td>Monto</td>
                                    <td>Restante</td>
                                    <td>Número</td>
                                </thead>
                                <tbody id="tablaDatos">

                                </tbody>
                            </table>
                        </div>
                    </div>





                <?php

                        } else {

                            $empresas = $adminEmpresas->dameEmpresasLite();


                ?>






                    <div class="panel">
                        <div class="mb-5 flex items-center justify-between">
                            <h5 class="text-lg font-semibold dark:text-white-light">Selecciona empresa</h5>

                        </div>
                        <form action="fac-facturacion-complementos.php" method="get">
                            <div class="mb-5">
                                <select id="seachable-select" name="empresa" style="display: none;">
                                    <?php
                                    foreach ($empresas as $empresa) {
                                        echo "<option value='$empresa->id'>$empresa->razon</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-success">Ir a facturar </button>
                        </form>
                    </div>
                    <!-- script -->
                    <script>
                        document.addEventListener("DOMContentLoaded", function(e) {
                            // seachable 
                            var options = {
                                searchable: true
                            };
                            NiceSelect.bind(document.getElementById("seachable-select"), options);
                        });
                    </script>

                <?php } ?>






                </div>
            </div>
        </div>
        <!-- end main content section -->

        <!-- start footer section -->
        <div class="mt-auto p-6 pt-0 text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
            © <span id="footer-year">2023</span>. Sistema 14 Ultra All rights reserved.
        </div>
        <!-- end footer section -->
    </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <!-- start hightlight js -->
    <link rel="stylesheet" href="assets/css/highlight.min.css" />
    <script src="assets/js/highlight.min.js"></script>
    <!-- end hightlight js -->
    <script src="assets/js/nice-select2.js"></script>
    <script src="assets/js/simple-datatables.js"></script>
    <script src=" https://cdn.jsdelivr.net/npm/dinero.js@1.9.1/build/umd/dinero.min.js "></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            if (<?php echo  intval($movimiento->idCliente) ?> != 0) {
                cargarClaves(<?php echo $movimiento->idCliente ?>);
            }


            const tableOptions = {
                sortable: true,
                searchable: true,
                perPage: 5,
                perPageSelect: [5, 10, 20, 30, 50],
                firstLast: true,
            };

            const datatable1 = new simpleDatatables.DataTable('#miTabla', tableOptions);
        });
    </script>
    <script>
        function agregarFactura(uuid) {
            var espacioFolioFiscal = document.getElementById('folio');
            espacioFolioFiscal.value = uuid;
        }
    </script>
    <script>
        function enviarImportado() {
            var captura = document.getElementById("summernote").value;
            var envio = new FormData();
            envio.append("captura", captura);
            envio.append("empresa", "<?php echo $_GET['empresa'] ?>");
            fetch("api/apiInfoImportacionComplemento.php", {
                    method: "POST",
                    body: envio
                }).then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    for (var f = 0; f < data.length; f++) {
                        enviarFacturaApi(data[f].uuid, data[f].monto, data[f].numero);
                    }
                });
        }
    </script>


    <script>
        function enviarFacturaApi(folio, monto, numero) {
            var datos = new FormData();
            datos.append('accion', 'ver');
            datos.append('folio', folio);
            fetch("api/apiComplementos.php", {
                    method: "POST",
                    body: datos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    if (data.id != null) {
                        var restante = data.saldo - monto;

                        restanteFormateado = restante.toLocaleString('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        });

                        montoFormateado = monto.toLocaleString('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        });

                        // Crear una fila de tabla
                        var row = "<tr><td>" + folio + "</td><td>" + montoFormateado + "</td><td>" + restanteFormateado + "</td><td>" + numero + "</td></tr>";



                        // Agregar la fila a la tabla
                        tablaBody = document.getElementById('tablaDatos');
                        tablaBody.innerHTML += row;

                        var factura = data;
                        factura.total_cubierto = monto;
                        factura.numero_pago = numero;

                        facturas.push(factura);
                        enviaDatos();

                        // Limpiar los campos del formulario después de agregarlos a la tabla
                        document.getElementById('folio').value = '';
                        document.getElementById('monto-pagar').value = '';
                        document.getElementById('complemento').value = '';

                    } else {
                        var restante = data.saldo - monto;

                        // Crear una fila de tabla
                        var row = "<tr style='color: red;'><td>" + folio + "</td><td>" + monto + "</td><td>" + restante.toLocaleString('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        }) + "</td><td>" + numero + "</td></tr>";



                        // Agregar la fila a la tabla
                        tablaBody = document.getElementById('tablaDatos');
                        tablaBody.innerHTML += row;

                        var factura = data;
                        factura.total_cubierto = monto;
                        factura.numero_pago = numero;

                        facturas.push(factura);
                        enviaDatos();

                        // Limpiar los campos del formulario después de agregarlos a la tabla
                        document.getElementById('folio').value = '';
                        document.getElementById('monto-pagar').value = '';
                        document.getElementById('complemento').value = '';
                    }


                });






        }
    </script>



    <script>
        var espacioClaves = document.getElementById("clave_c");
        var clavesCortas = [];

        function cargarClaves(cliente) {
            clavesCortas = [];
            espacioClaves.innerHTML = "";
            fetch("api/apiReporteClavesCortas.php?accion=cliente&idCliente=" + cliente, {
                    method: "GET",
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {


                    for (var i = 0; i < data.aaData.length; i++) {
                        var option = document.createElement("option");
                        option.value = data.aaData[i].id;
                        option.textContent = data.aaData[i].rfc + " - " + data.aaData[i].clave_corta + " - " + data.aaData[i].razon_social;
                        espacioClaves.appendChild(option);
                        clavesCortas.push(data.aaData[i]);
                    }

                });
        }
    </script>



    <script>
        function agregarALista() {
            var folioFiscal = document.getElementById("folio").value;
        }
    </script>















    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));

            // content section
            Alpine.data('sales', () => ({
                init() {
                    isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;
                    isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;

                    const revenueChart = null;
                    const salesByCategory = null;
                    const dailySales = null;
                    const totalOrders = null;

                    // revenue
                    setTimeout(() => {
                        this.revenueChart = new ApexCharts(this.$refs.revenueChart, this.revenueChartOptions);
                        this.$refs.revenueChart.innerHTML = '';
                        this.revenueChart.render();

                        // sales by category
                        this.salesByCategory = new ApexCharts(this.$refs.salesByCategory, this.salesByCategoryOptions);
                        this.$refs.salesByCategory.innerHTML = '';
                        this.salesByCategory.render();

                        // daily sales
                        this.dailySales = new ApexCharts(this.$refs.dailySales, this.dailySalesOptions);
                        this.$refs.dailySales.innerHTML = '';
                        this.dailySales.render();

                        // total orders
                        this.totalOrders = new ApexCharts(this.$refs.totalOrders, this.totalOrdersOptions);
                        this.$refs.totalOrders.innerHTML = '';
                        this.totalOrders.render();
                    }, 300);

                    this.$watch('$store.app.theme', () => {
                        isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;

                        this.revenueChart.updateOptions(this.revenueChartOptions);
                        this.salesByCategory.updateOptions(this.salesByCategoryOptions);
                        this.dailySales.updateOptions(this.dailySalesOptions);
                        this.totalOrders.updateOptions(this.totalOrdersOptions);
                    });

                    this.$watch('$store.app.rtlClass', () => {
                        isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;
                        this.revenueChart.updateOptions(this.revenueChartOptions);
                    });
                },

                // revenue
                get revenueChartOptions() {
                    return {
                        series: [{
                                name: 'Income',
                                data: [16800, 16800, 15500, 17800, 15500, 17000, 19000, 16000, 15000, 17000, 14000, 17000],
                            },
                            {
                                name: 'Expenses',
                                data: [16500, 17500, 16200, 17300, 16000, 19500, 16000, 17000, 16000, 19000, 18000, 19000],
                            },
                        ],
                        chart: {
                            height: 325,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            zoom: {
                                enabled: false,
                            },
                            toolbar: {
                                show: false,
                            },
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            curve: 'smooth',
                            width: 2,
                            lineCap: 'square',
                        },
                        dropShadow: {
                            enabled: true,
                            opacity: 0.2,
                            blur: 10,
                            left: -7,
                            top: 22,
                        },
                        colors: isDark ? ['#2196f3', '#e7515a'] : ['#1b55e2', '#e7515a'],
                        markers: {
                            discrete: [{
                                    seriesIndex: 0,
                                    dataPointIndex: 6,
                                    fillColor: '#1b55e2',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                                {
                                    seriesIndex: 1,
                                    dataPointIndex: 5,
                                    fillColor: '#e7515a',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                            ],
                        },
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        xaxis: {
                            axisBorder: {
                                show: false,
                            },
                            axisTicks: {
                                show: false,
                            },
                            crosshairs: {
                                show: true,
                            },
                            labels: {
                                offsetX: isRtl ? 2 : 0,
                                offsetY: 5,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-xaxis-title',
                                },
                            },
                        },
                        yaxis: {
                            tickAmount: 7,
                            labels: {
                                formatter: (value) => {
                                    return value / 1000 + 'K';
                                },
                                offsetX: isRtl ? -30 : -10,
                                offsetY: 0,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-yaxis-title',
                                },
                            },
                            opposite: isRtl ? true : false,
                        },
                        grid: {
                            borderColor: isDark ? '#191e3a' : '#e0e6ed',
                            strokeDashArray: 5,
                            xaxis: {
                                lines: {
                                    show: true,
                                },
                            },
                            yaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 0,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        legend: {
                            position: 'top',
                            horizontalAlign: 'right',
                            fontSize: '16px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            itemMargin: {
                                horizontal: 10,
                                vertical: 5,
                            },
                        },
                        tooltip: {
                            marker: {
                                show: true,
                            },
                            x: {
                                show: false,
                            },
                        },
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: isDark ? 0.19 : 0.28,
                                opacityTo: 0.05,
                                stops: isDark ? [100, 100] : [45, 100],
                            },
                        },
                    };
                },

                // sales by category
                get salesByCategoryOptions() {
                    return {
                        series: [985, 737, 270],
                        chart: {
                            type: 'donut',
                            height: 460,
                            fontFamily: 'Nunito, sans-serif',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 25,
                            colors: isDark ? '#0e1726' : '#fff',
                        },
                        colors: isDark ? ['#5c1ac3', '#e2a03f', '#e7515a', '#e2a03f'] : ['#e2a03f', '#5c1ac3', '#e7515a'],
                        legend: {
                            position: 'bottom',
                            horizontalAlign: 'center',
                            fontSize: '14px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            height: 50,
                            offsetY: 20,
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    size: '65%',
                                    background: 'transparent',
                                    labels: {
                                        show: true,
                                        name: {
                                            show: true,
                                            fontSize: '29px',
                                            offsetY: -10,
                                        },
                                        value: {
                                            show: true,
                                            fontSize: '26px',
                                            color: isDark ? '#bfc9d4' : undefined,
                                            offsetY: 16,
                                            formatter: (val) => {
                                                return val;
                                            },
                                        },
                                        total: {
                                            show: true,
                                            label: 'Total',
                                            color: '#888ea8',
                                            fontSize: '29px',
                                            formatter: (w) => {
                                                return w.globals.seriesTotals.reduce(function(a, b) {
                                                    return a + b;
                                                }, 0);
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        labels: ['Apparel', 'Sports', 'Others'],
                        states: {
                            hover: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                            active: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                        },
                    };
                },

                // daily sales
                get dailySalesOptions() {
                    return {
                        series: [{
                                name: 'Sales',
                                data: [44, 55, 41, 67, 22, 43, 21],
                            },
                            {
                                name: 'Last Week',
                                data: [13, 23, 20, 8, 13, 27, 33],
                            },
                        ],
                        chart: {
                            height: 160,
                            type: 'bar',
                            fontFamily: 'Nunito, sans-serif',
                            toolbar: {
                                show: false,
                            },
                            stacked: true,
                            stackType: '100%',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 1,
                        },
                        colors: ['#e2a03f', '#e0e6ed'],
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                legend: {
                                    position: 'bottom',
                                    offsetX: -10,
                                    offsetY: 0,
                                },
                            },
                        }, ],
                        xaxis: {
                            labels: {
                                show: false,
                            },
                            categories: ['Sun', 'Mon', 'Tue', 'Wed', 'Thur', 'Fri', 'Sat'],
                        },
                        yaxis: {
                            show: false,
                        },
                        fill: {
                            opacity: 1,
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '25%',
                            },
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            show: false,
                            xaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 10,
                                right: -20,
                                bottom: -20,
                                left: -20,
                            },
                        },
                    };
                },

                // total orders
                get totalOrdersOptions() {
                    return {
                        series: [{
                            name: 'Sales',
                            data: [28, 40, 36, 52, 38, 60, 38, 52, 36, 40],
                        }, ],
                        chart: {
                            height: 290,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            sparkline: {
                                enabled: true,
                            },
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 2,
                        },
                        colors: isDark ? ['#00ab55'] : ['#00ab55'],
                        labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
                        yaxis: {
                            min: 0,
                            show: false,
                        },
                        grid: {
                            padding: {
                                top: 125,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        fill: {
                            opacity: 1,
                            type: 'gradient',
                            gradient: {
                                type: 'vertical',
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: 0.3,
                                opacityTo: 0.05,
                                stops: [100, 100],
                            },
                        },
                        tooltip: {
                            x: {
                                show: false,
                            },
                        },
                    };
                },
            }));
        });
    </script>
    <script>
        var facturas = [];

        function enviarFactura() {

            // Obtener los valores de los campos del formulario
            var folio = document.getElementById('folio').value;
            var monto = document.getElementById('monto-pagar').value;
            var numero = document.getElementById('complemento').value;

            var datos = new FormData();
            datos.append('accion', 'ver');
            datos.append('folio', folio);
            fetch("api/apiComplementos.php", {
                    method: "POST",
                    body: datos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    if (data.id != null) {
                        var restante = data.saldo - monto;

                        // Crear una fila de tabla
                        var row = "<tr><td>" + folio + "</td><td>" + monto + "</td><td>" + restante.toLocaleString('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        }) + "</td><td>" + numero + "</td></tr>";



                        // Agregar la fila a la tabla
                        tablaBody = document.getElementById('tablaDatos');
                        tablaBody.innerHTML += row;

                        var factura = data;
                        factura.total_cubierto = monto;
                        factura.numero_pago = numero;

                        facturas.push(factura);
                        enviaDatos();

                        // Limpiar los campos del formulario después de agregarlos a la tabla
                        document.getElementById('folio').value = '';
                        document.getElementById('monto-pagar').value = '';
                        document.getElementById('complemento').value = '';

                    } else {
                        alert('folio no encontrado');
                    }


                });






        }
    </script>
    <script>
        function enviaDatos() {
            var facturaJSON = JSON.stringify(facturas);
            console.log(facturaJSON);
        }
    </script>
    <script>
        const formUsuario = document.getElementById("agregar-complemento");

        formUsuario.addEventListener("submit", function(e) {
            e.preventDefault();
            var datosComplemento = new FormData(formUsuario);
            datosComplemento.append('facturas', JSON.stringify(facturas));
            datosComplemento.append("accion", "agregar");
            datosComplemento.append("pago", "<?php echo intval($_GET['movimiento']) ?>");
            datosComplemento.append("empresa", "<?php echo $_GET['empresa'] ?>");
            fetch("api/apiComplementos.php", {
                    method: "POST",
                    body: datosComplemento,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        icon: data.status,
                        title: data.mensaje,
                        showConfirmButton: true
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirigir a la página index
                            window.location.href = "fac-complementos.php"; // Cambia "index.php" por la URL de tu página index
                        }
                    });
                });
        });
    </script>
    <script>
        function verFactura(folioFiscal) {
            var datos = new FormData();
            datos.append('accion', 'ver');
            datos.append('folio', folioFiscal);
            fetch("api/apiComplementos.php", {
                    method: "POST",
                    body: datos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    return data;


                });
        }
    </script>

</body>

</html>