<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Sistema 14</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />

    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>

</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <style>
        @keyframes flickerAnimation {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }

        @-o-keyframes flickerAnimation {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }

        @-moz-keyframes flickerAnimation {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }

        @-webkit-keyframes flickerAnimation {
            0% {
                opacity: 1;
            }

            50% {
                opacity: 0;
            }

            100% {
                opacity: 1;
            }
        }

        .animate-flicker {
            -webkit-animation: flickerAnimation .5s infinite;
            -moz-animation: flickerAnimation .5s infinite;
            -o-animation: flickerAnimation .5s infinite;
            animation: flickerAnimation .5s infinite;
        }

        .date-text {
            display: none;
        }

        .date:hover .date-text {
            display: inline;
        }

        .date:hover .arc {
            display: none;
        }

        .rotated-svg {
            animation: rotateLeft 2s linear infinite;
            /* Ajusta la duración y el tipo de animación según tus necesidades */
        }

        @keyframes rotateLeft {
            from {
                transform: rotate(0deg);
                /* La posición inicial de la rotación */
            }

            to {
                transform: rotate(-360deg);
                /* La posición final de la rotación (360 grados en sentido antihorario para hacer una rotación completa) */
            }
        }
    </style>
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php

    session_start();
    include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->


        <?php

        if ($_SESSION["tipo_usuario"] == 'archivo') {
            echo "<script>window.location.href = 'empresas.php';</script>";
        } else {
            include "template/barra.php";
        }

        ?>
        <!-- end sidebar section -->

        <div class="main-content flex flex-col min-h-screen">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>

            <!-- end header section -->
            <script>
                var clientes = [];
                var grupos = [];

                function Grupo(id, saldo) {
                    this.id = id;
                    this.saldo = saldo;
                }
            </script>
            <script>
                function UserProfile(id, path, name, role, email, location, phone, posts, followers, following) {
                    this.id = id;
                    this.path = path;
                    this.name = name;
                    this.role = role;
                    this.email = email;
                    this.location = location;
                    this.phone = phone;
                    this.posts = posts;
                    this.followers = followers;
                    this.following = following;
                }
                var arregloContactos = [];
            </script>
            <?php




            include_once('api/adminGrupos.php');
            include_once('api/adminUtil.php');
            include_once('api/adminClientes.php');
            include_once('api/encriptador.php');
            include_once 'api/adminEmpresas.php';
            include_once 'api/doxeador.php';

            $adminUtil = new AdministradorUtil();
            $adminClientes = new AdministradorClientes();
            $adminEmpresas = new AdminEmpresas();
            $empresas = $adminEmpresas->dameEmpresasLite();
            $tipo_cambio =  $adminUtil->dameUltimoTipoCambio()->tipo_cambio;
            $ultimos_tipos_cambio = $adminUtil->dameUltimos5TiposCambio();
            $clientes = $adminClientes->dameClientesAdministrador();
            $token = $_SESSION['token_autoriza'];
            $doxeo = dameDoxeo();

            //acortar a 20 caracteres 
            $token = substr($token, 0, 20);
            $token = $token . "...";
            $tokenInfo = desencriptar($_SESSION['token_autoriza']);
            $tokenInfo = explode(",", $tokenInfo);
            $idUsuario = $tokenInfo[0];
            $nombreUsuario = $tokenInfo[1];
            $fecha = $tokenInfo[2];
            $hora = $tokenInfo[3];
            $fechaToken = $fecha . " " . $hora;
            
            //aumentar una hora y media 

            $fechaToken = strtotime('+30 minutes', strtotime($fechaToken));

            $fechaActual = date("Y-m-d H:i:s");
            $fechaTokenFormato = date("d-m-Y H:i:s", $fechaToken);
            //comparar 
            $diferencia = strtotime($fechaActual) - strtotime($fechaTokenFormato);
            if ($diferencia > 0) {
                $_SESSION['token_autoriza'] = null;
                $_SESSION['id_banca_autoriza'] = null;
                $_SESSION['nombre_banca_autoriza'] = null;
                $token = null;
            }

            $clientesSelect = "";
            foreach ($clientes as $cliente) {
                echo '<script> clientes.push(' . $cliente->id . '); </script>';
                $clientesSelect .= '<option value="' . $cliente->id . '">' . $cliente->nombre . '</option>';
                $saldos = $adminClientes->dameSaldosPorCliente($cliente->id);
                if ($cliente->saldo < -1) {
                    $alerta = "Alerta cliente negativo";
                } else {
                    $alerta = "";
                }
                if ($cliente->clave_corta != '') {
                    $claveCorta = $cliente->clave_corta;
                } else {
                    $claveCorta = "Sin clave";
                }
                echo '<script> arregloContactos.push(new UserProfile(' . $cliente->id . ',"' . $cliente->imagen . '","' . $cliente->nombre . '","' . $cliente->rol . '","' . $saldos[0]->cheques_pend_dinero . '","$' . number_format($cliente->saldo, 2) . '","' . "$ " . number_format($saldos[0]->dinero_sin_fact, 2) . '","' . $alerta . '","' . $claveCorta . '",0));</script>';
                //echo "<script> arregloContactos.push(new UserProfile($cliente->id, '$cliente->imagen', '$cliente->nombre', '$cliente->rol', '$saldos[0]->cheques_pend_dinero', 'CARGANDO', 'number_format($saldos[0]->dinero_sin_fact, 2)', '$cliente->posts', '$cliente->followers', '$cliente->following'));</script>";

            }

            ?>







            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->

                <div x-data="contacts">
                    <div class="flex flex-wrap items-center justify-between gap-4">
                        <h2 class="text-xl">Carteras </h2>
                        <div class="flex w-full flex-col gap-4 sm:w-auto sm:flex-row sm:items-center sm:gap-3">
                            <div class="flex gap-3">
                                <div>

                                    <div class="fixed inset-0 z-[999] hidden overflow-y-auto bg-[black]/60" :class="addContactModal && '!block'">
                                        <div class="flex min-h-screen items-center justify-center px-4" @click.self="addContactModal = false">
                                            <div x-show="addContactModal" x-transition x-transition.duration.300 class="panel my-8 w-[90%] max-w-lg overflow-hidden rounded-lg border-0 p-0 md:w-full">
                                                <button type="button" class="absolute top-4 text-white-dark hover:text-dark ltr:right-4 rtl:left-4" @click="addContactModal = false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6">
                                                        <line x1="18" y1="6" x2="6" y2="18"></line>
                                                        <line x1="6" y1="6" x2="18" y2="18"></line>
                                                    </svg>
                                                </button>
                                                <h3 class="bg-[#fbfbfb] py-3 text-lg font-medium ltr:pl-5 ltr:pr-[50px] rtl:pr-5 rtl:pl-[50px] dark:bg-[#121c2c]" x-text="params.id ? 'Edit Contact' : 'Add Contact'"></h3>
                                                <div class="p-5">
                                                    <form @submit.prevent="saveUser">
                                                        <div class="mb-5">
                                                            <label for="name">Name</label>
                                                            <input id="name" type="text" placeholder="Enter Name" class="form-input" x-model="params.name" />
                                                        </div>
                                                        <div class="mb-5">
                                                            <label for="email">Email</label>
                                                            <input id="email" type="email" placeholder="Enter Email" class="form-input" x-model="params.email" />
                                                        </div>
                                                        <div class="mb-5">
                                                            <label for="number">Phone Number</label>
                                                            <input id="number" type="text" placeholder="Enter Phone Number" class="form-input" x-model="params.phone" />
                                                        </div>
                                                        <div class="mb-5">
                                                            <label for="occupation">Occupation</label>
                                                            <input id="occupation" type="text" placeholder="Enter Occupation" class="form-input" x-model="params.role" />
                                                        </div>
                                                        <div class="mb-5">
                                                            <label for="address">Address</label>
                                                            <textarea id="address" rows="3" placeholder="Enter Address" class="form-textarea min-h-[130px] resize-none" x-model="params.location"></textarea>
                                                        </div>
                                                        <div class="mt-8 flex items-center justify-end">
                                                            <button type="button" class="btn btn-outline-danger" @click="addContactModal = false">
                                                                Cancel
                                                            </button>
                                                            <button type="submit" class="btn btn-primary ltr:ml-4 rtl:mr-4" x-text="params.id ? 'Update' : 'Add'"></button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <?php 
                                
                                   if ($doxeo['city'] != "Zapopan") {
                               echo '<div class="text-3xl font-bold ltr:mr-3 rtl:ml-3 animate-flicker" style="color: red;"> ' . $doxeo['city'] . ", " . $doxeo['regionName'] . '</div>';
                            } else {
                                echo '<div class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> ' . $doxeo['city'] . ", " . $doxeo['regionName'] . '</div>';
                            }
                                
                                ?>


                                <div style="justify-content: center;">
                                    <div x-data="modal">
                                        <!-- button -->
                                        <button type="button" class="btn btn-outline-primary p-2" @click="toggle">TOKEN ()</button>

                                        <!-- modal -->
                                        <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                            <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 py-1 px-4 rounded-lg overflow-hidden w-full max-w-sm my-8">
                                                    <div class="flex items-center justify-between p-5 font-semibold text-lg dark:text-white">Token Retiros (ADMINISTRADOR)

                                                    </div>
                                                    <div class="p-5">
                                                        <form id="formularioToken">
                                                            <div class="relative mb-4">

                                                                <input type="email" name="email" placeholder="Email" class="form-input ltr:pl-10 rtl:pr-10" />
                                                            </div>
                                                            <div class="relative mb-4">

                                                                <input type="password" name="pass" placeholder="Contraseña" class="form-input ltr:pl-10 rtl:pr-10" />
                                                            </div>
                                                            <div class="relative mb-4">

                                                                <input type="password" name="codigo_2fa" placeholder="2FA" class="form-input ltr:pl-10 rtl:pr-10" />
                                                            </div>
                                                            <button type="submit" class="btn btn-primary w-full">Obtener Token</button>
                                                        </form>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        document.addEventListener("alpine:init", () => {
                                            Alpine.data("modal", (initialOpenState = false) => ({
                                                open: initialOpenState,

                                                toggle() {
                                                    this.open = !this.open;
                                                },
                                            }));
                                        });
                                    </script>
                                </div>



                                <div style="justify-content: center;">
                                    <div x-data="modal">
                                        <!-- button -->
                                        <button type="button" class="btn btn-outline-primary p-2" @click="toggle">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 24 24" fill="none">

                                                <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" />

                                                <g id="SVGRepo_iconCarrier">
                                                    <path d="M21 12C21 16.714 21 19.0711 19.682 20.5355C18.364 22 16.2426 22 12 22C7.75736 22 5.63604 22 4.31802 20.5355C3 19.0711 3 16.714 3 12C3 7.28595 3 4.92893 4.31802 3.46447C5.63604 2 7.75736 2 12 2C16.2426 2 18.364 2 19.682 3.46447C20.5583 4.43821 20.852 5.80655 20.9504 8" stroke="#1C274D" stroke-width="1.5" stroke-linecap="round" />
                                                    <path d="M7 8C7 7.53501 7 7.30252 7.05111 7.11177C7.18981 6.59413 7.59413 6.18981 8.11177 6.05111C8.30252 6 8.53501 6 9 6H15C15.465 6 15.6975 6 15.8882 6.05111C16.4059 6.18981 16.8102 6.59413 16.9489 7.11177C17 7.30252 17 7.53501 17 8C17 8.46499 17 8.69748 16.9489 8.88823C16.8102 9.40587 16.4059 9.81019 15.8882 9.94889C15.6975 10 15.465 10 15 10H9C8.53501 10 8.30252 10 8.11177 9.94889C7.59413 9.81019 7.18981 9.40587 7.05111 8.88823C7 8.69748 7 8.46499 7 8Z" stroke="#1C274D" stroke-width="1.5" />
                                                    <circle cx="8" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="8" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="17" r="1" fill="#1C274D" />
                                                </g>

                                            </svg>
                                            Dispersor
                                        </button>

                                        <!-- modal -->
                                        <div class="fixed inset-0 bg-[black]/60 z-[999]  hidden" :class="open && '!block'">
                                            <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-5xl my-8">

                                                    <div class="p-5">


                                                        <div class="relative mb-4">
                                                            <select name="unidades_calculo" id="unidades_calculo" class="form-input">
                                                                <option value="">Seleccione cantidad de bancas</option>
                                                                <option value="1">1 Banca</option>
                                                                <option value="2">2 Bancas</option>
                                                                <option value="3">3 Bancas</option>
                                                                <option value="4">4 Bancas</option>
                                                                <option value="5">5 Bancas</option>

                                                            </select>
                                                        </div>

                                                        <div class="relative mb-4">
                                                            <input type="text" name="monto_calculo" id="monto_calculo" size="18" maxlength="100" placeholder="Monto..." step="0.01" class="form-input" oninput="formatearNumeroBarra()">

                                                        </div>
                                                        <div class="relative mb-4">
                                                            <input type="text" name="cuentas_calculo" id="cuentas_calculo" size="18" maxlength="100" placeholder="Separadas por comas" step="0.01" class="form-input" oninput="formatearNumeroBarra()">

                                                        </div>
                                                        <div class="relative mb-4">
                                                            <div class="table-responsive">


                                                                <table style="color: black;">
                                                                    <thead>
                                                                        <tr>

                                                                            <th>Empresa de salida</th>
                                                                            <th>Monto</th>


                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="tablaCalculadoraDisp">
                                                                    </tbody>
                                                                </table>

                                                            </div>
                                                        </div>
                                                        <button type="button" onclick="calcularDisp()" class="btn btn-primary w-full">Calcular</button>

                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        document.addEventListener("alpine:init", () => {
                                            Alpine.data("modal", (initialOpenState = false) => ({
                                                open: initialOpenState,

                                                toggle() {
                                                    this.open = !this.open;
                                                },
                                            }));
                                        });
                                    </script>
                                </div>



                                <div style="justify-content: center;">
                                    <div x-data="modal">
                                        <!-- button -->
                                        <button type="button" class="btn btn-outline-primary p-2" @click="toggle">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 24 24" fill="none">

                                                <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" />

                                                <g id="SVGRepo_iconCarrier">
                                                    <path d="M21 12C21 16.714 21 19.0711 19.682 20.5355C18.364 22 16.2426 22 12 22C7.75736 22 5.63604 22 4.31802 20.5355C3 19.0711 3 16.714 3 12C3 7.28595 3 4.92893 4.31802 3.46447C5.63604 2 7.75736 2 12 2C16.2426 2 18.364 2 19.682 3.46447C20.5583 4.43821 20.852 5.80655 20.9504 8" stroke="#1C274D" stroke-width="1.5" stroke-linecap="round" />
                                                    <path d="M7 8C7 7.53501 7 7.30252 7.05111 7.11177C7.18981 6.59413 7.59413 6.18981 8.11177 6.05111C8.30252 6 8.53501 6 9 6H15C15.465 6 15.6975 6 15.8882 6.05111C16.4059 6.18981 16.8102 6.59413 16.9489 7.11177C17 7.30252 17 7.53501 17 8C17 8.46499 17 8.69748 16.9489 8.88823C16.8102 9.40587 16.4059 9.81019 15.8882 9.94889C15.6975 10 15.465 10 15 10H9C8.53501 10 8.30252 10 8.11177 9.94889C7.59413 9.81019 7.18981 9.40587 7.05111 8.88823C7 8.69748 7 8.46499 7 8Z" stroke="#1C274D" stroke-width="1.5" />
                                                    <circle cx="8" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="8" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="17" r="1" fill="#1C274D" />
                                                </g>

                                            </svg>
                                            Banking
                                        </button>

                                        <!-- modal -->
                                        <div class="fixed inset-0 bg-[black]/60 z-[999]  hidden" :class="open && '!block'">
                                            <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden w-full max-w-5xl my-8">
                                                    <div class="flex items-center justify-between p-5 font-semibold text-lg dark:text-white">Calculadora de banking
                                                        <button onclick="calculoExel()" type="button" class="btn btn-success">Exel</button>
                                                    </div>
                                                    <div class="p-5">


                                                        <div class="relative mb-4">
                                                            <select name="id_empresa_cal" id="id_empresa_cal" class="form-input">
                                                                <option value="">Seleccione una empresa</option>
                                                                <?php

                                                                foreach ($empresas as $empresa) {
                                                                    echo '<option value="' . $empresa->id . '">' . $empresa->razon . '</option>';
                                                                }


                                                                ?>
                                                            </select>
                                                        </div>

                                                        <div class="relative mb-4">
                                                            <input type="text" name="dinero_empresa" id="dinero_empresa" size="18" maxlength="100" placeholder="Monto..." step="0.01" class="form-input" oninput="formatearNumeroBarra()">

                                                        </div>
                                                        <div class="relative mb-4">
                                                            <div class="table-responsive">


                                                                <table style="color: black;">
                                                                    <thead>
                                                                        <tr>

                                                                            <th>Proveedor</th>
                                                                            <th>Monto</th>
                                                                            <th>% calculado</th>
                                                                            <th>% capturado</th>


                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="tablaCalculadora">
                                                                    </tbody>
                                                                </table>

                                                            </div>
                                                        </div>
                                                        <button type="button" onclick="calcularEmpresas()" class="btn btn-primary w-full">Calcular</button>

                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        document.addEventListener("alpine:init", () => {
                                            Alpine.data("modal", (initialOpenState = false) => ({
                                                open: initialOpenState,

                                                toggle() {
                                                    this.open = !this.open;
                                                },
                                            }));
                                        });
                                    </script>
                                </div>





                                <div style="justify-content: center;">
                                    <div x-data="modal">

                                        <button type="button" class="btn btn-outline-primary p-2" @click="toggle"><svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 24 24" fill="none">

                                                <g id="SVGRepo_bgCarrier" stroke-width="0" />

                                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round" />

                                                <g id="SVGRepo_iconCarrier">
                                                    <path d="M21 12C21 16.714 21 19.0711 19.682 20.5355C18.364 22 16.2426 22 12 22C7.75736 22 5.63604 22 4.31802 20.5355C3 19.0711 3 16.714 3 12C3 7.28595 3 4.92893 4.31802 3.46447C5.63604 2 7.75736 2 12 2C16.2426 2 18.364 2 19.682 3.46447C20.5583 4.43821 20.852 5.80655 20.9504 8" stroke="#1C274D" stroke-width="1.5" stroke-linecap="round" />
                                                    <path d="M7 8C7 7.53501 7 7.30252 7.05111 7.11177C7.18981 6.59413 7.59413 6.18981 8.11177 6.05111C8.30252 6 8.53501 6 9 6H15C15.465 6 15.6975 6 15.8882 6.05111C16.4059 6.18981 16.8102 6.59413 16.9489 7.11177C17 7.30252 17 7.53501 17 8C17 8.46499 17 8.69748 16.9489 8.88823C16.8102 9.40587 16.4059 9.81019 15.8882 9.94889C15.6975 10 15.465 10 15 10H9C8.53501 10 8.30252 10 8.11177 9.94889C7.59413 9.81019 7.18981 9.40587 7.05111 8.88823C7 8.69748 7 8.46499 7 8Z" stroke="#1C274D" stroke-width="1.5" />
                                                    <circle cx="8" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="8" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="12" cy="17" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="13" r="1" fill="#1C274D" />
                                                    <circle cx="16" cy="17" r="1" fill="#1C274D" />
                                                </g>

                                            </svg></button>


                                        <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                                            <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                                                <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 py-1 px-4 rounded-lg overflow-hidden w-full max-w-sm my-8">
                                                    <div class="flex items-center justify-between p-5 font-semibold text-lg dark:text-white">Calculadora de saldos

                                                    </div>
                                                    <div class="p-5">

                                                        <div class="relative mb-4">
                                                            <select name="calculadora_modo" id="calculadora_modo" class="form-input">
                                                                <option selected value="necesito">Dinero que necesito</option>
                                                                <option value="queda">Dinero que me queda</option>
                                                            </select>
                                                        </div>
                                                        <div class="relative mb-4">
                                                            <select name="id_cliente" id="id_cliente" class="form-input">
                                                                <option value="">Seleccione una cartera</option>
                                                                <?php echo $clientesSelect ?>
                                                            </select>
                                                        </div>

                                                        <div class="relative mb-4">
                                                            <input type="text" name="dinero" id="dinero" size="18" maxlength="100" placeholder="Monto..." step="0.01" class="form-input" oninput="formatearNumeroBarra()">
                                                            <input type="hidden" value="si" name="calculo" size="18" maxlength="100" class="form-control rounded-input">

                                                        </div>
                                                        <div class="relative mb-4">
                                                            <input disabled type="text" name="resultadoCalculadora" id="resultadoCalculadora" size="18" maxlength="100" placeholder="Resultado..." step="0.01" class="form-input">
                                                        </div>
                                                        <button type="button" onclick="calcular()" class="btn btn-primary w-full">Calcular</button>

                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        document.addEventListener("alpine:init", () => {
                                            Alpine.data("modal", (initialOpenState = false) => ({
                                                open: initialOpenState,

                                                toggle() {
                                                    this.open = !this.open;
                                                },
                                            }));
                                        });
                                    </script>
                                </div>

                                <div>
                                    <button type="button" class="btn btn-outline-primary p-2" @click="actualizarSaldos()">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" id="rotarSvg" class="h-5 w-5">
                                            <path d="M13.5 2c-5.621 0-10.211 4.443-10.475 10h-3.025l5 6.625 5-6.625h-2.975c.257-3.351 3.06-6 6.475-6 3.584 0 6.5 2.916 6.5 6.5s-2.916 6.5-6.5 6.5c-1.863 0-3.542-.793-4.728-2.053l-2.427 3.216c1.877 1.754 4.389 2.837 7.155 2.837 5.79 0 10.5-4.71 10.5-10.5s-4.71-10.5-10.5-10.5z" />
                                        </svg>
                                    </button>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-outline-primary p-2" :class="{ 'bg-primary text-white': displayType === 'list' }" @click="setDisplayType('list')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5">
                                            <path d="M2 5.5L3.21429 7L7.5 3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            <path opacity="0.5" d="M2 12.5L3.21429 14L7.5 10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M2 19.5L3.21429 21L7.5 17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M22 19L12 19" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                            <path opacity="0.5" d="M22 12L12 12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                            <path d="M22 5L12 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" />
                                        </svg>
                                    </button>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-outline-primary p-2" :class="{ 'bg-primary text-white': displayType === 'grid' }" @click="setDisplayType('grid')">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5">
                                            <path opacity="0.5" d="M2.5 6.5C2.5 4.61438 2.5 3.67157 3.08579 3.08579C3.67157 2.5 4.61438 2.5 6.5 2.5C8.38562 2.5 9.32843 2.5 9.91421 3.08579C10.5 3.67157 10.5 4.61438 10.5 6.5C10.5 8.38562 10.5 9.32843 9.91421 9.91421C9.32843 10.5 8.38562 10.5 6.5 10.5C4.61438 10.5 3.67157 10.5 3.08579 9.91421C2.5 9.32843 2.5 8.38562 2.5 6.5Z" stroke="currentColor" stroke-width="1.5" />
                                            <path opacity="0.5" d="M13.5 17.5C13.5 15.6144 13.5 14.6716 14.0858 14.0858C14.6716 13.5 15.6144 13.5 17.5 13.5C19.3856 13.5 20.3284 13.5 20.9142 14.0858C21.5 14.6716 21.5 15.6144 21.5 17.5C21.5 19.3856 21.5 20.3284 20.9142 20.9142C20.3284 21.5 19.3856 21.5 17.5 21.5C15.6144 21.5 14.6716 21.5 14.0858 20.9142C13.5 20.3284 13.5 19.3856 13.5 17.5Z" stroke="currentColor" stroke-width="1.5" />
                                            <path d="M2.5 17.5C2.5 15.6144 2.5 14.6716 3.08579 14.0858C3.67157 13.5 4.61438 13.5 6.5 13.5C8.38562 13.5 9.32843 13.5 9.91421 14.0858C10.5 14.6716 10.5 15.6144 10.5 17.5C10.5 19.3856 10.5 20.3284 9.91421 20.9142C9.32843 21.5 8.38562 21.5 6.5 21.5C4.61438 21.5 3.67157 21.5 3.08579 20.9142C2.5 20.3284 2.5 19.3856 2.5 17.5Z" stroke="currentColor" stroke-width="1.5" />
                                            <path d="M13.5 6.5C13.5 4.61438 13.5 3.67157 14.0858 3.08579C14.6716 2.5 15.6144 2.5 17.5 2.5C19.3856 2.5 20.3284 2.5 20.9142 3.08579C21.5 3.67157 21.5 4.61438 21.5 6.5C21.5 8.38562 21.5 9.32843 20.9142 9.91421C20.3284 10.5 19.3856 10.5 17.5 10.5C15.6144 10.5 14.6716 10.5 14.0858 9.91421C13.5 9.32843 13.5 8.38562 13.5 6.5Z" stroke="currentColor" stroke-width="1.5" />
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <div class="relative">
                                <input type="text" placeholder="Buscar cartera..." class="peer form-input py-2 ltr:pr-11 rtl:pl-11" x-model="searchUser" @keyup="searchContacts" />
                                <div class="absolute top-1/2 -translate-y-1/2 peer-focus:text-primary ltr:right-[11px] rtl:left-[11px]">
                                    <svg class="mx-auto" width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="11.5" cy="11.5" r="9.5" stroke="currentColor" stroke-width="1.5" opacity="0.5"></circle>
                                        <path d="M18.5 18.5L22 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>

                    <br>

                    <?php
                    $internos = $adminUtil->dameSaldoInternos();
                    if ($internos == 0) {
                        $mensajeInternos = "Sin operaciones pendientes";
                    } else {
                        $mensajeInternos = "Operaciones pendientes";
                    }

                    ?>

                    <div class="mb-6 grid grid-cols-1 gap-6 text-white sm:grid-cols-2 xl:grid-cols-3">
                        <!-- Users Visit -->
                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Saldos internos</div>

                            </div>
                            <div class="mt-5 flex items-center">
                                <a href="detalles-cliente.php?id=13">
                                    <div class="text-3xl font-bold ltr:mr-3 rtl:ml-3">$ <?php echo number_format($internos, 2) ?></div>
                                </a>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                <?php echo $mensajeInternos ?>
                            </div>
                        </div>

                        <!-- Sessions -->
                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Movimientos pendientes (<?php echo $adminUtil->cuentaMovimientosPendientes() ?>) </div>
                                <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                    <a href="javascript:;" @click="toggle">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                        </svg>
                                    </a>
                                    <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                        <li><a href="mov-sinasignar.php" @click="toggle">Ir a asignaciones</a></li>
                                        <li><a href="mov-asignados.php" @click="toggle">Ir a des-asignaciones</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="mt-5 flex items-center">
                                <a href="mov-sinasignar.php" class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format(($adminUtil->dameMovimientosPedientes() - 1394712), 2) ?></a>

                            </div>

                        </div>

                        <?php
                        $diferencias = $adminUtil->dameDiferenciasDeSaldo();
                        $diferenciaDelment = $adminUtil->dameDiferenciasDeSaldoZac();
                       

                        




                        $diferenciaEnclenci = $adminUtil->dameDiferenciasDeSaldoEnclenci();
                        $diferenciaWk  = $adminUtil->dameDiferenciasDeSaldoWk();
                        $diferenciaToki = $adminUtil->dameDiferenciasDeSaldoTokidoki();
                        $diferenciaRedondeada = round($diferencias, 2);
                        $ultimaDiferencia = $adminUtil->dameUltimaDiferencia();
                        $fechaUltima = $ultimaDiferencia->fecha;
                        // Crear un objeto DateTime
                        $fecha_obj = new DateTime($fechaUltima);

                        // Aumentar la hora en 1
                        $fecha_obj->modify('+1 hour');

                        // Obtener la nueva fecha
                        $fechaUltima = $fecha_obj->format('Y-m-d H:i:s');

                        $fechaUltima = explode(" ", $fechaUltima);
                        $fechaU = $fechaUltima[0];
                        $horaU = $fechaUltima[1];

                        if ($fechaU == date("Y-m-d")) {
                            $diaU = "HOY";
                        } else {
                            $diaU = $fechaU;
                        }

                        //aumentar una hora 

                        if ($diferenciaRedondeada != 0) {
                            $claseDif = "animate-flicker";
                        } else {
                            $claseDif = "";
                        }

                        ?>
                        <!-- Time On-Site -->
                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Diferencia saldos</div>
                                <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                    <a href="javascript:;" @click="toggle">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                        </svg>
                                    </a>
                                    <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                        <li><a href="rep-diferencia.php" @click="toggle">Ver reporte de diferencias</a></li>
                                        <li><a href="javascript:;" @click="toggle">Ir a pagos</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="mt-5 flex items-center">
                                <div class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format($diferencias, 2) ?></div>
                                <div class="badge bg-white/30">De diferencia </div>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                Ultima diferencia detectada: <?php echo $diaU . " " . $horaU ?>
                            </div>
                        </div>

                    </div>

                    <div class="mb-6 grid grid-cols-1 gap-6 text-white sm:grid-cols-2 xl:grid-cols-3">


                        <!-- Bounce Rate -->
                        <!-- <div class="panel " style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Saldo STP WK</div>
                                <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                    <a href="javascript:;" @click="toggle">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                        </svg>
                                    </a>
                                    <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                        <li><a href="reporte-banco-detalle.php?cuenta=114" @click="toggle" target="_blank">Ver reporte</a></li>
                                        <li><a href="banca-retiro.php?banca=wk" @click="toggle">Ir a retiro</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="mt-5 flex items-center">
                                <a href="banca-retiro.php?banca=wk" class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format($adminUtil->dameSaldosStpWk(), 2) ?></a>
                                <div class="badge bg-white/30"> COLA $ <?php echo number_format($adminUtil->dameMontoEnFilaWk(), 2) ?></div>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                Diferencia $ <?php echo number_format($diferenciaWk, 2) ?>
                            </div>
                        </div> -->


                     
                        <!-- <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Ubicación</div>
                                
                            </div>
                            <div class="mt-5 flex items-center">

                            <?php 
                            
                         
                            

                            ?>

                               
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                GPS: <?php echo $doxeo['lat'] . ", " . $doxeo['lon'] ?>
                            </div>
                            
                        </div>  -->

                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <a href="mov-banca-unitaria.php">
                                <div class="flex justify-between">
                                    <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Saldo STP Kulindra</div>
                                    <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                        <a href="javascript:;" @click="toggle">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                                <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                                <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                                <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            </svg>
                                        </a>
                                        <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                            <li><a href="reporte-banco-detalle.php?cuenta=127" @click="toggle" target="_blank">Ver reporte</a></li>
                                            <li><a href="banca-retiro.php?banca=zac" @click="toggle">Ir a retiro</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </a>

                            <div class="mt-5 flex items-center">
                                <a href="banca-retiro.php?banca=del" class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format($adminUtil->dameSaldosStpKulindra(), 2) ?></a>
                                <div class="badge bg-white/30"> COLA $ <?php echo number_format($adminUtil->dameMontoEnFilaZac(), 2) ?></div>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                Diferencia $ <?php echo number_format($adminUtil->dameDiferenciasDeSaldoKul(), 2)  . " <p style='opacity: 0;'> " . $diferenciaDelment . "</p>" ?>
                            </div>
                        </div>
                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <a href="mov-banca-unitaria.php">
                                <div class="flex justify-between">
                                    <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Saldo STP ZAC</div>
                                    <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                        <a href="javascript:;" @click="toggle">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                                <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                                <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                                <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            </svg>
                                        </a>
                                        <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                            <li><a href="reporte-banco-detalle.php?cuenta=127" @click="toggle" target="_blank">Ver reporte</a></li>
                                            <li><a href="banca-retiro.php?banca=zac" @click="toggle">Ir a retiro</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </a>

                            <div class="mt-5 flex items-center">
                                <a href="banca-retiro.php?banca=del" class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format($adminUtil->dameSaldosStpZac(), 2) ?></a>
                                <div class="badge bg-white/30"> COLA $ <?php echo number_format($adminUtil->dameMontoEnFilaZac(), 2) ?></div>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                Diferencia $ <?php echo number_format(0, 2)  . " <p style='opacity: 0;'> " . $diferenciaDelment . "</p>" ?>
                            </div>
                        </div>

                        <div class="panel" style="background: linear-gradient(to right, orange, #FFD277);">
                            <div class="flex justify-between">
                                <div class="text-md font-semibold ltr:mr-1 rtl:ml-1">Saldo STP Tokidoki </div>
                                <div x-data="dropdown" @click.outside="open = false" class="dropdown">
                                    <a href="javascript:;" @click="toggle">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-70 hover:opacity-80">
                                            <circle cx="5" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle opacity="0.5" cx="12" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                            <circle cx="19" cy="12" r="2" stroke="currentColor" stroke-width="1.5"></circle>
                                        </svg>
                                    </a>
                                    <ul x-show="open" x-transition="" x-transition.duration.300ms="" class="text-black ltr:right-0 rtl:left-0 dark:text-white-dark" style="display: none;">
                                        <li><a href="reporte-banco-detalle.php?cuenta=117" @click="toggle" target="_blank">Ver reporte</a></li>
                                        <li><a href="banca-retiro.php?banca=enc" @click="toggle">Ir a retiro</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="mt-5 flex items-center">
                                <a href="banca-retiro.php?banca=enc" class="text-3xl font-bold ltr:mr-3 rtl:ml-3"> $ <?php echo number_format($adminUtil->dameSaldosStpTo(), 2) ?></a>
                                <div class="badge bg-white/30"> COLA $ <?php echo number_format($adminUtil->dameMontoEnFilaEn(), 2) ?></div>
                            </div>
                            <div class="mt-5 flex items-center font-semibold">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0 ltr:mr-2 rtl:ml-2">
                                    <path opacity="0.5" d="M3.27489 15.2957C2.42496 14.1915 2 13.6394 2 12C2 10.3606 2.42496 9.80853 3.27489 8.70433C4.97196 6.49956 7.81811 4 12 4C16.1819 4 19.028 6.49956 20.7251 8.70433C21.575 9.80853 22 10.3606 22 12C22 13.6394 21.575 14.1915 20.7251 15.2957C19.028 17.5004 16.1819 20 12 20C7.81811 20 4.97196 17.5004 3.27489 15.2957Z" stroke="currentColor" stroke-width="1.5"></path>
                                    <path d="M15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9C13.6569 9 15 10.3431 15 12Z" stroke="currentColor" stroke-width="1.5"></path>
                                </svg>
                                Diferencia $ <?php echo number_format($diferenciaToki-411, 2) ?>
                            </div>
                        </div>




                    </div>



                    <div class="panel mt-5 overflow-hidden border-0 p-0">
                        <template x-if="displayType === 'list'">
                            <div class="table-responsive">
                                <table class="table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Balance</th>
                                            <th>Dinero por cobrar</th>
                                            <th>Movimientos pendientes</th>
                                            <th class="!text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <template x-for="contact in filterdContactsList" :key="contact.id">
                                            <tr>
                                                <td>
                                                    <div class="flex w-max items-center">
                                                        <!-- <div class="flex-none mr-3">
                                                    <div class="p-1 bg-white-dark/30 rounded-full"><img class="h-8 w-8 rounded-full object-cover" src="assets/images/user-profile.jpeg" /></div>
                                                </div> -->
                                                        <div x-show="contact.path" class="w-max">
                                                            <img :src="`${contact.path}`" class="h-8 w-8 rounded-full object-cover ltr:mr-2 rtl:ml-2" alt="avatar" />
                                                        </div>
                                                        <div x-show="!contact.path && contact.name" class="grid h-8 w-8 place-content-center rounded-full bg-primary text-sm font-semibold text-white ltr:mr-2 rtl:ml-2" x-text="contact.name.charAt(0) + '' + contact.name.charAt(contact.name.indexOf(' ') + 1)"></div>
                                                        <div x-show="!contact.path && !contact.name" class="rounded-full border border-gray-300 p-2 ltr:mr-2 rtl:ml-2 dark:border-gray-800">
                                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-4.5 w-4.5">
                                                                <circle cx="12" cy="6" r="4" stroke="currentColor" stroke-width="1.5"></circle>
                                                                <ellipse opacity="0.5" cx="12" cy="17" rx="7" ry="4" stroke="currentColor" stroke-width="1.5"></ellipse>
                                                            </svg>
                                                        </div>
                                                        <div x-text="contact.name"></div>
                                                    </div>
                                                </td>
                                                <td x-text="contact.location"></td>
                                                <td x-text="contact.email" class="whitespace-nowrap"></td>
                                                <td x-text="contact.phone" class="whitespace-nowrap"></td>
                                                <td>
                                                    <!-- <div class="flex items-center justify-center gap-4">
                                                        <button type="button" class="btn btn-sm btn-outline-primary" @click="editUser(contact)">
                                                            Edit
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-outline-danger" @click="deleteUser(contact)">
                                                            Delete
                                                        </button>
                                                    </div> -->
                                                </td>
                                            </tr>
                                        </template>
                                    </tbody>
                                </table>
                            </div>
                        </template>
                    </div>
                    <template x-if="displayType === 'grid'">
                        <div class="my-5 grid w-full grid-cols-1 gap-6 sm:grid-cols-2 xl:grid-cols-3 2xl:grid-cols-4">
                            <template x-for="contact in filterdContactsList" :key="contact.id">
                                <div class="relative overflow-hidden rounded-md bg-white text-center shadow dark:bg-[#1c232f]" style="-webkit-box-shadow: -1px 10px 34px -1px rgba(0,0,0,0.75);
                                        -moz-box-shadow: -1px 10px 34px -1px rgba(0,0,0,0.75);
                                        box-shadow: -1px 10px 34px -1px rgba(0,0,0,0.75);">
                                    <div class="rounded-t-md bg-white/40 bg-[url('../images/notification-bg.png')] bg-cover bg-center p-6 pb-0">
                                        <template x-if="contact.path">
                                            <img class="mx-auto max-h-40 w-4/5 object-contain" :src="`${contact.path}`" />
                                        </template>
                                    </div>
                                    <div class="relative -mt-10 px-6 pb-24">
                                        <div class="rounded-md bg-white px-2 py-4 shadow-md dark:bg-gray-900">
                                            <div class="date">
                                                <div class="text-xl arc" x-text="contact.name"></div>
                                                <div class="text-xl date-text" x-text="contact.followers" @click="copiarClave(contact)"></div>
                                                <div class="flex-none ltr:mr-2 rtl:ml-2">Balance :</div>
                                                <div class="text-white-dark text-xl" x-text="contact.location"></div>
                                            </div>
                                            <div class="text-white-dark" x-text="contact.role"></div>
                                            <div class="mt-6 flex flex-wrap items-center justify-between gap-3">
                                                <div class="flex-auto">
                                                    <div class="text-info animate-flicker" x-text="contact.posts"></div>

                                                </div>


                                            </div>
                                            <div class="mt-4">
                                                <ul class="flex items-center justify-center space-x-4 rtl:space-x-reverse">
                                                    <li>
                                                        <a @click="manda(contact)" class="btn btn-outline-primary h-7 w-7 rounded-full p-0">
                                                            <svg class="dark:text-white-dark" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="-0.5 0 25 25" fill="none">
                                                                <path d="M12.8702 16.97V18.0701C12.8702 18.2478 12.7995 18.4181 12.6739 18.5437C12.5482 18.6694 12.3778 18.74 12.2001 18.74C12.0224 18.74 11.852 18.6694 11.7264 18.5437C11.6007 18.4181 11.5302 18.2478 11.5302 18.0701V16.9399C11.0867 16.8668 10.6625 16.7051 10.2828 16.4646C9.90316 16.2241 9.57575 15.9097 9.32013 15.54C9.21763 15.428 9.16061 15.2817 9.16016 15.1299C9.16006 15.0433 9.17753 14.9576 9.21155 14.8779C9.24557 14.7983 9.29545 14.7263 9.35809 14.6665C9.42074 14.6067 9.49484 14.5601 9.57599 14.5298C9.65713 14.4994 9.7436 14.4859 9.83014 14.49C9.91602 14.4895 10.0009 14.5081 10.0787 14.5444C10.1566 14.5807 10.2254 14.6338 10.2802 14.7C10.6 15.1178 11.0342 15.4338 11.5302 15.6099V13.0701C10.2002 12.5401 9.53015 11.77 9.53015 10.76C9.55019 10.2193 9.7627 9.70353 10.1294 9.30566C10.4961 8.9078 10.9929 8.65407 11.5302 8.59009V7.47998C11.5302 7.30229 11.6007 7.13175 11.7264 7.0061C11.852 6.88045 12.0224 6.81006 12.2001 6.81006C12.3778 6.81006 12.5482 6.88045 12.6739 7.0061C12.7995 7.13175 12.8702 7.30229 12.8702 7.47998V8.58008C13.2439 8.63767 13.6021 8.76992 13.9234 8.96924C14.2447 9.16856 14.5226 9.43077 14.7402 9.73999C14.8284 9.85568 14.8805 9.99471 14.8901 10.1399C14.8928 10.2256 14.8783 10.3111 14.8473 10.3911C14.8163 10.4711 14.7696 10.5439 14.7099 10.6055C14.6502 10.667 14.5787 10.7161 14.4998 10.7495C14.4208 10.7829 14.3359 10.8001 14.2501 10.8C14.1607 10.7989 14.0725 10.7787 13.9915 10.7407C13.9104 10.7028 13.8384 10.648 13.7802 10.5801C13.5417 10.2822 13.2274 10.054 12.8702 9.91992V12.1699L13.1202 12.27C14.3902 12.76 15.1802 13.4799 15.1802 14.6299C15.163 15.2399 14.9149 15.8208 14.4862 16.2551C14.0575 16.6894 13.4799 16.9449 12.8702 16.97ZM11.5302 11.5901V9.96997C11.3688 10.0285 11.2298 10.1363 11.1329 10.2781C11.0361 10.4198 10.9862 10.5884 10.9902 10.76C10.9984 10.93 11.053 11.0945 11.1483 11.2356C11.2435 11.3767 11.3756 11.4889 11.5302 11.5601V11.5901ZM13.7302 14.6599C13.7302 14.1699 13.3902 13.8799 12.8702 13.6599V15.6599C13.1157 15.6254 13.3396 15.5009 13.4985 15.3105C13.6574 15.1202 13.74 14.8776 13.7302 14.6299V14.6599Z" fill="red" />
                                                                <path d="M12.58 3.96997H6C4.93913 3.96997 3.92178 4.39146 3.17163 5.1416C2.42149 5.89175 2 6.9091 2 7.96997V17.97C2 19.0308 2.42149 20.0482 3.17163 20.7983C3.92178 21.5485 4.93913 21.97 6 21.97H18C19.0609 21.97 20.0783 21.5485 20.8284 20.7983C21.5786 20.0482 22 19.0308 22 17.97V11.8999" stroke="red" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                                <path d="M16.3398 8.57992L21.9998 2.91992" stroke="red" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                                <path d="M17.4805 2.91992H22.0005V7.44992" stroke="red" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a @click="recive(contact)" class="btn btn-outline-primary h-7 w-7 rounded-full p-0">
                                                            <svg class="dark:text-white-dark" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="-0.5 0 25 25" fill="none">
                                                                <path d="M12.8702 16.97V18.0701C12.8702 18.2478 12.7995 18.4181 12.6739 18.5437C12.5482 18.6694 12.3778 18.74 12.2001 18.74C12.0224 18.74 11.852 18.6694 11.7264 18.5437C11.6007 18.4181 11.5302 18.2478 11.5302 18.0701V16.9399C11.0867 16.8668 10.6625 16.7051 10.2828 16.4646C9.90316 16.2241 9.57575 15.9097 9.32013 15.54C9.21763 15.428 9.16061 15.2817 9.16016 15.1299C9.16006 15.0433 9.17753 14.9576 9.21155 14.8779C9.24557 14.7983 9.29545 14.7263 9.35809 14.6665C9.42074 14.6067 9.49484 14.5601 9.57599 14.5298C9.65713 14.4994 9.7436 14.4859 9.83014 14.49C9.91602 14.4895 10.0009 14.5081 10.0787 14.5444C10.1566 14.5807 10.2254 14.6338 10.2802 14.7C10.6 15.1178 11.0342 15.4338 11.5302 15.6099V13.0701C10.2002 12.5401 9.53015 11.77 9.53015 10.76C9.55019 10.2193 9.7627 9.70353 10.1294 9.30566C10.4961 8.9078 10.9929 8.65407 11.5302 8.59009V7.47998C11.5302 7.30229 11.6007 7.13175 11.7264 7.0061C11.852 6.88045 12.0224 6.81006 12.2001 6.81006C12.3778 6.81006 12.5482 6.88045 12.6739 7.0061C12.7995 7.13175 12.8702 7.30229 12.8702 7.47998V8.58008C13.2439 8.63767 13.6021 8.76992 13.9234 8.96924C14.2447 9.16856 14.5226 9.43077 14.7402 9.73999C14.8284 9.85568 14.8805 9.99471 14.8901 10.1399C14.8928 10.2256 14.8783 10.3111 14.8473 10.3911C14.8163 10.4711 14.7696 10.5439 14.7099 10.6055C14.6502 10.667 14.5787 10.7161 14.4998 10.7495C14.4208 10.7829 14.3359 10.8001 14.2501 10.8C14.1607 10.7989 14.0725 10.7787 13.9915 10.7407C13.9104 10.7028 13.8384 10.648 13.7802 10.5801C13.5417 10.2822 13.2274 10.054 12.8702 9.91992V12.1699L13.1202 12.27C14.3902 12.76 15.1802 13.4799 15.1802 14.6299C15.163 15.2399 14.9149 15.8208 14.4862 16.2551C14.0575 16.6894 13.4799 16.9449 12.8702 16.97ZM11.5302 11.5901V9.96997C11.3688 10.0285 11.2298 10.1363 11.1329 10.2781C11.0361 10.4198 10.9862 10.5884 10.9902 10.76C10.9984 10.93 11.053 11.0945 11.1483 11.2356C11.2435 11.3767 11.3756 11.4889 11.5302 11.5601V11.5901ZM13.7302 14.6599C13.7302 14.1699 13.3902 13.8799 12.8702 13.6599V15.6599C13.1157 15.6254 13.3396 15.5009 13.4985 15.3105C13.6574 15.1202 13.74 14.8776 13.7302 14.6299V14.6599Z" fill="green" />
                                                                <path d="M12.58 3.96997H6C4.93913 3.96997 3.92178 4.39146 3.17163 5.1416C2.42149 5.89175 2 6.9091 2 7.96997V17.97C2 19.0308 2.42149 20.0482 3.17163 20.7983C3.92178 21.5485 4.93913 21.97 6 21.97H18C19.0609 21.97 20.0783 21.5485 20.8284 20.7983C21.5786 20.0482 22 19.0308 22 17.97V11.8999" stroke="green" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                                <path d="M21.9998 2.91992L16.3398 8.57992" stroke="green" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                                <path d="M20.8698 8.5798H16.3398V4.0498" stroke="green" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                        </a>
                                                    </li>

                                                </ul>
                                                <ul class="flex space  -x-4 rtl:space-x-reverse">
                                                    <li>
                                                        <a @click="actualizaSaldos(contact)" class="btn btn-outline-primary h-7 w-7 rounded-full p-0">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="#000000" width="24" height="24" viewBox="-7 0 32 32" version="1.1">
                                                                <title>loading</title>
                                                                <path d="M2.080 14.040l4-1.040c0.44-0.12 0.72-0.56 0.6-1.040-0.12-0.44-0.56-0.72-1.040-0.6l-2.080 0.56c0.68-0.88 1.56-1.6 2.64-2.080 1.64-0.72 3.44-0.76 5.12-0.12 1.64 0.64 2.96 1.92 3.68 3.52 0.2 0.44 0.68 0.6 1.12 0.44 0.44-0.2 0.6-0.68 0.44-1.12-0.88-2.040-2.52-3.6-4.6-4.44-2.080-0.8-4.36-0.76-6.4 0.12-1.36 0.6-2.48 1.52-3.36 2.68l-0.52-1.96c-0.12-0.44-0.56-0.72-1.040-0.6-0.44 0.12-0.72 0.56-0.6 1.040l1.040 4c0.12 0.56 0.4 0.8 1 0.64zM17.72 22.52l-1.040-3.96c0 0-0.16-0.8-0.96-0.6v0l-4 1.040c-0.44 0.12-0.72 0.56-0.6 1.040 0.12 0.44 0.56 0.72 1.040 0.6l2.080-0.56c-1.76 2.32-4.88 3.28-7.72 2.16-1.64-0.64-2.96-1.92-3.68-3.52-0.2-0.44-0.68-0.6-1.12-0.44-0.44 0.2-0.6 0.68-0.44 1.12 0.88 2.040 2.52 3.6 4.6 4.44 1 0.4 2 0.56 3.040 0.56 2.64 0 5.12-1.24 6.72-3.4l0.52 1.96c0.080 0.36 0.44 0.64 0.8 0.64 0.080 0 0.16 0 0.2-0.040 0.4-0.16 0.68-0.6 0.56-1.040z" />
                                                            </svg>
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="mt-6 grid grid-cols-1 gap-4 ltr:text-left rtl:text-right">
                                            <div class="flex items-center">
                                                <div class="flex-none ltr:mr-2 rtl:ml-2">Dinero por cobrar :</div>
                                                <div class="truncate text-white-dark" x-text="contact.email"></div>
                                            </div>
                                            <div class="flex items-center">
                                                <div class="flex-none ltr:mr-2 rtl:ml-2">Mov Pendientes :</div>
                                                <div style="cursor: pointer;" class="text-white-dark" x-text="contact.phone" @click="conta(contact)"></div>
                                            </div>
                                            <div class="flex items-center">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="absolute bottom-0 mt-6 flex w-full gap-4 p-6 ltr:left-0 rtl:right-0" style="justify-content: center;">
                                        <!-- <button type="button" class="btn btn-outline-primary w-1/2" @click="editUser(contact)">Edit</button>
                                        <button type="button" class="btn btn-outline-danger w-1/2" @click="deleteUser(contact)">Delete</button> -->
                                        <button type="button" class="btn btn-outline-primary w-1/2" @click="detalle(contact)">Detalles </button>
                                        <button type="button" class="btn btn-outline-danger" @click="config(contact)">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="1.5"></circle>
                                                <path d="M3.66122 10.6392C4.13377 10.9361 4.43782 11.4419 4.43782 11.9999C4.43781 12.558 4.13376 13.0638 3.66122 13.3607C3.33966 13.5627 3.13248 13.7242 2.98508 13.9163C2.66217 14.3372 2.51966 14.869 2.5889 15.3949C2.64082 15.7893 2.87379 16.1928 3.33973 16.9999C3.80568 17.8069 4.03865 18.2104 4.35426 18.4526C4.77508 18.7755 5.30694 18.918 5.83284 18.8488C6.07287 18.8172 6.31628 18.7185 6.65196 18.5411C7.14544 18.2803 7.73558 18.2699 8.21895 18.549C8.70227 18.8281 8.98827 19.3443 9.00912 19.902C9.02332 20.2815 9.05958 20.5417 9.15224 20.7654C9.35523 21.2554 9.74458 21.6448 10.2346 21.8478C10.6022 22 11.0681 22 12 22C12.9319 22 13.3978 22 13.7654 21.8478C14.2554 21.6448 14.6448 21.2554 14.8478 20.7654C14.9404 20.5417 14.9767 20.2815 14.9909 19.9021C15.0117 19.3443 15.2977 18.8281 15.7811 18.549C16.2644 18.27 16.8545 18.2804 17.3479 18.5412C17.6837 18.7186 17.9271 18.8173 18.1671 18.8489C18.693 18.9182 19.2249 18.7756 19.6457 18.4527C19.9613 18.2106 20.1943 17.807 20.6603 17C20.8677 16.6407 21.029 16.3614 21.1486 16.1272M20.3387 13.3608C19.8662 13.0639 19.5622 12.5581 19.5621 12.0001C19.5621 11.442 19.8662 10.9361 20.3387 10.6392C20.6603 10.4372 20.8674 10.2757 21.0148 10.0836C21.3377 9.66278 21.4802 9.13092 21.411 8.60502C21.3591 8.2106 21.1261 7.80708 20.6601 7.00005C20.1942 6.19301 19.9612 5.7895 19.6456 5.54732C19.2248 5.22441 18.6929 5.0819 18.167 5.15113C17.927 5.18274 17.6836 5.2814 17.3479 5.45883C16.8544 5.71964 16.2643 5.73004 15.781 5.45096C15.2977 5.1719 15.0117 4.6557 14.9909 4.09803C14.9767 3.71852 14.9404 3.45835 14.8478 3.23463C14.6448 2.74458 14.2554 2.35523 13.7654 2.15224C13.3978 2 12.9319 2 12 2C11.0681 2 10.6022 2 10.2346 2.15224C9.74458 2.35523 9.35523 2.74458 9.15224 3.23463C9.05958 3.45833 9.02332 3.71848 9.00912 4.09794C8.98826 4.65566 8.70225 5.17191 8.21891 5.45096C7.73557 5.73002 7.14548 5.71959 6.65205 5.4588C6.31633 5.28136 6.0729 5.18269 5.83285 5.15108C5.30695 5.08185 4.77509 5.22436 4.35427 5.54727C4.03866 5.78945 3.80569 6.19297 3.33974 7C3.13231 7.35929 2.97105 7.63859 2.85138 7.87273" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </template>
                </div>
                <!-- end main content section -->

            </div>

            <!-- start footer section -->
            <div class="p-6 pt-0 mt-auto text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2022</span>. S14 All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.6/isotope.pkgd.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>
        function actualizarSaldos() {
            var rotarSvg = document.getElementById('rotarSvg');
            rotarSvg.classList.add("rotated-svg");

            //rotated-svg
            var enviarDatosAct = new FormData();
            fetch("api/saldo_clientes_script.php", {
                    method: "POST",
                    body: enviarDatosAct,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    if (data.status == 'ok') {
                        Swal.fire({
                            title: data.mensaje,
                            text: data.subMensaje,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then((result) => {
                            if (result.isConfirmed) {

                                location.reload();

                            }
                        });
                    }

                });
        }
    </script>






    <script>
        function calcular() {
            var enviarDatos = new FormData();
            enviarDatos.append("calculo", "si");
            enviarDatos.append("dinero", document.getElementById("dinero").value);
            enviarDatos.append("calculadora_modo", document.getElementById("calculadora_modo").value);
            enviarDatos.append("id_cliente", document.getElementById("id_cliente").value);
            fetch("api/apiCalculadora.php", {
                    method: "POST",
                    body: enviarDatos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    //(data);
                    var espacioResultado = document.getElementById("resultadoCalculadora");
                    espacioResultado.value = "";
                    espacioResultado.value = data.calculo;

                });
        }
    </script>



    <script>
        function calculoExel() {
            var empresa = document.getElementById("id_empresa_cal").value;
            var monto = document.getElementById("dinero_empresa").value;

            // Crear un formulario oculto
            var form = document.createElement('form');
            form.setAttribute('method', 'post');
            form.setAttribute('action', 'api/generaReporteCalculadora.php');
            form.setAttribute('target', '_blank');

            // Crear un input para cada parámetro
            var params = {
                'empresa': empresa,
                'reporte': reporteCal,
                'monto': monto
            };
            for (var key in params) {
                if (params.hasOwnProperty(key)) {
                    var input = document.createElement('input');
                    input.setAttribute('type', 'hidden');
                    input.setAttribute('name', key);
                    input.setAttribute('value', params[key]);
                    form.appendChild(input);
                }
            }

            // Agregar el formulario al documento y enviarlo
            document.body.appendChild(form);
            form.submit();
        }
    </script>


    <script>
        var reporteCal = null;

        function calcularDisp() {
            //limpiar tabla 

            var arregloEmpresas = ['A', 'B', 'C', 'D', 'E'];
            //odernar de manera aleatorio 
     



            var tabla = document.getElementById("tablaCalculadoraDisp");
            tabla.innerHTML = "";
            var enviarDatos = new FormData();
            enviarDatos.append("accion", "reporteDisp");
            enviarDatos.append("monto", document.getElementById("monto_calculo").value);
            enviarDatos.append("unidades", document.getElementById("unidades_calculo").value);
            enviarDatos.append("cuentas", document.getElementById("cuentas_calculo").value);

            fetch("api/apiProveedores.php", {
                    method: "POST",
                    body: enviarDatos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    var tabla = document.getElementById("tablaCalculadoraDisp");
                    for (var i = 0; i < data.length; i++) {
                        var tr = document.createElement("tr");
                        var td1 = document.createElement("td");
                        var td2 = document.createElement("td");
                        var td3 = document.createElement("td");
                        var numeroFormateado = new Intl.NumberFormat('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        }).format(data[i].monto);
                        if (i == data.length - 1) {
                            td1.innerHTML = 'TOTAL';

                        } else {
                            td1.innerHTML = arregloEmpresas[i];
                        }
                        td2.innerHTML = numeroFormateado;
                        td3.innerHTML = data[i].porcentaje;


                        //negritas 

                        td1.style.fontWeight = "bold";
                        td2.style.fontWeight = "bold";
                        td3.style.fontWeight = "bold";

                        tr.appendChild(td1);
                        tr.appendChild(td2);
                        tabla.appendChild(tr);

                        for (var j = 0; j < data[i].sub_montos.length; j++) {
                            var tr2 = document.createElement("tr");
                            var td4 = document.createElement("td");
                            var td5 = document.createElement("td");
                            var td6 = document.createElement("td");
                            var numeroFormateado2 = new Intl.NumberFormat('es-MX', {
                                style: 'currency',
                                currency: 'MXN'
                            }).format(data[i].sub_montos[j].monto);
                            td4.innerHTML = '&ensp;&ensp;&ensp;' + data[i].sub_montos[j].nombre;
                            td5.innerHTML = '' + numeroFormateado2;
                            td6.innerHTML = '' + data[i].sub_montos[j].porcentaje;
                            tr2.appendChild(td4);
                            tr2.appendChild(td5);
                            tabla.appendChild(tr2);
                        }
                    }
                });
        }
    </script>

    <script>
        var reporteCal = null;

        function calcularEmpresas() {
            var enviarDatos = new FormData();
            enviarDatos.append("dinero", document.getElementById("dinero_empresa").value);
            enviarDatos.append("id", document.getElementById("id_empresa_cal").value);
            enviarDatos.append("accion", "reporte");
            fetch("api/apiProveedores.php", {
                    method: "POST",
                    body: enviarDatos,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    //(data);
                    var espacioResultado = document.getElementById("tablaCalculadora");
                    espacioResultado.innerHTML = "";
                    var total = 0;
                    var totalProcentaje = 0;
                    var dataJson = JSON.stringify(data);
                    reporteCal = dataJson;
                    for (var i = 0; i < data.length; i++) {

                        var numeroFormateado = new Intl.NumberFormat('es-MX', {
                            style: 'currency',
                            currency: 'MXN'
                        }).format(data[i].total);
                        total = total + data[i].total;
                        totalProcentaje = totalProcentaje + data[i].porcentaje_calculado;
                        espacioResultado.innerHTML += "<tr><td>" + data[i].proveedor + "</td><td>" + numeroFormateado + "</td><td>" + data[i].porcentaje_calculado + "%</td><td>" + data[i].porcentaje + "%</td></tr>";
                    }
                    var numeroFormateado = new Intl.NumberFormat('es-MX', {
                        style: 'currency',
                        currency: 'MXN'
                    }).format(total);

                    espacioResultado.innerHTML += "<tr><td>Total</td><td>" + numeroFormateado + "</td><td>" + totalProcentaje + "%</td><td></td></tr>";
                });
        }
    </script>
    <script>
        function formatearNumeroBarra() {
            var input = document.getElementById('dinero');
            var valor = input.value.replace(/[^\d.]/g, ''); // Eliminar caracteres no numéricos ni puntos
            var partes = valor.split('.');

            if (partes.length > 2) {
                partes = [partes.shift(), partes.join('.')];
            }

            if (partes.length > 0) {
                partes[0] = partes[0].replace(/\B(?=(\d{3})+(?!\d))/g, ','); // Agregar comas
            }

            input.value = partes.join('.');
        }
    </script>
     <script>
        function formatearNumeroCalcular() {
            var input = document.getElementById('monto_calculo');
            var valor = input.value.replace(/[^\d.]/g, ''); // Eliminar caracteres no numéricos ni puntos
            var partes = valor.split('.');

            if (partes.length > 2) {
                partes = [partes.shift(), partes.join('.')];
            }

            if (partes.length > 0) {
                partes[0] = partes[0].replace(/\B(?=(\d{3})+(?!\d))/g, ','); // Agregar comas
            }

            input.value = partes.join('.');
        }
    </script>
    <script>
        const formulario = document.getElementById("formularioToken");


        formulario.addEventListener("submit", function(e) {
            e.preventDefault();
            const enviaDatosContra = new FormData(formulario);
            enviaDatosContra.append("accion", "inicioBanco");
            fetch("api/apiUsuarios.php", {
                    method: "POST",
                    body: enviaDatosContra,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    var espacioToken = document.getElementById("espacioToken");
                    //cortar a 20 caracteres 
                    data.token = data.token.substring(0, 20);
                    //añadir 3 puntos 
                    data.token = data.token + "...";
                    espacioToken.innerHTML = data.token;
                    Swal.fire({
                        title: data.estatus,
                        text: data.mensaje,
                        icon: data.tipo,
                        confirmButtonText: 'Aceptar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            if (data.tipo == "success") {
                                location.reload();
                            }
                        }
                    });

                });
        });
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));
            //contacts
            var lista = Alpine.data('contacts', () => ({
                defaultParams: {
                    id: null,
                    name: '',
                    email: '',
                    role: '',
                    phone: '',
                    location: '',
                },
                displayType: 'grid',
                addContactModal: false,
                params: {
                    id: null,
                    name: '',
                    email: '',
                    role: '',
                    phone: '',
                    location: '',
                },
                filterdContactsList: [],
                searchUser: '',
                contactList: arregloContactos,

                init() {
                    this.searchContacts();
                },

                searchContacts() {
                    this.filterdContactsList = this.contactList.filter((d) => d.name.toLowerCase().includes(this.searchUser.toLowerCase()));

                },

                editUser(user) {
                    this.params = this.defaultParams;
                    if (user) {
                        this.params = JSON.parse(JSON.stringify(user));
                    }

                    this.addContactModal = true;
                },

                detalle(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    window.open("detalles-cliente.php?id=" + user.id, "_blank");
                },

                conta(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    window.open("detalles-cliente-conta.php?id=" + user.id, "_blank");
                },



                manda(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    window.open("mov-traspasos-form.php?da=" + user.id, "_blank");
                },
                recive(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    window.open("mov-traspasos-form.php?de=" + user.id, "_blank");
                },

                actualizaSaldos(user) {
                    console.log("Se esta actualizando el saldo de " + user.id);

                    user.location = "Cargando..."; // saldo
                    user.phone = "Cargando..."; // saldo pendiente


                    var enviarDatosAct = new FormData();
                    enviarDatosAct.append('id', user.id);
                    fetch("api/saldo_cliente_script.php", {
                            method: "POST",
                            body: enviarDatosAct,
                        })
                        .then((respuesta) => respuesta.json())
                        .then((data) => {
                            if (data.status == 'ok') {

                                user.location = '$' + (data.saldoss); // saldo
                                user.phone = '$' + data.dinero_sin_fac; // saldo pendiente
                            }

                        });


                },



                config(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    window.open("cat-carteras-form.php?id=" + user.id, "_blank");
                },
                copiarClave(user) {
                    console.log(user.id);
                    //abir ventan en pagina nueva 
                    var elementoTemporal = document.createElement("input");
                    // Establecer el valor del elemento temporal
                    elementoTemporal.value = user.followers;
                    // Adjuntar el elemento temporal al cuerpo de la página
                    document.body.appendChild(elementoTemporal);
                    // Seleccionar el contenido del elemento temporal
                    elementoTemporal.select();
                    // Copiar el contenido al portapapeles
                    document.execCommand("copy");
                    // Eliminar el elemento temporal
                    document.body.removeChild(elementoTemporal);
                    // Puedes agregar aquí lógica adicional o proporcionar retroalimentación al usuario

                    const toast = window.Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 1000,
                        padding: '2em',
                    });
                    toast.fire({
                        icon: 'success',
                        title: 'Copiado',
                        padding: '2em',
                    });

                },


                saveUser() {
                    if (!this.params.name) {
                        this.showMessage('Name is required.', 'error');
                        return true;
                    }
                    if (!this.params.email) {
                        this.showMessage('Email is required.', 'error');
                        return true;
                    }
                    if (!this.params.phone) {
                        this.showMessage('Phone is required.', 'error');
                        return true;
                    }
                    if (!this.params.role) {
                        this.showMessage('Occupation is required.', 'error');
                        return true;
                    }

                    if (this.params.id) {
                        //update user
                        let user = this.contactList.find((d) => d.id === this.params.id);
                        user.name = this.params.name;
                        user.email = this.params.email;
                        user.role = this.params.role;
                        user.phone = this.params.phone;
                        user.location = this.params.location;
                    } else {
                        //add user
                        let maxUserId = this.contactList.length ?
                            this.contactList.reduce((max, character) => (character.id > max ? character.id : max), this.contactList[0].id) :
                            0;

                        let user = {
                            id: maxUserId + 1,
                            path: 'profile-35.png',
                            name: this.params.name,
                            email: this.params.email,
                            role: this.params.role,
                            phone: this.params.phone,
                            location: this.params.location,
                            posts: 20,
                            followers: '5K',
                            following: 500,
                        };
                        this.contactList.splice(0, 0, user);
                        this.searchContacts();
                    }

                    this.showMessage('User has been saved successfully.');
                    this.addContactModal = false;
                },

                deleteUser(user) {
                    this.contactList = this.contactList.filter((d) => d.id != user.id);
                    // this.ids = this.ids.filter((d) => d != user.id);
                    this.searchContacts();
                    this.showMessage('User has been deleted successfully.');
                },

                setDisplayType(type) {
                    this.displayType = type;
                },

                showMessage(msg = '', type = 'success') {
                    const toast = window.Swal.mixin({
                        toast: true,
                        position: 'top',
                        showConfirmButton: false,
                        timer: 3000,
                    });
                    toast.fire({
                        icon: type,
                        title: msg,
                        padding: '10px 20px',
                    });
                },
            }));
        });
    </script>

    <script>
        var saldosC = [];
        var saldoTodo = 0.0;

        function formatearNumeroConComas(numero) {
            return numero.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        function calcularSaldosClientes() {


            return new Promise((resolve) => {
                console.log(clientes);

                for (var i = 0; i < clientes.length; i++) {
                    console.log("Cliente " + clientes[i]);
                    var enviaDatosCliente = new FormData();
                    enviaDatosCliente.append("cliente", clientes[i]);
                    enviaDatosCliente.append("accion", "saldoCliente");
                    fetch("api/apiClientes.php", {
                            method: "POST",
                            body: enviaDatosCliente,
                        })
                        .then((respuesta) => respuesta.json())
                        .then((data) => {

                            //console.log(data);

                            saldosC.push(data);


                            var saldo = data.saldo;
                            var grupo = data.grupo;
                            var saldoTotal = new Intl.NumberFormat('en-US', {
                                style: 'currency', //  usar 'decimal', 'currency' o 'percent'
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2,
                                currency: 'USD',
                                currencyDisplay: 'symbol', //  usar 'symbol', 'code' o 'name'
                                useGrouping: true
                            }).format(saldo);



                            var taregetaCliente = document.getElementById("targetaCliente" + data.cliente);
                            saldoTodo += parseFloat(saldo);

                            var saldoTodoR = new Intl.NumberFormat('en-US', {
                                style: 'currency', //  usar 'decimal', 'currency' o 'percent'
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2,
                                currency: 'USD',
                                currencyDisplay: 'symbol', // usar 'symbol', 'code' o 'name'
                                useGrouping: true
                            }).format(saldoTodo);

                            if (saldo < 0) {
                                //taregetaCliente.classList.add("animate-flicker");

                            }
                            var contacto = arregloContactos.find((d) => d.id == data.cliente);
                            console.log(contacto);
                            contacto.location = saldoTotal;
                            //lista.searchContacts();
                            //var espacioSaldo = document.getElementById("espacioSaldo" + data.cliente);
                            //var espacioSaldoTotal = document.getElementById("espacioBotonGeneral");
                            // espacioSaldoTotal.innerHTML = `<p  class='text-md m-t block'>${saldoTodoR}</p>`;
                            //espacioSaldo.innerHTML = `<p  class='text-md m-t block'>${saldoTotal}</p>`;
                            //calcularSaldoGrupos(data.grupo, data.saldo);


                        });

                }


                resolve();



            });
        }



        function calcularSaldoGrupos(grupo, saldo) {
            var grupoBuscado;
            for (var i = 0; i < grupos.length; i++) {
                if (grupos[i].id == grupo) {
                    grupoBuscado = grupos[i];
                    break;
                }
            }

            if (grupoBuscado == undefined) {
                //console.log("No se encontro el grupo " + grupo + " en el arreglo de grupos se comparo " + grupo.id + " con " + parseInt(grupo));
                return;
            }
            grupoBuscado.saldo += parseFloat(saldo);
            var saldoTotal = new Intl.NumberFormat('en-US', {
                style: 'currency', // Puedes usar 'decimal', 'currency' o 'percent'
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
                currency: 'USD',
                currencyDisplay: 'symbol', // Puedes usar 'symbol', 'code' o 'name'
                useGrouping: true
            }).format(grupoBuscado.saldo);

            console.log("Nuevo saldo grupo " + grupoBuscado.saldo + " grupo " + grupoBuscado.id + " saldo " + saldo);

            //var espacioBoton = document.getElementById("espacioBoton" + grupoBuscado.id);
            //espacioBoton.innerHTML = `<p  class='text-md m-t block'>${saldoTotal}</p>`;
            // console.log("Nuevo saldo grupo " + grupoBuscado.saldo + " grupo " + grupoBuscado.id + " saldo " + saldo);

        }
    </script>
    <script>
        $(document).ready(function() {
            // calcularSaldosClientes().then(() => {

            // });
            // console.log("Saldos clientes");


        });
    </script>
</body>

</html>