<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/x-icon" href="favicon.png" />

    <title>Login</title>
</head>

<body>

    <style>
        @import url('https://rsms.me/inter/inter-ui.css');

        ::selection {
            background: #2D2F36;
        }

        ::-webkit-selection {
            background: #2D2F36;
        }

        ::-moz-selection {
            background: #2D2F36;
        }

        body {
            background: white;
            font-family: 'Inter UI', sans-serif;
            margin: 0;
            padding: 20px;
        }

        .page {
            background: rgb(163, 163, 163);
            display: flex;
            flex-direction: column;
            height: calc(100% - 40px);
            position: absolute;
            place-content: center;
            width: calc(100% - 40px);
        }

        @media (max-width: 767px) {
            .page {
                height: auto;
                margin-bottom: 20px;
                padding-bottom: 20px;
            }
        }

        .container {
            display: flex;
            height: 320px;
            margin: 0 auto;
            width: 640px;
        }

        @media (max-width: 767px) {
            .container {
                flex-direction: column;
                height: 630px;
                width: 320px;
            }
        }

        .left {
            background: white;
            height: calc(100% - 40px);
            top: 20px;
            position: relative;
            width: 50%;
        }

        @media (max-width: 767px) {
            .left {
                height: 100%;
                left: 20px;
                width: calc(100% - 40px);
                max-height: 270px;
            }
        }

        .login {
            font-size: 50px;
            font-weight: 900;
            margin: 50px 40px 40px;
        }

        .eula {
            color: #999;
            font-size: 14px;
            line-height: 1.5;
            margin: 40px;
        }

        .right {
            background: #474A59;
            box-shadow: 0px 0px 40px 16px rgba(0, 0, 0, 0.22);
            color: #F1F1F2;
            position: relative;
            width: 50%;
        }

        @media (max-width: 767px) {
            .right {
                flex-shrink: 0;
                height: 100%;
                width: 100%;
                max-height: 350px;
            }
        }

        svg {
            position: absolute;
            width: 320px;
        }

        path {
            fill: none;
            stroke: url(#linearGradient);
            ;
            stroke-width: 4;
            stroke-dasharray: 240 1386;
        }

        .form {
            margin: 40px;
            position: absolute;
        }

        label {
            color: #c2c2c5;
            display: block;
            font-size: 14px;
            height: 16px;
            margin-top: 20px;
            margin-bottom: 5px;
        }

        input {
            background: transparent;
            border: 0;
            color: #f2f2f2;
            font-size: 20px;
            height: 30px;
            line-height: 30px;
            outline: none !important;
            width: 100%;
        }

        input::-moz-focus-inner {
            border: 0;
        }

        .password-container {
            display: flex;
            align-items: center;
            position: relative;
        }

        .password-container input {
            flex: 1;
        }

        .password-container button {
            background: none;
            border: none;
            color: #f2f2f2;
            cursor: pointer;
            font-size: 16px;
            position: absolute;
            right: 0;
            outline: none;
        }

        #submit {
            color: #707075;
            margin-top: 40px;
            transition: color 300ms;
        }

        #submit:focus {
            color: #f2f2f2;
        }

        #submit:active {
            color: #d0d0d2;
        }
    </style>

    <?php
    session_start();
    $_SESSION[$session_id] = null;
    $_SESSION[$session_usuario] = null;
    $_SESSION["usuario"] = null;
    $_SESSION["admindif_admin_id"] = null;
    $_SESSION["usuario_id"] = null;
    $_SESSION["tipo_usuario"] =  null;
    $_SESSION["id_cliente_14"] = null;
    ?>
    <div class="page">
        <div class="container">
            <div class="left">
                <img src="https://sistema14.com/assets/images/logo.png" width="166px" alt="" style="padding-top: 3rem; padding-left: 4.5rem">
            </div>
            <div class="right" id="loginPrimero">
                <svg viewBox="0 0 320 300">
                    <defs>
                        <linearGradient
                            inkscape:collect="always"
                            id="linearGradient"
                            x1="13"
                            y1="193.49992"
                            x2="307"
                            y2="193.49992"
                            gradientUnits="userSpaceOnUse">
                            <stop
                                style="stop-color:#ffa200;"
                                offset="0"
                                id="stop876" />
                            <stop
                                style="stop-color:#ff0000;"
                                offset="1"
                                id="stop878" />
                        </linearGradient>
                    </defs>
                    <path d="m 40,120.00016 239.99984,-3.2e-4 c 0,0 24.99263,0.79932 25.00016,35.00016 0.008,34.20084 -25.00016,35 -25.00016,35 h -239.99984 c 0,-0.0205 -25,4.01348 -25,38.5 0,34.48652 25,38.5 25,38.5 h 215 c 0,0 20,-0.99604 20,-25 0,-24.00396 -20,-25 -20,-25 h -190 c 0,0 -20,1.71033 -20,25 0,24.00396 20,25 20,25 h 168.57143" />
                </svg>
                <div class="form">
                    <label for="email">Email</label>
                    <input type="email" id="email">
                    <label for="password">Contraseña</label>
                    <div class="password-container">
                        <input type="password" id="password">
                        <button type="button" id="togglePassword">👁</button>
                    </div>
                    <input onclick="ingresa()" type="submit" id="submit" value="Verificar">
                </div>


            </div>

            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    document.getElementById("email").addEventListener("keypress", function(event) {
                        if (event.key === "Enter") {
                            event.preventDefault();
                            ingresa();
                        }
                    });

                    document.getElementById("password").addEventListener("keypress", function(event) {
                        if (event.key === "Enter") {
                            event.preventDefault();
                            ingresa();
                        }
                    });
                });
            </script>




            <div class="right" style="display: none;" id=loginSegundo>
                <svg viewBox="0 0 320 300">
                    <defs>
                        <linearGradient
                            inkscape:collect="always"
                            id="linearGradient"
                            x1="13"
                            y1="193.49992"
                            x2="307"
                            y2="193.49992"
                            gradientUnits="userSpaceOnUse">
                            <stop
                                style="stop-color:#ffa200;"
                                offset="0"
                                id="stop876" />
                            <stop
                                style="stop-color:#ff0000;"
                                offset="1"
                                id="stop878" />
                        </linearGradient>
                    </defs>
                    <path d="m 40,120.00016 239.99984,-3.2e-4 c 0,0 24.99263,0.79932 25.00016,35.00016 0.008,34.20084 -25.00016,35 -25.00016,35 h -239.99984 c 0,-0.0205 -25,4.01348 -25,38.5 0,34.48652 25,38.5 25,38.5 h 215 c 0,0 20,-0.99604 20,-25 0,-24.00396 -20,-25 -20,-25 h -190 c 0,0 -20,1.71033 -20,25 0,24.00396 20,25 20,25 h 168.57143" />
                </svg>
                <div class="form">
                    <label for="email">2FA</label>
                    <input type="number" id="fa">
                    <input type="submit" onclick="iniciarSesion()" value="Ingresar">
                </div>


            </div>


        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.2/anime.min.js" integrity="sha512-aNMyYYxdIxIaot0Y1/PLuEu3eipGCmsEUBrUq+7aVyPGMFH8z0eTP0tkqAvv34fzN6z+201d3T8HPb1svWSKHQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const toggleButton = this;

            // Cambiar el tipo de input entre "password" y "text"
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleButton.textContent = '🙈'; // Cambiar el icono
            } else {
                passwordInput.type = 'password';
                toggleButton.textContent = '👁'; // Cambiar el icono
            }
        });
    </script>
    <script>
        var current = null;
        document.querySelector('#email').addEventListener('focus', function(e) {
            if (current) current.pause();
            current = anime({
                targets: 'path',
                strokeDashoffset: {
                    value: 0,
                    duration: 700,
                    easing: 'easeOutQuart'
                },
                strokeDasharray: {
                    value: '240 1386',
                    duration: 700,
                    easing: 'easeOutQuart'
                }
            });
        });
        document.querySelector('#password').addEventListener('focus', function(e) {
            if (current) current.pause();

            current = anime({
                targets: 'path',
                strokeDashoffset: {
                    value: -336,
                    duration: 700,
                    easing: 'easeOutQuart'
                },
                strokeDasharray: {
                    value: '240 1386',
                    duration: 700,
                    easing: 'easeOutQuart'
                }
            });
        });
        document.querySelector('#submit').addEventListener('focus', function(e) {
            if (current) current.pause();
            current = anime({
                targets: 'path',
                strokeDashoffset: {
                    value: -730,
                    duration: 700,
                    easing: 'easeOutQuart'
                },
                strokeDasharray: {
                    value: '530 1386',
                    duration: 700,
                    easing: 'easeOutQuart'
                }
            });
        });
    </script>

    <script>
        function ingresa() {
            //quital el div que contiene la contraseña y da paso al 2fa
            var loginPrimero = document.getElementById("loginPrimero");
            var loginSegundo = document.getElementById("loginSegundo");
            loginPrimero.style.display = "none";
            loginSegundo.style.display = "block";
            //termina el flujo y focusea el input de 2fa 
            var inputFa = document.getElementById("fa");
            inputFa.focus();
        }
    </script>

    <script>
        document.getElementById('fa').addEventListener('keydown', function(event) {
            if (event.key === "Enter") {
                iniciarSesion();
            }
        });
    </script>


    <script>
        function iniciarSesion() {
            //envio de datos atraves de fetch 
            const envioDatosCuenta = new FormData();
            var pass = document.getElementById('password').value;
            var usuario = document.getElementById('email').value;
            var fa = document.getElementById('fa').value;
            envioDatosCuenta.append("usuario", usuario);
            envioDatosCuenta.append("password", pass);
            envioDatosCuenta.append("2fa", fa);
            envioDatosCuenta.append("accion", "inicio");
            fetch("api/adminLogin.php", {
                    method: "POST",
                    body: envioDatosCuenta,
                })
                .then((respuesta) => respuesta.json())
                .then((data) => {
                    console.log(data);
                    Swal.fire({
                        position: 'top-end',
                        icon: "susses",
                        title: data.mensaje,
                        showConfirmButton: false,
                        timer: 1500
                    })
                    if (data.estatus == "exito") {
                        //esperar 2 segundos y recargar la pagina
                        setTimeout(function() {
                            //ir a la pagina de inicio
                            if (data.tipo == "administrador" || data.tipo == "supercapturista" || data.tipo == "administrador_b" || data.tipo == "capturista") {
                                window.location.href = "index.php";
                            } else {
                                window.location.href = "https://sistema14.com/plus/clientes";
                            }
                        }, 2000);

                    }
                });
        }
    </script>



</body>

</html>