<?php

include_once('conectorChecador.php');

class Asistencia
{
  public $id;
  public $fecha;
  public $uuid;
  public $empleado;
  public $estatus;
  public $retardo;
  public $notificado;
  public $nombreEmpleado;
  public $entrada;
  public $salida;

  public function __construct()
  {
    $this->id = 0;
  }
}

class Empleado
{
  public $id;
  public $nombre;
  public $appat;
  public $apmat;
  public $entrada;
  public $salida;
  public $id_targeta;
  public $email;
  public $celular;
  public $puesto;
  public $imagen;

  public function __construct()
  {
    $this->id = 0;
  }
}


class Targeta
{
  public $id;
  public $uuid;
  public $fecha;

  public function __construct()
  {
    $this->id = 0;
  }
}


class AdministradorChecador extends conectorReloj
{


  public function agregarEmpleado($nombre, $appat, $apmat, $entrada, $salida, $id_targeta, $email, $celular, $puesto, $imagen)
  {
    $sql = 'INSERT INTO empleados (nombre, appat, apmat, entrada, salida, id_targeta, email, celular, puesto, imagen) VALUES ("' . $nombre . '", "' . $appat . '", "' . $apmat . '", "' . $entrada . '", "' . $salida . '", "' . $id_targeta . '", "' . $email . '", "' . $celular . '", "' . $puesto . '", "' . $imagen . '")';
    $this->ejecutar($sql);
  }

  public function dameTargetasUltimoMinuto()
  {

    $fecha = date('Y-m-d H:i:s');

    $fechaMenosUnMinuto = date('Y-m-d H:i:s', strtotime('-1 minute', strtotime($fecha)));
    $fechaMenosSeisHoras = date('Y-m-d H:i:s', strtotime('-6 hours', strtotime($fechaMenosUnMinuto)));
    $sql = 'select * from tarjetas_sin_enrol where fecha > "' . $fechaMenosSeisHoras . '" limit 1';
    $result = $this->ejecutar($sql);
    $asistencias = array();
    while ($row = mysqli_fetch_array($result)) {
      $asistencia = new Targeta();
      $asistencia->id = $row['id'];
      $asistencia->uuid = $row['uuid'];
      $asistencia->fecha = $row['fecha'];
      array_push($asistencias, $asistencia);
    }
    return $asistencias;
  }

  public function cuentaUsuarios()
  {
    $sql = 'SELECT count(*) as total FROM empleados';
    $result = $this->ejecutar($sql);
    $row = mysqli_fetch_array($result);
    return $row['total'];
  }


  public function dameEmpleados()
  {
    $sql = 'SELECT * FROM empleados';
    $result = $this->ejecutar($sql);
    $empleados = array();
    while ($row = mysqli_fetch_array($result)) {
      $empleado = new Empleado();
      $empleado->id = $row['id'];
      $empleado->nombre = $row['nombre'];
      $empleado->appat = $row['appat'];
      $empleado->apmat = $row['apmat'];
      $empleado->entrada = $row['entrada'];
      $empleado->salida = $row['salida'];
      $empleado->id_targeta = $row['id_targeta'];
      $empleado->email = $row['email'];
      $empleado->celular = $row['celular'];
      array_push($empleados, $empleado);
    }
    return $empleados;
  }



  public function dameAsistencias()
  {
    $sql = 'SELECT 
    empleados.nombre,
    DATE(accesos.fecha) AS fecha,
    MIN(TIME(accesos.fecha)) AS hora_entrada,
    MAX(TIME(accesos.fecha)) AS hora_salida
    FROM accesos 
    INNER JOIN empleados ON empleados.id = accesos.empleado
    GROUP BY empleados.nombre, DATE(accesos.fecha)
    ORDER BY accesos.id DESC;';
    $result = $this->ejecutar($sql);
    $asistencias = array();
    while ($row = mysqli_fetch_array($result)) {
      $asistencia = new Asistencia();
      $asistencia->id = $row['id'];

      $asistencia->fecha = $row['fecha'];
      $asistencia->uuid = $row['uuid'];
      $asistencia->empleado = $row['empleado'];
      if ($row['status'] == 1) {
        $asistencia->estatus = 'Entrada';
      } else {
        $asistencia->estatus = 'Salida';
      }
      if ($row['retardo'] == 1) {
        $asistencia->retardo = '<p style="color: red;"> Con Retardo </p>';
      } else {
        $asistencia->retardo = '<p style="color: green;"> Sin Retardo </p>';
      }
      $horaMasUnoEntrada = date('H:i:s', strtotime('+1 hour', strtotime($row['hora_entrada'])));
      $asistencia->entrada = $horaMasUnoEntrada;
      if($row['hora_salida'] == $row['hora_entrada']){
        $asistencia->salida = 'Sin Salida';
      }else{
      $horaMasUnaSalida = date('H:i:s', strtotime('+1 hour', strtotime($row['hora_salida'])));
        $asistencia->salida = $horaMasUnaSalida;

      }
      $asistencia->notificado = $row['notificado'];
      $asistencia->nombreEmpleado = $row['nombre'];
      array_push($asistencias, $asistencia);
    }
    return $asistencias;
  }
}
