<?php
include_once("conectorBD.php");

class PPD
{
    public $id;
    public $nombre;
    public $metodoPago;
    public $moneda;
    public $formaDePago;
    public $estatus;
    public $totalFactura;
    public $empresa;
    public $tipoComprobante;
    public $usoCfdi;
    public $numeroCertificado;
    public $fechaTimbrado;
    public $certificadoSat;
    public $fechaPagado;
    public $complementos;
    public $monto;
    public $saldo;
    public $restante;
    public $token;
    public $accion;


    public function __construct($id, $nombre, $metodoPago, $moneda, $formaDePago, $estatus, $totalFactura, $empresa, $tipoComprobante, $usoCfdi, $numeroCertificado, $fechaTimbrado, $certificadoSat, $fechaPagado, $monto)
    {
        $this->id = $id;
        $this->nombre = $nombre;
        $this->metodoPago = $metodoPago;
        $this->moneda = $moneda;
        $this->formaDePago = $formaDePago;
        $this->estatus = $estatus;
        $this->totalFactura = $totalFactura;
        $this->empresa = $empresa;
        $this->tipoComprobante = $tipoComprobante;
        $this->usoCfdi = $usoCfdi;
        $this->numeroCertificado = $numeroCertificado;
        $this->fechaTimbrado = $fechaTimbrado;
        $this->certificadoSat = $certificadoSat;
        $this->fechaPagado = $fechaPagado;
        $this->monto = $monto;
    }

    public function calculaRestante()
    {
        $total = 0;
        foreach ($this->complementos as $complemento) {
            $total += $complemento->monto;
        }
        $this->restante = $this->totalFactura - $total;
    }
}

class Complemento
{
    public $id;
    public $monto;
    public $idComplemento;
    public $numeroPago;
    public $factura;
    public $saldo;
    public $restante;
    public $token;

    public function __construct($id, $monto, $idComplemento, $numeroPago, $factura, $saldo, $restante)
    {
        $this->id = $id;
        $this->monto = $monto;
        $this->idComplemento = $idComplemento;
        $this->numeroPago = $numeroPago;
        $this->factura = $factura;
        $this->saldo = $saldo;
        $this->restante = $restante;
    }
}


class AdministradorPPD extends conector
{


    public function insertaComplementoRel($idFactura, $idComplemento, $monto, $numPago, $saldo, $restante, $uuid_rel, $folio, $serie)
    {
        $query = "INSERT INTO facturar_rel_complementos (id_factura, id_complemento, monto, num_pago, saldo, restante, uuid_rel, folio, serie) VALUES ('$idFactura', '$idComplemento', '$monto', '$numPago', '$saldo', '$restante', '$uuid_rel', '$folio', '$serie')";
        $this->ejecutar($query);
    }


    public function insertaComplemento ($nombre, $metodo_pago, $moneda, $forma_pago, $status_pago, $total_factura, $razon, $tipo_factura, $uso_cfdi, $num_certificado, $fecha_timbrado, $num_certificado_sat, $fecha_pago, $token, $id_clave_corta, $folio, $serie)
    {
        $query = "INSERT INTO facturas_complementos (nombre, metodo_pago, moneda, forma_pago, status_pago, total_factura, razon, tipo_factura, uso_cfdi, num_certificado, fecha_timbrado, num_certificado_sat, fecha_pago, token, id_clave_corta, folio, serie) VALUES ('$nombre', '$metodo_pago', '$moneda', '$forma_pago', '$status_pago', '$total_factura', '$razon', '$tipo_factura', '$uso_cfdi', '$num_certificado', '$fecha_timbrado', '$num_certificado_sat', '$fecha_pago', '$token', '$id_clave_corta', '$folio', '$serie')";
        $this->ejecutar($query);
        $id = $this->ultimoId();
        return $id;
    }

    public function ultimoId(){
        $query = "SELECT MAX(id) FROM facturas_complementos";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['MAX(id)'];
    }

    public function cuentaComplementos($id)
    {
        $query = "SELECT COUNT(*) FROM facturar_rel_complementos WHERE id_factura = '$id'";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['COUNT(*)'];
    }

    public function dameToken($id)
    {
        $query = "SELECT token FROM `facturas_complementos` WHERE id = $id";
        $result = $this->ejecutar($query);
        $row = mysqli_fetch_array($result);
        return $row['token'];
    }

    public function dameComplementos($id)
    {
        $query = "SELECT * FROM facturar_rel_complementos WHERE id_factura = $id";
        $result = $this->ejecutar($query);
        $complementos = array();
        while ($row = mysqli_fetch_array($result)) {
            $complemento = new Complemento($row['id'], $row['monto'], $row['id_complemento'], $row['num_pago'], $row['id_factura'], $row['saldo'], $row['restante']);
            $complemento->token = $this->dameToken($row['id_complemento']);
            array_push($complementos, $complemento);
        }
        return $complementos;
    }
    public function damePPDs()
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
                INNER JOIN metodos_pago
                ON facturas.metodo_pago = metodos_pago.id
                INNER JOIN empresas
                ON facturas.razon = empresas.id
                WHERE facturas.forma_pago = 23
                ORDER BY facturas.id ASC
        ";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);
            $ppd->complementos = $this->dameComplementos($row['id']);
            $ppd->token = $row['token'];
            $ppd->accion =  "<a href=''>COMPLEMENTO</a>";
            $ppd->calculaRestante();

            array_push($ppds, $ppd);
        }
        return $ppds;
    }

    public function cuentaPpds(){
        $query = "SELECT COUNT(*) FROM facturas WHERE forma_pago = 23";
        $result = $this->ejecutar($query);
        $row = $result->fetch_assoc();
        return $row['COUNT(*)'];
    }

    public function paginacionPPDs($pagina)
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
                INNER JOIN metodos_pago
                ON facturas.metodo_pago = metodos_pago.id
                INNER JOIN empresas
                ON facturas.razon = empresas.id
                WHERE facturas.forma_pago = 23
                ORDER BY facturas.id DESC
                LIMIT 30 OFFSET " . ($pagina - 1) * 30 . ";";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);
            $ppd->complementos = $this->dameComplementos($row['id']);
            $ppd->token = $row['token'];

            $ppd->calculaRestante();

            array_push($ppds, $ppd);
        }
        return $ppds;
    }


    public function damePPD($id)
    {
        $query = "
        SELECT facturas.id, metodos_pago.metodo_pago, facturas.fecha, facturas.nombre, facturas.moneda, facturas.forma_pago, facturas.status_pago, facturas.total_factura, facturas.empresa, facturas.estatus_cert, facturas.certificado, facturas.cadena, facturas.id_factura, empresas.razon, facturas.tipo_factura, facturas.total_sin_iva, facturas.total_iva, facturas.empresa_destino, facturas.token, facturas.tipo_comprobante, facturas.uso_cfdi, facturas.num_certificado, facturas.certificado_fact, facturas.uuid, facturas.fecha_timbrado, facturas.hora_timbrado, facturas.sello_cfd, facturas.num_certificado_sat, facturas.sello_sat, facturas.complemento, facturas.id_pago, facturas.requiere_complemento, facturas.factura_manual, facturas.id_clave_corta, facturas.xml_firmado, facturas.status, facturas.enviado, facturas.cuadrado, facturas.id_captura, facturas.status_error
        FROM facturas
        INNER JOIN metodos_pago
        ON facturas.metodo_pago = metodos_pago.id
        INNER JOIN empresas
        ON facturas.razon = empresas.id
        WHERE facturas.forma_pago = 23
        AND facturas.id = '$id'";
        $result = $this->ejecutar($query);
        $ppds = array();
        while ($row = mysqli_fetch_array($result)) {
            $ppd = new PPD($row['id'], $row['nombre'], $row['metodo_pago'], $row['moneda'], $row['forma_pago'], $row['status_pago'], $row['total_factura'], $row['razon'], $row['tipo_factura'], $row['uso_cfdi'], $row['num_certificado'], $row['fecha_timbrado'], $row['num_certificado_sat'], $row['fecha_pago'], 0);

            $ppd->complementos = $this->dameComplementos($row['id']);

            $ppd->token = $row['token'];

            $ppd->calculaRestante();
            array_push($ppds, $ppd);
        }
        return $ppds;
    }

    public function dameComplementosDePago(){
        
    }
}
