<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Retiro Banca</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/asiel.css" />

    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
    <link rel="stylesheet" type="text/css" href="assets/css/nice-select2.css" />

</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <?php
    function calcular_diferencia_horas($hora_inicio, $hora_fin)
    {
        // Convertir cadenas de hora a objetos DateTime
        $inicio_dt = DateTime::createFromFormat('H:i:s', $hora_inicio);
        $fin_dt = DateTime::createFromFormat('H:i:s', $hora_fin);

        // Calcular la diferencia entre las horas
        $diferencia = $inicio_dt->diff($fin_dt);

        // Calcular la diferencia en minutos
        $minutos = $diferencia->h * 60 + $diferencia->i + $diferencia->s / 60;

        return intval($minutos);
    }
    include "api/adminClientes.php";
    include_once('api/adminUtil.php');
    include_once('api/encriptador.php');
    $adminClientes = new AdministradorClientes();
    $clientes = $adminClientes->dameClientes();
    $adminUtil = new AdministradorUtil();
    $catalogoBancos = $adminUtil->dameCatalogoBancos();
    //echo json_encode($catalogoBancos);
    $alternativa = '';
    switch ($_GET['banca']) {
        case 'del':
            $saldoEmpresa = $adminUtil->dameSaldosStp();
            $empresaSele = "DELMENT";
            $cuentaSalida = 1;
            break;
        case 'wk':
            $saldoEmpresa = $adminUtil->dameSaldosStpWk();
            $empresaSele = "COM WK";

            $cuentaSalida = 2;
            break;
        case 'enc':
            $saldoEmpresa = $adminUtil->dameSaldosStpEn();
            $empresaSele = "ENCLENCI";

            $cuentaSalida = 3;
            break;
    }

    $token = $_SESSION['token_autoriza'];
    //acortar a 20 caracteres 
    $token = substr($token, 0, 10);
    $token = $token . "...";
    $tokenInfo = desencriptar($_SESSION['token_autoriza']);
    $tokenInfo = explode(",", $tokenInfo);
    $idUsuario = $tokenInfo[0];
    $nombreUsuario = $tokenInfo[1];
    $fecha = $tokenInfo[2];
    $hora = $tokenInfo[3];
    //hora mas 30 minutos 
    $horaCaduca = date("H:i:s", strtotime($hora . '+30 minutes'));
    $horaActual = date("H:i:s", strtotime('-6 hour'));
    $diferencia = calcular_diferencia_horas($horaCaduca, $horaActual);
    echo "<script>console.log('hora token : " . $horaCaduca . "');</script>";
    echo "<script>console.log('hora actual : " . $horaActual . "');</script>";
    echo "<script>console.log('diferencia : " . $diferencia . "');</script>";


    ?>
    <script>
        var clientes = [];
        var saldos = [];
        var cuentaDeSalida = <?php echo $cuentaSalida ?>;
        var contadorMovimientos = 1;
        var saldoStp = "<?php echo $adminUtil->dameSaldosStp() ?>";
        var saldoStpWk = "<?php echo number_format($adminUtil->dameSaldosStpWk()) ?>";
        var valLog = false;
        console.log("El saldo de DELMENT ES : " + saldoStp);
        console.log("El saldo de WK ES : " + saldoStpWk);
    </script>
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <div class="containerL">
            <div class="item item-1"></div>
            <div class="item item-2"></div>
            <div class="item item-3"></div>
            <div class="item item-4"></div>
        </div>

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex min-h-screen flex-col">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>
            <!-- end header section -->

            <?php

            if ($_SESSION['token_autoriza']) {



            ?>

                <div class="animate__animated p-6" :class="[$store.app.animation]">
                    <!-- start main content section -->
                    <div x-data="sales">
                        <ul class="flex space-x-2 rtl:space-x-reverse">
                            <li>
                                <a href="javascript:;" class="text-primary hover:underline">Banca</a>
                            </li>
                            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                                <span>Retiro</span>
                            </li>
                        </ul>



                        <br>

                        <div class="grid grid-cols-1 gap-6 xl:grid-cols-1">
                            <!-- Favorites -->
                            <div>
                                <div class="mb-5 flex items-center font-bold">
                                    <span class="text-lg">Clientes para retiro</span>


                                </div>




                                <div class="grid grid-cols-1 gap-6 sm:grid-cols-5 md:mb-5">

                                    <!-- Bitcoin -->
                                    <div class="panel">
                                        <div class="mb-5 flex items-center font-semibold">
                                            <div class="grid h-10 w-10 shrink-0 place-content-center rounded-full">
                                                <img src="img/stp.png" alt="">
                                            </div>
                                            <div class="ltr:ml-2 rtl:mr-2">
                                                <h6 class="text-dark dark:text-white-light"><?php echo $empresaSele ?> (<?php echo $nombreUsuario ?>)</h6>
                                                <p class="text-xs text-white-dark">Token STP: <?php echo $token ?> </p>
                                            </div>
                                        </div>
                                        <div class="mb-5 overflow-hidden">
                                            <div x-ref="bitcoin" style="min-height: 45px;">
                                                <div id="apexcharts1u4a1411k" class="apexcharts-canvas apexcharts1u4a1411k apexcharts-theme-light" style="width: 252px; height: 45px;">
                                                    <div class="flex items-center justify-between text-base font-bold">
                                                        $ <?php echo number_format($saldoEmpresa, 2) ?>
                                                    </div>

                                                    <div class="flex items-center justify-between text-base font-bold">
                                                        Caducidad: <p id="contador"></p> <?php echo $fecha  ?>
                                                    </div>

                                                    <div class="apexcharts-legend" style="max-height: 22.5px;"></div>
                                                    <div class="apexcharts-tooltip apexcharts-theme-light">
                                                        <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(0, 171, 85);"></span>
                                                            <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                                <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-y-label"></span><span class="apexcharts-tooltip-text-y-value"></span></div>
                                                                <div class="apexcharts-tooltip-goals-group"><span class="apexcharts-tooltip-text-goals-label"></span><span class="apexcharts-tooltip-text-goals-value"></span></div>
                                                                <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                        <div class="apexcharts-yaxistooltip-text"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex items-center justify-between text-base font-bold">
                                            $ <?php echo number_format($saldoEmpresa, 2) ?>
                                        </div>
                                    </div>

                                    <?php
                                    $indice = 0;
                                    foreach ($clientes as $cliente) {
                                        echo '<script> clientes.push(' . $cliente->id . '); </script>';


                                        echo '
                
                                            <div class="panel" style="display: none;" id="targetaCliente' . $cliente->id . '">
                                                <div class="mb-5 flex items-center font-semibold">
                                                    <div class="grid h-10 w-10 shrink-0 place-content-center rounded-full">
                                                            <img src="' . $cliente->imagen . '" alt="">

                                                    </div>
                                                    <div class="ltr:ml-2 rtl:mr-2">
                                                        <h6 class="text-dark dark:text-white-light">' . $cliente->nombre . '</h6>
                                                        <p class="text-xs text-white-dark">Cliente: ' . $cliente->id . '</p>
                                                    </div>
                                                </div>
                                                <div class="mb-5 overflow-hidden">
                                                    <div x-ref="bitcoin" style="min-height: 45px;">
                                                        <div id="apexcharts1u4a1411k" class="apexcharts-canvas apexcharts1u4a1411k apexcharts-theme-light" style="width: 252px; height: 45px;">
                                                            <div class="flex items-center justify-between text-base font-bold"  id="espacioSaldo' . $cliente->id . '">
                                                                CARGANDO...
                                                            </div>

                                                            <div class="apexcharts-legend" style="max-height: 22.5px;"></div>
                                                            <div class="apexcharts-tooltip apexcharts-theme-light">
                                                                <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(0, 171, 85);"></span>
                                                                    <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                                        <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-y-label"></span><span class="apexcharts-tooltip-text-y-value"></span></div>
                                                                        <div class="apexcharts-tooltip-goals-group"><span class="apexcharts-tooltip-text-goals-label"></span><span class="apexcharts-tooltip-text-goals-value"></span></div>
                                                                        <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                                <div class="apexcharts-yaxistooltip-text"></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="flex items-center justify-between text-base font-bold"  id="espacioSaldoPosterior' . $cliente->id  . '">
                                                    (Primero ingrese un monto)
                                                </div>
                                            </div>
                
                                         ';
                                    }

                                    $indice++;

                                    ?>


                                </div>



                            </div>

                            <!-- Live Prices -->

                        </div>




                        <div class="pt-5">




                            <div class="panel">
                                <div class="mb-5 flex items-center justify-between">
                                    <h5 class="text-lg font-semibold dark:text-white-light">Formulario de nuevo retiro</h5>

                                </div>


                                <div class="mb-5">
                                    <div class="grid grid-cols-4 gap-4">

                                        <a href="banca-retiro-plantilla.php?banca=<?php echo $_GET['banca'] ?>" class="btn btn-primary gap-2">
                                            <svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 4h3c.6 0 1 .4 1 1v15c0 .6-.4 1-1 1H6a1 1 0 0 1-1-1V5c0-.6.4-1 1-1h3m0 3h6m-3 5h3m-6 0h0m3 4h3m-6 0h0m1-13v4h4V3h-4Z" />
                                            </svg>
                                            Usar plantilla
                                        </a>
                                    </div>
                                    <br><br>
                                    <div class="grid grid-cols-4 gap-4">
                                        <div>
                                            <label for="cliente-o">Cliente de salida </label>
                                            <!-- searchable -->
                                            <select onchange="obtenerSaldo(this.value,0)" name="cliente-0" id="cliente-0">
                                                <?php

                                                foreach ($clientes as $cliente) {
                                                    echo '<option value="' . $cliente->id . '">' . $cliente->nombre . '</option>';
                                                }

                                                ?>
                                            </select>

                                            <!-- script -->
                                            <script>
                                                document.addEventListener("DOMContentLoaded", function(e) {
                                                    // seachable 
                                                    var options = {
                                                        searchable: true
                                                    };
                                                    NiceSelect.bind(document.getElementById("cliente-0"), options);
                                                });
                                            </script>
                                        </div>
                                        <div>
                                            <label for="browserState">Nombre / Contacto</label>
                                            <input id="nombre-0" name="nombre-0" oninput="trasnformaMayusculas(0)" type="text" placeholder="Nombre..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState" id="letrero0">Tarjeta / Clabe </label>
                                            <input id="numero-0" name="numero0" oninput="verificarCadena(0)" onchange="validarTargeta(this.value, 0)" type="text" placeholder="Tarjeta..." class="form-input" required="">
                                            <input type="text" name="idBanco" autofocus autocomplete="off" id="idBanco0" style="display: none;">
                                            <label for="browserState" id="letrero-error0"></label>

                                        </div>
                                        <div>
                                            <label for="browserState">Monto</label>
                                            <input id="monto-0" oninput="restaSaldoCliente(0)" name="monto-0" type="text" placeholder="Monto..." class="form-input" required="">
                                        </div>

                                    </div>
                                    <br>

                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                        <div>
                                            <label for="browserState">Correos</label>
                                            <input id="correo-0" name="correo-0" type="text" placeholder="Correos..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState">Concepto </label>
                                            <input id="concepto-0" name="concepto-0" type="text" placeholder="Concepto..." class="form-input" required="">
                                        </div>


                                    </div>



                                    <br>



                                    <div class="grid grid-cols-4 gap-4" style="display: none;" id="movimiento-1">


                                        <div>
                                            <label for="cliente-o">Cliente de salida </label>
                                            <!-- searchable -->
                                            <select onchange="obtenerSaldo(this.value,1)" name="cliente-1" id="cliente-1">
                                                <?php

                                                foreach ($clientes as $cliente) {
                                                    echo '<option value="' . $cliente->id . '">' . $cliente->nombre . '</option>';
                                                }

                                                ?>
                                            </select>

                                            <!-- script -->
                                            <script>
                                                document.addEventListener("DOMContentLoaded", function(e) {
                                                    // seachable 
                                                    var options = {
                                                        searchable: true
                                                    };
                                                    NiceSelect.bind(document.getElementById("cliente-1"), options);
                                                });
                                            </script>
                                        </div>
                                        <div>
                                            <label for="browserState">Nombre / Contacto</label>
                                            <input id="nombre-1" name="nombre-1" oninput="trasnformaMayusculas(1)" type="text" placeholder="Nombre..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState" id="letrero1">Tarjeta / Clabe </label>
                                            <input id="numero-1" name="numero-1" type="text" placeholder="Tarjeta..." class="form-input" required="">
                                            <input type="text" name="idBanco" autofocus autocomplete="off" id="idBanco1" style="display: none;">
                                            <label for="browserState" id="letrero-error1"></label>
                                        </div>
                                        <div>
                                            <label for="browserState">Monto</label>
                                            <input id="monto-1" oninput="restaSaldoCliente(1)" name="monto-1" type="text" placeholder="Monto..." class="form-input" required="">
                                        </div>

                                    </div>
                                    <br>
                                    <div class="grid grid-cols-2 gap-5 md:grid-cols-1" style="display: none;" id="concep-1">
                                        <div>
                                            <label for="browserState">Correos</label>
                                            <input id="correo-1" name="correo-1" type="text" placeholder="Correos..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState">Concepto </label>
                                            <input id="concepto-1" name="concepto-1" type="text" placeholder="Concepto..." class="form-input" required="">
                                        </div>


                                    </div>







                                    <br>



                                    <div class="grid grid-cols-4 gap-4" style="display: none;" id="movimiento-2">


                                        <div>
                                            <label for="cliente-o">Cliente de salida </label>
                                            <!-- searchable -->
                                            <select onchange="obtenerSaldo(this.value,2)" name="cliente-2" id="cliente-2">
                                                <?php

                                                foreach ($clientes as $cliente) {
                                                    echo '<option value="' . $cliente->id . '">' . $cliente->nombre . '</option>';
                                                }

                                                ?>
                                            </select>

                                            <!-- script -->
                                            <script>
                                                document.addEventListener("DOMContentLoaded", function(e) {
                                                    // seachable 
                                                    var options = {
                                                        searchable: true
                                                    };
                                                    NiceSelect.bind(document.getElementById("cliente-2"), options);
                                                });
                                            </script>
                                        </div>
                                        <div>
                                            <label for="browserState">Nombre / Contacto</label>
                                            <input id="nombre-2" name="nombre-2" oninput="trasnformaMayusculas(2)" type="text" placeholder="Nombre..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState" id="letrero2">Tarjeta / Clabe </label>
                                            <input id="numero-2" name="numero-2" type="text" placeholder="Tarjeta..." class="form-input" required="">
                                            <input type="text" name="idBanco" autofocus autocomplete="off" id="idBanco2" style="display: none;">
                                            <label for="browserState" id="letrero-error2"></label>
                                        </div>
                                        <div>
                                            <label for="browserState">Monto</label>
                                            <input id="monto-2" oninput="restaSaldoCliente(2)" name="monto-2" type="text" placeholder="Monto..." class="form-input" required="">
                                        </div>

                                    </div>







                                    <br>
                                    <div class="grid grid-cols-2 gap-5 md:grid-cols-1" style="display: none;" id="concep-2">
                                        <div>
                                            <label for="browserState">Correos</label>
                                            <input id="correo-2" name="correo-2" type="text" placeholder="Correos..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState">Concepto </label>
                                            <input id="concepto-2" name="concepto-2" type="text" placeholder="Concepto..." class="form-input" required="">
                                        </div>


                                    </div>












                                    <br>



                                    <div class="grid grid-cols-4 gap-4" style="display: none;" id="movimiento-3">


                                        <div>
                                            <label for="cliente-o">Cliente de salida </label>
                                            <!-- searchable -->
                                            <select onchange="obtenerSaldo(this.value,3)" name="cliente-3" id="cliente-3">
                                                <?php

                                                foreach ($clientes as $cliente) {
                                                    echo '<option value="' . $cliente->id . '">' . $cliente->nombre . '</option>';
                                                }

                                                ?>
                                            </select>

                                            <!-- script -->
                                            <script>
                                                document.addEventListener("DOMContentLoaded", function(e) {
                                                    // seachable 
                                                    var options = {
                                                        searchable: true
                                                    };
                                                    NiceSelect.bind(document.getElementById("cliente-3"), options);
                                                });
                                            </script>
                                        </div>
                                        <div>
                                            <label for="browserState">Nombre / Contacto</label>
                                            <input id="nombre-3" name="nombre-3" oninput="trasnformaMayusculas(3)" type="text" placeholder="Nombre..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState" id="letrero3">Tarjeta / Clabe </label>
                                            <input id="numero-3" name="numero-3" type="text" placeholder="Tarjeta..." class="form-input" required="">
                                            <input type="text" name="idBanco" autofocus autocomplete="off" id="idBanco3" style="display: none;">
                                            <label for="browserState" id="letrero-error3"></label>
                                        </div>
                                        <div>
                                            <label for="browserState">Monto</label>
                                            <input id="monto-3" oninput="restaSaldoCliente(3)" name="monto-3" type="text" placeholder="Monto..." class="form-input" required="">
                                        </div>

                                    </div>







                                    <br>
                                    <div class="grid grid-cols-2 gap-5 md:grid-cols-1" style="display: none;" id="concep-3">
                                        <div>
                                            <label for="browserState">Correos</label>
                                            <input id="correo-3" name="correo-3" type="text" placeholder="Correos..." class="form-input" required="">
                                        </div>
                                        <div>
                                            <label for="browserState">Concepto </label>
                                            <input id="concepto-3" name="concepto-3" type="text" placeholder="Concepto..." class="form-input" required="">
                                        </div>


                                    </div>



                                </div>











                                <div style="display: flex; justify-content: center;">
                                    <button onclick="dibujarSiguiente()" style="width: 20%;" class="btn btn-primary !mt-6">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5">
                                            <line x1="12" y1="5" x2="12" y2="19"></line>
                                            <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        Nuevo movimiento
                                    </button>
                                </div>




                                <button type="submit" onclick="enviarMovimientos()" class="btn btn-primary !mt-6">Terminar</button>
                            </div>

                        </div>





                    </div>
                </div>
            <?php } else {
                echo '<div class="animate__animated p-6" :class="[$store.app.animation]">';
                echo "<h1>NO TIENES PERMISOS PARA ESTAR AQUI</h1>";
                echo '</div>';
            }


            ?>
        </div>
        <!-- end main content section -->

        <!-- start footer section -->
        <div class="mt-auto p-6 pt-0 text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
            © <span id="footer-year">2023</span>. Sistema 14 Ultra All rights reserved.
        </div>
        <!-- end footer section -->
    </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script defer src="assets/js/apexcharts.js"></script>
    <script src="assets/js/nice-select2.js"></script>

    <script>
        startCountdown(<?php echo number_format($diferencia, 1)  ?>);

        function startCountdown(hora) {
            // Convert hours to minutes for the countdown
            let totalMinutes = hora * 60;

            // Get the target div for displaying the countdown
            let contadorDiv = document.getElementById("contador");

            // Update the countdown every second
            let countdownInterval = setInterval(function() {
                // Calculate minutes and seconds
                let minutes = Math.floor(totalMinutes / 60);
                let seconds = totalMinutes % 60;

                // Display the countdown in the specified div
                contadorDiv.textContent = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;

                // Check if the countdown reaches zero
                if (totalMinutes <= 0) {
                    // Clear the interval and display a message when the countdown is finished
                    clearInterval(countdownInterval);
                    contadorDiv.textContent = "Tiempo agotado";
                    //redirigir index 
                    window.location.href = "index.php";
                } else {
                    // Decrement the total minutes
                    totalMinutes--;
                }
            }, 1000); // Update every second
        }

        // Example usage: startCountdown(0.5) for 30 minutes
    </script>
    <script>
        function dibujarSiguiente() {
            var campoMovimiento = document.getElementById("movimiento-" + contadorMovimientos);
            var campoConcepto = document.getElementById("concep-" + contadorMovimientos);
            campoMovimiento.style.display = "";
            campoConcepto.style.display = "";
            contadorMovimientos++;
        }
    </script>
    <script>
        class clienteSeleccionado {
            constructor(id, saldo, grupo) {
                this.id = id;
                this.saldo = saldo;
                this.grupo = grupo;
            }
        }
        clientesSelect = [];
    </script>

    <script>
        var errorSaldoInsuficiente = false;

        function restaSaldoCliente(id) {
            errorSaldoInsuficiente = false;
            var cliente = document.getElementById("cliente-" + id).value;
            console.log(cliente);
            var espacioSaldo = document.getElementById("espacioSaldoPosterior" + cliente);
            for (var i = 0; i < contadorMovimientos; i++) {
                for (var j = 0; j < clientesSelect.length; j++) {
                    if (clientesSelect[j].id == cliente) {
                        console.log("Intentando obtener monto " + i);
                        var monto = document.getElementById("monto-" + i).value;
                        if (monto == "") {
                            monto = 0;
                        }
                        var saldo = clientesSelect[j].saldo;
                        console.log("El saldo es: " + saldo);
                        var grupo = clientesSelect[j].grupo;
                        var montoTotal = parseFloat(saldo) - parseFloat(monto);
                        if (montoTotal <= 0) {
                            errorSaldoInsuficiente = true;
                        }
                        var montoTotalFormato = new Intl.NumberFormat('en-US', {
                            style: 'currency', // Puedes usar 'decimal', 'currency' o 'percent'
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2,
                            currency: 'USD',
                            currencyDisplay: 'symbol', // Puedes usar 'symbol', 'code' o 'name'
                            useGrouping: true
                        }).format(montoTotal);

                        espacioSaldo.innerHTML = "Saldo posterior: " + montoTotalFormato;
                    }
                }
            }
        }
    </script>


    <script>
        var ecnotnrados = [];
        var clientesEncontrados = [];


        function obtenerSaldo(cliente, indice) {
            clientesSelect = [];
            banOkc = true;
            // var montoCliente = document.getElementById("monto-" + indice);
            // montoCliente.value = "";


            ecnotnrados = [];
            clientesEncontrados = [];
            for (var i = 0; i < contadorMovimientos; i++) {
                console.log("Entro al for");
                console.log(i + " VALE I ");

                if (!movimientosOmitidos.includes(i)) {
                    var valorCliente = document.getElementById("cliente-" + i).value;
                    for (var j = 0; j < clientes.length; j++) {
                        var clienteSolicitado = document.getElementById("targetaCliente" + clientes[j]);
                        //console.log(cliente + " " + clientes[j]);
                        if ((parseInt(clientes[j]) === parseInt(valorCliente)) || ecnotnrados.includes(j)) {
                            clienteSolicitado.style.display = "block";
                            ecnotnrados.push(j);
                            clientesEncontrados.push(clientes[j]);





                            var enviaDatosCliente = new FormData();
                            enviaDatosCliente.append("cliente", cliente);
                            enviaDatosCliente.append("accion", "saldoCliente");
                            fetch("api/apiClientes.php", {
                                    method: "POST",
                                    body: enviaDatosCliente,
                                })
                                .then((respuesta) => respuesta.json())
                                .then((data) => {

                                    //console.log(data);
                                    var saldo = data.saldo;
                                    var grupo = data.grupo;
                                    var saldoTotal = new Intl.NumberFormat('en-US', {
                                        style: 'currency', // Puedes usar 'decimal', 'currency' o 'percent'
                                        minimumFractionDigits: 2,
                                        maximumFractionDigits: 2,
                                        currency: 'USD',
                                        currencyDisplay: 'symbol', // Puedes usar 'symbol', 'code' o 'name'
                                        useGrouping: true
                                    }).format(saldo);

                                    var espacioSaldo = document.getElementById("espacioSaldo" + data.cliente);
                                    espacioSaldo.innerHTML = saldoTotal;
                                    if (!ecnotnrados.includes(j)) {
                                        clientesSelect.push(new clienteSeleccionado(data.cliente, data.saldo, data.grupo));
                                    }
                                    console.log(clientesSelect);
                                });




                        } else {
                            clienteSolicitado.style.display = "none";

                        }
                    }
                }


            }




        }
    </script>

    <script>
        var movimientosOmitidos = [];

        function limpiarCampo(indice) {
            var campoMovimiento = document.getElementById("movimiento" + indice);
            movimientosOmitidos.push(indice);
            var numero = document.getElementById("numero-" + indice);
            numero.value = "";
            var cliente = document.getElementById("cliente-" + indice);
            cliente.value = 0;
            var nombre = document.getElementById("nombre-" + indice);
            nombre.value = "";
            var monto = document.getElementById("monto-" + indice);
            monto.value = "0";
            var idBanco = document.getElementById("idBanco" + indice);
            idBanco.value = "";
            var letrero = document.getElementById("letrero" + indice);
            letrero.innerHTML = "Número Tarjeta / CLABE Interbancaria";
            obtenerSaldo(0, 0);
            calculaMonto();
            campoMovimiento.style.display = "none";
        }
    </script>



    <script>
        var promesas = [];

        function enviarMovimientos() {
            if (!errorSaldoInsuficiente) {


                for (var i = 0; i < contadorMovimientos; i++) {

                    if (!movimientosOmitidos.includes(i)) {
                        var cliente = document.getElementById("cliente-" + i).value;
                        var nombre = document.getElementById("nombre-" + i).value;
                        var numero = document.getElementById("numero-" + i).value;
                        var monto = document.getElementById("monto-" + i).value;
                        var idBanco = document.getElementById("idBanco" + i).value;
                        var conceptoD = document.getElementById("concepto-" + i).value;
                        // usuarioInserta, $2fa, idBanco
                        promesas.push(envioDatos(nombre, "", monto, numero, i, "", conceptoD));
                    } else {
                        console.log("OMITIDO movimiento " + i);
                    }

                }

                Promise.all(promesas).then(function() {
                    console.log("Todas las " + promesas.length + " promesas se cumplieron");
                    //window.location.href = "/historial";
                    Swal.fire({
                        title: 'Retiro(s) exitoso(s)',
                        text: 'Se enviara un correo con el comprobante de retiro',
                        icon: 'success',
                        confirmButtonText: 'Ok'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "mov-stp.php";
                        }
                    })
                }).catch(function(error) {
                    console.log("Alguna promesa fallo");
                    console.log(error);
                    Swal.fire({
                        title: 'Error',
                        text: 'Ocurrio un error al realizar el retiro',
                        icon: 'error',
                        confirmButtonText: 'Ok'
                    })
                });
            } else if (<?php echo $idUsuario ?> == 82 || <?php echo $idUsuario ?> == 1 || <?php echo $idUsuario ?> == 32||1==1) {

                for (var i = 0; i < contadorMovimientos; i++) {

                    if (!movimientosOmitidos.includes(i)) {
                        var cliente = document.getElementById("cliente-" + i).value;
                        var nombre = document.getElementById("nombre-" + i).value;
                        var numero = document.getElementById("numero-" + i).value;
                        var monto = document.getElementById("monto-" + i).value;
                        var idBanco = document.getElementById("idBanco" + i).value;
                        var conceptoD = document.getElementById("concepto-" + i).value;
                        // usuarioInserta, $2fa, idBanco
                        promesas.push(envioDatos(nombre, "", monto, numero, i, "", conceptoD));
                    } else {
                        console.log("OMITIDO movimiento " + i);
                    }


                }

                Promise.all(promesas).then(function() {
                    console.log("Todas las " + promesas.length + " promesas se cumplieron");
                    //window.location.href = "/historial";
                    Swal.fire({
                        title: 'Retiro(s) exitoso(s) con permiso negativo',
                        text: 'Se enviara un correo con el comprobante de retiro',
                        icon: 'success',
                        confirmButtonText: 'Ok'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "mov-stp.php";
                        }
                    })
                }).catch(function(error) {
                    console.log("Alguna promesa fallo");
                    console.log(error);
                    Swal.fire({
                        title: 'Error',
                        text: 'Ocurrio un error al realizar el retiro',
                        icon: 'error',
                        confirmButtonText: 'Ok'
                    })
                });
            } else {
                Swal.fire({
                    title: 'Alguno de los clientes no cuenta con saldo',
                    text: 'Verifique los montos',
                    icon: 'error',
                    confirmButtonText: 'Ok'
                }).then((result) => {
                    if (result.isConfirmed) {

                    }
                });
            }
        }
    </script>



    <script>
        async function envioDatos(nombre, varlor, monto, numero, indice, correos, concepto) {
            try {
                var envioDatosCuenta = new FormData();
                envioDatosCuenta.append("2fa", varlor);
                envioDatosCuenta.append("monto", monto);
                envioDatosCuenta.append("numero", numero);
                envioDatosCuenta.append("nombre", nombre);
                envioDatosCuenta.append("idBanco", document.getElementById(`idBanco${indice}`).value);
                envioDatosCuenta.append("correos", correos);
                envioDatosCuenta.append("usuarioInserta", <?php echo $_SESSION["usuario_id"] ?>);
                envioDatosCuenta.append("cliente", document.getElementById(`cliente-${indice}`).value);
                envioDatosCuenta.append("cuentaSalida", cuentaDeSalida);
                envioDatosCuenta.append("concepto", concepto);
                return fetch("envia_retiro_fun_mult.php", {
                        method: "POST",
                        body: envioDatosCuenta,
                    })
                    .then((respuesta) => respuesta.json())
                    .then((data) => {
                        console.log(data);
                        if (data.status == 'ok') {
                            var espacioNombre = document.getElementById(`nombre-${indice}`);
                            var espacioNumero = document.getElementById(`numero-${indice}`);
                            var espacioMonto = document.getElementById(`monto-${indice}`);
                            var espacioSaldo = document.getElementById(`espacioSaldo${data.cliente}`);
                            //desactivar campo 
                            espacioNombre.disabled = true;
                            espacioNumero.disabled = true;
                            espacioMonto.disabled = true;
                        } else {
                            var espacioNombre = document.getElementById(`nombre-${indice}`);
                            var espacioNumero = document.getElementById(`numero-${indice}`);
                            var espacioMonto = document.getElementById(`monto-${indice}`);
                            var espacioSaldo = document.getElementById(`espacioSaldo${data.cliente}`);
                            //desactivar campo 
                            espacioNombre.disabled = true;
                            espacioNumero.disabled = true;
                            espacioMonto.disabled = true;
                        }
                    });
            } catch (error) {
                console.log("Error en la promesa");
                console.log(error);
            }
        }
    </script>


    <script>
        function limpiarCadena(cadena) {
            // Reemplazar caracteres con tilde
            cadena = cadena.replace(/[áÁ]/g, 'a')
                .replace(/[éÉ]/g, 'e')
                .replace(/[íÍ]/g, 'i')
                .replace(/[óÓ]/g, 'o')
                .replace(/[úÚ]/g, 'u')
                .replace(/[ñÑ]/g, 'n');
            return cadena;
        }
    </script>

    <script>
        function trasnformaMayusculas(indice) {
            var campo = document.getElementById(`nombre-${indice}`);
            var cadena = campo.value;
            cadena = limpiarCadena(cadena);
            campo.value = cadena.toUpperCase();
        }
    </script>

    <script>
        function verificarCadena(indice) {
            var numero = document.getElementById("numero-" + indice).value;
            var numeroACadena = numero.toString();
            var caracteresNumero = numeroACadena.length;
            var letreroError = document.getElementById("letrero" + indice);
            if (caracteresNumero == 16 || caracteresNumero == 18) {
                letreroError.innerHTML = "";
            } else {
                letreroError.innerHTML = "El numero debe contener 16 o 18 caracteres";
            }
        }
    </script>


    <script>
        function validarTargeta(numero, indice) {
            console.log(numero);
            var numero = numero.toString();
            var campo = document.getElementById(`letrero-error${indice}`);
            //primerDigito 
            var primerDigito = numero.substring(0, 1);
            //contar caracteres de numer 
            var tamanoNumero = numero.length;
            if (tamanoNumero == 16) {
                var bin = numero.substring(0, 6);
                if (bin.length == 6) {
                    console.log(determinarBanco(bin, indice));
                }
            } else if (tamanoNumero == 18) {
                campo.innerHTML = "Clabe Interbancaria";
                campo.style.color = "black";
            } else {
                campo.innerHTML = "Número Tarjeta / Clabe Interbancaria";
                campo.style.color = "black";

            }
        }
    </script>

    <script>
        function determinarBanco(numero, indice) {

            var respuesta = "";

            var myHeaders = new Headers();
            myHeaders.append("Accept-Version", "3");

            var requestOptions = {
                method: 'GET',
                headers: myHeaders,
                redirect: 'follow'
            };

            fetch("api/dameBancoCatalogoL.php?numero=" + numero, requestOptions)
                .then(response => response.text())
                .then(result => {
                    var resultado = JSON.parse(result);
                    var campobanco = document.getElementById(`idBanco${indice}`);
                    var campo = document.getElementById(`letrero${indice}`);
                    var campoMonto = document.getElementById(`monto-${indice}`);
                    campo.style.color = "black";
                    campoMonto.disabled = false;
                    campo.innerHTML = resultado.bank.name;
                    console.log(resultado.bank.name);
                    var envioDatosCuenta = new FormData();
                    envioDatosCuenta.append("nombre", resultado.bank.name);
                    fetch("api/dameBancoCatalogo.php", {
                            method: "POST",
                            body: envioDatosCuenta,
                        })
                        .then((respuesta2) => respuesta2.json())
                        .then((data2) => {
                            console.log("CAMPO " + campobanco);
                            campobanco.value = data2;
                        });


                })
                .catch(error => {
                    var espacioBanco = document.getElementById(`espacioBancoMan-${indice}`);
                    var campo = document.getElementById(`letrero${indice}`);
                    var campoMonto = document.getElementById(`monto-${indice}`);
                    campo.innerHTML = "No se encontro el banco";
                    campo.style.color = "red";
                    campoMonto.disabled = true;
                    campoMonto.value = "0";
                    espacioBanco.style.display = "block";
                });




        }
    </script>



    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));

            // content section
            Alpine.data('sales', () => ({
                init() {
                    isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;
                    isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;

                    const revenueChart = null;
                    const salesByCategory = null;
                    const dailySales = null;
                    const totalOrders = null;

                    // revenue
                    setTimeout(() => {
                        this.revenueChart = new ApexCharts(this.$refs.revenueChart, this.revenueChartOptions);
                        this.$refs.revenueChart.innerHTML = '';
                        this.revenueChart.render();

                        // sales by category
                        this.salesByCategory = new ApexCharts(this.$refs.salesByCategory, this.salesByCategoryOptions);
                        this.$refs.salesByCategory.innerHTML = '';
                        this.salesByCategory.render();

                        // daily sales
                        this.dailySales = new ApexCharts(this.$refs.dailySales, this.dailySalesOptions);
                        this.$refs.dailySales.innerHTML = '';
                        this.dailySales.render();

                        // total orders
                        this.totalOrders = new ApexCharts(this.$refs.totalOrders, this.totalOrdersOptions);
                        this.$refs.totalOrders.innerHTML = '';
                        this.totalOrders.render();
                    }, 300);

                    this.$watch('$store.app.theme', () => {
                        isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;

                        this.revenueChart.updateOptions(this.revenueChartOptions);
                        this.salesByCategory.updateOptions(this.salesByCategoryOptions);
                        this.dailySales.updateOptions(this.dailySalesOptions);
                        this.totalOrders.updateOptions(this.totalOrdersOptions);
                    });

                    this.$watch('$store.app.rtlClass', () => {
                        isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;
                        this.revenueChart.updateOptions(this.revenueChartOptions);
                    });
                },

                // revenue
                get revenueChartOptions() {
                    return {
                        series: [{
                                name: 'Income',
                                data: [16800, 16800, 15500, 17800, 15500, 17000, 19000, 16000, 15000, 17000, 14000, 17000],
                            },
                            {
                                name: 'Expenses',
                                data: [16500, 17500, 16200, 17300, 16000, 19500, 16000, 17000, 16000, 19000, 18000, 19000],
                            },
                        ],
                        chart: {
                            height: 325,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            zoom: {
                                enabled: false,
                            },
                            toolbar: {
                                show: false,
                            },
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            curve: 'smooth',
                            width: 2,
                            lineCap: 'square',
                        },
                        dropShadow: {
                            enabled: true,
                            opacity: 0.2,
                            blur: 10,
                            left: -7,
                            top: 22,
                        },
                        colors: isDark ? ['#2196f3', '#e7515a'] : ['#1b55e2', '#e7515a'],
                        markers: {
                            discrete: [{
                                    seriesIndex: 0,
                                    dataPointIndex: 6,
                                    fillColor: '#1b55e2',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                                {
                                    seriesIndex: 1,
                                    dataPointIndex: 5,
                                    fillColor: '#e7515a',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                            ],
                        },
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        xaxis: {
                            axisBorder: {
                                show: false,
                            },
                            axisTicks: {
                                show: false,
                            },
                            crosshairs: {
                                show: true,
                            },
                            labels: {
                                offsetX: isRtl ? 2 : 0,
                                offsetY: 5,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-xaxis-title',
                                },
                            },
                        },
                        yaxis: {
                            tickAmount: 7,
                            labels: {
                                formatter: (value) => {
                                    return value / 1000 + 'K';
                                },
                                offsetX: isRtl ? -30 : -10,
                                offsetY: 0,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-yaxis-title',
                                },
                            },
                            opposite: isRtl ? true : false,
                        },
                        grid: {
                            borderColor: isDark ? '#191e3a' : '#e0e6ed',
                            strokeDashArray: 5,
                            xaxis: {
                                lines: {
                                    show: true,
                                },
                            },
                            yaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 0,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        legend: {
                            position: 'top',
                            horizontalAlign: 'right',
                            fontSize: '16px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            itemMargin: {
                                horizontal: 10,
                                vertical: 5,
                            },
                        },
                        tooltip: {
                            marker: {
                                show: true,
                            },
                            x: {
                                show: false,
                            },
                        },
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: isDark ? 0.19 : 0.28,
                                opacityTo: 0.05,
                                stops: isDark ? [100, 100] : [45, 100],
                            },
                        },
                    };
                },

                // sales by category
                get salesByCategoryOptions() {
                    return {
                        series: [985, 737, 270],
                        chart: {
                            type: 'donut',
                            height: 460,
                            fontFamily: 'Nunito, sans-serif',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 25,
                            colors: isDark ? '#0e1726' : '#fff',
                        },
                        colors: isDark ? ['#5c1ac3', '#e2a03f', '#e7515a', '#e2a03f'] : ['#e2a03f', '#5c1ac3', '#e7515a'],
                        legend: {
                            position: 'bottom',
                            horizontalAlign: 'center',
                            fontSize: '14px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            height: 50,
                            offsetY: 20,
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    size: '65%',
                                    background: 'transparent',
                                    labels: {
                                        show: true,
                                        name: {
                                            show: true,
                                            fontSize: '29px',
                                            offsetY: -10,
                                        },
                                        value: {
                                            show: true,
                                            fontSize: '26px',
                                            color: isDark ? '#bfc9d4' : undefined,
                                            offsetY: 16,
                                            formatter: (val) => {
                                                return val;
                                            },
                                        },
                                        total: {
                                            show: true,
                                            label: 'Total',
                                            color: '#888ea8',
                                            fontSize: '29px',
                                            formatter: (w) => {
                                                return w.globals.seriesTotals.reduce(function(a, b) {
                                                    return a + b;
                                                }, 0);
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        labels: ['Apparel', 'Sports', 'Others'],
                        states: {
                            hover: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                            active: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                        },
                    };
                },

                // daily sales
                get dailySalesOptions() {
                    return {
                        series: [{
                                name: 'Sales',
                                data: [44, 55, 41, 67, 22, 43, 21],
                            },
                            {
                                name: 'Last Week',
                                data: [13, 23, 20, 8, 13, 27, 33],
                            },
                        ],
                        chart: {
                            height: 160,
                            type: 'bar',
                            fontFamily: 'Nunito, sans-serif',
                            toolbar: {
                                show: false,
                            },
                            stacked: true,
                            stackType: '100%',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 1,
                        },
                        colors: ['#e2a03f', '#e0e6ed'],
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                legend: {
                                    position: 'bottom',
                                    offsetX: -10,
                                    offsetY: 0,
                                },
                            },
                        }, ],
                        xaxis: {
                            labels: {
                                show: false,
                            },
                            categories: ['Sun', 'Mon', 'Tue', 'Wed', 'Thur', 'Fri', 'Sat'],
                        },
                        yaxis: {
                            show: false,
                        },
                        fill: {
                            opacity: 1,
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '25%',
                            },
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            show: false,
                            xaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 10,
                                right: -20,
                                bottom: -20,
                                left: -20,
                            },
                        },
                    };
                },

                // total orders
                get totalOrdersOptions() {
                    return {
                        series: [{
                            name: 'Sales',
                            data: [28, 40, 36, 52, 38, 60, 38, 52, 36, 40],
                        }, ],
                        chart: {
                            height: 290,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            sparkline: {
                                enabled: true,
                            },
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 2,
                        },
                        colors: isDark ? ['#00ab55'] : ['#00ab55'],
                        labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
                        yaxis: {
                            min: 0,
                            show: false,
                        },
                        grid: {
                            padding: {
                                top: 125,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        fill: {
                            opacity: 1,
                            type: 'gradient',
                            gradient: {
                                type: 'vertical',
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: 0.3,
                                opacityTo: 0.05,
                                stops: [100, 100],
                            },
                        },
                        tooltip: {
                            x: {
                                show: false,
                            },
                        },
                    };
                },
            }));
        });
    </script>
</body>

</html>